//---------------------------------------------
// shader for "Generator" Single Player level
// By KatsBits.com ("kat")
// Generator
// last edited Jan 2014
//---------------------------------------------
textures/spkat5/stonechapel
{
	qer_editorimage textures/spkat5/n_castle_1.tga
	q3map_nonplanar
	q3map_shadeangle 60		//shadeangel doesn't affect above warning
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_lightmapSampleOffset 8.0
		{
			map $lightmap
			rgbGen identity
		}
		{
			map textures/spkat5/n_castle_1.tga
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/stonechapel_cnr
{
	qer_editorimage textures/spkat5/n_castle_1a.tga
	q3map_nonplanar
	q3map_shadeangle 60
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_lightmapSampleOffset 8.0
		{
			map $lightmap
			rgbGen identity
		}
		{
			map textures/spkat5/n_castle_1a.tga
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/stonewall
{
	qer_editorimage textures/spkat5/wall_c04.tga
	q3map_nonplanar
	q3map_shadeangle 60
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_lightmapSampleOffset 8.0
		{
			map $lightmap
			rgbGen identity
		}
		{
			map textures/spkat5/wall_c04.tga
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
//#####################
//CANAL WATER/BOTTOM
//#####################
textures/spkat5/canalbottom
{
	qer_editorimage textures/broken_castle/debri_m01_moss.tga
	q3map_nonplanar
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_shadeangle 179
		{
			map $lightmap
			rgbGen identity
		}
		{
			map textures/broken_castle/debri_m01_moss.tga
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
//alternative shader
textures/spkat5/debri_m01_moss
{
	qer_editorimage textures/broken_castle/debri_m01_moss.tga
	q3map_shadeAngle 179
	q3map_forceMeta	//needed otherwise using shadeangle ,ight not working correctly
	q3map_nonPlanar
	{
		map textures/broken_castle/debri_m01_moss.tga
		rgbGen vertex
	}
}
//###########
//CLEAR WATER
textures/spkat5/water_xlab2_mist
{
	qer_editorimage textures/liquids/water_m6.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm water
	waterfogvars ( 0.0660714 0.0767857 .1000000 ) 1800
	cull disable
	deformVertexes wave 64 sin .25 .25 0 .5
	{
		fog on	// extra para
		map textures/liquids/water_m6.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod scroll .025 .01
	}
	{
		fog on
		map textures/liquids/water_m7.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale -1 -1
		tcmod scroll .025 .025
	}
	{
		fog on	// extra para
		map $lightmap
		blendFunc GL_ZERO GL_ONE
		rgbgen identity
	}
}
//##################
//DIRTY CANAL WATER
textures/spkat5/water_xlab2_fog
{
	qer_editorimage textures/liquids/ocean_m1b.tga
	qer_trans .75
	q3map_globaltexture
	surfaceparm trans
	surfaceparm water
	waterfogvars ( 0.0660714 0.0767857 .1000000 ) 1800
	cull disable
	deformVertexes wave 64 sin .25 .25 0 .5
	{
		fog on	// extra para
		map textures/spkat5/lake_m1_lite_soft.tga
		blendFunc blend
		rgbgen identity
		tcmod scale 2 2
		tcmod scroll 0.0 -.015
	}
	{
		fog on
		map textures/spkat5/water_m6.tga
		blendFunc blend
		rgbgen identity
		tcmod scale -.15 -.15
		tcmod scroll 0.0 .003
	}
	{
		fog on	// extra para
		map $lightmap
		blendFunc GL_ZERO GL_ONE
		rgbgen identity
	}
}
textures/spkat5/water_xlab2
{
		qer_editorimage textures/liquids/water_m6.tga
		qer_trans .5
		q3map_globaltexture
		surfaceparm trans
		surfaceparm water
		waterfogvars ( .3 .3 .38 ) 2400	// .000095
		cull disable
		deformVertexes wave 64 sin .25 .25 0 .5
		{
			fog on	// extra para
			map textures/liquids/water_m6.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcMod scroll 0 -3.5
		}
		{
			fog on	// extra para
			map $lightmap
			blendFunc GL_ZERO GL_ONE
			rgbgen identity
		}
}
textures/spkat5/water_stain
{
	qer_editorimage textures/decals/water_stain.tga
	polygonOffset
	entityMergable
	surfaceparm nolightmap
	{
		map textures/decals/water_stain.tga
		blendFunc GL_ZERO GL_ONE
		rgbGen vertex
		alphaGen vertex
	}
}
//################
// OLD textures/spkat5/watercaulk_fog1800
textures/spkat5/watercaulk_mist
{
	qer_editorimage textures/spkat5/watercaulk.tga
    qer_trans 0.5
    surfaceparm nodraw
    surfaceparm nomarks
    surfaceparm trans
    surfaceparm water
    waterfogvars ( 0.0660714 0.0767857 .1000000 ) 1800
}
//###################
// duplicated for shaders still using old fog1800
textures/spkat5/watercaulk_fog1800
{
	qer_editorimage textures/spkat5/watercaulk.tga
    qer_trans 0.5
    surfaceparm nodraw
    surfaceparm nomarks
    surfaceparm trans
    surfaceparm water
    waterfogvars ( 0.0660714 0.0767857 .1000000 ) 1800
}
//#########
//BOLDERS
//#########
textures/spkat5/stone4_b_120
{
	qer_editorimage textures/spkat5/stone4_b.tga
	q3map_shadeangle 120
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_nonplanar
	surfaceparm gravelsteps
		{
			map textures/spkat5/stone4_b.tga
			rgbGen identity
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/stone4_b_110
{
	qer_editorimage textures/spkat5/stone4_b.tga
	q3map_shadeangle 100
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_nonplanar
	surfaceparm gravelsteps
		{
			map textures/spkat5/stone4_b.tga
			rgbGen identity
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
//######
//GRASS
//######
textures/spkat5/grass_120
{
	qer_editorimage textures/stone/mxrock0t.tga
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	surfaceparm grasssteps
		{
			map textures/stone/mxrock0t.tga
			rgbGen identity	//vertex	//identity
			tcMod scale 1.5 1.5
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity	//vertex	//identity
		}
}
textures/spkat5/grass_120_tcgen
{
	qer_editorimage textures/stone/mxrock0t.tga
	q3map_shadeangle 179
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_nonplanar
	q3map_tcgen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
		{
			map textures/stone/mxrock0t.tga
			rgbGen identity
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
//############
//GRASSY ROCK
//############
textures/spkat5/grassrock_120
{
	qer_editorimage textures/stone/mxrock2t.tga
	q3map_shadeangle 120
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_nonplanar
	surfaceparm grasssteps
		{
			map textures/stone/mxrock2t.tga
			rgbGen identity
			tcMod scale 2.5 2.5
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/grassrock_120_tcgen
{
	qer_editorimage textures/stone/mxrock2t.tga
	q3map_shadeangle 120
	q3map_forceMeta	//needed otherwise using shadeangle might not working correctly
	q3map_nonplanar
	q3map_tcgen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
		{
			map textures/stone/mxrock2t.tga
			rgbGen identity
			tcMod scale 0.5 0.5
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/grassrock_145
{
	qer_editorimage textures/stone/mxrock2t.tga
	q3map_shadeangle 145
	q3map_forceMeta	//needed otherwise using shadeangle ,ight not working correctly
	q3map_nonplanar
	surfaceparm grasssteps
		{
			map textures/stone/mxrock2t.tga
			rgbGen identity
		}
		{
			map $lightmap
			blendFunc GL_DST_COLOR GL_ZERO
			rgbGen identity
		}
}
textures/spkat5/rock2grass
{
    qer_editorimage textures/spkat5/mxrock2t.tga
	q3map_forceMeta	//needed otherwise using shadeangle ,ight not working correctly
	q3map_nonplanar
	q3map_shadeAngle 120
	q3map_tcGen ivector ( 384 0 0 ) ( 0 384 0 )
	q3map_tcMod rotate 90
	q3map_alphaMod dotproduct2 ( 0.1 0.0 0.8 )	// 0.0 0.0 0.75 )	//0.1 0.0 0.8
	q3map_lightmapSampleOffset 8.0
	{
		map textures/stone/mxrock0t.tga	//	grass
		tcMod scale 8.0 8.0	// 6 6
		rgbGen identity
	}
	{
		map textures/spkat5/mxrock2t.tga	//stoneyground
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen oneminusvertex	//flips the alphachannel if wrong way round
		tcMod scale	2.5 2.5	// 4 4
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
//##############
//SKIES
//##############
//Night time with thin fog (distance cull)
//EPISODE I - GRAVEYARD
textures/spkat5/sky_graveyard
{
	qer_editorimage textures/skies/sky_m01dmcmp
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_globaltexture
	q3map_lightsubdivide 1024
	q3map_sun 0.274632 0.274632 0.358662 30 325 35
	q3map_surfacelight 200	//was 75
	skyparms full 200 -
	fogvars ( 0.0660714 0.0767857 .1000000 ) 1800
	{
		map textures/skies/sky_m01dmcmp.tga
		blendfunc GL_ONE GL_ONE
		tcMod scale 12.0 12.0
	}
}
//EPISODE II - CANAL
//------------Daylight-------------------
textures/spkat5/sky_canal
{
	qer_editorimage textures/skies/sky_4.tga
	q3map_lightimage textures/skies/n_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	q3map_globaltexture
	q3map_lightsubdivide 512
	q3map_sun	1.0 0.8 0.6 130 220 50
	q3map_surfacelight 175	//25

	fogvars ( .3 .3 .38 ) .000095	//.000065

	skyparms full 200 -
	{
		map textures/skies/newclouds.tga
		tcMod scroll -0.001 -0.003
		tcMod scale 6 6
		depthWrite
	}
	{
		map textures/skies/assa_clouds1.tga
		blendfunc blend
		tcMod scroll 0.0005 0.00
		tcMod scale 2 1
	}
}
//##############
//FOG VOLUMES
//##############
textures/spkat5/fog_1800
{
	qer_editorimage textures/spkat5/fog.tga
	qer_trans 0.5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogParms ( 0.040000 0.047533 0.045372 ) 1800
}
textures/spkat5/fog_1800_blackish
{
	qer_editorimage textures/spkat5/fog_blackish.tga
	qer_trans 0.5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogParms ( 0 0 0 ) 1800
}
textures/spkat5/fog_512_blackish
{
	qer_editorimage textures/spkat5/fog_blackish.tga
	qer_trans 0.5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogParms ( 0 0 0 ) 512
}
textures/spkat5/fog_256_blackish
{
	qer_editorimage textures/spkat5/fog_blackish.tga
	qer_trans 0.5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogParms ( 0 0 0 ) 256
}
textures/spkat5/fog_512_greyish
{
	qer_editorimage textures/spkat5/fog.tga
	qer_trans 0.5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogParms ( 0.070000 0.077533 0.075372 ) 512
}
//##################
//DECALS
//##################
//textures/decals/blood2 - original
textures/spkat5/burnmark3
{
	nopicmip
	nomipmaps
	polygonOffset
	entityMergable
	{
		map textures/spkat5/burnmark3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}
textures/spkat5/manholecover
{
	qer_editorimage textures/xlab_props/wasser_c01.tga
	polygonOffset
	entityMergable
	{
		map textures/xlab_props/wasser_c01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}
textures/spkat5/hsign
{
	qer_editorimage textures/xlab_props/sign_c02.tga
	polygonOffset
	entityMergable
	{
		map textures/xlab_props/sign_c02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}
textures/spkat5/decal_xtrim
{
	qer_editorimage textures/xlab_wall/xtrim_c03.tga
	polygonOffset
	entityMergable
	{
		map textures/xlab_wall/xtrim_c03.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}
textures/spkat5/light_10k_red
{
	polygonOffset
	entityMergable
	surfaceparm nomarks
	qer_editorimage textures/lights/light_m25r.tga
	q3map_lightimage textures/lightimage/light_m25r_color.tga
    q3map_surfacelight 10000
    light 1
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/lights/light_c01.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/lights/light_m25r.tga
        blendFunc GL_ONE GL_ONE
    }
}
//###################
//MISC/CLIP shaders
//###################
textures/spkat5/slick_bot
{
	qer_trans 0.3
	qer_editorimage textures/spkat5/ai_slick.tga
	surfaceparm nodraw
    surfaceparm monsterslick
    surfaceparm trans
}
textures/spkat5/clipweap
{
	qer_editorimage textures/spkat5/weapon_clip.tga
    qer_trans 0.3
    surfaceparm nodraw
    surfaceparm nomarks
    surfaceparm trans
    surfaceparm nonsolid
}
textures/spkat5/clipmetal
{
	qer_editorimage textures/spkat5/metal_clip.tga
    qer_trans 0.3
    surfaceparm nodraw
    surfaceparm nonsolid
    surfaceparm playerclip
    surfaceparm clipmissile
    surfaceparm trans
    surfaceparm metalsteps
}
textures/spkat5/slick_bot
{
	qer_trans 0.3
	qer_editorimage textures/spkat5/ai_slick.tga
	surfaceparm nodraw
    surfaceparm monsterslick
    surfaceparm trans
}
//##################
// MISC 
//##################
//truss texture used for railings.. needs to be nonsolid
textures/spkat5/truss_m06
{
    qer_editorimage textures/alpha/truss_m06.tga
    surfaceparm alphashadow
    surfaceparm roofsteps
    surfaceparm nonsolid	//allows shootthru
//  nomipmaps
//  nopicmip
    cull disable
    {
        map textures/alpha/truss_m06.tga
        alphaFunc GE128
        depthWrite
        rgbGen vertex
    }
}