//This shader files contains those shaders that are aligned by radiant, not the shader. 
//Used for vertical faces like walls in caves and rockwalls. Now we can blend vertically too. ;-)

//Shaders and textures by Sage
//*********************
//Last edit 31.01.2010 17:26

//Textures used for the terrain shaders:
//
//1:	textures/capuzzo/sand1.tga					(Main Sand)
//2:	textures/capuzzo/sand2.tga					(Rocky sand)
//3:	textures/capuzzo/sand3.tga					(Dirty Sand)
//4:	textures/capuzzo/rock1.tga					(Main Mountain)
//5:	textures/capuzzo/desert_grass.tga				(Grass Sand)
//6:	textures/capuzzo/rock2.tga					(Sandy mountain)
//7:  textures/capuzzo/rock3.tga					(Smoother mountain)
//8:	textures/capuzzo/dirt.tga					(Cave floor)
//9:	textures/capuzzo/sandrock.tga					(Sand for mountain aka mosand)

//Base shader:

textures/capuzzo_terrain_2/base_shader
{
	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapBrightness 2.7
}

//***-***


//Single, non blending shaders:

textures/capuzzo_terrain_2/sand 
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1.tga
	surfaceparm gravelsteps
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain_2/sand3
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo/sand3.tga
	
	{
		map textures/capuzzo/sand3.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain_2/rock
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4.tga
	
	{
		map textures/capuzzo/rock1.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//***-***


//Dual, blending shaders:

textures/capuzzo_terrain_2/rock1_to_sand
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4_to_1.tga
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}


textures/capuzzo_terrain_2/rock2_to_rock1
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo/rock2.tga
	
	{
		map textures/capuzzo/rock2.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain_2/rock3_to_rock1
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo/rock1.tga
	
	{
		map textures/capuzzo/rock3.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain_2/mosand_to_rock1
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4_to_1.tga
	
	{
		map textures/capuzzo/sandrock.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}


textures/capuzzo_terrain_2/sand3_to_sand1
{
	q3map_baseshader textures/capuzzo_terrain_2/base_shader
	qer_editorimage textures/capuzzo/sand3.tga
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}
//***-***
