//Shaders and textures by Sage
//*********************
//Last edit 31.01.2010 17:26

//Textures used for the terrain shaders:
//
//1:	textures/capuzzo/sand1.tga					(Main Sand)
//2:	textures/capuzzo/sand2.tga					(Rocky sand)
//3:	textures/capuzzo/sand3.tga					(Dirty Sand)
//4:	textures/capuzzo/rock1.tga					(Main Mountain)
//5:	textures/capuzzo/desert_grass.tga				(Grass Sand)
//6:	textures/capuzzo/rock2.tga					(Sandy mountain)
//7:  textures/capuzzo/rock3.tga					(Smoother mountain)
//8:	textures/capuzzo/dirt.tga					(Cave floor)
//9:	textures/capuzzo/sandrock.tga					(Sand for mountain)

//Base shader:

textures/capuzzo_terrain/base_shader
{
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_alphaMod dotproduct2 ( 0 0 2 )
	q3map_tcMod rotate 30

	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapsize 1024 1024
	q3map_lightmapMergable
	q3map_lightmapsamplesize 8
	q3map_lightmapBrightness 2.7
	//q3map_lightmapaxis z
}

//***-***


//Single, non blending shaders:

textures/capuzzo_terrain/1 
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1.tga
	surfaceparm gravelsteps
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/2
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_2.tga

	{
		map textures/capuzzo/sand2.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4.tga
	
	{
		map textures/capuzzo/rock1.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/4_slick
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	surfaceparm slick
	qer_editorimage textures/capuzzo_terrain/pic_4_verti.tga
	
	{
		map textures/capuzzo/rock1.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/4_cave
{
	qer_editorimage textures/capuzzo/rock1.tga

	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapsize 1024 1024
	q3map_lightmapMergable
	q3map_lightmapBrightness 2.7

	{
		map textures/capuzzo/rock1.tga
		rgbGen identity
	}

	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/8
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_8.tga

	{
		map textures/capuzzo/dirt.tga
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//***-***


//Dual, blending shaders:

textures/capuzzo_terrain/1_to_2
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo/sand2.tga
	surfaceparm gravelsteps
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand2.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/1_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_4.tga
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/1_to_8
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_8.tga
	
	{
		map textures/capuzzo/sand1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/dirt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/capuzzo_terrain/2_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo/sand2.tga
	surfaceparm gravelsteps
	
	{
		map textures/capuzzo/sand2.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand1.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/3_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_3_to_1.tga
	surfaceparm gravelsteps
	
	{
		map textures/capuzzo/sand3.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand1.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/4_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4_to_1.tga
	
	{
		map textures/capuzzo/rock1.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/5_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_5_to_1.tga
	surfaceparm gravelsteps

	{
		map textures/capuzzo/desert_grass.tga	
		rgbGen identity
	}
	{
		map textures/capuzzo/sand1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/6_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo/rock2.tga
	
	{
		map textures/capuzzo/rock2.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/7_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo/rock1.tga
	
	{
		map textures/capuzzo/rock3.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity 
	}
}

textures/capuzzo_terrain/9_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_4.tga
	
	{
		map textures/capuzzo/sandrock.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity	 
	}
}

textures/capuzzo_terrain/9_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_4.tga
	
	{
		map textures/capuzzo/sandrock.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/rock1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		tcgen lightmap
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity	 
	}
}
//***-***
