// ========================
//  braundorf_final.shader
// ========================

textures/braundorf/sky
{
	nomipmaps
	nopicmip
	skyParms textures/braundorf/sky/snow 512 -
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
}

textures/braundorf/sign
{
	nomipmaps
	nopicmip
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm woodsteps
	implicitMap -
	{
		map textures/braundorf/sign.tga
	}
}

textures/braundorf/light
{
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/braundorf/light.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/braundorf/light.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/braundorf/rock2grass
{
	
	{
		map textures/braundorf/s_mountain.tga
		rgbGen identity
	}
	{
		map textures/braundorf/s_grass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/mountain
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/braundorf/s_mountain.tga
		blendFunc filter
	}
}

textures/braundorf/grass2dirt
{
	surfaceparm grasssteps
 	surfaceparm landmine
	{
		map textures/braundorf/s_grass.tga
		rgbGen identity
	}
	{
		map textures/braundorf/s_dirt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/barrel1
{
	{
		map textures/props/barrel_m01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/barrel2
{
	{
		map textures/props/barrel_m02.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/trunk
{
	{
		map models/mapobjects/tree/branch_slp1.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/tree1
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/tree2
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/plant
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/glass
{
	cull none
	surfaceparm alphashadow
	surfaceparm glass
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/common/dirtymirror2.tga
		blendfunc blend
		rgbGen identity
	}
}

textures/braundorf/pave1
{
	{
		map textures/snow/s_cathedrale_c24b.tga
		tcmod scale 1.75 1.75
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/pave2
{
	{
		map textures/snow/s_floor_l_01.tga
		tcmod scale 1.5 1.5
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/floor
{
	{
		map textures/snow/s_castle_m03_step.tga
		tcmod scale 2 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/wall1
{
	{
		map textures/snow/s_cathedrale_c06.tga
		tcmod scale 1 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/ceiling
{
	{
		map textures/snow/s_castle_c16d.tga
		tcmod scale 1 .5
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/roof
{
	{
		map textures/snow/s_roof_c04dm.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/bunker_wall
{
	{
		map textures/braundorf/s_bunker_wall.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/door_heavy
{
	{
		map textures/braundorf/s_door_heavy.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/garage_door
{
	{
		map textures/braundorf/s_garage_door.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/wall_town1
{
	{
		map textures/snow/s_castle_c46_on_grid.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/wall_town2
{
	{
		map textures/snow/s_castle_c46_on_grid.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/awf1
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/awf.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/awf/awf_w_m10.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/awf2
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/awf.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/awf/awf_w_m11.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/window
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/win.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/tobruk_windows_sd/tobruk_windows_off.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}