// red sun skybox, polar

// q3map_skylight amount iteractions (ex 100-200 amount, 3-4(5) iteractions)

// q3map_sun red green blue intensity degrees elevation
// intensity : A value of 100 is a fairly bright sun (falloff with angle, not 
// distance)
// degrees : The angle relative to the directions of the map file. A setting of
// 0 degrees equals east. 90 is north, 180 is west and 270 is south. In the 
// original version of Q3Map, non-axial values had a tendency to produce jagged
// shadows. With Q3Map2, this problem is avoided with new options like lightmap
// filtering, raytracing and penumbra effects.
// elevation : The distance, measured in degrees from the horizon (z value of
// zero in the map file). An elevation of 0 is sunrise/sunset. 
// An elevation of 90 is noon.

// q3map_sunExt red green blue intensity degrees elevation deviance samples
// Works like q3map_sun with the addition of two new parameters to create 
// "light jittering" for penumbra (half-shadow) effects. This gives you much
// more realistic shadows from the sun, especially when trying to simulate a
// cloudy day or a wide sun. The penumbra effect can also be applied to entity
// lights (point, spot or sun) with the _deviance N (distance in world units
// for point/spot lights and degrees for suns) and _samples N (number of
// samples) key/value pairs.
// deviance : The number of degrees for the half-shadow. General values up to
// 2 or 3 are acceptable. The real sun has a solid angle of about half a
// degree.
// samples : The number of random jitters distributed over the solid arc (~16).

textures/hafen3/arcss
{
	qer_editor_image textures/hafen3/arcss.tga
	q3map_lightrgb 1.0 0.23 0.16
	q3map_sunExt 1.0 0.62 0.11 135 112.5 5 2 8
	q3map_skylight 32 3

// fog haze
//	fogvars ( 0.72 0.33 0.43 ) .0001
//	skyfogvars ( 0.72 0.33 0.43 ) .01

	surfaceparm nodlight
	surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm sky

	skyparms textures/hafen3/arcss 256 -

//	sunshader textures/skies_sd/batterysunfog

}

// gib mountain scene, bit of haze, skybox

textures/whoreagedam/lostvalley
{
	qer_editor_image textures/whoreagedam/lostvalley.tga
	q3map_lightrgb 1.0 0.99 0.73
	q3map_sunExt 1.0 0.99 0.73 145 305 15 2 8
	q3map_skylight 32 3

// fog haze
//	fogvars ( 0.78 0.82 0.67 ) .0001
//	skyfogvars ( 0.78 0.82 0.67 ) .01

	surfaceparm nodlight
	surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm sky

	skyparms textures/whoreagedam/lostvalley 1024 -

	sunshader textures/skies_sd/batterysunfog

}

// Night sky, for whoreage dam

textures/whoreagedam/nightsky
{
	qer_editor_image textures/whoreagedam/nightsky.tga
	q3map_lightrgb 0.45 0.56 1.0
	q3map_sunExt 0.45 0.56 1.0 80 45 35 2 8
	q3map_skylight 32 3

// fog haze
//	fogvars ( 0.43 0.54 0.91 ) .0001
//	skyfogvars ( 0.43 0.54 0.91 ) .01

	surfaceparm nodlight
	surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm sky

	skyparms textures/whoreagedam/nightsky 1024 -

//	sunshader textures/skies_sd/batterysunfog

}


// metal railings for stairs
textures/whoreagedam/metalphong
{
	surfaceparm metalsteps
	q3map_nonplanar
	q3map_shadeangle 179
	qer_editorimage textures/whoreagedam/metalphong.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/whoreagedam/metalphong.tga
		blendFunc filter
	}
}

// metal with reflection 1
textures/whoreagedam/mdoorref
{
	qer_editorimage textures/whoreagedam/mdoorref.tga
	q3map_lightmapsamplesize 1
	surfaceparm metalsteps
	{
		map textures/whoreagedam/envmap_slate.tga
		rgbGen identity
		tcGen environment
		tcMod turb 0.5 0.1 0 0.02
	}
	{
		map textures/whoreagedam/mdoorref.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

// extra flag, from raiders map
textures/whoreagedam/flagextra
{
	qer_editorimage textures/whoreagedam/flagextra.tga
	cull twosided
	deformVertexes wave 10 sin 0 2 0 .2
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitBlend -
}

