// ------------ SHADER for Warbell ------
// most shaders written by ]UBC[ McNite
// some ideas borrowed from ET shaders
// alphachannel shaders from www.level-designer.de


textures/wb_ei/ei_terrain_grass
{
	qer_editorimage textures/wb_ei/ei_terrain_grass.jpg
	q3map_tcMod scale 0.25 -0.25
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/temperate_sd/grass_dense1.tga
}

textures/wb_ei/ei_terrain_rock1
{
	qer_editorimage textures/wb_ei/ei_terrain_rock1.jpg
	q3map_tcMod scale 0.5 -0.5
	q3map_nonplanar
	q3map_shadeangle 120
	implicitMap textures/wb_t/wb_rock01.jpg // temperate_sd/rock_ugly_brown.tga
}



// ---------------------------------------------
// ------------ WATER --------------------------
// ---------------------------------------------


textures/wb_t/complex
{
	qer_editorimage textures/wb_t/complex.jpg
	q3map_nonplanar
	qer_trans 0.7

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 10 0 .3	// the chop, removed for causing split with slope water
	// implicitMap textures/wb_t/wb_water_02_d03.tga


	{ 
		map textures/wb_t/complex.jpg
		rgbgen identity
		tcmod scroll 0 -.05		// paused
	}

	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// added
		rgbgen wave sin .4 0 0 .5
		alphaGen vertex							// added
		tcmod scale .7 .7		// paused
		// tcmod scroll .03 .02	
		tcmod scroll 0 -.2		// paused
		depthWrite			// try to avoid the funny effect with smoke etc
	}	

	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .25		
		tcmod scale .2 .2
		// tcmod scroll -.03 -.02	
		tcmod scroll 0 .01
	}

	{ 
		map $lightmap
		blendfunc filter
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		// alphaGen vertex
	}
}

// make the second water with the alpha gen for the foam instead of darker water
// act as the wedge to seperate light edge water and foamy water as no alpha brushes are needed

textures/wb_t/wedge
{
	qer_editorimage textures/wb_t/wedge.jpg
	q3map_nonplanar
	qer_trans 0.7

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 10 0 .3	// the chop, removed for causing split with slope water
	// implicitMap textures/wb_t/wb_water_02_d03.tga

	{ 
		map textures/wb_t/complex.jpg
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// added
		rgbgen wave sin .4 0 0 .5
		// alphaGen vertex							// no in this shader
		// alphagen const 1			// to  fake the 100 alpha values
		tcmod scale .7 .7		// paused
		// tcmod scroll .03 .02	
		tcmod scroll 0 -.2		// paused
		depthWrite			// try to avoid the funny effect with smoke etc
	}	

	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .25		
		tcmod scale .2 .2
		// tcmod scroll -.03 -.02	
		tcmod scroll 0 .01
	}

	{ 
		map $lightmap
		blendfunc filter
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		// alphaGen vertex
	}
}

// the third water shader for the water with foam on top
// make a texture with no display or solidarity to cast shadows under the water

textures/wb_t/wb_watershadow // 
{
	qer_editorimage textures/wb_t/wb_fog_08sm.jpg

	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm nonsolid
	cull disable

	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	        
	{
		map textures/wb_sfx/sfx_alpha0.tga
		//tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// the third water shader for the water with foam on top

textures/wb_t/waterfoam
{
	qer_editorimage textures/wb_t/waterfoam.tga
	q3map_nonplanar
	qer_trans 0.7

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // front
	deformVertexes wave 160 sin 0 10 0 .3	// the chop, removed for causing split with slope water
	// implicitMap textures/wb_t/wb_water_02_d03.tga

	{ 
		map textures/wb_t/complex.jpg
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// added
		rgbgen wave sin .4 0 0 .5
		// alphaGen vertex							// no in this shader
		// alphagen const 1			// to  fake the 100 alpha values
		tcmod scale .7 .7		// paused
		// tcmod scroll .03 .02	
		tcmod scroll 0 -.2		// paused
		depthWrite			// try to avoid the funny effect with smoke etc
	}	

	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .25		
		tcmod scale .2 .2
		// tcmod scroll -.03 -.02	
		tcmod scroll 0 .01
	}

	{
		map textures/wb_t/waterfoam.tga	// the foam image
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// transparency for alpha brushes
		alphaGen vertex		// generate alpha values from alpha brushes
		tcmod scroll 0 -.55
		alphaFunc GE128
	}

	{ 
		map $lightmap
		blendfunc filter
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		// alphaGen vertex
	}
}


// calm foam, needed to close the gap at the disappearing waterfall

textures/wb_t/waterfoamcalm
{
	qer_editorimage textures/wb_t/waterfoam.tga

	q3map_nonplanar
	q3map_shadeangle 180

	qer_trans 0.7

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks
	//surfaceparm alphashadow		//try to make it darker under the water so it looks more beliavble when submerged

	cull disable // front
	//deformVertexes wave 80 sin 0 3 0 0.3 // 160 sin 0 10 0 .3 the chop, removed for causing split with slope water
	
	{ 
		map textures/wb_t/complex.jpg
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// added
		rgbgen wave sin .4 0 0 .5
		// alphaGen vertex							// no in this shader
		// alphagen const 1			// to  fake the 100 alpha values
		tcmod scale .7 .7		// paused
		// tcmod scroll .03 .02	
		tcmod scroll 0 -.2		// paused
		depthWrite			// try to avoid the funny effect with smoke etc
	}	

	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .25	
		tcmod scale .2 .2
		// tcmod scroll -.03 -.02	
		tcmod scroll 0 .01
	}

	{
		map textures/wb_t/waterfoam.tga	// the foam image
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// transparency for alpha brushes
		alphaGen vertex		// generate alpha values from alpha brushes
		tcmod scroll 0 -.55
		alphaFunc GE128
	}

	{ 
		map $lightmap
		blendfunc filter
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		// alphaGen vertex
	}
}


textures/wb_t/wb_waterfall //carnmcnite/fall 
{ 
	qer_editorimage textures/wb_ei/ei_wb_waterfall.tga 
	q3map_nonplanar 
	q3map_shadeangle 120 
	qer_trans 0.7 

	q3map_globaltexture //new 
	q3map_tcMod scale 0.5 0.5 
	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 -256 ) // 1/256 = 0.00390625 

	surfaceparm water 
	surfaceparm trans // added... 
	surfaceparm nomarks 

	cull disable // "back" is no good idea 

	{ 
		map textures/wb_t/wb_waterfall.tga  // textures/wb_t/complex.jpg 
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA // added 
		rgbgen wave sin .4 0 0 .5 
		// alphaGen vertex // no in this shader 
		// alphagen const 0.25 // to  fake the 100 alpha values 
		tcmod scale .7 .7 // paused 
		tcmod scroll 0 -0.5 // 0 -1
		depthWrite // try to avoid the funny effect with smoke etc 
	} 
	
	{ 
		map textures/wb_t/wb_waterfall.tga // the foam image 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA // transparency for alpha brushes 
		alphaGen vertex // generate alpha values from alpha brushes 
		tcmod scroll 0 -0.75 // 0 -1.5 
		// alphaFunc GE128 
	} 

	{ 
		map $lightmap 
		blendfunc filter 
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA 
		rgbGen identity 
		// alphaGen vertex 
	} 
} 



textures/wb_t/shadow
{
	qer_editorimage textures/wb_t/wb_fog_08sm.jpg
	qer_trans 0.3
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm nonsolid
	cull disable
    {
        map textures/wb_sfx/sfx_alpha0.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }
}


textures/wb_t/shadowcarnage
{
	qer_editorimage textures/wb_t/shadow.tga
	surfaceparm alphashadow		//try to make it darker under the water so it looks more beliavble when submerged
	surfaceparm nonsolid

	{

	}
}




textures/wb_t/wb_watercalm // shader written by carnage
{
	qer_editorimage textures/wb_t/complex.jpg
	q3map_nonplanar
	qer_trans 0.7

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 2 0 .3	// the chop, removed for causing split with slope water
	// implicitMap textures/wb_t/wb_water_02_d03.tga



	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA		// added
		rgbgen wave sin .4 0 0 .5
		alphaGen vertex							// added
		tcmod scale .7 .7		// paused
		tcmod scroll -.03 -.02	
		//tcmod scroll 0 -.2		// paused
		depthWrite			// try to avoid the funny effect with smoke etc
	}	
	{ 
		map textures/wb_t/complex.jpg
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .25		
		tcmod scale .2 .2
		tcmod scroll .03 .02	
		//tcmod scroll 0 .01
	}
	{ 
		map $lightmap
		blendfunc filter
		// blendfunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		// alphaGen vertex
	}

}




textures/wb_t/wb_water1 // on the test, after water_beach_nerve from RtCW mp_pak0.pk3
{
	qer_editorimage textures/wb_ei/ei_water1.jpg
	qer_trans 0.9

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 10 0 .3	// the chop

	// implicitMap textures/wb_t/wb_water_02_d03.tga

	{ 
		map textures/wb_t/wb_water_02_d03.tga
		rgbgen wave sin .4 0 0 .5	
		tcmod scale .7 .7
		tcmod scroll .03 .02		
	}	
	{ 
		map textures/wb_t/wb_water_02_d03.tga
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .5		
		tcmod scale .2 .2
		tcmod scroll -.03 -.02	
	}
}

textures/wb_t/wb_water1calm // after water_beach_nerve from RtCW mp_pak0.pk3
{
	qer_editorimage textures/wb_ei/ei_water1.jpg
	qer_trans 0.9

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 2 0 .3	// the chop

	// implicitMap textures/wb_t/wb_water_02_d03.tga

	{ 
		map textures/wb_t/wb_water_02_d03.tga
		rgbgen wave sin .4 0 0 .5	
		tcmod scale .7 .7
		tcmod scroll -.03 -.02		
	}	
	{ 
		map textures/wb_t/wb_water_02_d03.tga
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .5		
		tcmod scale .2 .2
		tcmod scroll .03 .02	
	}
}

textures/wb_t/cavewater
{
	qer_editorimage textures/wb_ei/ei_cavewater.jpg
	qer_trans .8
	q3map_globaltexture
	cull disable
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water

	nopicmip
	{
		map textures/liquids_sd/siwa_water.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
		tcmod scale 0.5 0.5
		tcmod scroll -.02 .001
	}
	{
		map textures/liquids_sd/siwa_shimshim1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.4 0.02 0 0.3
		tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll .005 -.001
	}
}


// ---------------------------------------------
// ------------ SFX TERRAIN --------------------
// ---------------------------------------------

textures/wb_t/wb_sfxblack01 // black "room" for falling player
{
	qer_editorimage textures/wb_sfx/color_black.tga
	qer_trans 0.5
	surfaceparm nomarks
	surfaceparm nonsolid
	//surfaceparm nolightmap
        cull none
	implicitmap textures/wb_sfx/color_black.tga
}

textures/wb_t/wb_sfxblack02 // brush falling player lands on
{
	qer_editorimage textures/wb_ei/ei_wba_sfxblack02.jpg
	qer_trans 0.9
	surfaceparm nomarks
	//surfaceparm nolightmap
        cull none
	implicitmap textures/wb_sfx/color_black.tga
}

textures/wb_t/wb_sfxclipnodamage // brush falling player lands on
{
	qer_editorimage textures/wb_ei/ei_wba_sfxblack03.jpg

	qer_trans 0.3
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm playerclip
	surfaceparm trans
	surfaceparm nodamage
}

textures/wb_sfx/wb_sfxblack // black "room" for falling player
{
	qer_editorimage textures/wb_sfx/color_black.tga
	qer_trans 0.5
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm nolightmap
        cull none
	implicitmap textures/wb_sfx/color_black.tga
}



// ----------------------------------------------
// ------------ CLOUDS --------------------------
// ----------------------------------------------


textures/wb_t/wb_clouds02 //
{
	qer_editorimage textures/wb_t/wb_clouds02_e.tga
	qer_trans .9

	q3map_globaltexture
	cull disable
	nocompress

	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans

	nopicmip
	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		rgbgen identity
		//tcmod scale 0.7 0.3
		//tcmod scroll 0 0.01 // -.0002
	}
	{
		map textures/wb_t/wb_clouds03_b.tga 
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.45 0.05 0 0.02
		tcmod scale 0.35 0.25 // 0.5 0.5
		tcmod scroll .001 0.006 // -.0002
	}
	{
		map textures/wb_t/wb_clouds03_b.tga 
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.05 0 0.0125
		tcmod scale -0.45 0.4
		tcmod scroll -.005 .005
	}
	{
		map textures/wb_t/wb_clouds02_e.tga 
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.1 0.04 0 0.04
		tcmod scale 2.0 0.75
		tcmod scroll .009 .0075
	}
}


// textures/wb_t/wb_clouds02_d.tga // 32 bit
// textures/skies_sd/battery_clouds.tga // 24 bit
// textures/skies_sd/wurzburg_clouds.tga // 24 bit
// textures/skies/fueldump_clouds.tga // 32 bit
// textures/skies_sd/battery_clouds.tga // 24 bit


// wb_t.shader (Warbell_terrain shader)
// by Dersaidin
// ======================================================================
// alpha fade terrain shaders
// adapted by dersaidin from examples in tutorial from 
// http://simland.planetquake.gamespy.com/pages/articles/terrain1_1.htm
// ======================================================================

// ---------------------------------------------------------------------------------------------
// ------------ ALPHA BLENDS WITH GRASS TO... --------------------------------------------------
// ---------------------------------------------------------------------------------------------

textures/wb_t/wba_grasspave // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grasspavement.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	        
	{
		map textures/wb_z/ground_c06.jpg
		tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/wb_t/wba_grassgrass // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grassgrass.jpg
	
	q3map_nonplanar
	q3map_shadeangle 170
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	surfaceparm landmine
	surfaceparm grasssteps
	        
	{
		map textures/temperate_sd/grass_path1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/wb_t/wba_rivershore // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grassriverbed.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 160
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 ) // ( 256 0 0 ) ( 0 0 256 )
	surfaceparm gravelsteps
	surfaceparm landmine
	        
	{
		map textures/stone/mxrock3_a.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_rivershoreYZ // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grassriverbed.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 160
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 ) // ( 256 0 0 ) ( 0 0 256 )
	surfaceparm gravelsteps
	surfaceparm landmine
	        
	{
		map textures/stone/mxrock3_a.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_cliffbottom // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grasscliffbottom.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 160
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 ) // ( 256 0 0 ) ( 0 0 256 )
	surfaceparm gravelsteps
	surfaceparm landmine
	        
	{
		map textures/stone/mxrock1aa.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_grassclifftop_xy
{
	qer_editorimage textures/wb_ei/ei_wba_grassclifftopXY.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 ) // ( 256 0 0 ) ( 0 0 256 )
	        
	{
		map textures/wb_t/wb_rock01.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga  //wb_t/grass_dense1_b.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_grassclifftop_YZ
{
	qer_editorimage textures/wb_ei/ei_wba_grassclifftopYZ.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 ) // ( 256 0 0 ) ( 0 0 256 )
	        
	{
		map textures/wb_t/wb_rock01.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga  //wb_t/grass_dense1_b.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_grassclifftop_XZ
{
	qer_editorimage textures/wb_ei/ei_wba_grassclifftopXZ.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 0 512 ) // ( 256 0 0 ) ( 0 0 256 )
	        
	{
		map textures/wb_t/wb_rock01.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga  //wb_t/grass_dense1_b.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/wb_t/wba_grasspath // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grasspath.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm landmine
	surfaceparm gravelsteps
	        
	{
		map textures/wb_t/wb_path.jpg //sand_patchnoise.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga  //wb_t/grass_dense1_b.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_grassroad // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grassroad.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm landmine
	surfaceparm gravelsteps
	        
	{
		map textures/wb_t/wb_road.jpg
		// tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_grassgravel // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grassroad.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm landmine
	surfaceparm gravelsteps
	        
	{
		map textures/temperate_sd/dirt3.tga
		// tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/wb_t/wba_grasscavesand // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_grasscavesand.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm gravelsteps
	        
	{
		map textures/temperate_sd/sand_patchnoise.tga
		tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ---------------------------------------------------------------------------------------------
// ------------ ALPHA BLENDS WITH ROCK TO... ---------------------------------------------------
// ---------------------------------------------------------------------------------------------

textures/wb_t/wba_rockrock2_XZ
{
	qer_editorimage textures/stone/mxrock3_a.jpg 

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 0 512 ) // ( 256 0 0 ) ( 0 0 256 )
	        
	{
		map textures/wb_t/wb_rock01.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/stone/mxrock3_a.jpg //models/mapobjects/rocks_sd/rock_temperate2_big.jpg
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_rockrock2_YZ
{
	qer_editorimage textures/stone/mxrock3_a.jpg 

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 ) // ( 256 0 0 ) ( 0 0 256 )
	        
	{
		map textures/wb_t/wb_rock01.jpg
		// Primary
		rgbGen identity
	}
	{
		map textures/stone/mxrock3_a.jpg //models/mapobjects/rocks_sd/rock_temperate2_big.jpg
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ---------------------------------------------------------------------------------------------
// ------------ DECAL BLENDS -------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------

textures/wb_t/wba_grass // decal after socks stuff
{
	qer_editorimage textures/wb_ei/ei_wba_grass.jpg

	q3map_forceMeta 	
	//q3map_nonplanar
	//q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm grasssteps
	surfaceparm landmine

	polygonOffset
	        
	{
		map textures/temperate_sd/grass_dense1_a.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

textures/wb_t/wbd_rockXZ // decal to vary the look of the rock texture
{
	qer_editorimage textures/wb_ei/ei_wbd_rockXZ.jpg

	q3map_forceMeta 	
	//q3map_nonplanar
	//q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 0 512 )

	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm grasssteps
	surfaceparm landmine

	polygonOffset
	        
	{
		map textures/temperate_sd/grass_dense1_a.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

textures/wb_t/wbd_rockYZ // decal to vary the look of the rock texture
{
	qer_editorimage textures/wb_ei/ei_wbd_rockYZ.jpg

	q3map_forceMeta 	
	//q3map_nonplanar
	//q3map_shadeangle 80
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 )

	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm grasssteps
	surfaceparm landmine

	polygonOffset
	        
	{
		map textures/temperate_sd/grass_dense1_a.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}



// ---------------------------------------------------------------------------------------------
// ------------ PURE TEXTURES ------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------

textures/wb_t/wb_pavement
{
	qer_editorimage textures/wb_z/ground_c06.jpg
	q3map_tcMod scale 1 -1
	implicitMap textures/wb_z/ground_c06.jpg
}

textures/wb_t/wb_rock01
{
	qer_editorimage textures/wb_t/wb_rock01.jpg
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap textures/wb_t/wb_rock01.tga
}

textures/wb_t/wb_riverbed1
{
	qer_editorimage textures/stone/mxrock3_a.jpg
	q3map_tcMod scale 0.5 -0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/stone/mxrock3_a.jpg
}

textures/wb_t/wb_grass
{
	qer_editorimage textures/temperate_sd/grass_dense1.tga
	q3map_tcMod scale 0.25 -0.25
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/temperate_sd/grass_dense1.tga
}

textures/wb_t/wb_gravel
{
	qer_editorimage textures/temperate_sd/dirt3.tga  //sand_patchnoise.tga
	q3map_tcMod scale 0.5 -0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/temperate_sd/dirt3.tga //sand_patchnoise.tga
}

textures/wb_t/wb_path
{
	qer_editorimage textures/wb_t/wb_path.jpg  //sand_patchnoise.tga
	q3map_tcMod scale 0.5 -0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/wb_t/wb_path.jpg //sand_patchnoise.tga
}

textures/wb_t/wb_road
{
	qer_editorimage textures/wb_t/wb_road.jpg
	q3map_tcMod scale 0.5 -0.5
	q3map_nonplanar
	q3map_shadeangle 100
	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/wb_t/wb_road.jpg
}


// ---------------------------------------------------------------------------------------------
// ------------ CAVE SHADERS AND ALPHA BLENDS --------------------------------------------------
// ---------------------------------------------------------------------------------------------


textures/wb_t/wb_cavesand
{
	qer_editorimage textures/temperate_sd/sand_patchnoise.tga
	//qer_editorimage textures/wb_t/wb_gravel2.jpg
	q3map_tcMod scale 1 -1
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/sand_patchnoise.tga
}

textures/wb_t/wb_caverock1
{
	qer_editorimage textures/stone/mxrock3_a.tga
	q3map_tcMod scale 1 -1
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/stone/mxrock3_a.tga
}

textures/wb_t/wba_caverockcavesandXY // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_caverockcavesandXY.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	surfaceparm gravelsteps
	        
	{
		map textures/stone/mxrock3_a.tga
		// tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_caverockrockXY // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_rockcaverockXY.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm gravelsteps
	        
	{
		map textures/stone/mxrock3_a.jpg
		// Primary
		tcgen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )  // 256x256 size
		rgbGen identity
	}
	{
		map textures/wb_t/wb_rock01.jpg
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen const 1
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_rockcaverockXZ // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_rockcaverockXZ.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 512 0 0 ) ( 0 0 512 )
	surfaceparm gravelsteps
	        
	{
		map textures/stone/mxrock3_a.jpg
		// Primary
		tcgen vector ( 0.00390625 0 0 ) ( 0 0 0.00390625 )  // 256x256 size
		rgbGen identity
	}
	{
		map textures/wb_t/wb_rock01.jpg
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen const 1
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/wb_t/wba_rockcaverockYZ // works fine
{
	qer_editorimage textures/wb_ei/ei_wba_rockcaverockYZ.jpg

	q3map_forceMeta 	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 )
	surfaceparm gravelsteps
	        
	{
		map textures/stone/mxrock3_a.jpg
		// Primary
		tcgen vector ( 0 0.00390625 0 ) ( 0 0 0.00390625 )  // 256x256 size
		rgbGen identity
	}
	{
		map textures/wb_t/wb_rock01.jpg
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen const 1
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ---------------------------------------------------------------------------------------------
// ------------ SKYLINE ------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------

textures/wb_t/wb_skyline01
{
	qer_editorimage textures/wb_ei/ei_wb_skyline01

	cull front
	nomipmaps
	nopicmip

	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans

	implicitMask textures/wb_t/wb_skyline01a.tga
}

textures/wb_t/wb_skyline04
{
	qer_editorimage textures/wb_ei/ei_wb_skyline04

	cull front
	nomipmaps
	nopicmip

	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans

	implicitMask textures/wb_t/wb_skyline04.tga
}




// ---------------------------------------------
// ------------ OTHER TERRAIN SHADERS ----------
// ---------------------------------------------



textures/wb_t/wb_singlerock01
{
	qer_editorimage models/mapobjects/rocks_sd/rock_temperate_big.jpg
	q3map_clipModel
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	implicitMap models/mapobjects/rocks_sd/rock_temperate_big.jpg
}

textures/wb_t/wb_singlerock02
{
	qer_editorimage models/mapobjects/rocks_sd/rock_temperate2_big.jpg
	q3map_clipModel
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	implicitMap models/mapobjects/rocks_sd/rock_temperate2_big.jpg
}

textures/wb_t/wb_singlerock03
{
	qer_editorimage textures/wb_t/wb_rock01.jpg
	q3map_clipModel
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	implicitMap textures/wb_t/wb_rock01.jpg
}

