// ------------ SHADER for Warbell ------
// most shaders written by ]UBC[ McNite
// some ideas borrowed from ET shaders
// alphachannel shaders from www.level-designer.de



// ---------------------------------------------
// ------------ SKY ----------------------------
// ---------------------------------------------


textures/wb_t/wb_moon
{
	qer_editorimage textures/wb_t/wb_moonfull.tga
	cull none
	nofog
	{
		map textures/wb_t/wb_moonfull.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen identityLighting
	}
}


textures/wb_t/wb_skylow2 //sky after goldrush sky, low light for now
{
	qer_editorimage textures/wb_ei/ei_skynight.jpg

	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky


	q3map_sunExt 0.29 0.35 0.37 98 120 50 3 16 //color intensity-60 degree-120 elevation-50 deviance samples

	q3map_sun 0.29 0.35 0.37 5 120 50
	q3map_lightmapFilterRadius 0 8

	q3map_skylight 90 3 //65 3

	// nocompress

	sunshader textures/wb_t/wb_moon
	
	skyparms textures/wb_t/wbsky/wb 256 - //textures/skies_sd/wurzburg_env/sky 512 -
 
	
	{	fog off
		map textures/skies_sd/wurzburg_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.01 0.015
		rgbGen identityLighting
	}


	{	fog off
		map textures/skies/nightsky1.jpg
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/goldrush_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen const ( 0.29 0.35 0.37 ) 
	}
}



// ---------------------------------------------
// ------------ METAL --------------------------
// ---------------------------------------------


textures/wb_mat/metal01
{
	qer_editorimage textures/xlab_wall/xmetal_c03.jpg
	surfaceparm metalsteps
	implicitMap textures/xlab_wall/xmetal_c03.jpg
}

textures/wb_mat/metal02 // clean black
{
	qer_editorimage textures/metal_misc/metal_m04dr2.tga
	surfaceparm metalsteps
	implicitMap textures/metal_misc/metal_m04dr2.tga
}

textures/wb_mat/metal03
{
	qer_editorimage textures/metal_misc/ametal_m03.jpg
	surfaceparm metalsteps
	implicitMap textures/metal_misc/ametal_m03.jpg
}

textures/wb_mat/metal04
{
	qer_editorimage textures/assault/metal_c07a.jpg
	surfaceparm metalsteps
	implicitMap textures/assault/metal_c07a.jpg
}

// ----- technical stuff -----------------------------------------------------------

textures/wb_mat/metal21
{
	qer_editorimage textures/xlab_props/xradio_c02.jpg
	surfaceparm metalsteps
	implicitMap textures/xlab_props/xradio_c02.jpg
}



// ----- decorative metaltextures from here on

textures/wb_mat/wb_metal31
{
	// qer_editorimage textures/wb_p/wb_metal_1.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/wb_mat/wb_metal31_rivet
{
	// qer_editorimage textures/wb_p/wb_metal01_rivet.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/wb_mat/wb_metal32
{
	qer_editorimage textures/xlab_wall/xtrim_c04.jpg
	surfaceparm metalsteps
	implicitMap textures/xlab_wall/xtrim_c04.jpg
}

textures/wb_mat/wb_metal33
{
	qer_editorimage textures/xlab_wall/xtrim_c06.jpg
	surfaceparm metalsteps
	implicitMap textures/xlab_wall/xtrim_c06.jpg
}

textures/wb_mat/wb_metal34
{
	qer_editorimage textures/battery_wall/metal_trim1.tga
	surfaceparm metalsteps
	implicitMap textures/battery_wall/metal_trim1.tga
}

textures/wb_mat/wb_metal41
{
	qer_editorimage models/mapobjects/light/chandlier4l.jpg
	surfaceparm metalsteps
	implicitMap models/mapobjects/light/chandlier4l.jpg
}



textures/wb_mat/wb_metal51nonsolid
{
	qer_editorimage textures/xlab_wall/xmetal_m03l.tga
	surfaceparm nonsolid
	surfaceparm trans
	implicitMap textures/xlab_wall/xmetal_m03l.tga
}


// ---------------------------------------------
// ------------ OTHER MATERIALS ----------------
// ---------------------------------------------




// ---------------------------------------------
// ------------ STONE --------------------------
// ---------------------------------------------

textures/wb_stone/stone_01
{
	qer_editorimage textures/broken_castle/wall_c03d.jpg
	implicitMap textures/broken_castle/wall_c03d.jpg
}

textures/wb_stone/stone_01stay
{
	qer_editorimage textures/broken_castle/wall_c03d.jpg
	implicitMap textures/broken_castle/wall_c03d.jpg
}

textures/wb_stone/stone_02
{
	qer_editorimage textures/broken_castle/wall_c04.jpg
	implicitMap textures/broken_castle/wall_c04.jpg
}

textures/wb_stone/stone_02stay
{
	qer_editorimage textures/broken_castle/wall_c04.jpg
	implicitMap textures/broken_castle/wall_c04.jpg
}

textures/wb_stone/stone_03
{
	qer_editorimage textures/castle_wall/castle_c09_2.jpg
	implicitMap textures/castle_wall/castle_c09_2.jpg
}

textures/wb_stone/stone_04
{
	qer_editorimage textures/cathedrale_wall/cathedrale_c09.jpg
	implicitMap textures/cathedrale_wall/cathedrale_c09.jpg
}


textures/wb_stone/stone_06
{
	qer_editorimage textures/graveyard/gy_ml03a.jpg
	implicitMap textures/graveyard/gy_ml03a.jpg
}

textures/wb_stone/stone_07
{
	qer_editorimage textures/miltary_wall/concrete_c02.jpg
	implicitMap textures/miltary_wall/concrete_c02.jpg
}

textures/wb_stone/stone_08
{
	qer_editorimage textures/occult/menhir_c02a.jpg
	implicitMap textures/occult/menhir_c02a.jpg
}

textures/wb_stone/stone_09
{
	qer_editorimage textures/sleepy/wall_c01.jpg
	implicitMap textures/sleepy/wall_c01.jpg
}

// ----- these are the town_wall images --------

textures/wb_stone/stone_21
{
	qer_editorimage textures/town_wall/church_c01dm.jpg
	implicitMap textures/town_wall/church_c01dm.jpg
}

textures/wb_stone/stone_22
{
	qer_editorimage textures/town_wall/town_c38a.jpg
	implicitMap textures/town_wall/town_c38a.jpg
}

textures/wb_stone/stone_23
{
	qer_editorimage textures/town_wall/town_c91.jpg
	implicitMap textures/town_wall/town_c91.jpg
}

textures/wb_stone/stone_24
{
	qer_editorimage textures/town_wall/town_m_c01.jpg
	implicitMap textures/town_wall/town_m_c01.jpg
}


// ----- custom textures of river and redux ----

textures/wb_stone/stone_31
{
	qer_editorimage textures/wb_stone/rv2nd_floor_tiles02_d.jpg
	implicitMap textures/wb_stone/rv2nd_floor_tiles02_d.jpg
}

textures/wb_stone/stone_32
{
	qer_editorimage textures/wb_stone/rv2nd_trim10.jpg
	implicitMap textures/wb_stone/rv2nd_trim10.jpg
}

textures/wb_stone/stone_33
{
	qer_editorimage textures/wb_stone/tr2r_trim10c.jpg
	implicitMap textures/wb_stone/tr2r_trim10c.jpg
}

textures/wb_stone/stone_34
{
	qer_editorimage textures/wb_stone/tr2r_wall02_01.jpg
	implicitMap textures/wb_stone/tr2r_wall02_01.jpg
}

textures/wb_stone/stone_35
{
	qer_editorimage textures/wb_stone/tr2r_wall05sm.jpg //tr2r_wall05sma.jpg
	implicitMap textures/wb_stone/tr2r_wall05sm.jpg
}

textures/wb_stone/stone_36
{
	qer_editorimage textures/wb_stone/tr2r_wall06.jpg
	implicitMap textures/wb_stone/tr2r_wall06.jpg
}






// ----- floors from here on -------------------

textures/wb_stone/stone_41
{
	qer_editorimage textures/castle_wall/castle_m03_step_grave_03.jpg
	implicitMap textures/castle_wall/castle_m03_step_grave_03.jpg
}

textures/wb_stone/stone_42
{
	qer_editorimage textures/castle_wall/castle_m03a_step.jpg
	implicitMap textures/castle_wall/castle_m03a_step.jpg
}

textures/wb_stone/stone_43
{
	qer_editorimage textures/town_floor/floor_d01.jpg
	implicitMap textures/town_floor/floor_d01.jpg
}


// ----- stuff from here on -------------------

textures/wb_stone/stone_51
{
	qer_editorimage textures/wb_stone/wall23_ns1_00.jpg
	implicitMap textures/wb_stone/wall23_ns1_00.jpg
}

textures/wb_stone/stone_52
{
	qer_editorimage textures/wb_stone/wall24_Ba50.jpg
	implicitMap textures/wb_stone/wall24_Ba50.jpg
}

textures/wb_stone/stone_52a
{
	qer_editorimage textures/wb_stone/wall24_Ba50a.jpg
	implicitMap textures/wb_stone/wall24_Ba50a.jpg
}

textures/wb_stone/stone_53
{
	qer_editorimage textures/wb_stone/wall23_b.jpg
	q3map_nonplanar
	q3map_shadeangle 120
	implicitMap textures/wb_stone/wall23_b.jpg
}

textures/wb_stone/stone_53b
{
	qer_editorimage textures/wb_stone/wall23_n40.jpg
	q3map_nonplanar
	q3map_shadeangle 120
	implicitMap textures/wb_stone/wall23_n40.jpg
}

textures/wb_stone/stone_54
{
	qer_editorimage textures/wb_stone/wall25_01a.jpg
	implicitMap textures/wb_stone/wall25_01a.jpg
	q3map_nonplanar
	q3map_shadeangle 120
}

textures/wb_stone/stone_54a
{
	qer_editorimage textures/wb_stone/wall25_01b.jpg
	implicitMap textures/wb_stone/wall25_01b.jpg
	q3map_nonplanar
	q3map_shadeangle 120
}


// ----- decorative stuff from here on ---------

textures/wb_stone/stone_61
{
	qer_editorimage textures/broken_castle/wall_c05.jpg
	implicitMap textures/broken_castle/wall_c05.jpg
}

textures/wb_stone/stone_62
{
	qer_editorimage textures/cathedrale_wall/cathedrale_c13.jpg
	implicitMap textures/cathedrale_wall/cathedrale_c13.jpg
}


// ----- rubble from here on ---------

textures/wb_stone/wb_rubble01
{
	qer_editorimage textures/rubble/debri_m05.jpg
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/rubble/debri_m05.jpg
}

textures/wb_stone/wb_rubble02
{
	qer_editorimage textures/rubble/debri_m01.jpg
	surfaceparm gravelsteps
	implicitMap textures/rubble/debri_m01.jpg
}



// ---------------------------------------------
// ------------ WOOD ---------------------------
// ---------------------------------------------

textures/wb_mat/wood_01
{
	qer_editorimage textures/castle_wood/cwood_c10.jpg
	surfaceparm woodsteps
	implicitMap textures/castle_wood/cwood_c10.jpg
}

textures/wb_mat/wood_02
{
	qer_editorimage textures/chat_wood/chwood_c02.jpg
	surfaceparm woodsteps
	implicitMap textures/chat_wood/chwood_c02.jpg
}

textures/wb_mat/wood_03
{
	qer_editorimage textures/chateau/wood_c05.jpg
	surfaceparm woodsteps
	implicitMap textures/chateau/wood_c05.jpg
}

textures/wb_mat/wood_04
{
	qer_editorimage textures/chat_wood/chwood_c04.jpg
	surfaceparm woodsteps
	implicitMap textures/chat_wood/chwood_c04.jpg
}

textures/wb_mat/wood_05
{
	qer_editorimage textures/egypt_floor_sd/wood_c13.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_floor_sd/wood_c13.jpg
}

textures/wb_mat/wood_06
{
	qer_editorimage textures/egypt_wood_sd/wood1b.tga
	surfaceparm woodsteps
	implicitMap textures/egypt_wood_sd/wood1b.tga
}

textures/wb_mat/wood_06a
{
	qer_editorimage textures/egypt_wood_sd/wood1a.tga
	surfaceparm woodsteps
	implicitMap textures/egypt_wood_sd/wood1a.tga
}

textures/wb_mat/wood_07
{
	qer_editorimage textures/town_wood/wood_c01.jpg
	surfaceparm woodsteps
	implicitMap textures/town_wood/wood_c01.jpg
}

textures/wb_mat/wood_08
{
	qer_editorimage textures/wb_b/wood08.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/wood08.jpg
}

textures/wb_mat/wood_09
{
	qer_editorimage textures/wb_b/wood09.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/wood09.jpg
}

textures/wb_mat/wood_10
{
	qer_editorimage textures/wb_b/wood10.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/wood10.jpg
}


// ----- decorative stuff from here on ---------

textures/wb_mat/wood_21
{
	qer_editorimage textures/chat_wood/chwood_c04.jpg
	surfaceparm woodsteps
	implicitMap textures/chat_wood/chwood_c04.jpg
}

textures/wb_mat/wood_22
{
	qer_editorimage textures/egypt_floor_sd/floor_c06.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_floor_sd/floor_c06.jpg
}

textures/wb_mat/wood_23
{
	qer_editorimage textures/egypt_trim_sd/ctrim_c01.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_trim_sd/ctrim_c01.jpg
}

textures/wb_mat/wood_24
{
	qer_editorimage textures/egypt_trim_sd/ctrim_c03.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_trim_sd/ctrim_c03.jpg
}

textures/wb_mat/wood_25
{
	qer_editorimage textures/egypt_trim_sd/trim_c14.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_trim_sd/trim_c14.jpg
}

textures/wb_mat/wood_26
{
	qer_editorimage textures/chateau/pillar_temp_rf.jpg
	surfaceparm woodsteps
	implicitMap textures/chateau/pillar_temp_rf.jpg
}

textures/wb_mat/wood_27
{
	qer_editorimage textures/chateau/trim_c09.jpg
	surfaceparm woodsteps
	implicitMap textures/chateau/trim_c09.jpg
}

textures/wb_mat/wood_28
{
	qer_editorimage textures/chateau/wood_test.jpg
	surfaceparm woodsteps
	implicitMap textures/chateau/wood_test.jpg
}

textures/wb_mat/wood_29
{
	qer_editorimage textures/chat/wd_sr_va7.jpg
	surfaceparm woodsteps
	implicitMap textures/chat/wd_sr_va7.jpg
}

textures/wb_mat/wood_30
{
	qer_editorimage textures/chat/desk1.jpg
	surfaceparm woodsteps
	implicitMap textures/chat/desk1.jpg
}


// ---------------------------------------------
// ------------ BUILDING-PROPS -----------------
// ---------------------------------------------

textures/wb_b/wb_door01
{
	qer_editorimage textures/castle_door/door_c17.jpg
	surfaceparm woodsteps
	implicitMap textures/castle_door/door_c17.jpg
}


textures/wb_b/wb_door02
{
	qer_editorimage textures/doors/door_c01b.jpg
	surfaceparm woodsteps
	implicitMap textures/doors/door_c01b.jpg
}


textures/wb_b/wb_door03
{
	qer_editorimage textures/egypt_door_sd/door_c05.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_door_sd/door_c05.jpg
}

textures/wb_b/wb_door04
{
	qer_editorimage textures/doors/door_c13.jpg
	surfaceparm woodsteps
	implicitMap textures/doors/door_c13.jpg
}


textures/wb_b/wb_door11
{
	qer_editorimage textures/doors/door_m01asml.jpg
	surfaceparm metalsteps
	implicitMap textures/doors/door_m01asml.jpg
}

textures/wb_b/wb_door12
{
	qer_editorimage textures/doors/door_m01asml_axis.tga
	surfaceparm metalsteps
	implicitMap textures/doors/door_m01asml_axis.tga
}

textures/wb_b/wb_door13
{
	qer_editorimage textures/swf/door_m01swf.jpg
	surfaceparm metalsteps
	implicitMap textures/swf/door_m01swf.jpg
}

textures/wb_b/wb_door14
{
	qer_editorimage textures/metals_sd/door_a.tga
	surfaceparm metalsteps
	implicitMap textures/metals_sd/door_a.tga
}

textures/wb_b/wb_door15
{
	qer_editorimage textures/wb_p/wb_door_allied_w2.jpg
	surfaceparm metalsteps
	implicitMap textures/wb_p/wb_door_allied_w2.jpg
}



// ----- windows from here on ------------------

textures/wb_b/wb_window1
{
	qer_editorimage textures/awf/awf_w_m11.tga
	surfaceparm nomarks
	implicitMap textures/awf/awf_w_m11.tga
}

textures/wb_b/wb_window2 // after villwin_15 or so
{
	qer_editorimage textures/wb_b/windowwood1_c1a.jpg
	q3map_surfacelight 100 //300
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1a.jpg
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1light.jpg
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}


textures/wb_b/wb_window2a // after villwin_15 or so
{
	qer_editorimage textures/wb_b/windowwood1_c1a.jpg
	q3map_surfacelight 50 //150
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1a.jpg
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1light.jpg
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

textures/wb_b/wb_window2sfx_2on //on-and-off starting on
{
	qer_editorimage textures/wb_b/windowwood1_c1a1.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/windowwood1_c1a1.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1light.jpg 
		blendfunc add
		rgbGen wave square 0.0 0.7 1 0.01 //base amplitude phase frequency
	}
}

textures/wb_b/wb_window2sfx_2off // on-and-off starting off
{
	qer_editorimage textures/wb_b/windowwood1_c1a1.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/windowwood1_c1a1.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/windowwood1_c1light.jpg 
		blendfunc add
		rgbGen wave square 0.0 0.9 1 0.008 //base amplitude phase frequency
	}
}


// ---------------------------------------------------------------------------------------------
// Abbey Windows -------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------


textures/wb_b/wb_window4sfx_insdark // 
{
	qer_editorimage textures/wb_b/window4_1trim.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
}

textures/wb_b/wb_window4sfx_insmoon1a // lit by moonlight
{
	qer_editorimage textures/wb_b/window4_Lmoon1.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lmoon1.jpg
		blendfunc add
		rgbGen wave square 0.5 0 1 0.025 //base amplitude phase frequency
	}
}

textures/wb_b/wb_window4sfx_insmoon1b // lit by moonlight
{
	qer_editorimage textures/wb_b/window4_Lmoon1.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lmoon1.jpg
		blendfunc add
		rgbGen wave square 0.65 0 1 0.025 //base amplitude phase frequency
	}
}

textures/wb_b/wb_window4sfx_insmoon1c // lit by moonlight
{
	qer_editorimage textures/wb_b/window4_Lmoon1.jpg
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lmoon1.jpg
		blendfunc add
		rgbGen wave square 0.35 0 1 0.025 //base amplitude phase frequency
	}
}




textures/wb_b/wb_window4sfx_insmoon2 // lit by moonlight
{
	qer_editorimage textures/wb_b/window4_Lmoon1.jpg
	q3map_surfacelight 100
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/wb_b/window4_1trim.jpg
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lmoon1.jpg
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

textures/wb_b/wb_window4sfx_outslit3
{
	qer_editorimage textures/wb_b/window4_Lorange4.jpg
	//q3map_surfacelight 10
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lorange4.jpg
		blendfunc add
		rgbGen wave square 0.4 0 1 0.025 //base amplitude phase frequency
	}
}

textures/wb_b/wb_window4sfx_outslit4
{
	qer_editorimage textures/wb_b/window4_Lorange5.jpg
	q3map_surfacelight 20
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_b/window4_1trim.jpg //basic pic
		blendfunc filter
		rgbGen identity
	}
	{
		map textures/wb_b/window4_Lorange5.jpg
		blendfunc add
		rgbGen wave square 0.4 0 1 0.025 //base amplitude phase frequency
	}
}



// ----- shudders from here on -----------------

textures/wb_b/wb_shudder01
{
	qer_editorimage textures/town_window/shudder_c04.jpg
	surfaceparm woodsteps
	implicitMap textures/town_window/shudder_c04.jpg
}

textures/wb_b/wb_shudder02
{
	qer_editorimage textures/tobruk_windows_sd/tobruk_shutterbrown.jpg
	surfaceparm woodsteps
	implicitMap textures/tobruk_windows_sd/tobruk_shutterbrown.jpg
}

textures/wb_b/wb_shudder03
{
	qer_editorimage textures/wb_b/window4c.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/window4c.jpg
}

textures/wb_b/wb_shudder04
{
	qer_editorimage textures/wb_b/window4d.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/window4d.jpg
}



// ----- roofs from here on --------------------

textures/wb_b/roof_01
{
	qer_editorimage textures/wb_b/roof_wood01_d1.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_b/roof_wood01_d1.jpg
}

textures/wb_b/roof_11
{
	qer_editorimage textures/town_roof/roof_c03a.jpg
	implicitMap textures/town_roof/roof_c03a.jpg
}

textures/wb_b/roof_12
{
	qer_editorimage textures/town_roof/roof_c02.jpg
	implicitMap textures/town_roof/roof_c02.jpg
}


// ---------------------------------------------
// ------------ PROPS VARIOUS ------------------
// ---------------------------------------------


textures/wb_p/flag
{
	qer_editorimage textures/wb_z/banner.tga
	surfaceparm nomarks
        surfaceparm trans 
        surfaceparm alphashadow
        cull twosided
	deformVertexes wave 20 sin 0 2 0 0.2
        nopicmip
	{
        	map textures/wb_z/banner.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_p/flag_2
{
	qer_editorimage textures/wb_z/flag_m02.tga
	surfaceparm nomarks
        surfaceparm trans 
        surfaceparm alphashadow
        cull twosided
	deformVertexes wave 20 sin 0 2 1 0.15
        nopicmip
	{
        	map textures/wb_z/flag_m02.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_p/flag_3
{
	qer_editorimage textures/wb_z/flags_temp.tga
	surfaceparm nomarks
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
	deformVertexes wave 20 sin 0 2 0 0.15
        nopicmip
	{
        	map textures/wb_z/flags_temp.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_p/wb_carpet1
{
	qer_editorimage textures/chat/carpet_c03.jpg
	surfaceparm nosteps
	surfaceparm dust
	implicitMap textures/chat/carpet_c03.jpg // -
}

textures/wb_p/wb_rope
{
	qer_editorimage textures/props/cable_m01.jpg
	q3map_nonplanar
	q3map_shadeangle 270
	surfaceparm woodsteps
	implicitMap textures/props/cable_m01.jpg // -
}

textures/wb_p/wb_swimming
{
	qer_editorimage textures/wb_p/wb_swimming.jpg
	surfaceparm woodsteps
	implicitMap textures/wb_p/wb_swimming.jpg
}

textures/wb_p/wb_bellwheel
{
	qer_editorimage textures/wb_p/bell_wheel1d.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/wb_p/bell_wheel1d.tga
}



// ---------------------------------------------
// ------------ PROPS ART ----------------------
// ---------------------------------------------


textures/wb_p/wb_rubens1 // Pieter Paul Rubens (1619) Christ on the Cross between 2 Thieves
{
	qer_editorimage textures/wb_p/wb_rubens1.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	nopicmip
	nocompress
	implicitMap textures/wb_p/wb_rubens1.jpg
}

textures/wb_p/wb_rubens2 // Pieter Paul Rubens (1632) Last Supper
{
	qer_editorimage textures/wb_p/wb_rubens2.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	nopicmip
	nocompress
	implicitMap textures/wb_p/wb_rubens2.jpg
}

textures/wb_p/wb_stmartin // unknown hungarian master, app. 1490: St Martin and the Beggar
{
	qer_editorimage textures/wb_p/wb_stmartin.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	nopicmip
	nocompress
	implicitMap textures/wb_p/wb_stmartin.jpg
}

textures/wb_p/wb_duerer1 // Albrecht Drer: praying hands
{
	qer_editorimage textures/wb_sfx/prayinghint.tga
	qer_trans .9

	cull none // back means: inside of a brush is visible
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nocompress
	nopicmip

	{
		map textures/chateau/wood_c05.jpg // walltest_c07a.jpg
		tcMod_scale 2
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/prayinghint.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.75 0 0 0.1 //base amplitude phase frequency
	}
}

textures/wb_p/wb_duerer2 // Albrecht Drer: praying hands
{
	qer_editorimage textures/wb_sfx/prayinghint.tga
	nocompress
	nopicmip
	surfaceparm woodsteps
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_p/torchbase.tga //basic
		blendfunc filter
		rgbGen identity
		tcMod scale 2 2 //0.25 is way too large
	}
	{
		map textures/wb_sfx/prayinghint.tga //
		blendfunc filter
		rgbGen wave sin 1 0 0 0.1 //base amplitude phase frequency 
	}
}

textures/wb_p/wb_duerer3 // Albrecht Drer: praying hands
{
	qer_editorimage textures/wb_sfx/prayinghint.tga
	nocompress
	nopicmip
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitmap textures/wb_sfx/prayinghint.tga
}

textures/wb_p/wb_duererbg // 
{
	qer_editorimage textures/wb_sfx/wb_wax1bottom_a.tga
	nocompress
	nopicmip
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitmap textures/wb_sfx/wb_wax1bottom_a.tga
}


textures/wb_p/wb_kachart2
{
	qer_editorimage textures/wb_p/wb_kachart2.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	nopicmip
	nocompress
	implicitMap textures/wb_p/wb_kachart2.jpg
}

textures/wb_p/wb_kachart3
{
	qer_editorimage textures/wb_p/wb_kachart3.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	nopicmip
	nocompress
	implicitMap textures/wb_p/wb_kachart3.jpg
}


textures/wb_p/wb_artframe1
{
	//qer_editorimage textures/wb_p/wb_artframe1.jpg
	surfaceparm woodsteps
	implicitMap -
}

textures/wb_p/wb_artframe2
{
	//qer_editorimage textures/wb_p/wb_artframe2.jpg
	surfaceparm woodsteps
	implicitMap -
}


// ------------------------------------------------
// ------------ SFX LIGHTS ------------------------
// ------------------------------------------------


textures/wb_p/wb_light01 // lamp-look without emitting light
{
	qer_editorimage textures/lights/light_c04.tga
	implicitMap textures/lights/light_c04.tga
}

textures/wb_p/wb_torch
{
	qer_editorimage textures/wb_p/torch_1orange
	surfaceparm nomarks
	// q3map_surfacelight 3000 //we dont need light-emitting
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/wb_p/torchbase.tga //basic
		blendfunc filter
		rgbGen identity
		tcMod scale 2 2 //0.25 is way too large
	}
	{
		map textures/wb_p/torch_1orange.tga //orange
		blendfunc filter
		rgbGen wave sin 0.2 0.25 0 0.1 //base amplitude phase frequency 
		tcMod scale 2 2 //0.25 is way too large
	}
	{
		map textures/wb_p/torch_1red.tga //red
		blendfunc add
		rgbGen wave sin 0.25 0.2 0 0.06 //base amplitude phase frequency 
		tcMod scale 2 2
	}
}

textures/wb_p/wb_wax1
{
	qer_editorimage textures/wb_p/wb_wax1.jpg

	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180

	surfaceparm nomarks
	surfaceparm nonsolid	

	implicitMap -
}

textures/wb_sfx/wb_wax1bottom_a // decal 
{
	qer_editorimage textures/wb_ei/ei_wb_wax1bottom_a.jpg
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
	nocompress
        nopicmip
	polygonOffset
         
	{
        	map textures/wb_sfx/wb_wax1bottom_a.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_sfx/wb_wax1bottom_b // decal 
{
	qer_editorimage textures/wb_ei/ei_wb_wax1bottom_b.tga
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
	nocompress
        nopicmip
	polygonOffset
         
	{
        	map textures/wb_sfx/wb_wax1bottom_b.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_sfx/wb_wax1bottom_c // decal 
{
	qer_editorimage textures/wb_ei/ei_wb_wax1bottom_c.tga
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
	nocompress
        nopicmip
	polygonOffset
         
	{
        	map textures/wb_sfx/wb_wax1bottom_c.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_sfx/wb_sfxcandle1 // a modified wilsflame
{
	qer_editorimage textures/wb_sfx/c_flame0.tga
	cull none
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans

	deformvertexes autosprite2

	{
		animMap 6 textures/wb_sfx/c_flame0.tga textures/wb_sfx/c_flame1.tga textures/wb_sfx/c_flame2.tga textures/wb_sfx/c_flame3.tga textures/wb_sfx/c_flame4.tga textures/wb_sfx/c_flame5.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 6
	}
	{
		animMap 6 textures/wb_sfx/c_flame0.tga textures/wb_sfx/c_flame1.tga textures/wb_sfx/c_flame2.tga textures/wb_sfx/c_flame3.tga textures/wb_sfx/c_flame4.tga textures/wb_sfx/c_flame5.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 6
	}
	{
		map textures/wb_sfx/sfx_candlebase1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6
	}
}

textures/wb_sfx/wb_sfxcandle1_le // a modified wilsflame
{
	qer_editorimage textures/wb_sfx/c_flame0.tga
	q3map_surfacelight 10
	cull none
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans

	deformvertexes autosprite2

	{
		animMap 6 textures/wb_sfx/c_flame0.tga textures/wb_sfx/c_flame1.tga textures/wb_sfx/c_flame2.tga textures/wb_sfx/c_flame3.tga textures/wb_sfx/c_flame4.tga textures/wb_sfx/c_flame5.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 6
	}
	{
		animMap 6 textures/wb_sfx/c_flame0.tga textures/wb_sfx/c_flame1.tga textures/wb_sfx/c_flame2.tga textures/wb_sfx/c_flame3.tga textures/wb_sfx/c_flame4.tga textures/wb_sfx/c_flame5.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 6
	}
	{
		map textures/wb_sfx/sfx_candlebase1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6
	}
}


// ---------------------------------------------
// ------------ SFX ABBEY ----------------------
// ---------------------------------------------

textures/wb_sfx/saint
{
	qer_editorimage textures/wb_sfx/prayinghint.tga
	nomipmaps
	nopicmip
	{
		map textures/wb_sfx/prayinghint.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}


textures/wb_p/prayinghands
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/wb_sfx/prayinghint.tga
}

// ---------------------------------------------
// ------------ SFX BOOK -----------------------
// ---------------------------------------------

models/ubc/eb_books_anim
{
	qer_editorimage textures/wb_sfx/bd1.tga
	cull none 
	noPicmip
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	{
		animmap 7 textures/wb_sfx/bd1.tga textures/wb_sfx/bd2.tga textures/wb_sfx/bd3.tga textures/wb_sfx/bd4.tga textures/wb_sfx/bd5.tga textures/wb_sfx/bd6.tga textures/wb_sfx/bd7.tga textures/wb_sfx/bd8.tga textures/wb_sfx/bd9.tga textures/wb_sfx/bd10.tga textures/wb_sfx/bd11.tga textures/wb_sfx/bd12.tga textures/wb_sfx/bd13.tga
		blendfunc add
	}
	{
		animmap 9 textures/wb_sfx/g1.tga textures/wb_sfx/g2.tga textures/wb_sfx/g3.tga textures/wb_sfx/g4.tga textures/wb_sfx/g5.tga textures/wb_sfx/g6.tga textures/wb_sfx/g7.tga textures/wb_sfx/g8.tga textures/wb_sfx/g9.tga textures/wb_sfx/g10.tga textures/wb_sfx/g11.tga textures/wb_sfx/g12.tga textures/wb_sfx/g13.tga
		blendfunc add
		tcMod scale 1 -1
	}

}




// goes around the book(s)
models/ubc/eb_books_anim2   
{
	qer_editorimage textures/wb_sfx/glow.tga
	cull none 
	noPicmip
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	{
		map textures/wb_sfx/glow.tga
		blendfunc gl_dst_color gl_dst_color
		tcMod turb 0 0.5 0 0.15
	}

}


// ---------------------------------------------
// ------------ SFX BLOOD ----------------------
// ---------------------------------------------

textures/wb_sfx/wb_sfxcryptblood // 
{
	qer_editorimage gfx/misc/smokepuffflesh.tga
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
        nopicmip
	polygonOffset
         
	{
        	map gfx/misc/smokepuffflesh.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       

textures/wb_sfx/wb_sfxblood1_1 // decal 
{
	qer_editorimage textures/wb_sfx/sfx_blood01_01.tga
        surfaceparm trans 
        surfaceparm alphashadow
        cull none
	nocompress
        nopicmip
	polygonOffset
         
	{
        	map textures/wb_sfx/sfx_blood01_01.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       



// ---------------------------------------------
// ------------ PROPS EFFECTS SACRIFICE ROOM ---
// ---------------------------------------------



textures/wb_p/wbsfx_try3
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe2a24.tga
	qer_trans .9
	cull front // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	// deformVertexes wave 160 sin 0 10 0 0.3 // maybe good later on
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe2a24.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.1 0.02 0 0.3
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.3 0.2 // +x 0Y works fine
	}
	{
		map textures/liquids_sd/siwa_shimshim1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.02 0.4 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.3 0 // +x 0 Y works fine
	}

}


textures/wb_p/wbsfx_openbook_m
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe2a24.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	deformVertexes wave 150 sin 0 3 0 0.1 // wave div func base amplitude phase freq
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe2a24.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.13 0.02 0 0.1 //base amplitude phase frequency
		tcmod scroll 0.3 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0.25 0.25 0 0.4
		tcmod scroll 0.4 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.18 0.03 1 0.2
		tcmod scale 0.5 1
		tcmod scroll 0.325 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.15 1 0.25
		tcmod scroll 0.35 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.3 1 0.4
		tcmod scroll 0.5 0 // +x 0 Y works fine
	}
}



textures/wb_p/wbsfx_whiteish
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe2a24.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	// deformVertexes wave 160 sin 0 10 0 0.3 // maybe good later on
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe2a24.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.17 0.02 0 0.2 //base amplitude phase frequency
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.4 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.15 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.5 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.15 0.05 1 0.1
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.4 0 // +x 0 Y works fine
	}

	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.2 0 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.55 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.17 1 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.45 0 // +x 0 Y works fine
	}

}

textures/wb_p/wbsfx_whiteish_m
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe2a24.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	deformVertexes wave 256 sin 0 4 0 0.1 // wave div func base amplitude phase freq
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe2a24.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.17 0.018 0 0.18 //base amplitude phase frequency
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.42 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.13 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.51 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1bl.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.18 0.03 1 0.1
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.4 0 // +x 0 Y works fine
	}

	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.17 0 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.53 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.21 0.24 1 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.42 0 // +x 0 Y works fine
	}
}


textures/wb_p/wbsfx_orange1_m
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe4a.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	deformVertexes wave 160 sin 0 5 0 0.1 // wave div func base amplitude phase freq

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe4a.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.17 0.02 0 0.1 //base amplitude phase frequency
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.40 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1orangesm.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.2 0.13 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.48 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1orangesm.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.18 0.03 1 0.1
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scale 0.5 1
		tcmod scroll 0.52 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1orangemed.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.16 0.08 0 0.14
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.46 0 // +x 0 Y works fine
	}
}





textures/wb_p/wbsfx_red1_m
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe3.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	deformVertexes wave 256 sin 0 6 0 0.05 // wave div func base amplitude phase freq
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe3.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.17 0.018 0 0.18 //base amplitude phase frequency
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.35 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1red.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.25 0.15 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.55 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1red2.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.3 0.05 1 0.1
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.7 0 // +x 0 Y works fine
	}

	{
		map textures/wb_sfx/wb_ind_spots1w.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.15 0.05 0 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.6 0 // +x 0 Y works fine
	}
}

textures/wb_p/wbsfx_red1a_m
{
	qer_editorimage textures/wb_sfx/wb_ind_stripe3.tga
	qer_trans .9
	cull none // back means: inside of a brush is visible
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip

	deformVertexes wave 256 sin 0 6 0 0.05 // wave div func base amplitude phase freq
	
	// for tcmod scroll scrolling upwards you need scroll X Y value 0 and -90 angle on the surfaceinspector

	{
		map textures/wb_sfx/sfx_alpha0.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
	}
	{
		map textures/wb_sfx/wb_ind_stripe3.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.25 0.03 0 0.18 //base amplitude phase frequency
		//tcmod transform 0 1.5 1 1.5 2 1
		tcmod scale 0.5 1
		tcmod scroll 0.35 0 // +x 0Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1red.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.4 0.08 0 0.3
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.55 0 // +x 0 Y works fine
	}
	{
		map textures/wb_sfx/wb_ind_spots1red2.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.08 1 0.1
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll 0.7 0 // +x 0 Y works fine
	}

	{
		map textures/wb_sfx/wb_ind_spots1red.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.4 0.05 0 0.25
		// tcmod transform 0 1.5 1 1.5 2 1
		tcmod scale 0.5 1
		tcmod scroll 0.6 0 // +x 0 Y works fine
	}
}
