// Etna Terrain Shaders
// created on october 17th 2006
// Last update on March 13th 2007


// terrain contains 4 different textures: ff_path
//						      ff_grass
//							ff_rock
//							ff_mountain

textures/etna_terrain/e_alpha_100
{
  qer_editorimage textures/etna_terrain/e_alpha_100.tga
  qer_trans 0.75
  q3map_alphamod volume
  q3map_alphamod scale 1
  surfaceparm nonsolid
  surfaceparm nodraw
  surfaceparm trans
}

// *** z-projection shaders ***

textures/etna_terrain/ff_path
{ 
   qer_editorimage textures/etna_terrain/ff_path.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_path.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/ff_grass
{ 
   qer_editorimage textures/etna_terrain/ff_grass.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_grass.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/ff_rock
{ 
   qer_editorimage textures/etna_terrain/ff_rock.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   //surfaceparm landmine 
   //surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_rock.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/ff_mount
{ 
   qer_editorimage textures/etna_terrain/ff_mount.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_mount.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}


// *** z-projection blendings ***

textures/etna_terrain/path2grass
{ 
   qer_editorimage textures/etna_terrain/path2grass.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_grass.tga 
      rgbGen identity 
   } 
   { 
         map textures/etna_terrain/ff_path.tga
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       	 rgbGen identity 
         alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}



textures/etna_terrain/grass2path // just testing....
{ 
   qer_editorimage textures/etna_terrain/grass2path.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_path.tga 
      rgbGen identity 
   } 
   { 
         map textures/etna_terrain/ff_grass.tga
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       	 rgbGen identity 
         alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}


textures/etna_terrain/grass2mount
{ 
   qer_editorimage textures/etna_terrain/grass2mount.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_grass.tga 
      rgbGen identity 
   } 
   { 
         map textures/etna_terrain/ff_mount.tga
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       	 rgbGen identity 
         alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}

textures/etna_terrain/path2mount
{ 
   qer_editorimage textures/etna_terrain/path2mount.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_path.tga 
      rgbGen identity 
   } 
   { 
         map textures/etna_terrain/ff_mount.tga
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       	 rgbGen identity 
         alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}


textures/etna_terrain/ff_rockX // x-projection
{ 
   qer_editorimage textures/etna_terrain/ff_rockx.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 0 512 0 ) ( 0 0 512 )
   //surfaceparm landmine 
   //surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_rock.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/ff_rockY  // y-projection
{ 
   qer_editorimage textures/etna_terrain/ff_rocky.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 0 0 512 ) ( 512 0 0 )
   //surfaceparm landmine 
   //surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_rock.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/ff_rockxy //x-y blending
{ 
   qer_editorimage textures/etna_terrain/ff_rockxy.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 0 512 0 ) ( 0 0 512 )
   //surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_rock.tga 
	tcGen vector ( 0  0 0.00195 ) ( 0.00195 0 0 )
      rgbGen identity 
   } 
   { 
       //map textures/etna_terrain/copper.tga 
	 map textures/etna_terrain/ff_rock.tga 
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}

textures/etna_terrain/ff_rocky2grass
{ 
   qer_editorimage textures/etna_terrain/ff_rocky2grass.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_rock.tga 
	tcGen vector ( 0  0 0.00195 ) ( 0.00195 0 0 )
      rgbGen identity 
   } 
   { 
       map textures/etna_terrain/ff_grass.tga   
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}


textures/etna_terrain/ff_rock_new // _remap - used for the "rock" models
{
	 
	q3map_nonplanar
	q3map_shadeangle 60
	qer_editorimage textures/etna_terrain/ff_rock.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/etna_terrain/ff_rock.tga 
		blendFunc filter
	}
}

textures/etna_terrain/grass2rockx // x-blending for top & bottom cliffs
{ 
   qer_editorimage textures/etna_terrain/grass2rockx.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 0 512 0 ) ( 0 0 512 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_grass.tga 
	rgbGen identity 
   } 
   { 
       map textures/etna_terrain/ff_rock.tga   
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}

textures/etna_terrain/grass2rocky // y-blending for top & bottom cliffs
{ 
   qer_editorimage textures/etna_terrain/grass2rocky.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 0 0 512 ) ( 512 0 0 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_grass.tga 
	rgbGen identity 
   } 
   { 
       map textures/etna_terrain/ff_rock.tga   
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}

textures/etna_terrain/path2rock // working vertical blend... for now
{ 
   qer_editorimage textures/etna_terrain/path2rock.tga  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   //q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_tcgen ivector ( 0 512 0 ) ( 0 0 512 )
   surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
      map textures/etna_terrain/ff_path.tga 
      rgbGen identity 
   } 
   { 
         map textures/etna_terrain/ff_rock.tga
     	   blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
         rgbGen identity 
         alphaGen vertex 
      } 
      { 
             map $lightmap 
             blendFunc GL_DST_COLOR GL_ZERO
             rgbGen identity
      } 
}

textures/etna_terrain/path2cobbles
{ 
   qer_editorimage textures/etna_terrain/path2cobbles.jpg  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   //surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
	map textures/etna_terrain/ff_grass.tga
      rgbGen identity 
   } 
   { 
       map textures/desert_sd/pavement_quad_sandy.tga
     	 blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity
   } 
}

textures/etna_terrain/ff_grass2
//dusty ash texture - no landmines
{ 
   qer_editorimage textures/etna_terrain/ff_grass2_edit.tga  
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   //surfaceparm landmine 
   surfaceparm grasssteps 
   { 
      map textures/etna_terrain/ff_grass.tga 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity 
   } 
}

textures/etna_terrain/dust2slabs
{ 
   qer_editorimage textures/etna_terrain/dust2slabs.jpg  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   //surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
 map textures/etna_terrain/ff_grass.tga
      rgbGen identity 
   } 
   { 
       map textures/etna_b1/church_flagstones.jpg
 	blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
 	tcMod scale 4 4
 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity
   } 
}

textures/etna_terrain/sandfloor2ground
{ 
   qer_editorimage textures/etna_terrain/sandfloor2ground.jpg  
    
   q3map_lightmapsampleoffset 16 
   q3map_lightmapmergable 
   q3map_shadeangle 170
   q3map_nonplanar 
   q3map_forcemeta 
   q3map_tcgen ivector ( 512 0 0 ) ( 0 512 0 )
   //surfaceparm landmine 
   //surfaceparm grasssteps   
   { 
 map textures/etna_terrain/ff_grass.tga
      rgbGen identity 
   } 
   { 
       map textures/etna_b1/floor_c04c.tga
 	blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA             
       rgbGen identity 
       alphaGen vertex 
 	tcMod scale 4 4
 
   } 
   { 
       map $lightmap 
       blendFunc GL_DST_COLOR GL_ZERO
       rgbGen identity
   } 
}



