//==================================================================================
// Shaders for v2_factory
//
// last mod: Mean Mr. Mustard 03/29/2004
//==================================================================================

//====================================================================================
// terrain shaders
//====================================================================================

textures/v2_factory/terrain_base
{
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_lightmapsize 512 512
	//q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_forceMeta 
	q3map_nonPlanar 
	q3map_shadeAngle 180 
}

textures/v2_factory/terrain_0
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_1
{
	qer_editorimage textures/temperate_sd/rocky_sand.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rocky_sand.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}


textures/v2_factory/terrain_2
{
	qer_editorimage textures/temperate_sd/rock_grayvar.tga
      q3map_nonplanar
	q3map_shadeangle 179
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_3
{
	qer_editorimage textures/temperate_sd/grass_path1.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_path1.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_4
{
	qer_editorimage textures/temperate_sd/grass_dense1.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen identity
	}
	{
		lightmap $lightmap		
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_5
{
	qer_editorimage textures/temperate_sd/rock_ugly_brown.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		rgbGen identity
	}
	{
		lightmap $lightmap		
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_0to1
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rocky_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_0to2
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	surfaceparm landmine
	surfaceparm grasssteps
	q3map_baseshader textures/v2_factory/terrain_base
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_0to3
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_0to4
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_0to5
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_1to2
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/rocky_sand.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_1to3
{
	qer_editorimage textures/temperate_sd/rocky_sand.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rocky_sand.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_1to4
{
	qer_editorimage textures/temperate_sd/rocky_sand.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rocky_sand.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_1to5
{
	qer_editorimage textures/temperate_sd/rocky_sand.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rocky_sand.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_2to3
{
	qer_editorimage textures/temperate_sd/rock_grayvar.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_2to4
{
	qer_editorimage textures/temperate_sd/rock_grayvar.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps

	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_2to5
{
	qer_editorimage textures/temperate_sd/rock_grayvar.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_3to4
{
	qer_editorimage textures/temperate_sd/grass_path1.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_path1.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_3to5
{
	qer_editorimage textures/temperate_sd/grass_path1.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_path1.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/v2_factory/terrain_4to5
{
	qer_editorimage textures/temperate_sd/grass_dense1.tga
	q3map_baseshader textures/v2_factory/terrain_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

//**********************************************************************//
//												//
//	Desert.shader for Q3Radiant							//
//	by Sock - 19th August 2000							//
//												//
//**********************************************************************//
// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
// color will be normalized, so it doesn't matter what range you use
// intensity falls off with angle but not distance 100 is a fairly bright sun
// degree of 0 = from the east, 90 = north, etc.  altitude of 0 = sunrise/set, 90 = noon

textures/desert/desert_skybox
{
	qer_editorimage textures/desert/desert_view.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 75
	surfaceparm sky

// my changes

	fogvars ( .56 .58 .75 ) .000015
	q3map_skylight 75 3
	q3map_sunExt 0.6 0.5 0.2 100 160 50 2 16

	//q3map_sun 1.00 0.949 0.977 100 200 45
	skyparms textures/desert/env/desert/desert - -
}

//=================================================================================
// texture shaders 
//=================================================================================

textures/v2_factory/v2_wood_c01
{
	surfaceparm woodsteps
	implicitMap -
}

textures/v2_factory/v2_dirt3
{
	qer_editorimage textures/temperate_sd/dirt3.tga
	q3map_nonplanar
      q3map_shadeangle 120
	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/v2_factory/v2_dirt3.tga
}

textures/v2_factory/rope
{
	qer_editorimage textures/props/cable_m01.jpg 
	surfaceparm metalsteps 
	{
		map textures/props/cable_m01.jpg 
		rgbGen vertex 
	} 
}
//====================================================================================
// sign shaders
//====================================================================================

textures/v2_factory/knife
{
	qer_editorimage textures/v2_factory/knife_fight.jpg
	implicitMap textures/v2_factory/knife_fight.jpg 
}

textures/v2_factory/prodv2_signr
{
	qer_editorimage textures/v2_factory/prodv2_signr.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/prodv2_signr.tga
		rgbGen vertex
	}
}

textures/v2_factory/prodo2_signr
{
	qer_editorimage textures/v2_factory/prodo2_signr.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/prodo2_signr.tga
		rgbGen vertex
	}
}

textures/v2_factory/ablage_signr
{
	qer_editorimage textures/v2_factory/ablage_signr.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/ablage_signr.tga
		rgbGen vertex
	}
}
textures/v2_factory/prodv2_signl
{
	qer_editorimage textures/v2_factory/prodv2_signl.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/prodv2_signl.tga
		rgbGen vertex
	}
}

textures/v2_factory/prodo2_signl
{
	qer_editorimage textures/v2_factory/prodo2_signl.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/prodo2_signl.tga
		rgbGen vertex
	}
}

textures/v2_factory/ablage_signl
{
	qer_editorimage textures/v2_factory/ablage_signl.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/ablage_signl.tga
		rgbGen vertex
	}
}

//====================================================================================
// timer shaders
//====================================================================================

textures/v2_factory/v2_production_on
{
	qer_editorimage textures/v2_factory/v2_production_on.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/v2_production_on.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_production_off
{
	qer_editorimage textures/v2_factory/v2_production_off.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/v2_production_off.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_production_complete
{
	qer_editorimage textures/v2_factory/v2_production_complete.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/v2_production_complete.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_asm/time0
{
	qer_editorimage textures/v2_factory/timer_zero.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_zero.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_asm/time20
{
	qer_editorimage textures/v2_factory/timer_twenty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_twenty.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_asm/time40
{
	qer_editorimage textures/v2_factory/timer_forty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_forty.tga
		rgbGen vertex
	}
}

textures/v2_factory/v2_asm/time60
{
	qer_editorimage textures/v2_factory/timer_sixty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_sixty.tga
		rgbGen vertex
	}

}

textures/v2_factory/v2_asm/time80
{
	qer_editorimage textures/v2_factory/timer_eighty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_eighty.tga
		rgbGen vertex
	}

}

textures/v2_factory/v2_asm/time100
{
	qer_editorimage textures/v2_factory/timer_hundred.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_hundred.tga
		rgbGen vertex
	}
}

//--------------- O2 production signs/timer -----------------

textures/v2_factory/o2_production_on
{
	qer_editorimage textures/v2_factory/o2_production_on.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_production_on.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_production_off
{
	qer_editorimage textures/v2_factory/o2_production_off.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_production_off.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_production_complete
{
	qer_editorimage textures/v2_factory/o2_production_complete.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_production_complete.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time0
{
	qer_editorimage textures/v2_factory/timer_zero.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_zero.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time20
{
	qer_editorimage textures/v2_factory/timer_twenty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_twenty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time40
{
	qer_editorimage textures/v2_factory/timer_forty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_forty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time60
{
	qer_editorimage textures/v2_factory/timer_sixty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_sixty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time80
{
	qer_editorimage textures/v2_factory/timer_eighty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_eighty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_prod/time100
{
	qer_editorimage textures/v2_factory/timer_hundred.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_hundred.tga 
		rgbGen vertex
	}
}

//--------------- O2 storage signs/timer -----------------

textures/v2_factory/o2_ablage_on
{
	qer_editorimage textures/v2_factory/o2_ablage_on.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_ablage_on.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_ablage_off
{
	qer_editorimage textures/v2_factory/o2_ablage_off.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_ablage_off.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_ablage_complete
{
	qer_editorimage textures/v2_factory/o2_ablage_complete.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/o2_ablage_complete.tga
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time0
{
	qer_editorimage textures/v2_factory/timer_zero.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_zero.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time20
{
	qer_editorimage textures/v2_factory/timer_twenty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_twenty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time40
{
	qer_editorimage textures/v2_factory/timer_forty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_forty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time60
{
	qer_editorimage textures/v2_factory/timer_sixty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_sixty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time80
{
	qer_editorimage textures/v2_factory/timer_eighty.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_eighty.tga 
		rgbGen vertex
	}
}

textures/v2_factory/o2_stor/time100
{
	qer_editorimage textures/v2_factory/timer_hundred.tga
	surfaceparm metalsteps 
	{
		map textures/v2_factory/timer_hundred.tga 
		rgbGen vertex
	}
}

//-----------Poster Shaders---------------------

textures/v2_factory/v2poster
{
	 implicitMap -
}

textures/v2_factory/axis1
{
	 implicitMap -
}

textures/v2_factory/axis2
{
	 implicitMap -
}

textures/v2_factory/axis3
{
	 implicitMap -
}

textures/v2_factory/axis4
{
	 implicitMap -
}

// ---- Soft water stuff ----------

textures/v2_factory/mmm_water
{
	nocompress
	qer_editorimage textures/liquids_sd/siwa_water.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
	nopicmip
	nofog

	waterfogvars ( 0.11 0.13 0.15 ) 300
	{ 
		fog on
		map textures/liquids_sd/sea_bright_na.tga 
		blendFunc blend
		alphaGen vertex
		depthWrite
		rgbgen identity
		tcmod scale 0.5 0.5
		tcmod scroll -.05 .001
	}
}

textures/v2_factory/mmm_water2
{
	nocompress
	qer_editorimage textures/liquids_sd/siwa_water.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
	nopicmip
	nofog

	waterfogvars ( 0.11 0.13 0.15 ) 0.2
	{ 
		fog on
		map textures/liquids_sd/sea_bright_na.tga 
		blendFunc blend
		alphaGen vertex
		depthWrite
		rgbgen identity
		tcmod scale 0.5 0.5
		tcmod scroll -.01 -.001
	}
}
