// Transmitter Shader - Spring
// Last modified: Tardis, 18-09-2014
textures/transmitter_spring/waternodraw
{
	qer_editorimage textures/common/nodrawwater.tga
	qer_trans .75
	surfaceparm nomarks
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
}

//--- water from UJE 00
textures/transmitter_spring/water_base
{
	nocompress
	qer_editorimage textures/transmitter_sp/c1_128.tga
	qer_trans .40
	q3map_globaltexture
	q3map_nonplanar
	q3map_nofog
	q3map_nolightmap
	q3map_onlyvertexlighting
	surfaceparm	nonsolid
	surfaceparm	water
	surfaceparm	trans
	cull	disable
}


textures/transmitter_spring/water
{
	q3map_baseshader textures/transmitter_spring/water_base
	qer_editorimage textures/transmitter_sp/c1_128.tga
	cull none

	tessSize 512
	deformVertexes wave 224 sin 0 3 0.5 0.23
	surfaceparm	water
	cull	disable
	{
		animMap 9 textures/transmitter_sp/c1_128.tga textures/transmitter_sp/c2_128.tga textures/transmitter_sp/c3_128.tga textures/transmitter_sp/c4_128.tga textures/transmitter_sp/c5_128.tga textures/transmitter_sp/c6_128.tga textures/transmitter_sp/c7_128.tga textures/transmitter_sp/c8_128.tga

		blendfunc gl_src_alpha gl_one
		alphaGen const 0.25
		rgbGen vertex
		depthWrite
		tcmod scale 0.3 0.25
		tcmod turb 0 0.1 0.3 0.25
		tcmod scroll 0.004 0.003
	}
	{
		map textures/transmitter_sp/water.tga
		rgbGen identity
		blendFunc blend
		alphaGen const 0.85 //0.56
		depthWrite
	}
	{
		map textures/transmitter_sp/uje_env.tga

		blendfunc gl_src_alpha gl_one
		alphaGen const 0.05
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
		depthFunc equal
	}
}

textures/transmitter_spring/water_inside
{
	q3map_invert

	q3map_baseshader textures/transmitter_spring/water_base
	sort nearest
	tessSize 512
	deformVertexes wave 224 sin 0 3 0.5 0.23
	surfaceparm	water
	cull	disable
	{
		map textures/transmitter_sp/water.tga
		rgbGen identity
		blendFunc blend
		alphaGen const 0.56
		depthWrite
		tcmod scale 0.3 0.25
		tcmod turb 0 0.01 0 0.15
		tcmod scroll 0.004 0.003
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
		depthFunc equal
	}
}