// Transmitter Shader - Spring
// Original Transmitter Sader by heeen, MindLink, thegnat
// Last modified: Mateos, 28-05-2012
// Last modified: Tardis, 18-09-2014

textures/editor_image/alpha_000
{
	qer_trans 0.95
	qer_editorimage textures/editor_image/alpha_000.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/editor_image/alpha_100
{
	qer_trans 0.95
	qer_editorimage textures/editor_image/alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/transmitter_sp/base
{
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapaxis z
	q3map_lightmapMergable
	q3map_lightmapsize 512 512
	q3map_tcMod rotate 37
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
}

textures/transmitter_spring/terrain_foliage_base
{
	q3map_baseshader textures/transmitter_sp/base

	q3map_foliage models/foliage/grassfoliage1.md3 1.25 48 0.1 2
	q3map_foliage models/foliage/grassfoliage2.md3 1.1 48 0.1 2
	q3map_foliage models/foliage/grassfoliage3.md3 1 48 0.1 2
}

textures/transmitter_spring/terrain_foliage_fade
{
	q3map_baseshader textures/transmitter_sp/base

	q3map_foliage models/foliage/grassfoliage1.md3 1.25 64 0.1 2
	q3map_foliage models/foliage/grassfoliage2.md3 1.1 64 0.1 2
	q3map_foliage models/foliage/grassfoliage3.md3 1 64 0.1 2
}

//Riverbed - no follage

textures/transmitter_spring/terrain_3
{
	q3map_baseshader textures/transmitter_sp/base
	qer_editorimage textures/editor_image/terrain3.tga		//sea bed
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
		rgbGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}
//riverbed mix - no follage

textures/transmitter_spring/terrain_2to3
{
	q3map_baseshader textures/transmitter_sp/base
	qer_editorimage textures/editor_image/terrain2to3.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
		rgbGen vertex
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************

textures/transmitter_spring/terrain_0
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_fade
	qer_editorimage textures/editor_image/terrain0.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter_spring/terrain_1
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_fade
	qer_editorimage textures/editor_image/terrain1.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}

}

textures/transmitter_spring/terrain_2
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_fade
	qer_editorimage textures/editor_image/terrain2.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter_spring/terrain_0to1
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_base
	qer_editorimage textures/editor_image/terrain0to1.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/transmitter_spring/terrain_0to2
{
	q3map_baseshader textures/transmitter_sp/base
	//no follage
	qer_editorimage textures/editor_image/terrain0to2.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

// riverbed mix with master_grass_dirt3.tga - no follage

textures/transmitter_spring/terrain_0to3
{
	q3map_baseshader textures/transmitter_sp/base
	qer_editorimage textures/editor_image/terrain0to3.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter_spring/terrain_1to2
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_base
	qer_editorimage textures/editor_image/terrain1to2.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_path1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter_spring/terrain_1to3
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_base
	qer_editorimage textures/editor_image/terrain1to3.tga		// textures/snow_sd/snow_var01.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************

//same as 1 - no follage

textures/transmitter_spring/terrain_4
{
	q3map_baseshader textures/transmitter_sp/base
	qer_editorimage textures/editor_image/terrain4.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//mix of 4 and 0

textures/transmitter_spring/terrain_0to4
{
	q3map_baseshader textures/transmitter_sp/base
	q3map_baseshader textures/transmitter_spring/terrain_foliage_base
	qer_editorimage textures/editor_image/terrain0to4.tga
	surfaceparm grasssteps
	surfaceparm landmine	
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}
//mix of  0-2 + 0-1 - no follage
textures/transmitter_spring/terrain_2to4
{
	q3map_baseshader textures/transmitter_sp/base
	qer_editorimage textures/editor_image/terrain2to4.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}