// Transmitter Shader
// by heeen, MindLink, thegnat
// last modified: thegnat, 14-10-2004

// COMMANDMAP

levelshots/transmitter_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/transmitter_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/transmitter_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/transmitter_cc.tga
		blendFunc blend
		rgbGen identity
		alphaGen vertex
	}
}

// COMMANDMAP TEXTURE

textures/transmitter/transmitter-beta_map
{
	nomipmaps
	nopicmip
	{
		map levelshots/transmitter_cc.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter/barrel_side_s
{
	qer_editorimage textures/transmitter/barrel_m01_s.jpg
	implicitMap textures/transmitter/barrel_m01_s.jpg
}

// OBJECTIVE ICON

transmitter/objective
{
	nocompress
	nopicmip
	{
		map textures/transmitter/transmitter_objective.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

// NON-SOLIDS

textures/transmitter/cable_m01_nonsolid
{
	qer_editorimage textures/props/cable_m01.tga

	surfaceparm nonsolid
	implicitMap textures/props/cable_m01.tga
}

textures/transmitter/xmetal_c03_phong_nonsolid
{
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm nomarks
	surfaceparm nonsolid
	qer_editorimage textures/xlab_wall/xmetal_c03_phong.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/xlab_wall/xmetal_c03.tga
		blendFunc filter
	}
}

textures/transmitter/rope_m01_nonsolid_phong
{
	qer_editorimage textures/props/rope_m01.tga
	q3map_nonplanar
	q3map_shadeangle 60
	surfaceparm nomarks
	surfaceparm nonsolid
	implicitMap textures/props/rope_m01.tga
}

// GLASS

textures/transmitter/villwin_c12m_glass_new
{
 	qer_editorimage textures/village/villwin_c12m.tga
 	qer_trans 0.7
 	cull disable
 	surfaceparm glass
 	surfaceparm pointlight
 	surfaceparm trans
 	{
 		map textures/village/villwin_c12m.tga
 		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
 		rgbGen vertex
 	}
}

textures/transmitter/villwin_c15
{
	qer_editorimage textures/village/villwin_c15.tga
	q3map_surfacelight 300
	surfaceparm glass
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/village/villwin_c15.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/village/villwin_c15.blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

// PHONG FUN

textures/transmitter/s_cathedrale_c06_phong
{
	qer_editorimage textures/transmitter/common/s_cathedrale_c06_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/snow/s_cathedrale_c06.jpg
}

textures/transmitter/cathedrale_c09_phong
{
	qer_editorimage textures/transmitter/common/cathedrale_c09_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/cathedrale_wall/cathedrale_c09.jpg
}

textures/transmitter/cathedrale_c13_phong
{
	qer_editorimage textures/transmitter/common/cathedrale_c13_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/cathedrale_wall/cathedrale_c13.jpg
}

textures/transmitter/town_m_c01_phong
{
	qer_editorimage textures/transmitter/common/town_m_c01_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/town_wall/town_m_c01.jpg
}

textures/transmitter/s_door_c10b_phong
{
	qer_editorimage textures/transmitter/common/s_door_c10b_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/snow/s_door_c10b.jpg
}

textures/transmitter/town_c38a_phong
{
	qer_editorimage textures/transmitter/common/town_c38a_phong.jpg
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/town_wall/town_c38a.jpg
}

// LIGHTS

textures/transmitter/lights/light_tp_m06_2k
{
	qer_editorimage textures/transmitter/lights/light_tp_m06.tga
	q3map_surfacelight 750
	
	polygonOffset
	surfaceparm trans
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m06.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m2.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/transmitter/lights/light_tp_m07_2k
{
	qer_editorimage textures/transmitter/lights/light_tp_m07.tga
	q3map_surfacelight 750
	
	polygonOffset
	surfaceparm trans
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m07.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m2.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/transmitter/lights/light_tp_m07off
{
	qer_editorimage textures/transmitter/lights/light_tp_m07off.tga
	
	polygonOffset
	surfaceparm trans
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	
	implicitBlend textures/transmitter/lights/light_tp_m07off.tga
}

textures/transmitter/lights/light_tp_m08_2k
{
	qer_editorimage textures/transmitter/lights/light_tp_m08.tga
	q3map_surfacelight 750
	
	polygonOffset
	surfaceparm trans
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m08.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/transmitter/lights/light_tp_m2.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

// GAMEMODELS

// BEL_LAMP_ARM_alphafixed

textures/transmitter/alpha/bel_orn_m01
{
	qer_editorimage textures/alpha/bel_orn_m01.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/alpha/bel_orn_m01.tga
}

// SIGNS

textures/transmitter/mortarfriend
{
	nopicmip
	qer_alphafunc greater 0.5
	qer_editorimage textures/transmitter/mortarfriend.tga
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	implicitMask -
}

textures/transmitter/s_antenna
{
	surfaceparm metal
	nopicmip
	implicitMap -
}

textures/transmitter/s_trans
{
	surfaceparm metal
	nopicmip
	implicitMap -
}

textures/transmitter/s_burg
{
	surfaceparm woodsteps
	nopicmip
	implicitMap -
}

textures/transmitter/s_forhut
{
	surfaceparm woodsteps
	nopicmip
	implicitMap -
}

// NEW CLIPS

textures/transmitter/common/clipweap_glass
{
	qer_editorimage textures/transmitter/common/clipweapglass.tga
	qer_trans 0.3
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm glass
}

textures/transmitter/common/clipweap_snow
{
	qer_editorimage textures/transmitter/common/clipweapsnow.tga
	qer_trans 0.3
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm snowsteps
}

textures/transmitter/mirrorfloor
{
	portal
	qer_editorimage textures/snow_sd/icelake3.tga

	{
		map textures/snow_sd/icelake3.tga
		blendfunc blend
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter/snow_leaves
{
	nopicmip
	qer_alphafunc greater 0.5
	qer_editorimage textures/transmitter/snow_leaves.tga
	cull disable
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	implicitMask -
}

textures/transmitter/glittersnow
{
	qer_editorimage textures/snow_sd/snow_var01.tga

	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm landmine
	surfaceparm snowsteps
	{
		rgbGen identity
		map $lightmap
	}

	{
		map textures/transmitter/snow.tga
		blendFunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		alphaGen lightingSpecular
	}
}

textures/transmitter/frozendusk_skybox
{
	qer_editorimage textures/transmitter/frozendusk_view.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.894 0.933 1.00 200 250 15
	skyparms textures/transmitter/frozendusk - -
}

textures/transmitter/tr_frozendusk_skybox
{
	qer_editorimage textures/transmitter/frozendusk_view.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
  	nocompress

	q3map_lightimage textures/transmitter/skylight.tga
	q3map_sunExt 1.00 0.9 0.45 100 250 20 2 16
	q3map_lightmapFilterRadius 0 92
	q3map_skylight 50 5
	
	skyparms textures/transmitter/frozendusk - -
}

textures/transmitter/tr_frozendusk_skybox_antiportal
{
	qer_editorimage textures/transmitter/frozendusk_view.jpg
	qer_nocarve
	qer_trans 0.30
	surfaceparm antiportal
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm structural
	surfaceparm trans
	nocompress

   	q3map_lightimage textures/transmitter/skylight.tga
	q3map_sunExt 1.00 0.9 0.45 100 250 20 2 16
	q3map_lightmapFilterRadius 0 160
	q3map_skylight 50 5

	skyparms textures/transmitter/frozendusk - -
}

// Castleterrain

textures/transmitter/common/alpha_100
{
	qer_editorimage textures/transmitter/common/va_100.tga
	qer_trans 0.5
	q3map_alphaMod volume
	q3map_alphaMod set 0.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/transmitter/cterrain_base
{
 	q3map_nonplanar
 	q3map_shadeangle 90
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	surfaceparm snowsteps
}

textures/transmitter/cterrain_1
{
    q3map_baseshader textures/transmitter/cterrain_base
    qer_editorimage textures/transmitter/common/terrain_1_stsn.tga

	{
		map textures/snow/s_cathedrale_c24b.jpg
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/transmitter/cterrain_2
{
    q3map_baseshader textures/transmitter/cterrain_base
    qer_editorimage textures/transmitter/common/terrain_2_sndrt.tga

	{
		map textures/snow/s_dirt_m03i_2.jpg
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/transmitter/cterrain_2to1
{
        qer_editorimage textures/transmitter/common/terrain_2to1_blend.tga
	q3map_baseshader textures/transmitter/cterrain_base
	{
		map textures/snow/s_dirt_m03i_2.jpg
		rgbgen identity
	}
	{
		map textures/snow/s_cathedrale_c24b.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

// Terrain - Tunnel Blends

textures/transmitter/snow_path01
{
	qer_editorimage textures/snow_sd/snow_path01.tga
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm snowsteps
	{
		map textures/snow_sd/snow_path01.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/transmitter/snow_road01
{
	qer_editorimage textures/snow_sd/snow_road01.tga
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm snowsteps
	{
		map textures/snow_sd/snow_road01.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}


// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************
// TERRAIN 1 *****************************************************************

textures/castleserpentine/terrain_base
{
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
	surfaceparm landmine
	surfaceparm snowsteps
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_tcMod scale 1 1
	q3map_lightmapsize 512 512
}
textures/castleserpentine/terrain_0
{
    q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga

	{
		map textures/snow_sd/snow_var01.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleserpentine/terrain_1
{
    q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga

	{
		map textures/snow_sd/snow_var02.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleserpentine/terrain_2
{
    q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga

	{
		map textures/snow_sd/bigrock_rounded_faint.tga
//		tcMod scale 0.25 0.25
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleserpentine/terrain_3
{
    q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga

	{
		map textures/stone/mxdebri0_riverbed.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleserpentine/terrain_0to1
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/snow_var01.tga
		rgbgen identity
	}
	{
		map textures/snow_sd/snow_var02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleserpentine/terrain_0to2
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/snow_var01.tga
		rgbgen identity
	}
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
//		tcMod scale 0.25 0.25
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleserpentine/terrain_0to3
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/snow_var01.tga
		rgbgen identity
	}
	{
		map textures/stone/mxdebri0_riverbed.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleserpentine/terrain_1to2
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/snow_var02.tga

		rgbgen identity
	}
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
//		tcMod scale 0.25 0.25
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleserpentine/terrain_1to3
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/snow_var02.tga

		rgbgen identity
	}
	{
		map textures/stone/mxdebri0_riverbed.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleserpentine/terrain_2to3
{
	q3map_baseshader textures/castleserpentine/terrain_base
    qer_editorimage textures/snow_sd/snow_var01.tga
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
//		tcMod scale 0.25 0.25

		rgbgen identity
	}
	{
		map textures/stone/mxdebri0_riverbed.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************
//TERRAIN 3 *****************************************************

textures/castleforrest/terrain_base
{
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	q3map_tcMod rotate 37
	surfaceparm landmine
	surfaceparm snowsteps
	q3map_nonplanar
	q3map_shadeangle 90

	q3map_lightmapsize 512 512
}

textures/castleforrest/terrain_0
{
    q3map_baseshader textures/castleforrest/terrain_base
    qer_editorimage textures/snow_sd/snow_var01_big.tga

	{
		map textures/snow_sd/s_grass_ml03b_big.jpg
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleforrest/terrain_1
{
    q3map_baseshader textures/castleforrest/terrain_base
    qer_editorimage textures/snow_sd/snow_var01_big.tga

	{
		map textures/snow_sd/snow_var01.tga
//		tcMod scale 2 2
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleforrest/terrain_2
{
    q3map_baseshader textures/castleforrest/terrain_base
    qer_editorimage textures/snow_sd/snow_var01_big.tga

	{
		map textures/snow_sd/bigrock_rounded_faint.tga
//		tcMod scale 0.5 0.5
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleforrest/terrain_3
{
    q3map_baseshader textures/castleforrest/terrain_base
    qer_editorimage textures/snow_sd/snow_var01_big.tga

	{
		map textures/snow_sd/snow_var01_big.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/castleforrest/terrain_0to1
{
	q3map_baseshader textures/castleforrest/terrain_base
    qer_editorimage textures/snow_sd/snow_var01_big.tga
	{
		map textures/snow_sd/s_grass_ml03b_big.jpg
		rgbgen identity
	}
	{
		map textures/snow_sd/snow_var01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
//		tcMod scale 2 2
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleforrest/terrain_0to2
{
	q3map_baseshader textures/castleforrest/terrain_base
	{
		map textures/snow_sd/s_grass_ml03b_big.jpg
		rgbgen identity
	}
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
//		tcMod scale 0.5 0.5
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleforrest/terrain_0to3
{
    qer_editorimage textures/snow_sd/snow_var01_big.tga
	q3map_baseshader textures/castleforrest/terrain_base
	{
		map textures/snow_sd/s_grass_ml03b_big.jpg
		rgbgen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleforrest/terrain_1to2
{
	q3map_baseshader textures/castleforrest/terrain_base
	{
		map textures/snow_sd/snow_var01.tga
//		tcMod scale 2 2

		rgbgen identity
	}
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
//		tcMod scale 0.5 0.5
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleforrest/terrain_1to3
{
    qer_editorimage textures/snow_sd/snow_var01_big.tga
	q3map_baseshader textures/castleforrest/terrain_base
	{
		map textures/snow_sd/snow_var01.tga
//		tcMod scale 2 2

		rgbgen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/castleforrest/terrain_2to3
{
    qer_editorimage textures/snow_sd/snow_var01_big.tga
	q3map_baseshader textures/castleforrest/terrain_base
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
//		tcMod scale 0.5 0.5

		rgbgen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}
textures/lightblock/lightblock
{
	qer_editorimage textures/lightblock/lightblock.tga
	qer_trans 0.5
	surfaceparm nonsolid
	surfaceparm nomarks
	{
		map $whiteimage
		alphaFunc GT0
		alphaGen const 0
	}
}