// ------------ SHADER for TheRiver2Redux ------
// most shaders written by ]UBC[ McNite
// some ideas borrowed from ET shaders
// alphachannel shaders from www.level-designer.de

// ---------------------------------------------
// ------------ TERRAIN - NEW ------------------
// ---------------------------------------------


// ------------ PURE TEXTURES ------------------
textures/tr2redux_t/tr2r_rocksteep
{
	qer_editorimage textures/tr2redux_t/tr2r_rock_steep.tga
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	// surfaceparm
	implicitMap textures/tr2redux_t/tr2r_rock_steep.tga
}

textures/tr2redux_t/tr2r_riverbed1
{
	qer_editorimage textures/stone/mxrock3_a.jpg
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/stone/mxrock3_a.jpg
}

textures/tr2redux_t/tr2r_grass
{
	qer_editorimage textures/temperate_sd/grass_dense1.tga
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/temperate_sd/grass_dense1.tga
}

textures/tr2redux_t/tr2r_grassmoss
{
	qer_editorimage textures/tr2redux_t/rv2nd_grass_wet.jpg
	q3map_tcMod scale 0.5 0.5
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/tr2redux_t/rv2nd_grass_wet.jpg
}



// ---------------------------------------------
// ------------ TERRAIN ------------------------
// ---------------------------------------------


textures/tr2redux_t/terrain_0
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_1
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	q3map_nonplanar // phong 
	q3map_shadeangle 180 // phong angle
	// surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga  //river2nd_t/rv2nd_grass.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	q3map_nonplanar // phong 
	q3map_shadeangle 180 // phong angle
	surfaceparm landmine
	{
		map textures/tr2redux_t/tr2r_grasswet.jpg
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	{
		map textures/tr2redux_t/tr2r_gravel2.jpg
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// ---------------------------------------------
// ------------ TERRAIN BLENDS -----------------
// ---------------------------------------------

textures/tr2redux_t/terrain_0to1
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
	}
	{
		map textures/stone/mxrock3_a.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_0to2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_0to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
	}
	{
		map textures/tr2redux_t/tr2r_grasswet.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_0to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
	}
	{
		map textures/tr2redux_t/tr2r_gravel2.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_1to2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_1to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/tr2redux_t/tr2r_grasswet.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_1to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/tr2redux_t/tr2r_gravel2.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_2to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	surfaceparm landmine
	
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map textures/tr2redux_t/tr2r_grasswet.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_2to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map textures/tr2redux_t/tr2r_gravel2.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain_3to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/tr2redux_t/tr2r_grasswet.jpg
	}
	{
		map textures/tr2redux_t/tr2r_gravel2.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/tr2redux_t/terrain.vertex
{
	{
		map textures/tr2redux_t/tr2r_rock_steep.tga
		rgbGen vertex
	}
}


// ---------------------------------------------
// ------------ SKY ----------------------------
// ---------------------------------------------


textures/tr2redux_t/tr2r_skylow  //using this one
{
	qer_editorimage textures/tr2redux_t/tr2r_fog_06_ei.jpg

	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky

	q3map_lightsubdivide 1024
	q3map_globaltexture

	q3map_sunExt 0.98 0.98 0.84 75 60 60 3 16 //color intensity-65 degree elevation deviance samples
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 65 3  // amount-55 iterations-3

	skyParms - 128 -
	{
		map textures/tr2redux_t/tr2r_fog_08sm.jpg //$whiteimage 
		rgbGen identity //const ( 0.5 0.5 0.5 )
	}
	{
		map textures/tr2redux_t/tr2r_fog_08sm.jpg // this stage is not in the original one
		blendfunc blend
		rgbGen identity
	}

}

textures/tr2redux_t/tr2r_fog // used for _fog in worldspawn
{
	qer_editorimage textures/sfx/tr2r_fog_06_ei.jpg

	surfaceparm nodraw
	// surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog

	fogparms ( 0.518 0.549 0.557 ) 4950	 // = fog_07: 0.67 0.72 0.73 fog_08: 0.65 0.67 0.71
}

textures/tr2redux_t/tr2r_sky_011  //works fine
{
	qer_editorimage textures/tr2redux_t/tr2r_sky_011.jpg // rv2nd_fog_02.jpg or rv2nd_fog_03sm for TCs shader

	q3map_sunExt 1 .95 .9 65 60 55 3 16 //65 60 60 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 50 3

	skyparms - 128 - //low value >> more curved sky

	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	nopicmip

	{
		map textures/tr2redux_t/tr2r_sky_011.jpg
		rgbGen identity
	}
	{
		map textures/tr2redux_t/tr2r_sky_011.jpg
		blendfunc blend
		rgbGen identity
		tcMod scroll 0.002 0.001
		tcMod scale 1.4 1.4
	}
}


// ---------------------------------------------
// ------------ WATER TR2R ---------------------
// ---------------------------------------------


// works as box around waterfog

textures/tr2redux_t/waternofog
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga 
	qer_trans 0.9 
	q3map_globaltexture 
	q3map_noFog 
	cull disable 
	nocompress 
	nofog 
	surfaceparm nomarks 
	surfaceparm nonsolid 
	surfaceparm trans 
	surfaceparm water 
	nopicmip 

	{ 
		Map textures/liquids_sd/sea_bright_na.tga 
	}
}


textures/tr2redux_t/tr2r_water_old //works fine
{
	qer_editorimage textures/tr2redux_t/tr2r_water_ei.jpg
	qer_trans 0.9

	cull disable // "back" is no good idea
	surfaceparm water
	surfaceparm trans // added...
	q3map_tcMod scale 0.5 0.5
	implicitMap textures/tr2redux_t/tr2r_water_02_d03.tga
}


textures/tr2redux_t/tr2r_water // on the test, after water_beach_nerve from RtCW mp_pak0.pk3
{
	qer_editorimage textures/tr2redux_t/tr2r_water_ei.jpg
	qer_trans 0.9

	q3map_globaltexture //new
	q3map_tcMod scale 0.5 0.5

	surfaceparm water
	surfaceparm trans // added...
	surfaceparm nomarks

	cull disable // "back" is no good idea
	deformVertexes wave 160 sin 0 10 0 .3	// the chop

	// implicitMap textures/tr2redux_t/tr2r_water_02_d03.tga //

	{ 
		map textures/tr2redux_t/tr2r_water_02_d03.tga
		rgbgen wave sin .4 0 0 .5	
		tcmod scale .5 .5
		tcmod scroll .03 .02		
	}	
	{ 
		map textures/tr2redux_t/tr2r_water_02_d03.tga
		blendFunc GL_src_alpha GL_ONE // gl_zero_minus_src_alpha invalid
		alphagen const .5		
		tcmod scale .2 .2
		tcmod scroll -.03 -.02	
	}
}

textures/tr2redux_t/tr2r_waterfog //works?
{
	qer_editorimage textures/tr2redux_t/tr2r_waterfog_ei.jpg
	qer_trans 0.9
	qer_nocarve

	surfaceparm nodraw
  	surfaceparm nonsolid
  	surfaceparm trans
  	// surfaceparm water
	surfaceparm fog // fog inside the watershader after
	fogparms ( 0.16 0.36 0.32 ) 2048 // users.pandora.be/Ariffnet/tutorials/waterfog.html
}



// ---------------------------------------------
// ------------ OTHER TERRAIN SHADERS ----------
// ---------------------------------------------


textures/tr2redux_t/tr2r_cavesand
{
	qer_editorimage textures/temperate_sd/sand_patchnoise.tga
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/sand_patchnoise
}

textures/tr2redux_t/tr2r_cavewater
{
	qer_editorimage textures/tr2redux_t/tr2r_cavewater_ei.jpg
	qer_trans 0.9

	surfaceparm water
	surfaceparm trans
	q3map_tcMod scale 0.5 0.5
	implicitMap textures/liquids_sd/siwa_water.tga
}

textures/tr2redux_t/tr2r_caverock1
{
	qer_editorimage textures/stone/mxrock3_a.tga
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/stone/mxrock3_a.tga
}

textures/tr2redux_t/tr2r_asphalt
{
	qer_editorimage textures/temperate_sd/dirt_m03icmp_brown.jpg
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/temperate_sd/dirt_m03icmp_brown.jpg
}

textures/tr2redux_t/tr2r_asphaltborder
{
	qer_editorimage textures/temperate_sd/dirt_m04cmp_brown.jpg
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/dirt_m04cmp_brown.jpg
}

textures/tr2redux_t/tr2r_asphaltgravel
{
	qer_editorimage textures/temperate_sd/dirt3.tga
	//q3map_nonplanar
	//q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/dirt3.tga
}

textures/tr2redux_t/tr2r_gravel1
{
	qer_editorimage textures/temperate_sd/dirt3.tga
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/dirt3.tga
}

textures/tr2redux_t/tr2r_gravel2
{
	qer_editorimage textures/tr2redux_t/tr2r_gravel2.jpg
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/tr2redux_t/tr2r_gravel2.jpg
}


// ---------------------------------------------
// ------------ BUILDINGS ----------------------
// ---------------------------------------------

textures/river2nd_b/rv2nd_roof_wood01
{
	// qer_editorimage textures/river2nd_b/rv2nd_roof_wood01.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_roof_wood01_d1
{
	// qer_editorimage textures/river2nd_b/rv2nd_roof_wood01_d1.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_wood03
{
	// qer_editorimage textures/river2nd_b/rv2nd_wood03.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_wood04
{
	// qer_editorimage textures/river2nd_b/rv2nd_wood04.jpg
	surfaceparm woodsteps
	implicitmap -
}


// ---------------------------------------------
// ------------ BUILDINGS - DOORS & WINDOWS ----
// ---------------------------------------------

textures/tr2redux_b/tr2r_door01
{
	qer_editorimage textures/castle_door/door_c17.jpg
	surfaceparm woodsteps
	implicitMap textures/castle_door/door_c17.jpg
}


textures/tr2redux_b/tr2r_door02
{
	qer_editorimage textures/doors/door_c01b.jpg
	surfaceparm woodsteps
	implicitMap textures/doors/door_c01b.jpg
}


textures/tr2redux_b/tr2r_door03
{
	qer_editorimage textures/egypt_door_sd/door_c05.jpg
	surfaceparm woodsteps
	implicitMap textures/egypt_door_sd/door_c05.jpg
}

textures/tr2redux_b/tr2r_door04
{
	qer_editorimage textures/doors/door_c13.jpg
	surfaceparm wood
	implicitMap textures/doors/door_c13.jpg
}


textures/tr2redux_b/tr2r_door11
{
	qer_editorimage textures/doors/door_m01asml.jpg
	surfaceparm metal	
	implicitMap textures/doors/door_m01asml.jpg
}

textures/tr2redux_b/tr2r_door12
{
	qer_editorimage textures/doors/door_m01asml_axis.tga
	surfaceparm metal	
	implicitMap textures/doors/door_m01asml_axis.tga
}

textures/tr2redux_b/tr2r_door13
{
	qer_editorimage textures/swf/door_m01swf.jpg
	surfaceparm metal	
	implicitMap textures/swf/door_m01swf.jpg
}

textures/tr2redux_b/tr2r_door14
{
	qer_editorimage textures/metals_sd/door_a.tga
	surfaceparm metal	
	implicitMap textures/metals_sd/door_a.tga
}


textures/tr2redux_b/tr2r_window1
{
	qer_editorimage textures/awf/awf_w_m11.tga
	surfaceparm nomarks
	implicitMap textures/awf/awf_w_m11.tga
}

textures/tr2redux_b/tr2r_window3
{
	qer_editorimage textures/tr2redux_b/tr2r_window3.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_b/tr2r_window3.jpg
}

textures/tr2redux_b/tr2r_window3a
{
	qer_editorimage textures/tr2redux_b/tr2r_window3a.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_b/tr2r_window3a.jpg
}

textures/tr2redux_b/tr2r_window3b
{
	qer_editorimage textures/tr2redux_b/tr2r_window3c.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_b/tr2r_window3c.jpg
}



// ---------------------------------------------
// ------------ BUILDINGS - INNER ROOMS --------
// ---------------------------------------------


textures/tr2redux_r/tr2r_wallins01_0
{
	qer_editorimage textures/tr2redux_r/tr2r_wallins01_1
	implicitMap textures/tr2redux_r/tr2r_wallins01_1
}



// ---------------------------------------------
// ------------ PROPS --------------------------
// ---------------------------------------------


textures/river2nd_p/rv2nd_rope
{
	qer_editorimage textures/props/cable_m01.jpg
	surfaceparm woodsteps
	implicitMap textures/props/cable_m01.jpg // -
}

textures/river2nd_p/rv2nd_metal_trststripe_2
{
	// qer_editorimage textures/river2nd_p/rv2nd_metal_trststripe_2.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/river2nd_p/rv2nd_tramcable
{
	qer_editorimage textures/props/cable_m01.jpg
	q3map_nonplanar
	q3map_shadeangle 270
	surfaceparm metalsteps
	implicitMap textures/props/cable_m01.jpg
}

textures/tr2redux_p/tr2r_tramblack
{
	surfaceparm metalsteps
	implicitMap -
}

textures/tr2redux_p/tr2r_tramcolor
{
	qer_editorimage textures/tr2redux_p/tr2r_tramred.jpg
	surfaceparm metalsteps
	implicitMap textures/tr2redux_p/tr2r_tramred.jpg
}

textures/river2nd_p/rv2nd_tram_metalrivet
{
	// qer_editorimage textures/river2nd_p/rv2nd_tram_metalrivet.jpg
	surfaceparm metalsteps
	implicitMap -
}


textures/tr2redux_p/tr2r_alliesstage1
{
	qer_editorimage textures/tr2redux_p/tr2r_alliesstage1.jpg
	surfaceparm metalsteps
	implicitMap textures/tr2redux_p/tr2r_alliesstage1.jpg
}

textures/tr2redux_p/tr2r_alliesstage2
{
	qer_editorimage textures/tr2redux_p/tr2r_alliesstage2.jpg
	surfaceparm metalsteps
	implicitMap textures/tr2redux_p/tr2r_alliesstage2.jpg
}

textures/tr2redux_p/tr2r_alliesstage3
{
	qer_editorimage textures/tr2redux_p/tr2r_alliesstage3.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_alliesstage3.jpg
}

textures/tr2redux_p/tr2r_axisstage1
{
	qer_editorimage textures/tr2redux_p/tr2r_axisstage1.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_axisstage1.jpg
}

textures/tr2redux_p/tr2r_axisstage2
{
	qer_editorimage textures/tr2redux_p/tr2r_axisstage2.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_axisstage2.jpg
}


textures/tr2redux_p/axisstage1
{
	qer_editorimage textures/tr2redux_p/tr2r_axisstage1.jpg
	surfaceparm metalsteps
	implicitMap -
}


textures/tr2redux_p/flag

{
	qer_editorimage textures/tr2redux_p/flag.tga
	surfaceparm nomarks
        surfaceparm trans 
        surfaceparm alphashadow
        cull twosided
	//deformVertexes wave 10 sin 0 2 0 .2
        nopicmip
	{
        	map textures/tr2redux_p/flag.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       


// ---------------------------------------------
// ------------ PROPS ART ----------------------
// ---------------------------------------------


textures/tr2redux_p/tr2r_kachart1 // not in use
{
	qer_editorimage textures/tr2redux_p/tr2r_kachart1.tga
        surfaceparm trans 
        surfaceparm alphashadow
	surfaceparm woodsteps
        cull none
        nopicmip
         
	{
        	map textures/tr2redux_p/tr2r_kachart1.tga
	        blendFunc GL_ONE GL_ZERO
	        alphaFunc GE128 
        	depthWrite
	        rgbGen identity
	}
	{
        	map $lightmap
	        rgbGen identity
        	blendFunc GL_DST_COLOR GL_ZERO
	        depthFunc equal
	}
}       


textures/tr2redux_p/tr2r_kachart1jpg
{
	qer_editorimage textures/tr2redux_p/tr2r_kachart1jpg.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_kachart1jpg.jpg
}

textures/tr2redux_p/tr2r_kachart2jpg
{
	qer_editorimage textures/tr2redux_p/tr2r_kachart2jpg.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_kachart2jpg.jpg
}

textures/tr2redux_p/tr2r_kachart3jpg
{
	qer_editorimage textures/tr2redux_p/tr2r_kachart3jpg.jpg
	surfaceparm woodsteps
	implicitMap textures/tr2redux_p/tr2r_kachart3jpg.jpg
}


textures/tr2redux_p/tr2r_artframe1
{
	//qer_editorimage textures/tr2redux_p/tr2r_artframe1.jpg
	surfaceparm woodsteps
	implicitMap -
}

textures/tr2redux_p/tr2r_artframe2
{
	//qer_editorimage textures/tr2redux_p/tr2r_artframe2.jpg
	surfaceparm woodsteps
	implicitMap -
}



// ---------------------------------------------
// ------------ LIGHTS -------------------------
// ---------------------------------------------

