//**********************************************************************//
//
//	terrain_example.shader for maps Teuthonia and siwa_teuthonia. Shader based on Tutorial by Sock
//	Website : http://www.planetquake.com/simland/
//	Thank you very much Sock for the blending Tut and the shader file.
//	file modified by Teuthis. 
//**********************************************************************//
//


// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/terrain_example/ter_dirtmud
{
        qer_editorimage textures/terrain_example/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/egypt_walls_sd/debri_m05.tga	// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ter_mossmud
{
        qer_editorimage textures/terrain_example/ter_mossmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/siwa_teuthonia/oasis_sandy_01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/desert_sd/grass_desert_flat.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ter_rockmud
{
        qer_editorimage textures/terrain_example/ter_rockmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapMergable 
	
	{
		map textures/desert_sd/pavement_quad_sandy.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandy_dirt_01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ivec_sand1
{
        qer_editorimage textures/terrain_example/ivec_sand1.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/egypt_floor_sd/sandy_dirt_01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/desert_sd/pavement_quad_sandy.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ivec_gravel1
{
        qer_editorimage textures/terrain_example/ivec_gravel1.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/stone/mxrock1aa.tga	// Primary
		rgbGen identity
	}
	{
		map textures/desert_sd/pavement_quad_sandy.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ivec_moss2
{
        qer_editorimage textures/terrain_example/ivec_moss2.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/egypt_walls_sd/debri_m05.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandygrass_b.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/terrain_example/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

// ======================================================================
// shader for vertical blending-ground cave
// ======================================================================
textures/terrain_example/rock_grey2moss2
{
	qer_editorimage textures/terrain_example/rock_grey2moss2.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
// ======================================================================
// shader for vertical blending-roofcave
// ======================================================================
textures/terrain_example/rock_roof
{
	qer_editorimage textures/terrain_example/rock_roof.tga
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//========================================================
// phong shader for debri_m05_phong
//========================================================
textures/terrain_example/debri_m05_phong
{
	q3map_nonplanar
 	q3map_shadeangle 60
 	qer_editorimage textures/terrain_example/debri_m05_phong.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/terrain_example/debri_m05_phong.tga
 		blendFunc filter
	}
 }

//========================================================
// phong shader for rock_grayvar_phong
//========================================================
textures/terrain_example/rock_grayvar_phong
{
	q3map_nonplanar
 	q3map_shadeangle 60
 	qer_editorimage textures/terrain_example/rock_grayvar_phong.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/terrain_example/rock_grayvar_phong.tga
 		blendFunc filter
	}
 }
