// ======================
//  SOTTEVAST PE (Final)
// ======================
//
// Shader fixed by
// 		Sid & Etch


textures/sottevast/env/sky
{
	skyParms textures/sottevast/env/himmelsrot 1024 -
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
}


textures/sottevast/blitz_body
{
	{
		map textures/sottevast/opel_blitz.tga
		rgbgen lightingDiffuse
	}
}


textures/sottevast/blitz_window
{
	{
		map textures/sottevast/wr.tga
		tcmod scale .75 3
		tcGen environment
	}
	{
		map textures/sottevast/opel_blitz_w.tga
		tcmod scale 2 2
		blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		rgbgen lightingDiffuse
	}
}


textures/sottevast/rock
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/sottevast/rock.tga
		blendFunc filter
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 2.5 2.5
		detail
	}
}


textures/sottevast/rock2
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/sottevast/rock2.tga
		blendFunc filter
	}
	{
		map textures/detail_sd/snowdetail_heavy.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 2.5 2.5
		detail
	}
}


textures/sottevast/cliffs_blend
{
	surfaceparm grasssteps
	{
		map textures/stone/mxrock3_a.tga
		rgbGen identity
	}
	{
		map textures/sottevast/rock.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 2.5 2.5
		detail
	}
}


textures/sottevast/grass
{
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/sottevast/grass.tga
		rgbGen identity
		tcMod scale 1.5 1.5
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
		tcMod scale 1.5 1.5
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/grasspath
{
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/sottevast/grass.tga
		rgbGen identity
		tcMod scale 1.5 1.5
	}
	{
		map textures/sottevast/dirt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
		tcMod scale 1.5 1.5
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/sottevast/grasspath_nomines
{
	surfaceparm grasssteps
	{
		map textures/sottevast/grass.tga
		rgbGen identity
		tcMod scale 1.5 1.5
	}
	{
		map textures/sottevast/dirt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
		tcMod scale 1.5 1.5
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/caves_blend
{
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/sottevast/sand.tga
		rgbGen identity
		tcMod scale 2 2
	}
	{
		map textures/sottevast/gravel.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
		tcMod scale 2 2
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 3 3
		detail
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/caves_blend_nomines
{
	surfaceparm grasssteps
	{
		map textures/sottevast/sand.tga
		rgbGen identity
		tcMod scale 2 2
	}
	{
		map textures/sottevast/gravel.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
		tcMod scale 2 2
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 3 3
		detail
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/water
{
	cull twosided
	surfaceparm trans
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nonsolid
	deformVertexes wave 150 sin 0 6 0 .3
	{
		map textures/liquids_sd/siwa_water.tga
		blendFunc blend
		rgbgen identity
		tcmod scale .75 .75
		tcmod transform 1.5 0 1.5 1 1 2
		tcmod scroll -.05 .001
	}
	{
		map textures/sottevast/water1.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 1.5 0 1.5 1 1 2
		tcmod scroll -.05 .001
	}
	{
		map textures/sottevast/water2.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .25
		tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll .025 -.001
	}
	{
		map textures/sottevast/water3.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .125 .25
		tcmod scroll .001 .025
	}
	{
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity
	}
}


textures/sottevast/wall3

{
	{
		map textures/sottevast/wall3.tga
		tcmod scale .5 .5
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/door
{
	{
		map textures/swf/door_m01aaaaswf.tga
		tcmod scale 2 1
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/reiling

{
	{
		map textures/metal_misc/metal_m04dg.tga
		tcmod scale 2 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/banner

{

	surfaceparm nomarks

	surfaceparm alphashadow

	deformVertexes wave 10 sin 0 2 0 .2

	cull twosided

	{

		map textures/sottevast/banner.tga

		alphafunc ge128
		
rgbGen vertex

	}

	{

		map $lightmap

		blendfunc gl_zero gl_one

		rgbgen identity

		depthfunc equal

	}


}




textures/sottevast/banner_small

{
	surfaceparm nomarks

	surfaceparm alphashadow

	deformVertexes wave 10 sin 0 2 0 .2

	cull twosided

	{

		map textures/sottevast/banner_small.tga

		alphafunc ge128
		
rgbGen vertex

	}

	{

		map $lightmap

		blendfunc gl_zero gl_one

		rgbgen identity

		depthfunc equal

	}


}



textures/sottevast/trunk
{
	{
		map textures/sottevast/trunk.tga
		tcmod scale 1 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/sottevast/diamond
{
	{
		map textures/metal_misc/diamond_c_01.tga
		tcmod scale 3 3
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


//                       ___
//                     .___`.
//                     |o o`|
// -----------------ooO--(_)--Ooo-----------------
//
//  Every breath you take and every move you make.
//  Every bond you break.
//  Every step you take, I'll be watching you.