//**********************************************************************//
//
//	terrain_example.shader for maps Teuthonia and siwa_teuthonia. Shader based on Tutorial by Sock
//	Website : http://www.planetquake.com/simland/
//	Thank you very much Sock for the blending Tut and the shader file.
//	file modified by Teuthis. 
//**********************************************************************//
//


// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/terrain_example/ter_dirtmud
{
        qer_editorimage textures/terrain_example/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/egypt_walls_sd/debri_m05.tga	// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ter_mossmud
{
        qer_editorimage textures/terrain_example/ter_mossmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/siwa_teuthonia/oasis_sandy_01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/desert_sd/grass_desert_flat.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ter_rockmud
{
        qer_editorimage textures/terrain_example/ter_rockmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapMergable 
	
	{
		map textures/desert_sd/pavement_quad_sandy.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandy_dirt_01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/terrain_example/ivec_sand1
{
        qer_editorimage textures/terrain_example/ivec_sand1.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/temperate_sd/grass_dense1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandy_dirt_01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ivec_gravel1
{
        qer_editorimage textures/terrain_example/ivec_gravel1.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/etnam/grass1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/dirt_cracked_01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/terrain_example/ivec_moss2
{
        qer_editorimage textures/terrain_example/ivec_moss2.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/egypt_walls_sd/debri_m05.tga	// Primary
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandygrass_b.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/terrain_example/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

// ======================================================================
// shader for vertical blending-ground cave
// ======================================================================
textures/terrain_example/rock_grey2moss2
{
	qer_editorimage textures/terrain_example/rock_grey2moss2.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
// ======================================================================
// shader for vertical blending-roofcave
// ======================================================================
textures/terrain_example/rock_roof
{
	qer_editorimage textures/terrain_example/rock_roof.tga
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_ground
// ======================================================================
textures/terrain_example/oasis_ground
{
	qer_editorimage textures/terrain_example/oasis_ground.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/dirt_cracked_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ======================================================================
// shader for vertical blending oasis_grass
// ======================================================================
textures/terrain_example/oasis_grass
{
	qer_editorimage textures/terrain_example/oasis_grass.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandygrass_b.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall1
// ======================================================================
textures/terrain_example/oasis_wall1
{
	qer_editorimage textures/terrain_example/oasis_wall1.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco02.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/roughedge01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall2
// ======================================================================
textures/terrain_example/oasis_wall2
{
	qer_editorimage textures/terrain_example/oasis_wall2.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco02_rough.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/roughedge01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall3
// ======================================================================
textures/terrain_example/oasis_wall3
{
	qer_editorimage textures/terrain_example/oasis_wall3.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco02_rough.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco04.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall4
// ======================================================================
textures/terrain_example/oasis_wall4
{
	qer_editorimage textures/terrain_example/oasis_wall4.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco08d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall5
// ======================================================================
textures/terrain_example/oasis_wall5
{
	qer_editorimage textures/terrain_example/oasis_wall5.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco02.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/debri_m05.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall6
// ======================================================================
textures/terrain_example/oasis_wall6
{
	qer_editorimage textures/terrain_example/oasis_wall6.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/siwa_rubble_1.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ======================================================================
// shader for vertical blending oasis_wall7
// ======================================================================
textures/terrain_example/oasis_wall7
{
	qer_editorimage textures/terrain_example/oasis_wall7.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco04.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/bigblock02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall8
// ======================================================================
textures/terrain_example/oasis_wall8
{
	qer_editorimage textures/terrain_example/oasis_wall8.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco02_rough.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/bigblock02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall9
// ======================================================================
textures/terrain_example/oasis_wall9
{
	qer_editorimage textures/terrain_example/oasis_wall9.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco08d.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/bigblock02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall10
// ======================================================================
textures/terrain_example/oasis_wall10
{
	qer_editorimage textures/terrain_example/oasis_wall10.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/bigblock02.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco02_rough.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall11
// ======================================================================
textures/terrain_example/oasis_wall11
{
	qer_editorimage textures/terrain_example/oasis_wall11.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco04.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco02_rough.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall12
// ======================================================================
textures/terrain_example/oasis_wall12
{
	qer_editorimage textures/terrain_example/oasis_wall12.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco08d.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stripedbrick01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall13
// ======================================================================
textures/terrain_example/oasis_wall13
{
	qer_editorimage textures/terrain_example/oasis_wall13.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga 
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stripedbrick01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall14
// ======================================================================
textures/terrain_example/oasis_wall14
{
	qer_editorimage textures/terrain_example/oasis_wall14.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco04.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco08d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall15
// ======================================================================
textures/terrain_example/oasis_wall15
{
	qer_editorimage textures/terrain_example/oasis_wall15.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/stucco04.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco02_rough.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall16
// ======================================================================
textures/terrain_example/oasis_wall16
{
	qer_editorimage textures/terrain_example/oasis_wall16.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco08e.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall17
// ======================================================================
textures/terrain_example/oasis_wall17
{
	qer_editorimage textures/terrain_example/oasis_wall17.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco08d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall18
// ======================================================================
textures/terrain_example/oasis_wall18
{
	qer_editorimage textures/terrain_example/oasis_wall18.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_walls_sd/stucco09g.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall19
// ======================================================================
textures/terrain_example/oasis_wall19
{
	qer_editorimage textures/terrain_example/oasis_wall19.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/roughedge01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending oasis_wall20
// ======================================================================
textures/terrain_example/oasis_wall20
{
	qer_editorimage textures/terrain_example/oasis_wall20.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_floor_sd/sandy_dirt_01.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/terrain_example/debri_m05_phong.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

