////////////////////////////////////////////////////
/// ALPHA BLENDING /////////////////////////////////
////////////////////////////////////////////////////

textures/saniko/bld_dirtrock
{
	qer_editorimage textures/sani/q3_grassrock.jpg
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	surfaceparm grasssteps
 	surfaceparm landmine
	
	{
		map textures/temperate_sd/dirt3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_ugly_brown.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/saniko/bld_grassdirt
{
        qer_editorimage textures/saniko/q3_grassdirt.jpg
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	
	surfaceparm grasssteps
 	surfaceparm landmine
	
	{
		map textures/temperate_sd/grass_dense1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/dirt3.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//////// ALPHA VOLUMES //////

textures/saniko/alpha_000	// Primary texture ONLY
{
	qer_editorimage textures/sani/alpha_000.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/saniko/alpha_025
{
	qer_editorimage textures/sani/alpha_025.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/saniko/alpha_050	// Perfect mix of both Primary + Secondary
{
	qer_editorimage textures/sani/alpha_050.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/saniko/alpha_075
{
	qer_editorimage textures/sani/alpha_075.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/saniko/alpha_085
{
	qer_editorimage textures/sani/alpha_085.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/saniko/alpha_100	// Secondary texture ONLY
{
	qer_editorimage textures/sani/alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

////////// EDITED COMMON SHADERS ///////////

textures/saniko/wood_cushion
{
	qer_nocarve
	qer_trans 0.5
	surfaceparm nodamage
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm woodsteps
}

textures/saniko/nodamagecaulk
{
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm nodamage
}

////////////////////////
/// TEXTURES & FIXES ///
////////////////////////

textures/saniko/icelake2
{
	qer_trans 0.80
	qer_editorimage textures/saniko/icelake2.tga
	surfaceparm slick
	surfaceparm nodamage
	surfaceparm glass
	
	tesssize 256

	{
		map textures/effects/envmap_ice2.tga
		tcgen environment
		blendfunc blend
	}
	{
		map textures/sani/icelake2.tga
		blendfunc blend
	}
	{
		map $lightmap
		blendfunc filter
		rgbGen identity
		depthWrite
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 4 4
		detail
	}
}

textures/saniko/dirt3
{
	qer_editorimage textures/temperate_sd/dirt3.tga
	surfaceparm nodamage
	{
		map textures/temperate_sd/dirt3.tga
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/saniko/rock_grayvar
{
	qer_editorimage textures/temperate_sd/rock_grayvar.tga
	{
		map textures/temperate_sd/rock_grayvar.tga
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/saniko/dirt3_cush
{
	qer_editorimage textures/saniko/dirt3_cush.tga
	surfaceparm nodamage
	{
		map textures/temperate_sd/dirt3.tga
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/saniko/rock_slicknoise
{
	qer_editorimage textures/saniko/rock_slicknoise.tga
	surfaceparm nodamage
	surfaceparm slick
	{
		map textures/temperate_sd/rock_graynoise.tga
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		tcgen environment
		blendfunc blend
	}
}

/////// LAVA TEXTURE BY Max1
textures/saniko/Max1_lava
{
	qer_editorimage textures/saniko/Max1_lava.tga
	surfaceparm nolightmap
	surfaceparm lava	
	surfaceparm nomarks
	surfaceparm noimpact
	surfaceparm skybox
	surfaceparm sky	
	q3map_tessSize 64
	q3map_surfacelight 2000
	deformVertexes wave 128 sin 0 3 0.5 0.1
	cull disable
	{
		map textures/saniko/Max1_lava.tga
	}
	{
		map textures/liquids_sd/sea_bright_na.tga 
		blendfunc gl_one gl_one 
		rgbGen const ( 0.9 0.1 0.1 )
		tcMod turb 0 0.5 0 0.005
		tcMod scale 0.5 0.5 
		tcMod scroll 0 -0.3 
	}
}

textures/saniko/GrayTele
{ 
	qer_editorimage textures/saniko/Tele.tga
	cull none 
	deformVertexes wave 1 sin -0.5 0 0 1
	noPicmip 
	surfaceparm nonsolid
	surfaceparm trans 
	{ 
		map textures/sfx/construction.tga 
		blendFunc GL_SRC_ALPHA GL_ONE 
		rgbGen const ( 0.07 0.07 0.07 )
		tcGen environment 
		tcMod scroll -0.01 0.01
	} 
}