//Sipmle template for transparency and blending of water with different shades.
//Replace textures and add tcMod's etc. to every stage as neccessary to generate various effects.
//Requires q3map2 2.5.14 or later.
//By: NOP


textures/water_test/deepWater
{
	qer_editorimage textures/water/deepWater.tga
	cull none
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	{ 
		map textures/water/shallowWater.tga
		blendFunc blend
		alphaGen vertex

	}
	{ 
		map textures/water/deepWater.tga
		blendFunc blend
		rgbGen vertex
	}

}


textures/water_test/deepToShallow
{
	qer_editorimage textures/water/deepToShallow.tga
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	{ 
		map textures/water/shallowWater.tga
		blendFunc blend
		alphaGen const 0.6  //IMPORTANT MUST MATCH VALUE OF APLHAMOD BRUSH

	}
	{ 
		map textures/water/deepWater.tga
		blendFunc blend
		rgbGen vertex

	}
}


textures/water_test/shallowWater
{
	qer_editorimage textures/water/shallowWater.tga
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	{ 
		map textures/water/shallowWater.tga
		blendFunc blend
		alphaGen vertex

	}

}


///////////////////////////////////////////////
///////////////////////////////////////////////

textures/water_test/waterNoDraw
{
	qer_editorimage textures/common/nodraw.tga
	surfaceparm nodraw
  	surfaceparm nonsolid
  	surfaceparm trans
  	surfaceparm water
}


textures/common/alpha_60
{
	qer_trans 0.5
	q3map_alphaMod volume
	q3map_alphaMod set 0.6
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/common/alpha_25
{
	qer_trans 0.5
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/common/alpha_0
{
	qer_trans 0.5
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}


//
//water shaders adapted from NOP's Saberpeak tutorial
//

textures/water_test/deepwater_0
{
	qer_editorimage textures/water_test/deepwater_0.tga
	deformVertexes wave 160 sin 0 10 0 .3
	cull none
	surfaceparm water
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	{ 
		map textures/water_test/mediumwater_0.tga
		blendFunc blend
		alphaGen vertex
		tcmod scroll 0 -.1
		depthWrite
	}
	{
		map textures/water_test/deepwater_0.tga
		blendFunc blend
		rgbGen vertex
		tcmod scroll 0 -.1 
	}
}

//////////////////////waterfall///////////////////
textures/water_test/fountain1
{
	qer_editorimage textures/water_test/fountain1.tga
	deformVertexes wave 160 sin 0 10 0 .3
	cull none
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/water_test/fountain1.tga
		blendfunc blend
		depthWrite
		alphaGen vertex
		tcmod scale .5 .5
		tcmod scroll .1 -.7
	}
	{
		map textures/water_test/fountain2.tga
		blendfunc gl_src_alpha gl_one
		alphaGen vertex
		tcmod scale .5 .5
		tcmod scroll -.1 -.8
	}
	{
		map textures/water_test/mediumwater_0.tga
		blendfunc blend
		alphaGen vertex
		tcmod scroll 0 -.5
	}
	{
		map textures/water_test/deepwater_0.tga
		blendFunc blend
		rgbGen vertex
		tcmod scroll 0 -.5 
	}
}

/////////////////////////////////////////////////////////////////
///////////////////BLINKING LIGHT TEST///////////////////////////
/////////////////////////////////////////////////////////////////

textures/water_test/light_m1r
{
    nofog
    qer_editorimage textures/lights/light_m1r.tga
    surfaceparm nomarks
    {
        //Animmap .3 animMap 3 textures/lights/light_m1r textures/lights/light_m2r
        //blendFunc GL_ONE GL_ONE
        //rgbgen wave triangle .8 2 0 7
        //blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        animMap 1 textures/lights/light_m1r.tga textures/lights/light_m2r.tga 
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen identity
    }
}

//fog
textures/water_test/fog
{
	qer_editorimage textures/sfx/fog_grey1.tga
	fogparms ( 0.6 0.6 0.6 ) 5000
	surfaceparm fog
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

//////SAND EXPERIMENT

textures/water_test/sand6
{
	q3map_nonplanar
	q3map_shadeangle 120
	qer_editorimage textures/water_test/sand6.jpg
	surfaceparm landmine
	surfaceparm gravelsteps
	q3map_forcesunlight
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/water_test/sand6.jpg
		rgbgen identity
		blendFunc filter
	}
}

textures/water_test/sand7
{
	q3map_nonplanar
	q3map_shadeangle 120
	qer_editorimage textures/water_test/sand7.jpg
	surfaceparm landmine
	surfaceparm gravelsteps
	q3map_forcesunlight
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/water_test/sand7.jpg
		rgbgen identity
		blendFunc filter
	}
}

textures/water_test/sand8
{
	q3map_nonplanar
	q3map_shadeangle 120
	qer_editorimage textures/water_test/sand8.jpg
	surfaceparm landmine
	surfaceparm gravelsteps
	q3map_forcesunlight
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/water_test/sand8.jpg
		rgbgen identity
		blendFunc filter
	}
}

//textures/water_test/sand9
//{
//	q3map_nonplanar
//	q3map_shadeangle 120
//	qer_editorimage textures/water_test/sand9.tga
//	surfaceparm landmine
//	surfaceparm gravelsteps
//	q3map_forcesunlight
//	
//	{
//		map $lightmap
//		rgbGen identity
//	}
//	{
//		map textures/water_test/sand9.tga
//		rgbgen identity
//		blendFunc filter
//	}
//}

textures/water_test/stucco_phong

{
	q3map_nonplanar
	q3map_shadeangle 179
	implicitMap -
}

textures/water_test/fog
{
	qer_editorimage textures/water_test/fog.jpg
	fogparms ( 0.6 0.6 0.6 ) 2560
	surfaceparm fog
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans

}

///////DUCTS
textures/water_test/ametal_m05
{
	surfaceparm metalsteps
	implicitMap -
}

//BANNER
textures/water_test/flags_m1
{
	cull twosided
	deformVertexes wave 10 sin 0 2 0 .2
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitBlend -
}


