//**********************************************************************//
//
//  maker_terrain.shader for ET.
//
//**********************************************************************//
//

textures/maker_terrain/ter_base
{
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 16
	q3map_lightmapaxis z
	q3map_shadeangle 73 //179
}

textures/maker_terrain/ter_0_grass
{
  qer_editorimage textures/maker/editor/ter_0_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_1_dirt
{
  qer_editorimage textures/maker/editor/ter_1_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_2_dirt
{
  qer_editorimage textures/maker/editor/ter_dirt2_qer.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_3_rock
{
  qer_editorimage textures/maker/editor/ter_3_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base

	surfaceparm gravelsteps
	{
		map textures/stone/mxrock2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_4_rock
{
  qer_editorimage textures/maker/editor/ter_4_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base

	surfaceparm gravelsteps
	{
		map textures/stone/mxrock3_a.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_5_road
{
  qer_editorimage textures/maker/editor/road_01.tga
  q3map_nonplanar
  q3map_shadeangle 120
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/maker/terrain/road_01.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_6_road
{
  qer_editorimage textures/maker/editor/road_02.tga
  q3map_nonplanar
  q3map_shadeangle 120
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/maker/terrain/road_02.tga
    blendFunc filter
  }
}

//=============================================================

textures/maker_terrain/ter_vert_rock1
{
  qer_editorimage textures/stone/mxrock1aa.tga

  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock1aa.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock2
{
  qer_editorimage textures/stone/mxrock2.tga

  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock2.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock3
{
  qer_editorimage textures/stone/mxrock3_a.tga
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock3_a.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock4
{
  qer_editorimage textures/temperate_sd/rock_grayvar.tga
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/temperate_sd/rock_grayvar.tga
    blendFunc filter
  }
}


//=============================================================

textures/maker_terrain/ter_dirt1
{
  qer_editorimage textures/maker/editor/ter_dirt1_qer.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_dirt2
{
  qer_editorimage textures/maker/editor/ter_dirt2_qer.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

// ======================================================================
// alpha fade terrain shaders
// addapted by dersaidin from examples in tutorial from 
// http://simland.planetquake.gamespy.com/pages/articles/terrain1_1.htm
// ======================================================================

textures/maker_terrain/ter_grass
{
	qer_editorimage textures/maker/editor/ter_grass_qer.tga
	surfaceparm landmine
	surfaceparm grasssteps
	
	q3map_nonplanar
	q3map_shadeangle 100
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_bounceScale 0.2
	       
	{
		map textures/temperate_sd/grass_dense1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_grasspath
{
	qer_editorimage textures/maker/editor/ter_grasspath_qer.tga
	surfaceparm landmine
	surfaceparm grasssteps
	
	q3map_nonplanar
	q3map_shadeangle 100
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_bounceScale 0.1
     
	{
		map textures/temperate_sd/grass_dense1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/maker/terrain/ter_dirt1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_grasspath_nomines
{
	qer_editorimage textures/maker/editor/ter_grasspath_qer1.tga
	surfaceparm grasssteps
	
	q3map_nonplanar
	q3map_shadeangle 100
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_bounceScale 0.0
	        
	{
		map textures/temperate_sd/grass_dense1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/maker/terrain/ter_dirt1.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffs
{
	qer_editorimage textures/maker/editor/ter_cliffs_qer.tga
	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )
	q3map_bounceScale 0.2
      
	{
		map textures/temperate_sd/grass_dense1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffs1
{
	qer_editorimage textures/maker/editor/ter_cliffs1_qer.tga
	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
	q3map_bounceScale 0.2

	{
		map textures/temperate_sd/grass_dense1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffst
{
	qer_editorimage textures/maker/editor/ter_cliffst_qer.tga
	qer_trans 0.70
		
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_bounceScale 0.2

	{
		map textures/temperate_sd/grass_dense1.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffst_grav
{
	qer_editorimage textures/maker/editor/ter_cliffst_grav_qer.tga
		
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_bounceScale 0.2
	        
	{
		map textures/temperate_sd/rocky_sand.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffs_smo1
{
	qer_editorimage textures/maker/editor/ter_cliffs_smo1_qer.tga
	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
	q3map_bounceScale 0.2

	{
		map textures/temperate_sd/rock_smooth.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_cliffs_smo2
{
	qer_editorimage textures/maker/editor/ter_cliffs_smo2_qer.tga
	
	q3map_nonplanar
	q3map_shadeangle 80
	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )
	q3map_bounceScale 0.2
	qer_trans 0.70

	{
		map textures/maker/terrain/rock_smooth_a.tga
		// Primary
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/ter_road_01  // Vertical needs phong
{
  qer_editorimage textures/maker/editor/ter_road_01.tga
      
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/maker/terrain/ter_road_01.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_road_02  // Vertical needs phong
{
  qer_editorimage textures/maker/editor/ter_road_02.tga
      
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/maker/terrain/ter_road_02.tga
    blendFunc filter
  }
}


// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
// ======================================================================

textures/maker_terrain/alpha_000  // Primary texture ONLY
{
  qer_editorimage textures/maker/editor/alpha_000.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_025
{
  qer_editorimage textures/maker/editor/alpha_025.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.25
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_050  // Perfect mix of both Primary + Secondary
{
  qer_editorimage textures/maker/editor/alpha_050.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.50
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_075
{
  qer_editorimage textures/maker/editor/alpha_075.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.75
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_085
{
  qer_editorimage textures/maker/editor/alpha_085.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.85
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_100  // Secondary texture ONLY
{
  qer_editorimage textures/maker/editor/alpha_100.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 1.0
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

