//**********************************************************************//
//
//  maker_terrain.shader for ET.
//  DotProduct2 Shaders by Sock.
//  Website : http://www.planetquake.com/simland/
//
//**********************************************************************//
//
// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
//textures/my_terrain/my_base_shader 
//{ 
//   nopicmips 
//   q3map_lightmapaxis z 
//   q3map_lightmapmergable 
//   q3map_nonplanar 
//   q3map_shadeangle 155 
//   q3map_forcemeta 
//   q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 ) 
//} 
//   q3map_baseShader textures/my_terrain/my_base_shader // < used as base shader
//  

//
// Terrain
//

textures/maker_terrain/ter_dp2_dirtgrass
{
  qer_editorimage textures/maker/terrain/terrain_dirt_01.tga
        
  q3map_lightmapaxis z // Project lightmap on z axis (up/down) 
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)  
  q3map_nonplanar
  q3map_shadeangle 160
  q3map_noTJunc
  q3map_noclip
  q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
  q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
  surfaceparm grasssteps
  surfaceparm landmine
  {
    map textures/maker/terrain/terrain_dirt_01.tga  // Primary
    rgbGen identity
  }
  {
    map textures/maker/terrain/terrain_grass_01.tga // Secondary
    blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
    alphaFunc GE128
    rgbGen identity
    alphaGen vertex
  }
  {
    map $lightmap
    blendFunc GL_DST_COLOR GL_ZERO
    rgbGen identity
  }
}

// Caen2 shaders

textures/maker_terrain/ter_base
{
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 16
	q3map_lightmapaxis z
	q3map_shadeangle 73 //179
}

textures/maker_terrain/ter_0_grass
{
  qer_editorimage textures/maker/editor/ter_0_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_1_dirt
{
  qer_editorimage textures/maker/editor/ter_1_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_2_dirt
{
  qer_editorimage textures/maker/editor/ter_2_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_3_rock
{
  qer_editorimage textures/maker/editor/ter_3_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base

	surfaceparm gravelsteps
	{
		map textures/stone/mxrock2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_4_rock
{
  qer_editorimage textures/maker/editor/ter_4_ed.tga
	q3map_baseshader textures/maker_terrain/ter_base

	surfaceparm gravelsteps
	{
		map textures/stone/mxrock3_a.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_5_road
{
  qer_editorimage textures/maker/editor/road_01.tga
  q3map_nonplanar
  q3map_shadeangle 120
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/maker/terrain/road_01.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_6_road
{
  qer_editorimage textures/maker/editor/road_02.tga
  q3map_nonplanar
  q3map_shadeangle 120
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/maker/terrain/road_02.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock1
{
  qer_editorimage textures/stone/mxrock1aa.tga

  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock1aa.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock2
{
  qer_editorimage textures/stone/mxrock2.tga

  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock2.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock3
{
  qer_editorimage textures/stone/mxrock3_a.tga
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/stone/mxrock3_a.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_vert_rock4
{
  qer_editorimage textures/temperate_sd/rock_grayvar.tga
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip
//  surfaceparm gravelsteps
  {
    map $lightmap
    rgbGen identity
  }
  {
		map textures/temperate_sd/rock_grayvar.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_0to1
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
	}
	{
		map textures/desert_sd/road_dirty_gravel.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_0to2
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
	}
	{
		map textures/temperate_sd/dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_0to3
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
	}
	{
		map textures/stone/mxrock1aa.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_1to2
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
		alphaGen vertex
	}
	{
		map textures/temperate_sd/dirt3.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_1to3
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
		alphaGen vertex
	}
	{
		map textures/stone/mxrock1aa.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}

textures/maker_terrain/ter_2to3
{
	q3map_baseshader textures/maker_terrain/ter_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
		alphaGen vertex
	}
	{
		map textures/stone/mxrock1aa.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 4 4
	}
}


// ======================================================================
// Liquids
// ======================================================================

//stone/mxdebris0_riverbed.tga

textures/maker_terrain/water_pond
{
	nocompress
	qer_editorimage textures/maker/terrain/water.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
	deformVertexes wave 512 sin 1 3 0.75 0.2
	nopicmip
	waterfogvars ( 0.6 0.7 0.8 ) 500
	{ 
		fog on
		map textures/maker/terrain/water.tga
		depthWrite
		blendFunc blend
		rgbgen identity
		tcmod scale 0.3 0.3
		tcmod scroll 0.005 0.001
		tcgen environment
	}
	{
		fog on
		map textures/maker/terrain/water.tga
		blendFunc add
		tcmod scale 0.05 0.05
		tcmod scroll -.001 -.0002
		tcgen environment
	}
	{
		map $lightmap
		blendFunc filter
		rgbGen identity
	}

}

// ======================================================================
// Hong Phonged textures
// ======================================================================

//This shader is used to blend vertical surfaces (needs a new rock2grass texture)
//
//textures/sockter/ter_rock2moss1 // Vertical needs phong
//{
//  q3map_nonplanar
//  q3map_shadeangle 120
//  qer_editorimage textures/sockter/ter_rock2moss1.tga
//  {
//    map $lightmap
//    rgbGen identity
//  }
//  {
//    map textures/sockter/ter_rock2moss1.tga
//    alphaFunc GT0
//    blendFunc filter
//  }
//}

textures/maker_terrain/ter_road_01  // Vertical needs phong
{
  qer_editorimage textures/maker/terrain/terrain_road_01.tga
      
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/maker/terrain/terrain_road_01.tga
    blendFunc filter
  }
}

textures/maker_terrain/ter_road_02  // Vertical needs phong
{
  qer_editorimage textures/maker/terrain/terrain_road_02.tga
      
  q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams) 
  q3map_lightmapsamplesize 16 // Sets lightmap sample size to 2x normal to save mem (2x =32)      
  q3map_nonplanar
  q3map_shadeangle 120
//  q3map_noTJunc
//  q3map_noclip

  {
    map $lightmap
    rgbGen identity
  }
  {
    map textures/maker/terrain/terrain_road_02.tga
    blendFunc filter
  }
}

textures/maker_terrain/blacksky	// Used for testing boxmaps
{
	qer_editorimage textures/maker/terrain/blacksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	{
		map textures/maker/terrain/blacksky.tga
	}
}

// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/maker_terrain/ter_dirtmud
{
  qer_editorimage textures/maker/terrain/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/maker/terrain/ter_dirt1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/maker/terrain/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// Hong Phonged textures
// ======================================================================

textures/maker_terrain/ter_rock1_phong
{
  qer_editorimage textures/maker/terrain/ter_rock1.tga
	q3map_nonplanar
	q3map_shadeangle 120
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/maker/stone/mxrock1aa.tga
		blendFunc filter
	}
}

textures/maker_terrain/ter_rock2_phong
{
  qer_editorimage textures/maker/terrain/ter_rock2.tga
	q3map_nonplanar
	q3map_shadeangle 120
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/maker/terrain/mxrock2.tga
		blendFunc filter
	}
}

// ======================================================================
// Alpha blending without dotProduct2 and ivector
// ======================================================================
textures/maker_terrain/bld_rock2moss1		// Normal texture blending
{
  qer_editorimage textures/maker/terrain/bld_rock2moss1.tga
	q3map_nonplanar
	q3map_shadeAngle 120
	{
		map textures/maker/terrain/ter_rock2.tga	// Primary
		rgbGen identity
	}
	{
		map textures/maker/terrain/ter_moss1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/maker_terrain/dcl_moss1		// Decal blending
{
  qer_editorimage textures/maker/terrain/ter_moss1.tga
	q3map_nonplanar 
	q3map_shadeangle 120 
	surfaceparm trans 
	surfaceparm nonsolid 
	surfaceparm nomarks
	polygonoffset
	{
		map textures/maker/terrain/ter_moss1.tga
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
// ======================================================================

textures/maker_terrain/alpha_000  // Primary texture ONLY
{
  qer_editorimage textures/maker/editor/alpha_000.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_025
{
  qer_editorimage textures/maker/editor/alpha_025.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.25
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_050  // Perfect mix of both Primary + Secondary
{
  qer_editorimage textures/maker/editor/alpha_050.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.50
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_075
{
  qer_editorimage textures/maker/editor/alpha_075.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.75
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_085
{
  qer_editorimage textures/maker/editor/alpha_085.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 0.85
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

textures/maker_terrain/alpha_100  // Secondary texture ONLY
{
  qer_editorimage textures/maker/editor/alpha_100.tga
  qer_trans 0.65
  q3map_alphaMod volume
  q3map_alphaMod set 1.0
  surfaceparm nodraw
  surfaceparm nonsolid
  surfaceparm trans
}

