//
// maker.shader
//
// So I did a quick dig around light.c in the Q3Map2 source. Ambient lighting does not contribute to the lightgrid. 
// However, it seems you can tweak it using the _minxxx settings. Thus far, I found these 3 settings:
// Code:
//
// _minvertexlight
// _mingridlight
// _minlight
//
// If you specify only _minlight, the other 2 values are defaulted to the _minlight value. 
// If you specify them, those specific settings are used.
//
//=================
//Fast, good quality (brightness values are tweakable):
//
//q3map_sunExt 1 1 1 140 -35 25 2 8
//q3map_lightmapFilterRadius 0 32
//q3map_skyLight 80 3
//
//High quality (final compile):
//
//q3map_sunExt 1 1 1 140 -35 25 2 32
//q3map_skyLight 80 6
//
//Note the replacement of q3map_lightmapFilterRadius with more skyLight iterations, and more sun samples.
//
//ydnar
//=================

//textures/gonk/kalimasky_bright
//{
//qer_editorimage textures/skies/sky.tga
//q3map_lightimage textures/skies/dune_up
//q3map_sunExt .5 .37 .19 175 180 73 2 16
//q3map_lightmapFilterRadius 0 160
//q3map_skylight 120 3
//surfaceparm sky
//surfaceparm noimpact
//surfaceparm nomarks
//q3map_nolightmap
//skyParms textures/skies/dune 512 -
//}
//

//===============================
// worldspawn _noshadersun 1  - REMOVE ALL SUN LIGHT
//===============================

//=====================================
// SKY
//=====================================

textures/maker_env/st_sky
{
	qer_editorimage textures/skies_sd/wurzburg_clouds.tga
	nocompress
	skyparms - 200 -
	sunshader textures/skies_sd/full_moon2
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky
	q3map_skyLight 80 3 //q3map_skyLight 80 3 //ydnar suggested for tests
	nopicmip
	nomipmaps

	skyparms textures/skies_sd/wurzburg_env/sky 512 -

	{	
		fog off
		map textures/skies_sd/goldrush_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}

	{	
		fog off
		map textures/skies/nightsky1.jpg
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/goldrush_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen const ( 0.35 0.35 0.35 ) 
	}
}


textures/maker_env/fog
{
	qer_editorimage textures/maker/editor/fog.tga
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	surfaceparm noimpact
	surfaceparm nomarks
//	cull disable
	fogparms ( 0.3 0.3 0.3 ) 4500
}

textures/maker_env/fog_cave
{
	qer_editorimage textures/maker/editor/fog.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	q3map_globaltexture
	q3map_surfacelight 1
//	fogparms ( .15 .15 .17 ) 768
	fogparms ( .2 .2 .2 ) 384
//	fogparms ( .5 .5 .5 ) 128
	{
		map textures/marko/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/marko/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}
