//Shaders by Sage
//*********************

/////////////////////////////////
//////////////Sky///////////////
///////////////////////////////
//
//Compile:
//

textures/sm/sky
{
	qer_editorimage textures/sm/sky.jpg
	
	nomipmaps
	nopicmip
	
	//q3map_sunExt 1 0.84 0.62 90 -45 45 3 32	//32 same as q3map_sun +  deviance (half shadows)+ samples

	q3map_sun 1 0.9 0.7 120 45 60


	q3map_lightmapFilterRadius 0 8			//to stop "stadium lights" without longer compile

	q3map_skylight 60 3 // 3		//3=dev 6=final(brightness) + iterations ("quality")

	sunshader textures/sm/sun
	
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

	//fogvars ( 1 0.73 0.33 ) .0001
	//skyfogvars ( 1 0.73 0.33 ) .026	//0.96 0.75 0.32	
	
	skyparms full 512 -
 	q3map_nofog

	{
		clampmap textures/sm/sky.tga
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
		//depthWrite
	}

	{
		map textures/sm/clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll -0.003 0.003
		tcmod scale 4 4
	}

	{
		map textures/sm/clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll 0.007 0.008
		tcmod scale 2 2
	}

}

textures/sm/sun
{
	//nomipmaps
	//nopicmip
	nocompress
	cull none
	q3map_nofog

	{
		map textures/sm/sun.tga
		//blendFunc  GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//rgbGen identity
		blendFunc blend
		rgbGen identityLighting
	}

}

textures/sm/water_fog
{
        qer_trans 0.5

	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm fog
	fogparms ( 1 0.99 0.92 ) 8192
}
	

//Wow this is not easy :D
textures/sm/sky_fakefog
{
	qer_editorimage textures/sm/fakefog.tga
	qer_trans 0.80
	cull none
	//sort nearest
q3map_globaltexture
	nocompress
	nopicmip
	nomipmaps
	//q3map_forceMeta		//Bake the patch
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	{
		map textures/sm/fakefog.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	//	depthWrite

		rgbGen identity
	}
}

textures/sm/sky_waterfog
{
	qer_editorimage textures/sm/waterfog.tga
	qer_trans 0.80
	cull none
	//sort nearest
q3map_globaltexture
	nocompress
	nopicmip
	nomipmaps
	//q3map_forceMeta		//Bake the patch
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	{
		map textures/sm/waterfog.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		depthWrite

		rgbGen identity
	}
}

textures/sm/sky_new_water

{
	qer_editorimage textures/sm/water.tga
	qer_trans .5
	//q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip

	{
		map textures/liquids_sd/puddle_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen const .8
		tcGen environment
		//depthWrite
	}
		
	{ 
		map textures/sm/water.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.75
		tcmod scroll -0.06 0.02
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.4
		tcmod scale 0.25 0.25
		tcmod scroll -0.05 -0.02
		rgbGen identity
	}
	
}

textures/sm/sky_new_water2

{
	qer_editorimage textures/sm/water.tga
	qer_trans 0.8
	//q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip

	{
		map textures/sm/specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen const 0.8
		tcGen environment
		//depthWrite
	}
		
	{ 
		map textures/sm/water.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.75
		tcmod scroll 0.04 0.005
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.5
		tcmod scale 0.5 0.5
		tcmod scroll 0.05 0.009
		rgbGen identity
	}

	
}

textures/sm/new_water
{
	qer_editorimage textures/sm/water.tga
	qer_trans .5
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip


	{ 
		map textures/sm/water.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.75
		tcmod scroll -0.06 0.02
	}
	{
		map textures/sm/specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen const 0.8
		tcGen environment
	}
	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.4
		tcmod scale 0.25 0.25
		tcmod scroll -0.06 0.02
		rgbGen identity
	}
}

textures/sm/new_water2

{
	qer_editorimage textures/sm/water.tga
	qer_trans .8
	//q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip
//deformVertexes wave 1317 sin 0 3.5 0 0.25
		

	{ 
		map textures/sm/water.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.75
		//tcmod scroll 0.1 0
		tcmod scroll 0.05 -0.01
		tcMod turb 0 -0.01 0 -0.11
	}	
}

textures/sm/river_splash
{
	qer_editorimage textures/sm/foam.tga
	qer_trans .6
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip
deformVertexes wave 1317 sin 0 7 0 0.4
		
	{
		map textures/sm/specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen const 0.8
		tcGen environment
		//depthWrite
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.6
		tcmod scale 0.5 0.5
		//tcmod scroll 0.1 0
		tcmod scroll 0.035 -0.03
		//tcMod turb 0 -0.02 0 -0.12
		rgbGen identity
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.25
		tcmod scale 1.5 1.5
		tcmod scroll 0.11 -0.1
		//tcMod turb 0 -0.2 0 -0.2
		rgbGen identity
	}
}

textures/sm/river_foam
{
	qer_editorimage textures/sm_misc/wood_plank.wav
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 2.5 0 0.3

	{
		map textures/sm/uboat_foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		tcmod scroll 0.01 0.2
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.03 0 -0.03
		alphaGen vertex
		rgbGen const ( 1 1 1 )

	}
}

textures/sm/water_seam
{
	qer_editorimage textures/sm/water.tga
	q3map_globaltexture
sort additive
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 2 0 0.25




	{
		map textures/sm/foam.tga
		blendFunc blend
		//alphaGen const 0.6
		tcmod scale 0.25 0.25
		//tcmod scroll 0.1 0
		//tcmod scroll 0.05 -0.03
		tcMod turb 0 -0.09 0 -0.19
		alphaGen vertex
		rgbGen identity
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		//alphaGen const 0.6
		tcmod scale 0.4 0.4
		//tcmod scroll 0.1 0
		//tcmod scroll 0.05 -0.03
		tcMod turb 0 -0.09 0 -0.19
		alphaGen vertex
		rgbGen identity
	}

	{
		map textures/sm/uboat_foam.tga
		blendFunc blend
		//alphaGen const 0.6
		//tcmod scale 0.5 0.5
		//tcmod scroll 0.1 0
		//tcmod scroll 0.05 -0.03
		tcMod turb 0 -0.09 0 -0.19

		alphaGen vertex
		rgbGen identity
	}
}

models/mapobjects/sm/sky_terrain
{
	//nomipmaps
	//nopicmip
	//nocompress

	{
		map models/mapobjects/sm/sky_terrain.tga
		rgbGen identity
	}

//Make it hot ;)
	{
		map models/mapobjects/sm/sky_fake.tga

       	//blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 14 14
		rgbGen identity
	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}

//	{	
//	map textures/detail_sd/sanddetail.tga
//		blendFunc GL_DST_COLOR GL_SRC_COLOR
//		//detail
//		tcMod scale 4 4
//	}


}


textures/sm/water
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	//q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
	cull none
	//deformVertexes wave 1317 sin 0 2.5 0 0.15
 	//deformVertexes wave 317 sin 0 1.5 0 0.30
	
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		//tcmod scroll 0.0003 0.001
		tcMod turb 0 -0.03 0 -0.13
		alphaGen const 0.5

	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc blend
	//	rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 -0.03 0 -0.13
		tcmod scroll -0.0009 -0.004
		alphaGen const 0.5
	}

	
}


textures/sm/water_wave
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	//q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	//surfaceparm lightfilter
	//surfaceparm pointlight
	nopicmip
	cull none
	deformVertexes wave 717 sin 0 2.4 0 0.14
 	deformVertexes wave 317 sin 0 1.4 0 0.3
	sort opaque
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		tcGen environment
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .78
		//tcmod scroll 0.0003 0.001
		tcMod turb 0 -0.03 0 -0.13
		//depthWrite

	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.03 0 -0.13
		tcmod scroll -0.0009 -0.004
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.15 0.1 0.1 0.15
		tcMod turb 0 0.03 0.3 0.13
		tcmod scroll 0.0009 0.007

	}
	
}

textures/sm/water_flow
{
	qer_editorimage textures/sm/waterSS.tga
	qer_trans .5
	//q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	q3map_globaltexture
	cull disable
	nocompress
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	//waterfogvars ( 0.11 0.13 0.15 ) 0.2
	nopicmip

	deformVertexes wave 517 sin 0 1.2 0 0.09
 	deformVertexes wave 317 sin 0 0.8 0 0.1
	{
		map textures/liquids_sd/seawall_foam.tga
		depthWrite
		blendFunc blend
		alphaGen const 0.6
		tcmod scroll 0.01 -1.1
		tcMod turb 0 -0.03 0 -0.13
		rgbGen identity
	}

	{
		map textures/sm_misc/bubbles.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.7
		tcmod scroll 0.003 -0.81
		tcMod turb 0 -0.03 0 -0.13
	}
}

///////////////////phong shading!//////////////////

textures/sm_walls/wall_05
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/sm_misc/trim_04_phong
{
	qer_editorimage textures/sm_misc/trim_04_phong.tga
	q3map_nonplanar
	q3map_shadeangle 90
	//surfaceparm woodsteps
	implicitMap textures/sm_misc/trim_04.tga
}

/////////////////////////////////
//////////////Reflection////////
///////////////////////////////

textures/sm_windows/window_01
{
	{
		map textures/sm_windows/window_01.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_02
{
	{
		map textures/sm_windows/window_02.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_02_trans
{
	surfaceparm glass
	surfaceparm trans
	surfaceparm playerclip
	polygonOffset
	cull none
	qer_trans 0.5
	qer_editorimage textures/sm_windows/window_02.tga
	
	{
		map textures/effects/envmap_ice2.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/sm_windows/window_02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}


textures/sm_windows/window_03
{
	{
		map textures/sm_windows/window_03.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_04
{
	{
		map textures/sm_windows/window_04.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_05
{
	{
		map textures/sm_windows/window_05.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_06
{
	{
		map textures/sm_windows/window_06.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_07
{
	{
		map textures/sm_windows/window_07.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_08
{
	{
		map textures/sm_windows/window_08.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_09
{
	{
		map textures/sm_windows/window_09.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_windows/window_10
{
	{
		map textures/sm_windows/window_10.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


/////////////////////////////////
//////////////Alpha/////////////
///////////////////////////////

textures/sm_misc/alpha_bars		//handlebars
{
	qer_alphaFunc greater 0.5
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm playerclip
	surfaceparm trans
	implicitMask -
}

textures/sm_misc/railing_wood
{
	qer_alphaFunc greater 0.5
	cull disable
	nomipmaps
	nopicmip
	polygonoffset
	sort banner
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm playerclip
	surfaceparm trans
	implicitMask -
}

textures/sm_misc/leaves_01			//alpha_leaves
{
	qer_alphaFunc greater 0.5
	polygonoffset
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}


/////////////////////////////////
//////////////Doors/////////////
///////////////////////////////


textures/sm_doors/door_01
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_02
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_03
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_04
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_05
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_06
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_doors/door_07
{
	surfaceparm woodsteps
	implicitMap -
}




/////////////////////////////////
//////////////Misc//////////////
///////////////////////////////

//ADD ALL FOAM SHADERS INSIDE SCRIPT_MOVER!!!

textures/sm_misc/bubbles
{
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 3.5 0 0.50

	{
		map textures/sm_misc/bubbles.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 0 0.7
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.03 0 -0.13
	}
}

textures/sm/v2_foam
{
	qer_editorimage textures/sm/uboat_foam.tga
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 3.5 0 0.50

	{
		map textures/sm/uboat_foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		//tcmod scroll 1.5 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.23 0 -0.33

	}
}


textures/sm/uboat_foam2
{
	qer_editorimage textures/sm/uboat_foam.tga
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 3.5 0 0.50

	{
		map textures/sm/uboat_foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		//tcmod scroll 1.5 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.23 0 -0.33

	}
}

textures/sm/uboat_foam
{
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 3.5 0 0.50

	{
		map textures/sm/uboat_foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 1.8 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.13 0 -0.23

	}
}

textures/sm/uboat_foam_fade
{
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 384 sin 0 3.5 0 0.50
	//q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )

	{
		map textures/sm/foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 0.25 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		//tcMod turb 0 -0.13 0 -0.23
		tcMod Scale 0.5 0.5

	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		//tcmod scroll 0.1 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		//tcMod turb 0 -0.13 0 -0.23
		tcMod Scale 0.3 0.3

	}

	{
		map textures/sm_misc/bubbles.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		//tcmod scroll 2.3 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.03 0 -0.13
	}

	{
		map textures/sm/foam.tga
		blendFunc blend
		//alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 0.2 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		//tcMod turb 0 -0.13 0 -0.23
		tcMod Scale 1.5 1.5

	}
}

textures/sm/uboat_splash
{
	qer_editorimage textures/sm/foam.tga

	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
 	deformVertexes wave 512 sin 0 5.5 0 0.8
	//q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )

	{
		map textures/sm/foam.tga
		blendFunc blend
		alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 2.5 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.3 0 -0.3
		tcMod Scale 1 3.5

	}

	{
		map textures/sm_misc/bubbles.tga
		blendFunc blend
		alphaGen const 0.4
		//depthWrite
		alphagen vertex
		rgbGen identity
		tcmod scroll 2.3 0
		//rgbGen wave sin 0.2 0.1 0 0.2
		tcMod turb 0 -0.03 0 -0.13
	}
}



textures/sm_misc/wood2
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_misc/wood_plank
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_misc/painting_01
{
	surfaceparm woodsteps
	implicitMap -
}

textures/sm_misc/light_off
{
	nopicmip 
	surfaceparm metalsteps
	{
		map textures/sm_misc/light_off.tga
		rgbGen vertex
	}

}

textures/sm_misc/light_on
{
	nopicmip
	surfaceparm metalsteps
	{
		map textures/sm_misc/light_on.tga
		rgbGen vertex
	}
}

//Shader used to add light to script_mover

textures/sm/s_light
{
	qer_editorimage textures/props/base_lamp.tga
	q3map_lightimage textures/props/base_lamp.tga
	q3map_surfacelight 3000
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans

	{
		map gfx/misc/flare5.tga
		alphaFunc GE128
		rgbGen vertex
	}
}

textures/sm/s_corona
{
	qer_editorimage gfx/misc/flare5.tga
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans
	polygonOffset
deformVertexes autosprite
	{
		map gfx/misc/flare5.tga
		blendFunc add
		rgbGen vertex
	}
}

textures/sm_misc/cloth_01
{
	cull disable
deformVertexes wave 96 sin 0 1 0 .25
	surfaceparm nomarks
	implicitMap -
}

textures/sm_misc/cloth_02
{
	cull disable
deformVertexes wave 96 sin 0 1 0 .25
	surfaceparm nomarks
	implicitMap -
}

//THX RAYBAN!
textures/sm_misc/tree1_med
{
	qer_alphaFunc greater 0.5
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	//implicitMask -
	{
		map  textures/sm_misc/tree1_med.tga
		alphaFunc GE128
		rgbGen vertex
	}
}

textures/sm_uboat/base
{
	q3map_noClip
	q3map_noTJunc
	
	q3map_nonplanar
	q3map_shadeAngle 120

	q3map_lightmapMergable
}


textures/sm_uboat/combo
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/combo.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_uboat/dark
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/dark.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_uboat/light
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/light.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_uboat/detail
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/detail.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_uboat/detail2
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/detail2.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm_uboat/detail3
{
	q3map_baseshader textures/sm_uboat/base
	surfaceparm metalsteps
	{
		map textures/sm_uboat/detail3.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	//	tcMod Scale 0.5 0.5
		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/sm/fan
{
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm trans
	{
		clampmap textures/sfx/fan.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		rgbGen identity
		tcMod rotate 1024
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
		rgbGen identity
	}
}

textures/sm/fan_static
{
	
	qer_editorimage textures/sfx/fan.tga
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm trans
	{
		clampmap textures/sfx/fan.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
		rgbGen identity
	}
}

textures/sm/shadows
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans

	{
		clampmap textures/sm/shadows.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen identity
	}
}

textures/sm/uboat_fake_shadow
{
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm alphashadows
	{
		map textures/sm/uboat_fake_shadow.tga
		blendFunc GL_SRC_ALPHA GL_ONE
	}

}

textures/sm_walls/brick_02_nonsolid
{
	qer_editorimage textures/sm_walls/brick_02_nonsolid.tga
	surfaceparm nonsolid
	implicitMap textures/sm_walls/brick_02.tga
}

textures/sm_walls/brick_03_nonsolid
{
	qer_editorimage textures/sm_walls/brick_03_nonsolid.tga
	surfaceparm nonsolid
	implicitMap textures/sm_walls/brick_03.tga
}