//Shaders created by Sage ;)

//Textures used for the terrain shaders:

//1:	textures/sm_ground/sand_bright.tga		
//2:	textures/sm_ground/moss.tga 
//3:	textures/sm_ground/heavy_sand.tga			
//4:	textures/sm_ground/grass.tga
//5:	textures/temperate_sd/rock_grayvar.tga		
//6:	textures/temperate_sd/rocky_sand.tga
//7:	textures/stone/mxrock1aa.tga
//8:	textures/sm_ground/grass_dark.tga

//Base shader:

textures/sm_terrain/base_shader
{
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_alphaMod dotproduct2 ( 0 0 1.5 )
	q3map_tcMod rotate 33

	q3map_noClip
	q3map_noTJunc
	
	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapsize 1024 1024
//	q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 8
}

textures/sm_terrain/base_shader_old
{
	q3map_nonplanar
	q3map_shadeAngle 179
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_alphaMod dotproduct2 ( 0 0 1.5 )
	q3map_tcMod rotate 33

	q3map_noClip
	q3map_noTJunc
	
}

textures/sm_terrain/base_shader_cave
{
	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	//q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 8
	//q3map_lightmapaxis z
}

//***-***


//Single, non blending shaders:

textures/sm_terrain/1 
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/sm_ground/sand_bright.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/2
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_2.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/sm_ground/moss.tga 
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/3
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_3.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4.tga
	surfaceparm grasssteps
	surfaceparm landmine	
	{
		map textures/sm_ground/grass.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/5
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_5.tga

	{
		map textures/temperate_sd/rock_grayvar.tga	
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/rock_cave
{
	q3map_baseshader textures/sm_terrain/base_shader_cave
	qer_editorimage textures/temperate_sd/rock_grayvar.tga

	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/sm_terrain/7
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4.tga
	
	{
		map textures/desert_sd/sand_patchy.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/grass_foliage
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4_foliage.tga

	surfaceparm grasssteps
	surfaceparm landmine
//q3map_foliage <model> <scale> <density> <odds> <use inverse alpha>
q3map_foliage models/mapobjects/sage/grass1.md3 0.8 48 0.01 0
q3map_foliage models/mapobjects/sage/grass2.md3 1.0 64 0.01 0
q3map_foliage models/mapobjects/sage/grass3.md3 0.7 64 0.014 0

q3map_foliage models/mapobjects/sage/flower.md3 1.1 32 0.0002 0
q3map_foliage models/mapobjects/sage/flower_r.md3 1.15 32 0.0003 0
q3map_foliage models/mapobjects/sage/flower_y.md3 1 32 0.0001 0

q3map_foliage models/mapobjects/sage/flower2.md3 1.1 64 0.0006 0
q3map_foliage models/mapobjects/sage/flower2_r.md3 1.3 64 0.0001 0
q3map_foliage models/mapobjects/sage/flower2_y.md3 1.2 32 0.0005 0

q3map_foliage models/mapobjects/sage/flower3.md3 1.15 64 0.0004 0
q3map_foliage models/mapobjects/sage/flower3_r.md3 1.2 32 0.0006 0
q3map_foliage models/mapobjects/sage/flower3_y.md3 1.35 64 0.0005 0
	
	{
		map textures/sm_ground/grass.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

//***-***


//Dual, blending shaders:

textures/sm_terrain/1_to_2
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_1_to_2.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/sand_bright.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/moss.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/1_to_3
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_1_to_3.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/sand_bright.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/heavy_sand.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/1_to_4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_1_to_4.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/sand_bright.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/2_to_1
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_2_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/moss.tga 
		rgbGen identity
	}
	{
		map textures/sm_ground/sand_bright.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/2_to_3
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_2_to_3.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/moss.tga 	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/3_to_1
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_3_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/sand_bright.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/3_to_2
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_3_to_2.tga
	surfaceparm gravelsteps
	surfaceparm landmine		
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/moss.tga 	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/3_to_4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_3_to_4.tga
	surfaceparm gravelsteps
	surfaceparm landmine		
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/3_to_sea
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_3_to_4.tga
	surfaceparm gravelsteps
	{
		map textures/sm_ground/heavy_sand.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/seabed.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
		tcMod scale 0.15 0.15
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/4_to_1
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine		
	{
		map textures/sm_ground/grass.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/sand_bright.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/4_to_2
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4_to_2.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	{
		map textures/sm_ground/grass.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/moss.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/2_to_4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_2_to_4.tga
	surfaceparm gravelsteps
	surfaceparm landmine		
	{
		map textures/sm_ground/moss.tga 
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}


textures/sm_terrain/4_to_3
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4_to_3.tga
	surfaceparm gravelsteps
	surfaceparm landmine		
	{
		map textures/sm_ground/grass.tga 
		rgbGen identity
	}
	{
		map textures/sm_ground/heavy_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/5_to_3
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_5_to_3.tga

	{
		map textures/temperate_sd/rock_grayvar.tga	
		rgbGen identity
	}
	{
		map textures/sm_ground/heavy_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}


textures/sm_terrain/5_to_4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_5_to_1.tga

	{
		map textures/temperate_sd/rock_grayvar.tga	
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/6_to_1
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_5_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine

	{
		map textures/temperate_sd/rocky_sand.tga	
		rgbGen identity
	}
	{
		map textures/sm_ground/sand_bright.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/7_to_4
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_4_to_1.tga
	surfaceparm gravelsteps

	{
		map textures/desert_sd/sand_patchy.tga	
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/grass_flower_blend_foliage
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_2_to_1.tga

	surfaceparm grasssteps
	surfaceparm landmine
//q3map_foliage <model> <scale> <density> <odds> <use inverse alpha>
q3map_foliage models/mapobjects/sage/grass1.md3 0.8 32 0.01 0
q3map_foliage models/mapobjects/sage/grass2.md3 1.0 64 0.01 0
q3map_foliage models/mapobjects/sage/grass3.md3 0.7 32 0.014 0

q3map_foliage models/mapobjects/sage/flower.md3 1.1 32 0.0002 0
q3map_foliage models/mapobjects/sage/flower_r.md3 1.15 32 0.0003 0
q3map_foliage models/mapobjects/sage/flower_y.md3 1 32 0.0001 0

q3map_foliage models/mapobjects/sage/flower2.md3 1.1 32 0.0006 0
q3map_foliage models/mapobjects/sage/flower2_r.md3 1.3 32 0.0001 0
q3map_foliage models/mapobjects/sage/flower2_y.md3 1.2 32 0.0005 0

	{
		map textures/sm_ground/grass_flower.tga
		rgbGen identity
	}
	{
		map textures/sm_ground/grass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/grass_flower_foliage
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/racing_terrain/pic_6.tga

	surfaceparm grasssteps
	surfaceparm landmine
//q3map_foliage <model> <scale> <density> <odds> <use inverse alpha>
q3map_foliage models/mapobjects/sage/grass1.md3 0.8 32 0.01 0
q3map_foliage models/mapobjects/sage/grass2.md3 1.0 64 0.01 0
q3map_foliage models/mapobjects/sage/grass3.md3 0.7 32 0.014 0

q3map_foliage models/mapobjects/sage/flower.md3 1.1 32 0.0002 0
q3map_foliage models/mapobjects/sage/flower_r.md3 1.15 32 0.0003 0
q3map_foliage models/mapobjects/sage/flower_y.md3 1 32 0.0001 0

q3map_foliage models/mapobjects/sage/flower2.md3 1.1 32 0.0006 0
q3map_foliage models/mapobjects/sage/flower2_r.md3 1.3 32 0.0001 0
q3map_foliage models/mapobjects/sage/flower2_y.md3 1.2 32 0.0005 0
	
	{
		map textures/sm_ground/grass_flower.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}

textures/sm_terrain/grass_flower
{
	q3map_baseshader textures/sm_terrain/base_shader
	qer_editorimage textures/sm_ground/grass_flower.tga

	surfaceparm grasssteps
	surfaceparm landmine
	
	{
		map textures/sm_ground/grass_flower.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 6 6
	}
}


//***-***

textures/kerkyra/sand_patchy_sd
{
	surfaceparm gravelsteps
	implicitMap -
}