//*************************************
//	RivrStyx Shader for Wolfenstein
//*************************************
textures/common/nodraw_water
{
    qer_editorimage textures/rivrstyx/nodraw_water.tga
    qer_trans 0.5
    surfaceparm nodraw
    surfaceparm water
    surfaceparm nonsolid
    surfaceparm trans
}

textures/skies/sky_rivrblue
{
	qer_editorimage textures/skies/newclouds.tga
	q3map_lightimage textures/skies/n_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	q3map_globaltexture
	q3map_lightsubdivide 512
	q3map_sun	1.0 0.8 0.6 120 220 40
	q3map_surfacelight 35//mine =35

	//fogvars ( .3 .3 .305 ) .0001
	//skyfogvars ( .23 .23 .24 ) .1

	skyparms full 200 -
	
	{
		map textures/skies/newclouds.tga
		tcMod scroll -0.001 -0.003
		tcMod scale 6 6
		depthWrite
	}
}
textures/skies/sky_rivrblue2
{
	qer_editorimage textures/skies/newclouds.tga
	q3map_lightimage textures/skies/n_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	q3map_globaltexture
	q3map_lightsubdivide 512
	//q3map_sun	1.0 0.8 0.6 120 220 40
	//q3map_surfacelight 35//mine =35

	//fogvars ( .3 .3 .305 ) .0001
	//skyfogvars ( .23 .23 .24 ) .1

	skyparms full 200 -
	
	{
		map textures/skies/newclouds.tga
		tcMod scroll -0.001 -0.003
		tcMod scale 6 6
		depthWrite
	}
}

//lightbulb
textures/props2/rivr_bulb
{
	qer_editorimage textures/props2/bulbcircle_1.tga
	DeformVertexes autosprite
	surfaceparm nolightmap //added
	surfaceparm nodamage
	q3map_surfacelight 400
	surfaceparm pointlight
	cull disable
	{
		map $lightmap
       	blendfunc gl_zero gl_one
		//rgbgen identity 
	alphaFunc GE128
	}
	{
		map textures/props2/bulbcircle.tga
		//blendFunc blend
	alphaFunc GE128
	}
}
textures/metal_misc/r_ametal_m07a
{
	qer_editorimage textures/metal_misc/ametal_m07a.tga
	surfaceparm metalsteps
	//surfaceparm nolightmap //added
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/metal_misc/ametal_m07a.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
textures/metal_misc/r_metal_m06
{
	qer_editorimage textures/metal_misc/metal_m06.tga
	surfaceparm metalsteps
	//surfaceparm nolightmap //added
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/metal_misc/metal_m06.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/town_floor/carpet_drty
{
	qer_editorimage textures/evil_1floors/carpet_drty.tga
	surfaceparm carpetsteps
//surfaceparm nolightmap //added
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/evil_1floors/carpet_drty.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
textures/town_floor/carpet_drty_blood
{
	qer_editorimage textures/evil_1floors/carpet_drty_blood.tga
	surfaceparm carpetsteps
//surfaceparm nolightmap //added
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/evil_1floors/carpet_drty_blood.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//*****common***
textures/common/clip_wood
{
    qer_editorimage textures/common/clip_wood.tga
    qer_trans 0.3
    surfaceparm nodraw
    surfaceparm nomarks
    surfaceparm playerclip
    surfaceparm trans
    surfaceparm woodsteps
}

textures/rivrstyx/rivrweed2
{
qer_editorimage textures/rivrstyx_organics/weed_c01.tga		
	surfaceparm alphashadow
	//surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm nomarks
	//surfaceparm nodlight
    cull none
    nopicmip
	{

		map textures/rivrstyx_organics/weed_c01.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		//depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

textures/rivrstyx/rivr_weeds
{
qer_editorimage textures/rivrstyx/rivrweeds.tga
    surfaceparm alphashadow
  // surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm nomarks
    cull none
    nopicmip

  //  deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/rivrstyx/rivrweeds.tga
        blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
    }
}
textures/rivrstyx/rivr_tree2
{
qer_editorimage textures/rivrstyx/rivrtree2.tga
    //removelightmap info
    surfaceparm nolightmap
    qer_trans 0.8
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm nonsolid
	surfaceparm nodlight //added this
    cull none
	nopicmip
 //   deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/rivrstyx/rivrtree2.tga
      // blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	alphaFunc GE128
        rgbGen vertex
    }
}
textures/rivrstyx/rivr_tree
{
qer_editorimage textures/rivrstyx/rivrtree.tga
    //removelightmap info
    surfaceparm nolightmap
    qer_trans 0.8
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm nonsolid
    cull disable
 //   deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/rivrstyx/rivrtree.tga
        //blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	alphaFunc GE128
        rgbGen vertex
    }
}
textures/rivrstyx/rivr_bush
{
qer_editorimage textures/rivrstyx/rivrbush.tga
	surfaceparm nolightmap //added
    surfaceparm alphashadow
    cull none
    nopicmip
 //   deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/rivrstyx/rivrbush.tga
        blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identityLighting
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
    }
}

//****************************************************
// *************************************************
// *
// * ground shader - wolfmap1..grass_dm01.tga
// *
// *************************************************
textures/Rivr_wolf1/rivrterra1_0
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
//qer_editorimage textures/terrain/dirt_m03_mung.tga
{
map textures/terrain/grass_dm01.tga
tcmod scale 0.125 0.125
rgbGen vertex
alphaGen vertex
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}
textures/Rivr_wolf1/rivrterra1_1
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/grass_dm01.tga
tcmod scale 0.1 0.1
rgbGen vertex
alphaGen vertex
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}
textures/Rivr_wolf1/rivrterra1_2
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/dirt_m03_mung.tga
tcmod scale 0.05 0.05
rgbGen vertex
alphaGen vertex
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}

textures/Rivr_wolf1/rivrterra1_0to1
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/grass_dm01.tga
rgbGen vertex
alphaGen vertex
tcmod scale 0.125 0.125
}
{
map textures/terrain/dirt_m03_mung.tga
tcmod scale 0.1 0.1
rgbGen vertex
alphaGen vertex
blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}
textures/Rivr_wolf1/rivrterra1_0to2 
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/grass_dm01.tga
rgbGen vertex
alphaGen vertex
tcmod scale 0.125 0.125
}
{
map textures/terrain/dirt_m03_mung.tga
tcmod scale 0.05 0.05
rgbGen vertex
alphaGen vertex
blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}
textures/Rivr_wolf1/rivrterra1_1to2 
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/grass_dm01.tga
rgbGen vertex
alphaGen vertex
tcmod scale 0.1 0.1
}
{
map textures/terrain/dirt_m03_mung.tga
tcmod scale 0.05 0.05
rgbGen vertex
alphaGen vertex
blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
}
//{
//map textures/skies2/clouds.tga
//blendfunc filter
//detail
//tcmod scale 0.01 0.01
//tcMod scroll -0.05 0.05
//tcmod transform 1 0 1 1 1 1
//}
}

//****************************************************
// *************************************************
// *
// * ground shader -wolfmap1 vertex
// *
// *************************************************
textures/Rivr_wolf1/vrivrterra1
{
surfaceparm grasssteps
surfaceparm nolightmap
q3map_novertexshadows
q3map_forcesunlight
{
map textures/terrain/dirt_m03_mung.tga
rgbGen vertex
tcmod scale 0.125 0.125
}
}

//**************************************************
//*
//* Water.......Steam
//*
//**************************************************
textures/rivrstyx/rivr_splash_1
{
	qer_editorimage textures\rivrstyx\rs_splash.tga
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	deformVertexes autosprite
	deformVertexes move 15.2671 0 21.0681 sawtooth 0 1 0 0.99758 
	{
		clampmap textures\rivrstyx\rs_splash.tga
		blendfunc add
		rgbGen wave sawtooth 1 -0.75 0 0.99758 
		tcMod rotate 3
		tcMod stretch sawtooth 1 0 0 0.99758 
		alphaGen wave sawtooth 0.6 -0.6 0 0.99758 
	}
}

textures/rivrstyx/rivr_splash_2
{
	qer_editorimage textures\rivrstyx\rs_splash.tga
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	deformVertexes autosprite
	deformVertexes move 27.9806 0 14.5417 sawtooth 0 1 0 1.00822 
	{
		clampmap textures\rivrstyx\rs_splash.tga
		blendfunc add
		rgbGen wave sawtooth 1 -0.75 0 1.00822 
		tcMod rotate -3
		tcMod stretch sawtooth 1 0 0 1.00822 
		alphaGen wave sawtooth 0.6 -0.6 0 1.00822 
	}
}

textures/rivrstyx/rivr_splash_3
{
	qer_editorimage textures\rivrstyx\rs_splash.tga
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	deformVertexes autosprite
	deformVertexes move -23.5294 0 24.9054 sawtooth 0 1 0 0.922809 
	{
		clampmap textures\rivrstyx\rs_splash.tga
		blendfunc add
		rgbGen wave sawtooth 1 -0.75 0 0.922809 
		tcMod rotate 4
		tcMod stretch sawtooth 1 0 0 0.922809 
		alphaGen wave sawtooth 0.6 -0.6 0 0.922809 
	}
}

textures/rivrstyx/rivr_splash_4
{
	qer_editorimage textures\rivrstyx\rs_splash.tga
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	deformVertexes autosprite
	deformVertexes move 12.4378 0 31.5161 sawtooth 0 1 0 1.02932 
	{
		clampmap textures\rivrstyx\rs_splash.tga
		blendfunc add
		rgbGen wave sawtooth 1 -0.75 0 1.02932 
		tcMod rotate -4
		tcMod stretch sawtooth 1 0 0 1.02932 
		alphaGen wave sawtooth 0.6 -0.6 0 1.02932 
	}
}

textures/rivrstyx/rivr_splash_5
{
	qer_editorimage textures\rivrstyx\rs_splash.tga
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	deformVertexes autosprite
	deformVertexes move -34.8016 0 9.76785 sawtooth 0 1 0 0.958803 
	{
		clampmap textures\rivrstyx\rs_splash.tga
		blendfunc add
		rgbGen wave sawtooth 1 -0.75 0 0.958803 
		tcMod rotate 1
		tcMod stretch sawtooth 1 0 0 0.958803 
		alphaGen wave sawtooth 0.6 -0.6 0 0.958803 
	}
}

//******************
textures/rivrstyx/rs_waterfall
{
	qer_editorimage textures/rivrstyx/rs_water.tga
//surfaceparm nodlight
surfaceparm nolightmap
surfaceparm nonsolid
	cull disable
	deformVertexes wave 100 sin 0 1 0 1.5
	{
		map textures/rivrstyx/rs_water.tga  //rivrstyx/rs_water.tga
		blendfunc blend
		//rgbGen Vertex
		//tcmod scale .2 .2
		tcMod scroll 0 -2
		alphaGen Vertex
	}
//	{
//			map $lightmap
//			blendFunc GL_dst_color GL_zero
//			rgbgen identity		
//	}


}

textures/rivrstyx/rs_water
{
	qer_editorimage textures/liquids/ocean_m1b.tga
//surfaceparm nolightmap
//surfaceparm nodlight
qer_trans .5
	q3map_globaltexture
		surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	//surfaceparm nomarks	// don't play ripple effects when shooting into water
	//tesssize 512
	
	cull disable
	nofog
	deformVertexes wave 100 sin 0 2 0 .3	// the chop wave 160 sin 0 10 0 .3

	waterfogvars ( 0.1 0.35 0.1 ) 512
//	waterfogvars ( 0.1 0.1 0.1 ) .005
//	{
//		fog on
//		map $lightmap
//		blendFunc GL_dst_color GL_zero
//		rgbgen identity		
//	}
	{ 
		fog on
		map textures/liquids/ocean_m1b.tga
		//blendFunc GL_one GL_ONE
		//alphagen const .5
		rgbgen wave sin .4 0 0 .05	
		tcmod scale .2 .1
		tcmod scroll .01 -.03	//.03 .02
	}	
	{ 
		map textures/liquids/ocean_m1b.tga
		blendFunc GL_src_alpha GL_ONE 
		alphagen const .5		
		tcmod scale .2 .2
		tcmod scroll .03 -.03	//-.03 -.02
	}
{
			map $lightmap
			blendFunc GL_dst_color GL_zero
			rgbgen identity		
		}
}
textures/rivrstyx/rs_steam
{
	qer_editorimage textures/rivrstyx/rs_steam.tga
	surfaceparm nolightmap
	surfaceparm trans
	cull disable
	deformVertexes autosprite2
	deformVertexes wave 50 sin 0 4 0 0.3 
	deformVertexes move 0.3 0.1 0 sin 0 0.5 0 0.2 
	{
		map textures/rivrstyx/rs_steam.tga
		blendfunc add
		rgbGen Vertex
		tcMod scroll 0 0.3
	}
}

//******Flame flicker *********
//rivrstyx
textures/rivrstyx/flicker_town_m_c01
{
	qer_editorimage textures/town_wall/town_m_c01.tga
	
{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/town_wall/town_m_c01.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave noise 0.75 0.25 0 10
	}
}

textures/rivrstyx/flicker_town_c22a1
{
	qer_editorimage textures/town_wall/town_c38a.tga
	{
		map $lightmap
     		rgbgen identity 
	}

	{
		map textures/town_wall/town_c38a.tga
		blendfunc GL_DST_COLOR GL_ZERO //GL_zero gl_SRC_COLOR 
		rgbGen wave noise 0.75 0.25 0 10	
	}
}

textures/rivrstyx/flicker_inter_c11_ba
{
	qer_editorimage textures/village_interior/inter_c11_ba.tga
	
{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/village_interior/inter_c11_ba.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave noise 0.75 0.25 0 10
	}
}
//******light flicker metal*********
// rivrstyx
textures/rivrstyx/flicker_ametal_m07a
{
	qer_editorimage textures/metal_misc/ametal_m07a.tga
{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/metal_misc/ametal_m07a.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave noise 0.55 0.25 0 8
}
}

//******wood ladder*****
textures/rivrstyx/rivr_woodladder
{
	qer_editorimage textures/rivrstyx/rivr_ladder.tga
    surfaceparm alphashadow
    surfaceparm woodsteps
    cull disable
    {
        map textures/rivrstyx/rivr_ladder.tga
        alphaFunc GE128
        depthWrite
        rgbGen vertex
    }
}
