//praetoria FX Shaders for ET
//Sky, Water, and Fog shaders

//*******************************************************************
//****** SKY SHADER *************************************************
//*******************************************************************

textures/praetoria/env/praetoriasky_skybox
{
	qer_editorimage textures/praetoria/editor_images/praetoriasky_ed.tga
	qer_keyword Praetoria
	
	skyParms textures/praetoria/env/praetoriasky 1024 -

	//q3map_lightImage textures/praetoria/editor_images/praetoriasky_ed.tga
//	q3map_sunExt 1 .5 .5 100 -45 25 6 32		//(red)(green)(blue)(intensity)(degrees)(elevation)(deviance)(samples) Q3map2 version
	q3map_sunExt .85 .75 1 25 45 25 6 32		//(red)(green)(blue)(intensity)(degrees)(elevation)(deviance)(samples) Q3map2 version


	q3map_skylight 25 6                    //amount iterations
	q3map_noFog

	surfaceparm sky                         //flags compiler that this is sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	nopicmip
	nomipmaps
	


	{
		map textures/praetoria/env/praetoria_clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll 0.005 0.005
		tcmod scale 3 3
	}
	
}


//*******************************************************************
//******* HOT METAL *************************************************
//*******************************************************************
textures/praetoria/props/embers
{
	qer_editorimage textures/praetoria/props/ember1a.tga
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm nomarks

	{
		map textures/metal_misc/ametal_m03man.tga
		rgbGen identity
	}
	{
		map textures/praetoria/props/ember1a.tga
		blendFunc GL_ONE GL_ONE
	}
	{
		map textures/praetoria/props/ember1b.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.5 0 0.5
	}
}

//*******************************************************************
//******* Electricity ***********************************************
//*******************************************************************
textures/praetoria/lights/electric
{
	qer_editorimage textures/praetoria/lights/electric.tga
	surfaceparm pointlight
	surfaceparm nomarks
	
	{
		map textures/praetoria/lights/electric.tga
		tcMod scroll  0 1
		blendFunc GL_ONE GL_ONE
	}
}

textures/praetoria/lights/electric_glow
{
	qer_editorimage textures/praetoria/lights/electric_glow.tga
	surfaceparm pointlight
	surfaceparm nomarks

	
	{
		map textures/praetoria/lights/electric_glow.tga
		blendFunc GL_ONE GL_ONE
		tcMod rotate 15
	}
}

textures/praetoria/lights/lightning
{
		
	cull twosided
	deformVertexes autoSprite2
	qer_editorimage textures/praetoria/lights/lightning1.tga

	{
		animMap 20 textures/praetoria/lights/lightning1.tga textures/praetoria/lights/lightning2.tga textures/praetoria/lights/lightning3.tga textures/praetoria/lights/lightning2.tga
		
		blendFunc GL_SRC_ALPHA GL_ONE
	//	rgbGen wave inverseSawtooth 0 1 0 10
		rgbGen identity
	}
}

//*******************************************************************
//******* REFLECTIVE METAL ******************************************
//*******************************************************************

textures/praetoria/props/engine_body
{ 

	qer_editorimage textures/praetoria/props/train_B_02.tga
	surfaceparm metalsteps
	{ 
		map textures/praetoria/env/env_muted.tga 
		tcGen environment 
	} 
	{ 
		map textures/praetoria/props/train_B_02.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
}

textures/praetoria/props/engine_turbine
{ 

	qer_editorimage textures/praetoria/props/train_B_05.tga
	surfaceparm metalsteps
	{ 
		map textures/praetoria/env/env_muted.tga 
		tcGen environment 
	} 
	{ 
		map textures/praetoria/props/train_B_05.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
}

textures/praetoria/metal/metal_floor
{ 

	qer_editorimage textures/praetoria/metal/metal_floor.tga
	surfaceparm metalsteps
	{ 
		map textures/praetoria/env/env_muted.tga 
		tcGen environment 
	} 
	{ 
		map textures/praetoria/metal/metal_floor.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
}

textures/praetoria/metal/w_steel 
{ 

	qer_editorimage textures/praetoria/metal/w_steel.tga
	surfaceparm metalsteps
	{ 
		map textures/praetoria/env/env_bright.tga 
		tcGen environment 
	} 
	{ 
		map textures/praetoria/metal/w_steel.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
}

textures/praetoria/metal/safe 
{ 

	qer_editorimage textures/praetoria/metal/safe.tga
	surfaceparm metalsteps 
	{ 
		map textures/praetoria/env/env_bright.tga  
		tcGen environment 
	} 
	{ 
		map textures/praetoria/metal/safe.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
} 

//Reflective marble floor
textures/praetoria/floors/floor_marble_02
{ 

	qer_editorimage textures/praetoria/floors/floor_marble_02.tga
	{ 
		map textures/praetoria/env/env_muted.tga 
		tcGen environment 
	} 
	{ 
		map textures/praetoria/floors/floor_marble_02.tga 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO 
		rgbGen identity 
	} 
}

/////////////////////////////////////////////////////////////
// Red Brick wall with Reflective window
/////////////////////////////////////////////////////////////
textures/praetoria/walls_ext/extwall_redbrick_0b
{
	qer_editorimage textures/praetoria/walls_ext/extwall_redbrick_03b.tga
	{
		map textures/praetoria/env/env_bright.tga
		tcGen environment
	}
	{
		map textures/praetoria/walls_ext/extwall_redbrick_03b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


//******************************************************************
//****** WATER TEXTURES ********************************************
//******************************************************************

//Water surface when viewed from above
textures/praetoria/terrain/water_outside
{
	nocompress
	qer_editorimage textures/praetoria/terrain/water_base.tga
	qer_trans .25
	q3map_globaltexture
	q3map_cloneshader textures/praetoria/terrain/water_inside

//	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm water
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm lightfilter

	{
		map textures/praetoria/terrain/water_base.tga
		alphaGen const .75
		
		tcMod scroll .0 .05
		tcMod scale 4 1
		tcMod scale .25 1
	}
	{
		map textures/praetoria/terrain/water_overlay.tga
		blendFunc blend
		tcMod scroll 0 0.1
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen Identity
		depthFunc equal
	}
}

//Water surface viewed from underneath
textures/praetoria/terrain/water_inside
{
	qer_editorimage textures/praetoria/terrain/water_caustic.tga
	qer_trans .9
	nocompress
	
	q3map_globaltexture
	q3map_invert

	surfaceparm water
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
//	surfaceparm lightfilter


	{
		map textures/praetoria/terrain/water_base.tga
		blendFunc filter
		tcMod scroll .0 .10
		tcMod scale 4 1
		tcMod scale .25 1
	}
	{
		map textures/praetoria/terrain/water_caustic.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -.05 -.05
	}
	{
		map textures/praetoria/terrain/water_caustic_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll .05 0.05
	}
	{
		map textures/praetoria/terrain/water_overlay.tga
		blendFunc blend
		tcMod scroll 0 0.05
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

//Water surface for shallow pools
textures/praetoria/terrain/water_pool
{
	qer_editorimage textures/praetoria/terrain/water_caustic.tga
	qer_trans .9
	cull disable
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	surfaceparm lightfilter

	{
		map textures/praetoria/terrain/water_base.tga
		alphaGen const .35
		tcMod scale 4 1
		tcMod scale .25 1
		tcmod turb 0.1 0.15 0 0.075
	}
	{
		map textures/praetoria/terrain/water_caustic.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -.05 -.05
	}
	{
		map textures/praetoria/terrain/water_caustic_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll .05 0.05
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

//Recycler tanks Fluid
textures/praetoria/props/fluid_tanks
{
	qer_editorimage textures/praetoria/terrain/water_base.tga
	qer_trans .9
	q3map_lightmapBrightness 3
	q3map_surfacelight 300
	q3map_lightSubdivide 60
	q3map_lightRGB .8 .85 1
	surfaceparm glass
	surfaceparm lightfilter
	surfaceparm playerclip
//	surfaceparm trans
	
	{
		map textures/effects/tinfx.tga
		tcGen environment
	}
	{
		map textures/praetoria/terrain/water_caustic.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -.05 -.05
	}
	{
		map textures/praetoria/terrain/water_caustic_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll .05 0.05
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

//Water No-draw shader
textures/praetoria/water_nodraw
{
	qer_editorimage textures/praetoria/editor_images/water_nodraw.tga
	qer_trans .5
	
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	surfaceparm nomarks
}

//******************************************************************
//****** FOG TEXTURES ********************************************
//******************************************************************

//Water fog shader
textures/praetoria/water_fog
{
	qer_editorimage textures/praetoria/editor_images/water_fog.tga
	qer_trans 0.5

	surfaceparm nomarks	
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm fog
	surfaceparm water

//		fogparms ( 0.075 0.085 0.075 ) 3096
}

//Atmosphere fog shader
textures/praetoria/fog
{
	qer_editorimage textures/praetoria/editor_images/fog.tga
	qer_trans .75
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nodraw
	surfaceparm fog
	surfaceparm nonsolid
	surfaceparm noimpact
	surfaceparm nomarks
	cull disable
//	fogparms ( 0.67 0.31 0.25 ) 7704
	fogparms ( 0.67 0.31 0.25 ) 9000
}

//Poison fog shader
textures/praetoria/poison
{
	qer_editorimage textures/praetoria/editor_images/poison.tga
	qer_trans .75
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nodraw
	surfaceparm fog
	surfaceparm nonsolid
	surfaceparm noimpact
	surfaceparm nomarks
	cull disable
	q3map_globaltexture
	q3map_surfacelight 0
//	fogparms ( 0.7 1 0.45 ) 768
	fogparms ( 0.35 .5 0.25 ) 512
	
//	{
//		map textures/praetoria/env/praetoria_clouds.tga
//		blendfunc gl_dst_color gl_zero
//		rgbgen identity
//		tcmod scale -.05 -.05
//		tcmod scroll .01 -.01
//	}
//	{
//		map textures/praetoria/env/praetoria_clouds.tga
//		blendfunc gl_dst_color gl_zero
//		rgbgen identity
//		tcmod scale .05 .05
//		tcmod scroll .01 -.01
//	}
}
//Poison smoke
//textures/praetoria/poison_puff
//{
//	qer_editorimage textures/praetoria/misc/poison_puff.tga
//	cull none
//	entityMergable
//	nofog
//	{
//		map textures/praetoria/misc/poison_puff.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen vertex
//	}
//}

textures/praetoria/poison_puff
{
	qer_editorimage textures/praetoria/misc/poison_puff.tga
	cull none
	nofog
	{
		map textures/praetoria/misc/poison_puff.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		alphaGen const 0.5
	}
}