//===================================================================================================
//===================================================================================================
//                     SHARED CONSOLE SHADERS
//===================================================================================================
//===================================================================================================

////////////////////////////////////////////////////
//Praetoria Console Cabinet Shaders
////////////////////////////////////////////////////

models/praetoria/consoles/console_01
{
	qer_editorimage models/praetoria/consoles/console_01.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_01.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/console_01_overlay.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
}

models/praetoria/consoles/console_01_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_02
{
	qer_editorimage models/praetoria/consoles/console_02.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_02.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/console_02_overlay.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
}

models/praetoria/consoles/console_02_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_03
{
	qer_editorimage models/praetoria/consoles/console_03.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_03.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/console_03_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/console_03_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_04
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_04_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_05
{
	qer_editorimage models/praetoria/consoles/console_05.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_05.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/console_05_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/console_05_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_06
{
	qer_editorimage models/praetoria/consoles/console_06.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_06.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/console_06_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/console_06_damaged
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/console_metal
{
	surfaceparm metalsteps
	implicitMap -
}


////////////////////////////////////////////////////
//Praetoria Console Animated Shaders
////////////////////////////////////////////////////
//Radar Sweep Screen
models/praetoria/consoles/radar_screen
{
	qer_editorimage models/praetoria/consoles/radar_screen.tga
	surfaceparm metalsteps
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/radar_screen.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/radar_beep.tga
		blendFunc GL_ONE GL_ONE
	}
	{
		map models/praetoria/consoles/radar_sweep.tga
		tcMod rotate 90
		blendFunc GL_ONE GL_ONE
	}
}

//Radar Scroll Screen
models/praetoria/consoles/radio_scroll_screen
{
	qer_editorimage models/praetoria/consoles/radio_scroll_screen.tga
	polygonoffset
	{
		map models/praetoria/consoles/radio_scroll_01.tga
		blendFunc GL_ONE GL_ONE
	}
	{
		map models/praetoria/consoles/radio_scroll_02.tga
		tcMod scroll .5 0
		blendFunc GL_ONE GL_ONE
	}
}

//===================================================================================================
//===================================================================================================
//                     AT GUN CONTROLS CONSOLE SHADERS
//===================================================================================================
//===================================================================================================
// Yellow square light
models/praetoria/consoles/square_light_on
{
	qer_editorimage models/praetoria/consoles/square_light_on.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/square_light_on.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/square_light_on.tga
		blendFunc GL_ONE GL_ONE
	}
}



models/praetoria/consoles/square_light_off
{
	surfaceparm metalsteps
	implicitMap -
}

//===================================================================================================
//===================================================================================================
//                     TANK UPGRADER CONSOLE SHADERS
//===================================================================================================
//===================================================================================================

////////////////////////////////////////////////////
//Praetoria Upgrader Console Horizontal Switch
////////////////////////////////////////////////////
models/praetoria/consoles/switch_horiz
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/switch_horiz_red
{
	qer_editorimage models/praetoria/consoles/switch_horiz_red.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/switch_horiz.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/switch_horiz_red.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/switch_horiz_green
{
	qer_editorimage models/praetoria/consoles/switch_horiz_green.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/switch_horiz.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/switch_horiz_green.tga
		blendFunc GL_ONE GL_ONE
	}
}

///////////////////////////////////////////////////////
//Praetoria Upgrader Console Activate/Deactivate Lights
///////////////////////////////////////////////////////
models/praetoria/consoles/up_switch_off
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/up_switch_activate
{
	qer_editorimage models/praetoria/consoles/up_switch_activate.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_switch_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_switch_activate.tga
		blendFunc GL_ONE GL_ONE
	}
	
}

models/praetoria/consoles/up_switch_deactivate
{
	qer_editorimage models/praetoria/consoles/up_switch_deactivate.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_switch_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_switch_deactivate.tga
		blendFunc GL_ONE GL_ONE
	}
	
}

////////////////////////////////////////////////////
//Praetoria Upgrader Console White Icon Lights
////////////////////////////////////////////////////

models/praetoria/consoles/up_icon_off
{
	surfaceparm metalsteps
	implicitMap -
}

models/praetoria/consoles/up_icon_on
{
	qer_editorimage models/praetoria/consoles/up_icon_on.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_on.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/up_icon_cov
{
	qer_editorimage models/praetoria/consoles/up_icon_cov.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_cov.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/up_icon_med
{
	qer_editorimage models/praetoria/consoles/up_icon_med.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_med.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/up_icon_fop
{
	qer_editorimage models/praetoria/consoles/up_icon_fop.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_fop.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/up_icon_sol
{
	qer_editorimage models/praetoria/consoles/up_icon_sol.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_sol.tga
		blendFunc GL_ONE GL_ONE
	}
}

models/praetoria/consoles/up_icon_eng
{
	qer_editorimage models/praetoria/consoles/up_icon_eng.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/up_icon_off.tga
	    rgbGen lightingdiffuse
	}
	{
		map models/praetoria/consoles/up_icon_eng.tga
		blendFunc GL_ONE GL_ONE
	}
}



//===================================================================================================
//===================================================================================================
//    SHARED CONSOLE SHADERS FOR BRUSHWORK PROPS USING MODEL TEXTURES
//===================================================================================================
//===================================================================================================

// Yellow square light
textures/models/praetoria/consoles/square_light_off
{
	qer_editorimage models/praetoria/consoles/square_light_off.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/square_light_off.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/square_light_on
{
	qer_editorimage models/praetoria/consoles/square_light_on.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/square_light_on.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	
	{
		map models/praetoria/consoles/square_light_on.tga
		blendFunc GL_ONE GL_ONE
	}
}


////////////////////////////////////////////////////
//Praetoria Console Cabinet Shaders
////////////////////////////////////////////////////
textures/models/praetoria/consoles/console_01
{
	qer_editorimage models/praetoria/consoles/console_01.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_01.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_01_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}
textures/models/praetoria/consoles/console_01_damaged
{
	qer_editorimage models/praetoria/consoles/console_01_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_01_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_02
{
	qer_editorimage models/praetoria/consoles/console_02.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_02.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_02_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/models/praetoria/consoles/console_02_damaged
{
	qer_editorimage models/praetoria/consoles/console_02_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_02_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_03
{
	qer_editorimage models/praetoria/consoles/console_03.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_03.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_03_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/models/praetoria/consoles/console_03_damaged
{
	qer_editorimage models/praetoria/consoles/console_03_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_03_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_04
{
	qer_editorimage models/praetoria/consoles/console_04.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_04.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_04_damaged
{
	qer_editorimage models/praetoria/consoles/console_04_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_04_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_05
{
	qer_editorimage models/praetoria/consoles/console_05.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_05.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_05_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/models/praetoria/consoles/console_05_damaged
{
	qer_editorimage models/praetoria/consoles/console_05_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_05_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_06
{
	qer_editorimage models/praetoria/consoles/console_06.tga
	surfaceparm metalsteps

	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_06.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_06_overlay.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/models/praetoria/consoles/console_06_damaged
{
	qer_editorimage models/praetoria/consoles/console_06_damaged.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_06_damaged.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/models/praetoria/consoles/console_metal
{
	qer_editorimage models/praetoria/consoles/console_metal.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/console_metal.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


////////////////////////////////////////////////////
//Praetoria Console Animated Shaders
////////////////////////////////////////////////////
//Radar Sweep Screen
textures/models/praetoria/consoles/radar_screen
{
	qer_editorimage models/praetoria/consoles/radar_screen.tga
	surfaceparm metalsteps
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map models/praetoria/consoles/radar_screen.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/praetoria/consoles/radar_beep.tga
		blendFunc GL_ONE GL_ONE
	}
	{
		map models/praetoria/consoles/radar_sweep.tga
		tcMod rotate 90
		blendFunc GL_ONE GL_ONE
	}
}

//Radar Scroll Screen
textures/models/praetoria/consoles/radio_scroll_screen
{
	qer_editorimage models/praetoria/consoles/radio_scroll_screen.tga
	polygonoffset
	{
		map models/praetoria/consoles/radio_scroll_01.tga
		blendFunc GL_ONE GL_ONE
	}
	{
		map models/praetoria/consoles/radio_scroll_02.tga
		tcMod scroll .5 0
		blendFunc GL_ONE GL_ONE
	}
}


