//
// alpha trees shader
// ** add this shader filename to the shaderlist **
// raybanb@gmail.com
//

textures/op_tower/treeline_mixed	// a mixed treeline, tiling - no ends.
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

levelshots/op_tower_cc_automap 
{ 
   nopicmip 
   nocompress 
   nomipmaps 
   { 
      clampmap levelshots/op_tower_cc.jpg 
      depthFunc equal 
      rgbGen identity 
   } 
} 

levelshots/op_tower_cc_trans 
{ 
   nopicmip 
   nocompress 
   nomipmaps 
   { 
      clampmap levelshots/op_tower_cc.jpg 
      blendfunc blend 
      rgbGen identity 
      alphaGen vertex 
   } 
}

textures/op_tower/handrail_wood
{
	surfaceparm woodsteps
	implicitMap -
}

textures/op_tower/glass_shine
{
	surfaceparm glass
	surfaceparm pointlight
	surfaceparm trans
	cull none
	nomipmaps
	{
		map textures/op_tower/glass_shine.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcGen environment
	}
}

textures/op_tower/light_tp_red.tga
{
	nopicmip
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}


textures/op_tower/light_tp_green.tga
{
	nopicmip
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}


textures/op_tower/light_tp_blue.tga
{
	nopicmip
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/op_tower/clear_water
{
	qer_editorimage textures/op_tower/qer_clear_water.jpg
	qer_trans .5
	q3map_globaltexture
	cull disable
	surfaceparm nonsolid
	surfaceparm water
	{
		map textures/op_tower/clear_water.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 1.5 0 1.5 1 1 2
		tcmod scroll -.05 .001
	}
	{
		map textures/op_tower/da_pool.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll .025 -.001
	}
	{
		map textures/op_tower/clear_water.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .5
		tcmod scroll .001 .025
	}
	{
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity
	}
}

textures/op_tower/owl_water
{
	qer_editorimage textures/op_tower/da_pool.tga
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	cull disable
	deformVertexes wave 64 sin 1 2 0 0.3 
	qer_trans 0.5
	q3map_globaltexture
	{
		map textures/op_tower/da_pool1.tga
		blendfunc add
		rgbGen identity
		tcMod scale 0.15 0.22
		tcMod transform 1.7 0 1.7 1 1 2
		tcMod scroll -0.05 0.001
	}
	{
		map textures/op_tower/da_pool.tga
		blendfunc add
		rgbGen identity
		tcMod scale 0.2 0.18
		tcMod transform 0 1.5 1 1.5 2 1
		tcMod scroll 0.025 -0.001
	}
	{
		map textures/op_tower/water_da.tga
		blendfunc add
		rgbGen identity
		tcMod scale 0.25 0.25
		tcMod transform 0 1.8 1 1.8 2 1
		tcMod scroll 0.025 -0.001
	}
	{
		map textures/op_tower/water_da.tga
		blendfunc filter
		rgbGen identity
		tcMod scale 0.29 0.29
		tcMod transform 0 1.6 1 1.8 2 1
		tcMod scroll 0.021 -0.0008
	}
	{
		map $lightmap 
		blendfunc filter
		rgbGen identity		
		tcGen lightmap 		
	}
}

//****************************************************//
//									//
//	siege.shader for GTKRadiant			//
//	by Amethyst7 - 06.12.2001				//
//									//
//****************************************************//

textures/op_tower/skybox/skybox
{
	qer_editorimage textures/op_tower/skybox/siege
	q3map_lightrgb 0.8 0.9 1.0
	q3map_sunExt 1 .95 .9 150 330 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 5
	surfaceparm noimpact
	surfaceparm nolightmap
	nopicmip
	nomipmaps
	skyparms textures/op_tower/skybox/siege 512 -
	surfaceparm sky
	{
		map textures/op_tower/skybox/clouds.jpg
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

//---------------------------------------------------
// common/alpha shaders copied from Sock's terrain-tutorial-map
// http://www.simonoc.com
//
textures/op_tower/alpha_000
{
        qer_editorimage textures/op_tower/qer_alpha_000.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_025
{
        qer_editorimage textures/op_tower/qer_alpha_025.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_050
{
        qer_editorimage textures/op_tower/qer_alpha_050.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_075
{
        qer_editorimage textures/op_tower/qer_alpha_075.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_085
{
        qer_editorimage textures/op_tower/qer_alpha_085.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_095
{
        qer_editorimage textures/op_tower/qer_alpha_085.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.95
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/op_tower/alpha_100
{
        qer_editorimage textures/op_tower/qer_alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

// Grass section --------------------

// grass green
models/foliage/grass_green_foliage1
{
	qer_alphafunc greater 0.5
	cull disable
	distanceCull 512 1792 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grass_green1.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

//Grass more green
textures/op_tower/grass_green
{
	qer_editorimage textures/op_tower/grass_green.jpg
	q3map_nonplanar
	q3map_shadeangle 135
	surfaceparm landmine
	surfaceparm grasssteps
	implicitMap textures/op_tower/grass_green.jpg
}


// grass brown
models/foliage/grass_brown_foliage2
{
	qer_alphafunc greater 0.5
	cull disable
	distanceCull 512 1792 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grass_brown2.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

textures/op_tower/grastosand
{
    qer_editorimage textures/op_tower/qer_grastosand.jpg
	q3map_globalTexture
	q3map_lightmapMergable
	q3map_nonplanar
	q3map_shadeAngle 90
//	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_foliage models/mapobjects/plants_sd/catailfoliage.md3 1.5 32 0.01 0
	q3map_foliage models/mapobjects/plants_sd/mil.md3 3.0 128 0.01 1
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/desert_sd/sand_disturb_desert.tga
	}
	{
		map textures/egypt_floor_sd/sandygrass_b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0 //LT128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/op_tower/grastowave
{
    qer_editorimage textures/op_tower/qer_grastowave.jpg
	q3map_globalTexture
	surfaceparm landmine
	q3map_lightmapMergable
	q3map_nonplanar
	q3map_shadeAngle 90
//	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_foliage models/foliage/grass_green_foliage1.md3 0.85 32 0.05 0
//	q3map_foliage models/mapobjects/plants_sd/grass_low.md3 0.5 48 0.05 0
	q3map_foliage models/mapobjects/plants_sd/catailfoliage.md3 1.5 128 0.01 0
//	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.98 )
	{
		map textures/temperate_sd/rock_grayvar.tga
		rgbGen identity
	}
	{
		map textures/egypt_floor_sd/sandygrass_b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0 //LT128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// the true grass
textures/op_tower/sandygrass
{
        qer_editorimage textures/op_tower/qer_sandygrass.jpg
	q3map_globalTexture
	q3map_lightmapMergable
	q3map_nonplanar
	q3map_shadeAngle 135
//	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_foliage models/foliage/grass_green_foliage1.md3 0.80 40 0.05 0
	q3map_foliage models/foliage/grass_brown_foliage2.md3 0.91 96 0.02 0
	q3map_foliage models/mapobjects/plants_sd/grass_low.md3 0.5 48 0.05 0
	q3map_foliage models/mapobjects/plants_sd/catailfoliage.md3 1.5 128 0.01 0
	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/egypt_floor_sd/sandygrass_b.tga
}

// End grass section --------------------

// posters
textures/op_tower/poster1_allies
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}
textures/op_tower/prop_luftwaffe
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/op_tower/prop_panzer
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/prop_panzer.tga
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/borreau
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/borreau.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/littlehousegrass
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/littlehousegrass.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/poster1_axis
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/poster1_axis.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/airraid
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/airraid.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/girl_sold
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/girl_sold.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/docu
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/docu.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/axis_soldier
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/axis_soldier.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/map
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/map.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

textures/op_tower/loing
{
   polygonOffset
   entityMergable
   {
      map textures/op_tower/loing.jpg
      rgbGen vertex
      alphaGen vertex
      blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
   }  
}

// Ktrees shader
// Kic

models/mapobjects/ktrees/01bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/04bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/05bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/06bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/07bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/barkg
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/oak01_trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/oak1_trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/trunck3
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/trunk01
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/ttrunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/Umbrella_Trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/wood06
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/07branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/06branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/12branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/01branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/02branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/04branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/11branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/10branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/oak1_leaf
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/09branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/plant_01
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/oak_leaf
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/13branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/08branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/llv
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf01
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf02
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf021
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/tree
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf01u
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/cross09
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/ttree
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/branch_t
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/topkor
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/101branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leafs
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}


