//========================================================
// braundorf.shader
//========================================================


//========================================================
// standard textures
//========================================================

textures/braundorf/braundorf_kaserne
{ 
   qer_editorimage textures/braundorf/braundorf_kaserne.tga
   nomipmaps
   nopicmip
   surfaceparm pointlight
   surfaceparm trans
   surfaceparm woodsteps
   implicitMap - 
  
   { 
      map textures/braundorf/braundorf_kaserne.tga
   } 
}

textures/braundorf/light_m25b
{
   qer_editorimage textures/braundorf/light_m25b.tga
   q3map_lightimage textures/braundorf/light_msb1.tga
   q3map_lightsubdivide 128
   q3map_surfacelight 8000
   surfaceparm nomarks
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/braundorf/light_m25b.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbGen identity
   }
   {
      map textures/braundorf/light_m25b.tga
      blendFunc GL_ONE GL_ONE
   }
}


// ======================================================================
// Alpha blending without dotProduct2 and ivector
// ======================================================================
textures/braundorf/bld_rock2grass		// Normal texture blending
{
        qer_editorimage textures/braundorf/rock2grass_editor_image.tga
	
	q3map_nonplanar
	q3map_shadeAngle 90
	
	{
		map textures/braundorf/rock.tga	// Primary
		rgbGen identity
	}
	{
		map textures/braundorf/grass.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// Hong Phonged textures
// ======================================================================
textures/braundorf/rock_phong
{
	q3map_nonplanar
	q3map_shadeangle 90
        qer_editorimage textures/braundorf/rock.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/braundorf/rock.tga
		blendFunc filter
	}
}

// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================

textures/braundorf/terrain_grassdirt
{
        qer_editorimage textures/braundorf/terrain_grassdirt.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	surfaceparm grasssteps
 	surfaceparm landmine
	
	{
		map textures/braundorf/grass.tga	// Primary
		rgbGen identity
	}
	{
		map textures/braundorf/dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}


}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/braundorf/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/braundorf/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/braundorf/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/braundorf/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/braundorf/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/braundorf/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}
