//
// Brush Scripting
// Map: MP_VEMORK [ Heavy Water Factory Assault ]
// Last edited by: Haakon A. Myhra, hmint@frisurf.no
//

///////////////// Snow Sky ////////////////////
///////////////////////////////////////////////

textures/mp_vemork/winter_night
{
	nocompress
	qer_editorimage textures/skies/beachsky_m01
	q3map_lightimage textures/skies/n_blue2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_globaltexture
	q3map_lightsubdivide 2048
	q3map_sun 0.274632 0.274632 0.38 40 120 45
	q3map_surfacelight 30
	q3map_lightrgb .1 0.1 0.5
	skyparms full 200 -
	fogvars ( .1 .1 .2 ) 1600
	{
		map textures/skies/newclouds2.tga
		tcMod scale 4.0 4.0
		depthWrite
	}
}

textures/mp_vemork/terrain
{
	q3map_terrain
	surfaceparm snowsteps
	surfaceparm nodraw
	surfaceparm nomarks
    	surfaceparm nolightmap
}

///////////////// Snow Terrain ////////////////////
///////////////////////////////////////////////////

textures/mp_vemork/terrain_0
{
	surfaceparm snowsteps
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/terrain/snowsurface1.tga
		rgbGen vertex
		tcmod scale 0.025 0.025
	}
}

textures/mp_vemork/terrain_1
{
	surfaceparm snowsteps
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/terrain/snowsurface0.tga
		rgbGen vertex
		tcmod scale 0.05 0.05
	}
}

textures/mp_vemork/terrain_0to1
{
	surfaceparm snowsteps
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/terrain/snowsurface1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.025 0.025
	}
	surfaceparm snowsteps
	{
		map textures/terrain/snowsurface0.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.05 0.05
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/vxmp_vemork/terrain
{
	surfaceparm snowsteps
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/terrain/snowsurface1.tga
		rgbGen vertex
		tcmod scale 0.025 0.025
	}
}

///////////////// RiverWinter ////////////////////
//////////////////////////////////////////////////

textures/mp_vemork/riverwinter
	{
		qer_editorimage textures/liquids/pool3d_3.tga
		qer_trans .5
		q3map_globaltexture
		surfaceparm trans
		surfaceparm nonsolid
		surfaceparm water

		cull disable
		deformVertexes wave 64 sin .5 .5 0 .5	
	
		
		{ 
			map textures/liquids/pool3d_5.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 1.5 0 1.5 1 1 2
			tcmod scroll -.05 .001
		}
	
		{ 
			map textures/liquids/pool3d_6.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 0 1.5 1 1.5 2 1
			tcmod scroll .025 -.001
		}

		{ 
			map textures/liquids/pool3d_3.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .25 .5
			tcmod scroll .001 .025
		}	

		{
			map $lightmap
			blendFunc GL_dst_color GL_zero
			rgbgen identity		
		}

	}

///////////////// Misc. textures ////////////////////
/////////////////////////////////////////////////////


textures/vm_basic/vm_sign
{

	{
		map textures/vm_basic/vm_sign.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/mesh_snow
{
	surfaceparm snowsteps	
	nomipmaps
	nopicmip
	cull twosided
	surfaceparm alphashadow
	{
       		map textures/vm_basic/mesh_snow.tga
        	alphaFunc GE128
        	depthWrite
        	rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc filter
	}

}

textures/vm_basic/chair_1a
{

	{
       		map textures/vm_basic/chair_1a.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/sign_stop
{

	{
       		map textures/vm_basic/sign_stop.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/sign_exit
{

	{
       		map textures/vm_basic/sign_exit.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/sign_obs
{

	{
       		map textures/vm_basic/sign_obs.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/norwaymap
{

	{
       		map textures/vm_basic/norwaymap.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/nordmenn
{
	{
       		map textures/vm_basic/nordmenn.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/norgepst
{
	{
       		map textures/vm_basic/norgepst.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/steinpnt
{
	{
       		map textures/vm_basic/steinpnt.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/flag_l_m01
{
	polygonOffset
	entityMergable
	{
       		map textures/vm_basic/sunflag.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/sundoor
{
	{
       		map textures/vm_basic/sundoor.tga
		rgbGen vertex
		alphaGen vertex
	}

}

textures/vm_basic/cave
{
	surfaceparm snowsteps

	{
		map textures/vm_basic/cave.tga
		rgbGen vertex
		alphaGen vertex
	}

}


textures/mp_vemork/glass
{
	surfaceparm glass	
	surfaceparm trans	
	cull none
	qer_editorimage textures/common/dirtymirror.tga
	qer_trans 	0.5
     
      	{
		map textures/common/dirtymirror.tga
          	tcgen environment
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc filter
	}
}

textures/mp_vemork/glassice
{
	qer_editorimage textures/common/dirtymirror_ice2.tga		
	surfaceparm glass	
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nolightmap
	cull none
	{
		map textures/common/dirtymirror_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

///////////////// Misc. models //////////////////////
/////////////////////////////////////////////////////

models/mapobjects/light/pendant_new
{

	{
		map models/mapobjects/light/pendant_light1a.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/light/pendant_bowl
{

	{
		map models/mapobjects/light/pendant_bowl1a.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/light/wall_light
{

	{
		map models/mapobjects/light/wall_light.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/light/wall_light2
{

	{
		map models/mapobjects/light/wall_light.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/furniture/officechair
{

	{
		map models/mapobjects/furniture/officechair.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/furniture/desklamp
{

	{
		map models/mapobjects/furniture/desklamp.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/vehicles/halftrack_new
{
	surfaceparm snowsteps
	{
		map models/mapobjects/vehicles/halftrack_new.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/miltary_trim/hedgehog_new
{
	surfaceparm snowsteps
	{
		map models/mapobjects/miltary_trim/hedgehog_new.tga
		rgbGen vertex
		alphaGen vertex
	}

}

models/mapobjects/lion/dog
{
	{
		map models/mapobjects/lion/dog.tga
		rgbGen lightingdiffuse
	}

}