// ---------------------------------------------
// ------------ TERRAIN ------------------------
// ---------------------------------------------

textures/river2nd_t/terrain_0
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_1
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	q3map_nonplanar // phong 
	q3map_shadeangle 180 // phong angle
	// surfaceparm landmine
	{
		map textures/temperate_sd/grass_dense1.tga  //river2nd_t/rv2nd_grass.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	q3map_nonplanar // phong 
	q3map_shadeangle 180 // phong angle
	surfaceparm landmine
	{
		map textures/river2nd_t/rv2nd_grass_wet.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	{
		map textures/river2nd_t/rv2nd_rock_veg.jpg
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// ---------------------------------------------
// ------------ TERRAIN BLENDS -----------------
// ---------------------------------------------

textures/river2nd_t/terrain_0to1
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
	}
	{
		map textures/stone/mxrock3_a.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_0to2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_0to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
	}
	{
		map textures/river2nd_t/rv2nd_grass_wet.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_0to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
	}
	{
		map textures/river2nd_t/rv2nd_rock_veg.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_1to2
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_1to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/river2nd_t/rv2nd_grass_wet.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_1to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/stone/mxrock3_a.jpg
	}
	{
		map textures/river2nd_t/rv2nd_rock_veg.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_2to3
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	surfaceparm landmine
	
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map textures/river2nd_t/rv2nd_grass_wet.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_2to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm grasssteps
	
	{
		map textures/temperate_sd/grass_dense1.tga
	}
	{
		map textures/river2nd_t/rv2nd_rock_veg.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain_3to4
{
	q3map_lightmapsamplesize 64
	q3map_lightmapaxis z
	q3map_texturesize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	
	{
		map textures/river2nd_t/rv2nd_grass_wet.tga
	}
	{
		map textures/river2nd_t/rv2nd_rock_veg.jpg
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/river2nd_t/terrain.vertex
{
	{
		map textures/river2nd_t/rv2nd_rock_steep.tga
		rgbGen vertex
	}
}


// ---------------------------------------------
// ------------ SKY ----------------------------
// ---------------------------------------------

textures/river2nd_t/rv2ndsky_011
{
	qer_editorimage textures/river2nd_t/rv2ndsky_011.jpg // rv2nd_fog_02.jpg or rv2nd_fog_03sm for TCs shader

	q3map_sunExt 1 .95 .9 65 60 55 3 16 //65 60 60 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 50 3

	skyparms - 128 - //low value >> more curved sky

	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	nopicmip

	{
		map textures/river2nd_t/rv2ndsky_011.jpg
		rgbGen identity
	}
	{
		map textures/river2nd_t/rv2ndsky_011.jpg
		blendfunc blend
		rgbGen identity
		tcMod scroll 0.002 0.001
		tcMod scale 1.4 1.4
	}
}


// ---------------------------------------------
// ------------ WATER --------------------------
// ---------------------------------------------


// after siwa_water2:
textures/river2nd_t/rv2nd_water // surface of water - no proper fogclipping
{
	// nocompress // no idea why this is here
	qer_editorimage textures/river2nd_t/rv2nd_water.tga
	qer_trans 0.5
	qer_nocarve

	q3map_globaltexture

	// surfaceparm nomarks
	surfaceparm nonsolid
	// surfaceparm trans //disabled to make surface opaque
	surfaceparm water //disabled cuz of water_nodraw or for boxmap

	// surfaceparm fog // fog inside the watershader after
	// fogparms ( 0.08 0.18 0.17 ) 2048 // users.pandora.be/Ariffnet/tutorials/waterfog.html

	cull none
	nopicmip

	deformVertexes wave 64 sin .25 .25 0 .5 

	nofog //disable to have the water clipped by fog
	// waterfogvars ( 0.08 0.18 0.17 ) 0.2 // ( 0.11 0.13 0.15 ) 0.2

	{
		fog on
		map textures/river2nd_t/rv2nd_water.tga
		blendFunc blend
		alphaFunc GE128
		rgbgen identity
		tcmod scale 1 1 //0.5 0.5
		tcmod scroll -0.2 -0.1//-.02 -.001
	}
	{
		fog on
		map textures/liquids_sd/seawall_ripple1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.3 0.02 0 0.25
		tcmod scale 0.01 0.01 // me: 0.04 0.05
		tcmod scroll .0025 -.0015 // -.001 -.0002
	}
	{
		fog on
		map textures/liquids_sd/seawall_ripple1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.1 0.03 0 0.4
		tcmod scale 1 1
		tcmod scroll .009 -.006 //old:.005 .003
	}
	{
		fog on
		map textures/liquids_sd/siwa_shimshim1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.4 0.02 0 0.3
		tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll .01 .01 //.005 -.001
	}
}



// ---------------------------------------------
// ------------ OTHER TERRAIN SHADERS ----------
// ---------------------------------------------

textures/river2nd_t/rv2nd_cave-sand
{
	qer_editorimage textures/temperate_sd/sand_patchnoise.tga
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/sand_patchnoise
}

textures/river2nd_t/rv2nd_cave-rock1
{
	qer_editorimage textures/stone/mxrock3_a.tga
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/stone/mxrock3_a.tga
}

textures/river2nd_t/rv2nd_cave-rock2
{
	qer_editorimage textures/temperate_sd/rock_ugly_brown.tga
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/temperate_sd/rock_ugly_brown.tga
}

textures/river2nd_t/rv2nd_road_asphalt
{
	qer_editorimage textures/river2nd_t/rv2nd_road_asphalt.jpg
	q3map_nonplanar
	q3map_shadeangle 100
	implicitMap textures/river2nd_t/rv2nd_road_asphalt.jpg
}

textures/river2nd_t/rv2nd_gravel
{
	qer_editorimage textures/temperate_sd/dirt3.tga
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/dirt3.tga
}

textures/river2nd_t/rv2nd_gravel2
{
	qer_editorimage textures/river2nd_t/rv2nd_gravel2.jpg
	q3map_nonplanar
	q3map_shadeangle 180
	surfaceparm gravelsteps
	implicitMap textures/river2nd_t/rv2nd_gravel2.jpg
}


// ---------------------------------------------
// ------------ BUILDINGS ----------------------
// ---------------------------------------------

textures/river2nd_b/rv2nd_roof_wood01
{
	// qer_editorimage textures/river2nd_b/rv2nd_roof_wood01.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_roof_wood01_d1
{
	// qer_editorimage textures/river2nd_b/rv2nd_roof_wood01_d1.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_wood03
{
	// qer_editorimage textures/river2nd_b/rv2nd_wood03.jpg
	surfaceparm woodsteps
	implicitmap -
}

textures/river2nd_b/rv2nd_wood04
{
	// qer_editorimage textures/river2nd_b/rv2nd_wood04.jpg
	surfaceparm woodsteps
	implicitmap -
}


// ---------------------------------------------
// ------------ BUILDINGS - INNER ROOMS --------
// ---------------------------------------------

textures/river2nd_r/rv2nd_wallins01_base_0 //wall without moulding at base
{
	qer_editorimage textures/river2nd_r/rv2nd_wallins01_base_0.jpg
	implicitMap -
}

textures/river2nd_r/rv2nd_stucco01_01
{
	qer_editorimage textures/river2nd_r/rv2nd_stucco01_01.jpg
	implicitMap -
}

textures/river2nd_r/rv2nd_wall06_01
{
	qer_editorimage textures/river2nd_r/rv2nd_wall06_01.jpg
	implicitMap -
}


// ---------------------------------------------
// ------------ PROPS --------------------------
// ---------------------------------------------


textures/river2nd_p/rv2nd_rope
{
	qer_editorimage textures/props/cable_m01.jpg
	surfaceparm woodsteps
	implicitMap textures/props/cable_m01.jpg // -
}


textures/river2nd_p/rv2nd_metal_trststripe_2
{
	// qer_editorimage textures/river2nd_p/rv2nd_metal_trststripe_2.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/river2nd_p/rv2nd_tramcable
{
	qer_editorimage textures/props/cable_m01.jpg
	q3map_nonplanar
	q3map_shadeangle 270
	surfaceparm metalsteps
	implicitMap textures/props/cable_m01.jpg
}

textures/river2nd_p/rv2nd_tram_black
{
	// qer_editorimage textures/river2nd_p/rv2nd_tram_black.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/river2nd_p/rv2nd_tram_metalrivet
{
	// qer_editorimage textures/river2nd_p/rv2nd_tram_metalrivet.jpg
	surfaceparm metalsteps
	implicitMap -
}

textures/river2nd_p/rv2nd_tram_red
{
	// qer_editorimage textures/river2nd_p/rv2nd_tram_red.jpg
	surfaceparm metalsteps
	implicitMap -
}

// ---------------------------------------------
// ------------ LIGHTS -------------------------
// ---------------------------------------------

