//////////////////////////////////////////////////////////////////////////
// Command map shaders

levelshots/mp_forum_b1_cc_automap
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mp_forum_b1_cc.tga
        depthFunc equal
        rgbGen identity
    }
}
  
levelshots/mp_forum_b1_cc_trans
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mp_forum_b1_cc.tga
        blendfunc blend
        rgbGen identity
        alphaGen vertex
    }
} 

//////////////////////////////////////////////////////////////////////////
// Sky box
textures/mp_forum/mp_forum_skybox
{
	qer_editorimage textures/mp_forum/mp_forum_ft.tga

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	q3map_globaltexture
	q3map_lightsubdivide 512

	q3map_sun 1.0 1.0 0.9 100 220 60
	q3map_surfacelight 150
	q3map_lightimage textures/mp_forum/mp_forum_skycolour.tga

	skyparms textures/mp_forum/mp_forum 128 -
	q3map_backsplash 0 0
	q3map_bounce 0

	// Cloud layer
	{
		fog off
		map textures/mp_forum/mp_forum_clouds.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 5.0 5.0
		tcMod scroll 0.002 -0.0013
	}
}

//////////////////////////////////////////////////////////////////////////
// Limbo camera shader
textures/mp_forum/mp_forum_limbo_x
{
	qer_editorimage textures/mp_forum/bitmobilehq.tga
	surfaceparm nolightmap

	nopicmip
	nocompress
	nomipmaps

	{
		animMap 0.3 textures/mp_forum/bitmobilehq.tga textures/mp_forum/bitradioroom.tga
		blendFunc GL_ONE GL_ZERO
		rgbgen identity
	}	
}

//////////////////////////////////////////////////////////////////////////
// Generic shaders
textures/mp_forum/mp_forum_map
{
	qer_editorimage levelshots/mp_forum_b1_cc.tga		
	nopicmip
	nocompress
	nomipmaps
	polygonoffset
	surfaceparm trans
	implicitblend levelshots/mp_forum_b1_cc.tga
}


textures/mp_forum/mp_forum_strongglass
{
	qer_editorimage textures/common/s_glass.tga		
	surfaceparm alphashadow
	surfaceparm glass 
	surfaceparm trans
	qer_trans 	0.75
	surfaceparm trans

	{
		map textures/common/s_glass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/mp_forum/mp_forum_glass
{
	qer_editorimage textures/mp_forum/mp_forum_glass.tga		
	surfaceparm alphashadow
	surfaceparm glass 
	surfaceparm trans
	qer_trans 	0.5
	surfaceparm trans

	{
		map textures/mp_forum/mp_forum_glass.tga		
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/mp_forum/mp_forum_water
{
	qer_editorimage textures/liquids_sd/seawall_ripple1.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm nonsolid
	surfaceparm water
	cull disable
	
	{ 
		map textures/liquids_sd/seawall_ripple1.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 1.5 0 1.5 1 1 2
		tcmod scroll -.05 .001
	}
	{ 
		map textures/liquids_sd/seawall_ripple1.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .5
		tcmod scroll .001 .025
	}
	{
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity		
	}
}

//////////////////////////////////////////////////////////////////////////
// Signs for MP_FORUM sections

// Surrenderdotty sign
textures/mp_forum/sign_sd
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_sd.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Gerbil #1 sign
textures/mp_forum/sign_g1
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_g1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Gerbil #2 sign
textures/mp_forum/sign_g2
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_g2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Gerbil #3 sign
textures/mp_forum/sign_g3
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_g3.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Grizzlybear #1 sign
textures/mp_forum/sign_gb1
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_gb1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Grizzlybear #2 sign
textures/mp_forum/sign_gb2
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_gb2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Krishana #1 sign
textures/mp_forum/sign_k1
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_k1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Krishana #2 sign
textures/mp_forum/sign_k2
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_k2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// SCDS_reyalP sign
textures/mp_forum/sign_rp
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_rp.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Chavo One sign
textures/mp_forum/sign_co
{
	// RTCW properties
	surfaceparm metalsteps
	nopicmip

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/sign_co.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//////////////////////////////////////////////////////////////////////////
// Original shaders for MP_FORUM by Gerbil

textures/mp_forum/mp_forum_a_light_orange
{
	qer_editorimage textures/mp_forum/mp_forum_a_light_orange.tga
	q3map_surfacelight 5000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_orange.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_orange.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/mp_forum/mp_forum_a_light_yellow
{
	qer_editorimage textures/mp_forum/mp_forum_a_light_yellow.tga
	q3map_surfacelight 5000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_yellow.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_yellow.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/mp_forum/mp_forum_a_light_white
{
	qer_editorimage textures/mp_forum/mp_forum_a_light_white.tga
	q3map_surfacelight 5000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_white.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_light_white.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

// Waving grass base
textures/mp_forum/mp_forum_a_grass_base
{
	// Radiant properties
	qer_trans .75

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 170

	// RTCW properties
//	surfaceparm trans
//	surfaceparm alphashadow
	surfaceparm nonsolid
	surfaceparm nomarks
	nopicmip
	nomipmaps
	cull disable

	// Texture layer properties
	{
		map textures/mp_forum/mp_forum_a_grass_base.tga
		rgbGen identity
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthwrite
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthfunc equal
	}
}

// Vine
textures/mp_forum/mp_forum_a_vine
{
	// RTCW properties
	surfaceparm alphashadow
	surfaceparm nonsolid
	surfaceparm nomarks
	nopicmip
	cull disable

	// Texture layer properties
	{
		map textures/mp_forum/mp_forum_a_vine.tga
		rgbGen identity
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthwrite
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthfunc equal
	}
}

// Smooth rock face
textures/mp_forum/mp_forum_a_rockface
{
	// Radiant properties
	qer_editorimage textures/temperate_sd/rock_grayvar.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 170
	
	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Smooth grass
textures/mp_forum/mp_forum_a_grass
{
	// Radiant properties
	qer_editorimage textures/mp_forum/mp_forum_a_grass_base.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90
	
	surfaceparm landmine

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mp_forum/mp_forum_a_grass_base.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Water
textures/mp_forum/mp_forum_a_water
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga
	qer_trans .75
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm water
	cull disable
	deformVertexes wave 160 sin 0 8 0 .3
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
		tcmod scale .2 .1
		tcmod scroll .03 .02		
	}	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		rgbGen identity
		blendFunc GL_src_alpha GL_ONE_minus_src_alpha
		alphagen const .5		
		tcmod scale .2 .2
		tcmod scroll -.03 -.02	
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Water fog
textures/mp_forum/mp_forum_a_deep_water
{
//	qer_editorimage textures/liquids_sd/seawall_ripple1.tga
//      qer_trans 0.5
//	surfaceparm	trans
//	surfaceparm	nonsolid
//	surfaceparm	nodraw
//	surfaceparm	fog
//	surfaceparm	nolightmap
//	q3map_globaltexture
//	q3map_surfacelight 0
//	fogparms ( .0 .0 .0 ) 1024


	qer_editorimage textures/liquids_sd/seawall_ripple1.tga
        qer_trans 0.5
    surfaceparm trans
//    surfaceparm nodraw
    surfaceparm nonsolid
    surfaceparm nolightmap
    surfaceparm fog
    fogparms ( 0.0 0.0 0.0 ) 1024


	{ 
		map textures/liquids_sd/seawall_ripple1.tga
		blendFunc GL_src_alpha GL_ONE_minus_src_alpha
		alphagen const .5		
		rgbGen identity
	}	
}

//////////////////////////////////////////////////////////////////////////
// Modified official shaders for specific effects

// Modified water shader - no draw
textures/mp_forum/mp_forum_a_nodrawwater
{
	// Radiant properties
	qer_editorimage textures/common/nodrawnonsolid.tga
	qer_trans 0.5

	// RTCW properties
	surfaceparm trans
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
}

textures/mp_forum/mp_forum_d_fluffybuganim
{
	qer_editorimage textures/mp_forum/mp_forum_d_fluffybug01.tga
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	{
		animMap 10 textures/mp_forum/mp_forum_d_fluffybug01.tga textures/mp_forum/mp_forum_d_fluffybug03.tga textures/mp_forum/mp_forum_d_fluffybug05.tga textures/mp_forum/mp_forum_d_fluffybug07.tga
		blendFunc GL_ONE GL_ONE
	}	
}

textures/mp_forum/mp_forum_d_hull
{
    surfaceparm nodraw
    surfaceparm nomarks
    qer_trans .5 
}

//-----------chavo shaders
textures/mp_forum/mp_forum_t_lightning1
{
        qer_editorimage textures/mp_forum/mp_forum_t_lightning1.tga
	q3map_lightimage textures/mp_forum/mp_forum_t_lightning1.tga
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	q3map_surfacelight 100
	// added a lightimage function to take color from a frame

	{
		animMap 10 textures/mp_forum/mp_forum_t_lightning1.tga textures/mp_forum/mp_forum_t_lightning2.tga textures/mp_forum/mp_forum_t_lightning3.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
}

textures/mp_forum/mp_forum_t_lightning2
{
        qer_editorimage textures/mp_forum/mp_forum_t_lightning2.tga
	q3map_lightimage textures/mp_forum/mp_forum_t_lightning2.tga
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	q3map_surfacelight 100
	// added a lightimage function to take color from a frame

	{
		animMap 10 textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning2.tga textures/mp_forum/mp_forum_t_lightning1.tga textures/mp_forum/mp_forum_t_lightning3.tga textures/mp_forum/mp_forum_t_lightning4.tga  
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
}	

textures/mp_forum/mp_forum_t_lightning3
{
        qer_editorimage textures/mp_forum/mp_forum_t_lightning3.tga
	q3map_lightimage textures/mp_forum/mp_forum_t_lightning3.tga
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	q3map_surfacelight 100
	// added a lightimage function to take color from a frame

	{
		animMap 10 textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning1.tga textures/mp_forum/mp_forum_t_lightning3.tga textures/mp_forum/mp_forum_t_lightning2.tga textures/mp_forum/mp_forum_t_lightning4.tga textures/mp_forum/mp_forum_t_lightning4.tga              
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
}

//////////////////////////////////////////////////////////////////////////
// Original shaders for MP_FORUM by SCDS_reyalP

// should be common
// low priority hint, when you don't want your splits beaming out over the
// whole level
textures/mp_forum/mp_forum_i_subtlehint
{
    qer_nocarve
    qer_trans 0.3
    surfaceparm nodraw
    surfaceparm noimpact
    surfaceparm nonsolid
    surfaceparm structural
    surfaceparm trans
}

// should be common
// no draw water
textures/mp_forum/mp_forum_i_ndwater
{
	qer_trans .5
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nodraw
}


// should be common
// cast shadows without showing up or clipping. Can be detail. Contributes
// to r_speeds. Other faces should be nodrawnonsolid
textures/mp_forum/mp_forum_i_shadowcast
{
	qer_trans .5
    qer_editorimage textures/mp_forum/mp_forum_i_shadowcast.tga
	surfaceparm nonsolid
	{
		map $whiteimage
		alphaFunc GT0
		alphaGen const 0
	}
} 

// a sky for testing
textures/mp_forum/mp_forum_i_sky
{
	q3map_lightimage textures/skies/sunset1.tga
	qer_editorimage textures/skies/testclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	q3map_globaltexture
	q3map_lightsubdivide 512
	q3map_sun  1.0 0.74 0.70 75 300 35
	q3map_surfacelight 180							

//	fogvars ( .28 .24 .24 ) .00020
//	skyfogvars ( .25 .22 .22 ) .02

	skyparms - 200 -
	q3map_backsplash 0 0
	q3map_bounce 0
	{
		map textures/skies/sunset1.tga
		depthWrite
	}
	{
		map textures/skies/assa_clouds1.tga
		blendfunc blend
		tcMod scroll 0.0010 0.00
		tcMod scale 2 1
	}
}

textures/mp_forum/mp_forum_i_win_light
{
    q3map_lightimage textures/mp_forum/mp_forum_i_wlight.b.tga
    qer_editorimage textures/mp_forum/mp_forum_i_wlight.tga
    q3map_surfacelight 450
    surfaceparm nomarks
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/mp_forum/mp_forum_i_wlight.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/mp_forum/mp_forum_i_wlight.b.tga
        blendFunc GL_ONE GL_ONE
    }
}

textures/mp_forum/mp_forum_i_win_light2
{
    q3map_lightimage textures/mp_forum/mp_forum_i_wlight2.b.tga
    qer_editorimage textures/mp_forum/mp_forum_i_wlight2.tga
    q3map_surfacelight 450
    surfaceparm nomarks
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/mp_forum/mp_forum_i_wlight2.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/mp_forum/mp_forum_i_wlight2.b.tga
        blendFunc GL_ONE GL_ONE
    }
}

//////////////////////////////////////////////////////////////////////////
// Original shaders for Chavo One's section

textures/mp_forum/mp_forum_t_panel01_red
{
	implicitmap textures/mp_forum/mp_forum_t_panel01_red.tga
}

textures/mp_forum/mp_forum_t_panel01_green
{
	implicitmap textures/mp_forum/mp_forum_t_panel01_green.tga
}

