
//////////////////////////////////////////////////////////////////////////
// Normal lightmapped terrain
//////////////////////////////////////////////////////////////////////////

textures/mml_helmsdeep_b4_terrain/terrain_base
{
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_lightmapsize 512 512
	q3map_globalTexture 

	surfaceparm landmine
}

// Standard ground rock
textures/mml_helmsdeep_b4_terrain/terrain_0
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (twice normal size)
textures/mml_helmsdeep_b4_terrain/terrain_1
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (four times normal size)
textures/mml_helmsdeep_b4_terrain/terrain_2
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (eight times normal size)
textures/mml_helmsdeep_b4_terrain/terrain_3
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (twice normal size) - offset
textures/mml_helmsdeep_b4_terrain/terrain_4
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (four times normal size) - offset
textures/mml_helmsdeep_b4_terrain/terrain_5
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Muddy water texture
textures/mml_helmsdeep_b4_terrain/terrain_6
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/riverbed.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Normal alternative terrain shader
textures/mml_helmsdeep_b4_terrain/terrain_7
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_0to1
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.5 0.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_0to4
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.5 0.5
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_0to6
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
	}
	{
		map textures/mml_helmsdeep_b4_terrain/riverbed.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_0to7
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
	}
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_1to2
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 0.5 0.5
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_2to3
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.0 0.5
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_3to5
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 2.0 2.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_4to5
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.0 0.5
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain.vertex
{
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		rgbGen vertex
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_8
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_3to8
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 8.0 8.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_4to8
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 2.0 2.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_8to10
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 0.5 2.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Blue = 9
// Touches: 4

textures/mml_helmsdeep_b4_terrain/terrain_9
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_4to9
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 2.0 1.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Purple = 10
// Touches: 2, 8

textures/mml_helmsdeep_b4_terrain/terrain_10
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 256 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/terrain_2to10
{
	q3map_baseshader textures/mml_helmsdeep_b4_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
	}
	{
		tcMod scale 2.0 8.0
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_b4_terrain/cliff_x_seam
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}
