//////////////////////////////////////////////////////////////////////////
// Command map shaders for mml_helmsdeep_b4

levelshots/mml_helmsdeep_b4_cc_automap
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_helmsdeep_b4_cc.tga
        depthFunc equal
        rgbGen identity
    }
}
  
levelshots/mml_helmsdeep_b4_cc_trans
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_helmsdeep_b4_cc.tga
        blendfunc blend
        rgbGen identity
        alphaGen vertex
    }
}

//////////////////////////////////////////////////////////////////////////
// Wang's plaque shader
textures/mml_helmsdeep_b4/plaque
{
	nopicmip
	implicitmap -
}

//////////////////////////////////
// Map specific mine markers
textures/mml_helmsdeep_b4/flags/allied
{
	cull disable
	nomipmaps
	nopicmip
	{
		map textures/mml_helmsdeep_b4/flags/allied.tga
		rgbGen lightingdiffuse
	}
}

textures/mml_helmsdeep_b4/flags/axis
{
	cull disable
	nomipmaps
	nopicmip
	{
		alphafunc ge128
		blendfunc blend
		map textures/mml_helmsdeep_b4/flags/axis.tga
		rgbGen lightingdiffuse
	}
}

//////////////////////////////////
// Skybox
textures/mml_helmsdeep_b4/skybox
{
	qer_editorimage textures/mml_helmsdeep_b4/sunset.tga
	
	q3map_sunExt 255 250 220 50 30 22 5 16
	q3map_lightmapFilterRadius 0 64
	q3map_skyLight 50 5

	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap

	skyparms textures/mml_helmsdeep_b4/bg 480 -
   	
	{
		map textures/mml_helmsdeep_b4/clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.01 0.0175
		rgbGen identityLighting
	}
	{
		clampMap textures/mml_helmsdeep_b4/nightsky.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_COLOR
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		rgbGen identityLighting
	}
	{
		blendFunc blend
		clampMap textures/mml_helmsdeep_b4/sunset.tga
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		alphagen wave sin 0.52 0.48 0.75 0.0005
	}
}

//////////////////////////////////
// Crystal shader
textures/mml_helmsdeep_b4/crystal2
{
	qer_editorimage textures/mml_helmsdeep_b4_source/crystal2.tga
//	surfaceparm glasssteps
	nopicmip

	{
		rgbgen vertex
		blendfunc GL_ONE GL_ZERO
		tcgen environment
		tcmod scroll 0.005 0.001
		map textures/mml_helmsdeep_b4/crystal2env.tga
	}
	{
		rgbgen identity
		blendfunc add
		map textures/mml_helmsdeep_b4/crystal2.tga
	}
}

//////////////////////////////////
textures/mml_helmsdeep_b4/crystalwall
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep_b4/crystalwall.tga

	// General properties
	nopicmip

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	// Background
	{
		rgbgen vertex
		alphagen vertex
		blendFunc GL_SRC_ALPHA GL_ONE
		map textures/mml_helmsdeep_b4/crystalwall.tga
	}

	// Alpha write
	{
		depthwrite
		rgbgen vertex
		alphagen vertex
		alphafunc ge128
		blendfunc add
		map textures/mml_helmsdeep_b4/crystalwall.tga		
	}

	// Sparkle effect
	{
		tcgen environment
		tcmod scale 2 2
		tcmod scroll 0.003 0.01
		rgbgen vertex
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep_b4/crystalwall.tga
	}
}

//////////////////////////////////
textures/mml_helmsdeep_b4/glittering2
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep_b4/crystal2env.tga

	// General properties
	nopicmip

	q3map_nonplanar
	q3map_shadeAngle 90

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	// Alpha write
	{
		depthwrite
		rgbgen identity
		alphagen vertex
		alphafunc ge128
		blendfunc GL_ZERO GL_ONE
		map textures/mml_helmsdeep_b4/glitteralpha.tga		
	}

	// Sparkle effect
	{
		tcgen environment
		tcmod scroll 0.003 0.01
		rgbgen identity //vertex
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep_b4/crystal3env.tga
	}
}

textures/mml_helmsdeep_b4/glittering2_x
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep_b4_source/glittering2_x.tga

	// General properties
	nopicmip

	q3map_nonplanar
	q3map_shadeAngle 90

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	// Alpha write
	{
		depthwrite
		rgbgen identity
		alphagen vertex
		alphafunc ge128
		blendfunc GL_ZERO GL_ONE
		map textures/mml_helmsdeep_b4/glitteralpha.tga		
	}

	// Sparkle effect
	{
		tcgen environment
		tcmod scroll 0.003 0.01
		rgbgen identity //vertex
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep_b4/crystal3env.tga
	}
}

textures/mml_helmsdeep_b4/glittering2_y
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep_b4_source/glittering2_y.tga

	// General properties
	nopicmip

	q3map_nonplanar
	q3map_shadeAngle 90

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	// Alpha write
	{
		depthwrite
		rgbgen identity
		alphagen vertex
		alphafunc ge128
		blendfunc GL_ZERO GL_ONE
		map textures/mml_helmsdeep_b4/glitteralpha.tga		
	}

	// Sparkle effect
	{
		tcgen environment
		tcmod scroll 0.003 0.01
		rgbgen identity //vertex
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep_b4/crystal3env.tga
	}
}

textures/mml_helmsdeep_b4/glittering2_z
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep_b4_source/glittering2_z.tga

	// General properties
	nopicmip

	q3map_nonplanar
	q3map_shadeAngle 90

	q3map_tcGen ivector ( 0 256 0 ) ( 256 0 0 )

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	// Alpha write
	{
		depthwrite
		rgbgen identity
		alphagen vertex
		alphafunc ge128
		blendfunc GL_ZERO GL_ONE
		map textures/mml_helmsdeep_b4/glitteralpha.tga		
	}

	// Sparkle effect
	{
		tcgen environment
		tcmod scroll 0.003 0.01
		rgbgen identity //vertex
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep_b4/crystal3env.tga
	}
}

textures/mml_helmsdeep_b4/rope
{
	qer_editorimage textures/mml_helmsdeep_b4/rope_direction.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 170

	// Animating rope
	{
		map textures/props/rope_m01.tga
		rgbgen identity
		tcmod scroll 0.0 -1.0	
	}

	// Lightmap
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/mml_helmsdeep_b4/horn
{
	qer_editorimage textures/mml_helmsdeep_b4/hornreflection.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	surfaceparm metalsteps

	// Base metal
	{		
		map textures/mml_helmsdeep_b4/hornmetal.tga
	}

	// Reflection
	{
		map textures/mml_helmsdeep_b4/hornreflection.tga
		blendfunc add
		tcgen environment
	}

	// Lightmap
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/mml_helmsdeep_b4/debris
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	implicitmap -
}

textures/mml_helmsdeep_b4/darkwall
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep_b4/ceiling
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep_b4/mml_helmsdeep_b4_ground
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	implicitMap -
}

//////////////////////////////////
// Cave textures and blends

textures/mml_helmsdeep_b4_source/notdone
{
	implicitMap -
}

textures/mml_helmsdeep_b4/cave_ground1
{
	qer_editorimage textures/mml_helmsdeep_b4_source/ground1.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm gravelsteps
	surfaceparm landmine

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	implicitMap textures/stone/mxrock1aa.tga
}

textures/mml_helmsdeep_b4/cave_ground2
{
	qer_editorimage textures/mml_helmsdeep_b4_source/ground2.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm gravelsteps
	surfaceparm landmine

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	implicitMap textures/mml_helmsdeep_b4_terrain/blueground.tga
}

textures/mml_helmsdeep_b4/cave_ground1to2
{
	qer_editorimage textures/mml_helmsdeep_b4_source/ground1to2.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm gravelsteps
	surfaceparm landmine

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	{
		map textures/stone/mxrock1aa.tga
		rgbgen identity
	}
	{
		map textures/mml_helmsdeep_b4_terrain/blueground.tga
		alphagen vertex
		rgbgen identity
		blendfunc blend
	}
	{
		map $lightmap
		rgbgen identity
		blendfunc filter
	}
}

textures/mml_helmsdeep_b4/mml_helmsdeep_b4_rock2
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep_b4/terrain_rock
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1_free.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain1.tga
}

textures/mml_helmsdeep_b4/terrain_rock_x
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
	q3map_lightmapaxis x

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain1.tga
}

textures/mml_helmsdeep_b4/terrain_rock_y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1_y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )
	q3map_lightmapaxis y

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain1.tga
}

textures/mml_helmsdeep_b4/terrain_rock_z
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1_z.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain1.tga
}

textures/mml_helmsdeep_b4/terrain_rock_2
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain2_free.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain2.tga
}

textures/mml_helmsdeep_b4/terrain_rock_2_x
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain2_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
	q3map_lightmapaxis x

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain2.tga
}

textures/mml_helmsdeep_b4/terrain_rock_2_y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain2_y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )
	q3map_lightmapaxis y

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain2.tga
}

textures/mml_helmsdeep_b4/terrain_rock_2_z
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain2_z.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	implicitMap textures/mml_helmsdeep_b4_terrain/terrain2.tga
}

textures/mml_helmsdeep_b4/terrain_rock_join
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1to2_free.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		rgbgen identity
	}
	{
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga
		alphagen vertex
		rgbgen identity
		blendfunc blend
	}
	{
		map $lightmap
		rgbgen identity
		blendfunc filter
	}
}

textures/mml_helmsdeep_b4/terrain_rock_join_x
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1to2_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
	q3map_lightmapaxis x

	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		rgbgen identity
	}
	{
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga
		alphagen vertex
		rgbgen identity
		blendfunc blend
	}
	{
		map $lightmap
		rgbgen identity
		blendfunc filter
	}
}

textures/mml_helmsdeep_b4/terrain_rock_join_y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1to2_y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )
	q3map_lightmapaxis y

	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		rgbgen identity
	}
	{
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga
		alphagen vertex
		rgbgen identity
		blendfunc blend
	}
	{
		map $lightmap
		rgbgen identity
		blendfunc filter
	}
}

textures/mml_helmsdeep_b4/terrain_rock_join_z
{
	qer_editorimage textures/mml_helmsdeep_b4_source/terrain1to2_z.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_lightmapaxis z

	{
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga
		rgbgen identity
	}
	{
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga
		alphagen vertex
		rgbgen identity
		blendfunc blend
	}
	{
		map $lightmap
		rgbgen identity
		blendfunc filter
	}
}

////////////////////////////////////////////////
// Decal seam hiders

textures/mml_helmsdeep_b4/seam1_x
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}

textures/mml_helmsdeep_b4/seam1_y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}

textures/mml_helmsdeep_b4/seam1_z
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_z.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}

textures/mml_helmsdeep_b4/seam1_xy
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_xy.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( -362 362 0 ) ( 0 0 256 )
//	q3map_tcGen ivector ( -181 181 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}

textures/mml_helmsdeep_b4/seam1_x-y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam1_x-y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 362 362 0 ) ( 0 0 256 )
//	q3map_tcGen ivector ( 181 181 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain1.tga	
	}
}

textures/mml_helmsdeep_b4/seam2_x
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam2_x.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga	
	}
}

textures/mml_helmsdeep_b4/seam2_y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam2_y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga	
	}
}

textures/mml_helmsdeep_b4/seam2_z
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam2_z.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga	
	}
}

textures/mml_helmsdeep_b4/seam2_xy
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam2_xy.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( -362 362 0 ) ( 0 0 256 )
//	q3map_tcGen ivector ( -181 181 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga	
	}
}

textures/mml_helmsdeep_b4/seam2_x-y
{
	qer_editorimage textures/mml_helmsdeep_b4_source/seam2_x-y.tga

	q3map_nonplanar
	q3map_shadeAngle 160
	surfaceparm stonesteps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset
	sort 6

	q3map_tcGen ivector ( 362 362 0 ) ( 0 0 256 )
//	q3map_tcGen ivector ( 181 181 0 ) ( 0 0 256 )

	{
		rgbgen vertex
		alphagen vertex
		blendFunc blend
		map textures/mml_helmsdeep_b4_terrain/terrain2.tga	
	}
}

////////////////////////////////////////////////
// Miscellaneous shaders

textures/mml_helmsdeep_b4/fort_wall
{
	qer_editorimage textures/mml_helmsdeep_b4/stonewall.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap textures/mml_helmsdeep_b4/stonewall.tga
}

textures/mml_helmsdeep_b4/fort_wall_2
{
	qer_editorimage textures/mml_helmsdeep_b4/stonewalltrim.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap textures/mml_helmsdeep_b4/stonewalltrim.tga
}

textures/mml_helmsdeep_b4/barrel_side
{
	qer_editorimage textures/props/barrel_m01.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 130

	// others
	surfaceParm metalsteps

	implicitMap textures/props/barrel_m01.tga
}

textures/mml_helmsdeep_b4/earth
{
	qer_editorimage textures/mml_helmsdeep_b4/earth.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	// other
	surfaceparm grasssteps
	surfaceparm landmine

	implicitMap textures/mml_helmsdeep_b4/earth.tga
}

textures/mml_helmsdeep_b4/cloth
{
	qer_editorimage textures/miltary_wall/guardh_i03.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	// Draw on both sides
	cull none

	// other
	surfaceparm nomarks
	surfaceparm nonsolid

	deformVertexes wave 200 sin 0 3 0 1.0
//	deformVertexes wave 500 sin 0 2 0 2.0
//	deformVertexes wave 30 sin 0 5 0 0.1
	tessSize 64

	implicitMap textures/miltary_wall/guardh_i03.tga
}

textures/mml_helmsdeep_b4/anglerock
{
	q3map_nonplanar
	q3map_shadeAngle 60

	implicitMap -
}

textures/mml_helmsdeep_b4/mml_helmsdeep_b4_wall
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

// Normal visible water
textures/mml_helmsdeep_b4/water
{
	qer_editorimage textures/mml_helmsdeep_b4_source/water_editor.tga
	qer_trans .75

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 160
	q3map_globaltexture

	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm water
	cull disable
	{
		map textures/mml_helmsdeep_b4/water.tga
		alphagen const 0.7
		rgbGen identity
		blendFunc blend
		tcmod scale 0.6 0.35
		tcmod scroll .2 -.1		
	}	
	{ 
		map textures/mml_helmsdeep_b4/water.tga
		rgbGen identity
		alphagen const 0.5
		blendFunc blend
		tcmod scale 0.35 0.6
		tcmod scroll .25 .1	
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

// Invisible water
textures/mml_helmsdeep_b4/water_invis
{
	qer_editorimage textures/liquids_sd/siwa_water.tga
	qer_trans 0.5

	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nodraw
}

// Terrain fade
textures/mml_helmsdeep_b4/terrain_fade
{
	qer_editorimage textures/mml_helmsdeep_b4_terrain/terrain.tga

	q3map_tcgen ivector ( 900 0 0 ) ( 0 900 0 )
	q3map_tcmod rotate 37
	
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm landmine

	// So it's drawn on top of the normal terrain
	polygonoffset
	sort 6

	surfaceparm grasssteps
	{
		map textures/mml_helmsdeep_b4_terrain/terrain.tga
		alphagen vertex
		rgbgen vertex
		blendfunc blend
	}
}

//////////////////////////////////////////////////////////////////////////
// Sign
textures/mml_helmsdeep_b4/sign
{
	nopicmip

	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm stonesteps
	surfaceparm nolightmap
	polygonoffset
	{
		clampmap textures/mml_helmsdeep_b4/sign.tga
		rgbgen identitylighting
		blendfunc gl_dst_color gl_src_color
	}
}

//////////////////////////////////////////////////////////////////////////
// Gate
textures/mml_helmsdeep_b4/maingate
{
	surfaceparm woodsteps
	implicitmap -
}


//////////////////////////////////////////////////////////////////////////
// Statue textures
textures/mml_helmsdeep_b4/statue
{
	qer_editorimage textures/mml_helmsdeep_b4/anglerock.tga 

	q3map_nonplanar
	q3map_shadeAngle 60

	cull none

	implicitMap textures/mml_helmsdeep_b4/anglerock.tga
}

//////////////////////////////////////////////////////////////////////////
// Mushroom shaders - MD3 - paths shouldn't change
models/mapobjects/mml_helmsdeep_b4/shroom_top
{
	q3map_nonplanar 
	q3map_shadeangle 120 
	q3map_lightmapSampleOffset 4
	surfaceparm nomarks 
	surfaceparm pointlight 
	implicitMap -
}

models/mapobjects/mml_helmsdeep_b4/shroom_under
{
	q3map_nonplanar 
	q3map_shadeangle 120 
	q3map_lightmapSampleOffset 4
	surfaceparm nomarks 
	surfaceparm pointlight 
	implicitMap -
}

//////////////////////////////////
// dyno crate md3 shaders
models/mapobjects/mml_helmsdeep_b4/dynomite
{
	{
		map models/mapobjects/mml_helmsdeep_b4/dynomite.tga
	}
}

models/mapobjects/mml_helmsdeep_b4/dynocrate
{
	{
		map models/mapobjects/mml_helmsdeep_b4/dynocrate.tga
	}
}

models/mapobjects/mml_helmsdeep_b4/dynocrate_outline
{
	{
		alphagen const 0.1
		map models/mapobjects/mml_helmsdeep_b4/dynocrate_outline.tga
		blendfunc blend
	}
}
