
//////////////////////////////////////////////////////////////////////////
// Normal lightmapped terrain
//////////////////////////////////////////////////////////////////////////

textures/mml_helmsdeep_terrain/terrain_base
{
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_lightmapsize 512 512
	q3map_globalTexture 

//	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga

	surfaceparm landmine
}

// Standard ground rock
textures/mml_helmsdeep_terrain/terrain_0
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (twice normal size)
textures/mml_helmsdeep_terrain/terrain_1
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (four times normal size)
textures/mml_helmsdeep_terrain/terrain_2
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (eight times normal size)
textures/mml_helmsdeep_terrain/terrain_3
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (twice normal size) - offset
textures/mml_helmsdeep_terrain/terrain_4
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Scaled up rocks (four times normal size) - offset
textures/mml_helmsdeep_terrain/terrain_5
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Muddy water texture
textures/mml_helmsdeep_terrain/terrain_6
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/riverbed.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

// Normal alternative terrain shader
textures/mml_helmsdeep_terrain/terrain_7
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_0to1
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.5 0.0
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_0to4
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.5 0.5
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_0to6
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
	}
	{
		map textures/mml_helmsdeep_terrain/riverbed.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_0to7
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
	}
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_1to2
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		tcMod scale 0.5 0.5
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_2to3
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 2048 0 0 ) ( 0 2048 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.0 0.5
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_3to5
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 4096 0 0 ) ( 0 4096 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		tcMod scale 2.0 2.0
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain_4to5
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_base
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
	}
	{
		tcMod scale 0.5 0.5
//		tcMod transform 1.0 0.0 0.0 1.0 0.0 0.5
		map textures/mml_helmsdeep_terrain/terrain2.tga
		alphaGen vertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
	}
}

textures/mml_helmsdeep_terrain/terrain.vertex
{
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/mml_helmsdeep_terrain/terrain2.tga
		rgbGen vertex
	}
}

//////////////////////////////////////////////////////////////////////////
// Faded out vertex lit terrain
// Original shaders by Ratty Redemption @ jolt mapping forums
//////////////////////////////////////////////////////////////////////////

textures/mml_helmsdeep_terrain/terrain_fade_base
{
//	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga

	q3map_tcgen ivector ( 900 0 0 ) ( 0 900 0 )
	q3map_tcmod rotate 37

	surfaceparm landmine

	// So it's drawn on top of the normal terrain
	polygonoffset
}

// Where actually blends from fully opaque to full transparent
textures/mml_helmsdeep_terrain/terrain_fade_0to1
{
	q3map_baseshader textures/mml_helmsdeep_terrain/terrain_fade_base
	surfaceparm grasssteps
	{
		map textures/mml_helmsdeep_terrain/terrain.tga
		alphagen vertex
		rgbgen vertex
		blendfunc blend
	}
}