//////////////////////////////////////////////////////////////////////////
// Command map shaders for mml_helmsdeep

levelshots/mml_helmsdeep_a2_cc_automap
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_helmsdeep_a2_cc.tga
        depthFunc equal
        rgbGen identity
    }
}
  
levelshots/mml_helmsdeep_a2_cc_trans
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_helmsdeep_a2_cc.tga
        blendfunc blend
        rgbGen identity
        alphaGen vertex
    }
}

//////////////////////////////////
// Skybox
textures/mml_helmsdeep/skybox
{
	qer_editorimage textures/mml_helmsdeep/sunset.tga
	
	q3map_sunExt 255 250 220 50 30 22 5 16
	q3map_lightmapFilterRadius 0 64
	q3map_skyLight 50 5

	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap

	skyparms textures/mml_helmsdeep/bg 480 -
   	
	{
		map textures/mml_helmsdeep/clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.01 0.0175
		rgbGen identityLighting
	}
	{
		clampMap textures/mml_helmsdeep/nightsky.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_COLOR
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		rgbGen identityLighting
	}
	{
		blendFunc blend
		clampMap textures/mml_helmsdeep/sunset.tga
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		alphagen wave sin 0.52 0.48 0.75 0.0005
	}
}

//////////////////////////////////
// dyno crate md3 shaders
textures/mml_helmsdeep/dynocrate
{
	{
		map textures/mml_helmsdeep/dynocrate.tga
	}
}

textures/mml_helmsdeep/dynocrate_outline
{
	{
		alphagen const 0.1
		map textures/mml_helmsdeep/dynocrate_outline.tga
		blendfunc blend
	}
}

//////////////////////////////////
textures/mml_helmsdeep/glittering
{
	// Editor properties
	qer_editorimage textures/mml_helmsdeep/glitter.tga

	// General properties
	nopicmip
//	nomipmaps

	surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm trans
	polygonoffset

	// Alpha write
	{
		depthwrite
		alphafunc ge128
		blendfunc add
		map textures/mml_helmsdeep/glitteralpha.tga		
		rgbgen identity
	}

	// Sparkle effect
	{
		tcmod scroll 0.003 0.01
		depthfunc equal
		blendfunc add
		map textures/mml_helmsdeep/glitter.tga
		rgbgen identity
	}
}

textures/mml_helmsdeep/horn
{
	qer_editorimage textures/mml_helmsdeep/hornreflection.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	surfaceparm metalsteps

	// Base metal
	{		
		map textures/mml_helmsdeep/hornmetal.tga
	}

	// Reflection
	{
		map textures/mml_helmsdeep/hornreflection.tga
		blendfunc add
		tcgen environment
	}

	// Lightmap
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/mml_helmsdeep/darkwall
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep/ceiling
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep/mml_helmsdeep_ground
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	implicitMap -
}

textures/mml_helmsdeep/cave_ground
{
	qer_editorimage textures/stone/mxrock1aa.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90
	surfaceparm gravelsteps
	surfaceparm landmine

	implicitMap textures/stone/mxrock1aa.tga
}

textures/mml_helmsdeep/fort_wall
{
	qer_editorimage textures/mml_helmsdeep/stonewall.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap textures/mml_helmsdeep/stonewall.tga
}

textures/mml_helmsdeep/fort_wall_2
{
	qer_editorimage textures/mml_helmsdeep/stonewalltrim.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap textures/mml_helmsdeep/stonewalltrim.tga
}

textures/mml_helmsdeep/barrel_side
{
	qer_editorimage textures/props/barrel_m01.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 130

	// others
	surfaceParm metalsteps

	implicitMap textures/props/barrel_m01.tga
}

textures/mml_helmsdeep/earth
{
	qer_editorimage textures/mml_helmsdeep/earth.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	// other
	surfaceparm grasssteps
	surfaceparm landmine

	implicitMap textures/mml_helmsdeep/earth.tga
}

textures/mml_helmsdeep/cloth
{
	qer_editorimage textures/miltary_wall/guardh_i03.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 60

	// Draw on both sides
	cull none

	// other
	surfaceparm nomarks
	surfaceparm nonsolid

	deformVertexes wave 200 sin 0 3 0 1.0
//	deformVertexes wave 500 sin 0 2 0 2.0
//	deformVertexes wave 30 sin 0 5 0 0.1
	tessSize 64

	implicitMap textures/miltary_wall/guardh_i03.tga
}


textures/mml_helmsdeep/mml_helmsdeep_rock2
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

textures/mml_helmsdeep/terrain_rock
{
	qer_editorimage textures/mml_helmsdeep_terrain/terrain2.tga

	q3map_nonplanar
	q3map_shadeAngle 160

	implicitMap textures/mml_helmsdeep_terrain/terrain2.tga
}

textures/mml_helmsdeep/stalagmite_rock
{
	qer_editorimage textures/mml_helmsdeep_terrain/terrain2.tga

	q3map_nonplanar
	q3map_shadeAngle 160

	surfaceparm nonsolid

	implicitMap textures/mml_helmsdeep_terrain/terrain2.tga
}

textures/mml_helmsdeep/mml_helmsdeep_wall
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 30

	implicitMap -
}

// Normal visible water
textures/mml_helmsdeep/water
{
	qer_editorimage textures/mml_helmsdeep/water_editor.tga
	qer_trans .75

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 160
	q3map_globaltexture

	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm water
	cull disable
	{
		map textures/mml_helmsdeep/water.tga
		alphagen const 0.7
		rgbGen identity
		blendFunc blend
		tcmod scale 0.6 0.35
		tcmod scroll .2 -.1		
	}	
	{ 
		map textures/mml_helmsdeep/water.tga
		rgbGen identity
		alphagen const 0.5
		blendFunc blend
		tcmod scale 0.35 0.6
		tcmod scroll .25 .1	
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

// Invisible water
textures/mml_helmsdeep/water_invis
{
	qer_editorimage textures/liquids_sd/siwa_water.tga
	qer_trans 0.5

	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nodraw
}
