//////////////////////////////////////////////////////////////////////////
// Command map shaders for mml_church

levelshots/mml_church_et_v1_cc_automap
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_church_et_v1_cc.tga
        depthFunc equal
        rgbGen identity
    }
}
  


levelshots/mml_church_et_v1_cc_trans
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_church_et_v1_cc.tga
        blendfunc blend
        rgbGen identity
        alphaGen vertex
    }
} 

//////////////////////////////////////////////////////////////////////////
// Original shaders for mml_church

// Keyboard shader 1 (main keys)
textures/mml_church/mml_church_key
{
	surfaceparm woodsteps
	nopicmip
	{
		map textures/mml_church/mml_church_key.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen vertex
	}
}

// Keyboard shader 2 (main key underside)
textures/mml_church/mml_church_key2
{
	surfaceparm woodsteps
	nopicmip
	{
		map textures/mml_church/mml_church_key2.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen vertex
	}
}

// Keyboard shader 3 (side of keys)
textures/mml_church/mml_church_key3
{
	surfaceparm woodsteps
	nopicmip
	{
		map textures/mml_church/mml_church_key3.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen vertex
	}
}

// Organ options
textures/mml_church/mml_church_organ
{
	surfaceparm woodsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_organ.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Wood debris shader
textures/mml_church/mml_church_debris
{
	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90
	surfaceparm landmine

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_debris.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Rope shader
textures/mml_church/mml_church_rope
{
	// RTCW properties
	surfaceparm metalsteps

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_rope.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Candle holder shader
textures/mml_church/mml_church_candle_holder
{
	// RTCW properties
	surfaceparm metalsteps
	surfaceparm playerclip
	cull disable

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_candle_holder.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Candles shader
textures/mml_church/mml_church_candles
{
	// RTCW properties
	surfaceparm alphashadow
	surfaceparm woodsteps
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nomipmaps
	nopicmip
	cull disable

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	// Texture layer properties
	{
		map textures/mml_church/mml_church_candles.tga
		rgbGen vertex
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthwrite
	}
}

// Organ pipe shader
textures/mml_church/mml_church_organ_pipe
{
	// RTCW properties
	surfaceparm metalsteps

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 120

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_organ_pipe.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Organ pipe shader
textures/mml_church/mml_church_organ_pipe_top
{
	// RTCW properties
	surfaceparm metalsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_organ_pipe_top.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Light halo shader
textures/mml_church/mml_church_light_halo
{
	// Radiant properties
	qer_trans 0.75

	// RTCW properties
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm nolightmap
	nofog
	cull back
	nopicmip
	nomipmaps
	polygonoffset

	// Texture layer properties
	{
		map textures/mml_church/mml_church_light_halo.tga
		blendFunc add
	}
}

// Alarm light halo shader
textures/mml_church/mml_church_alarm_halo
{
	// Radiant properties
	qer_trans 0.75

	// RTCW properties
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm nolightmap
	nofog
	cull back
	nopicmip
	nomipmaps
	polygonoffset

	// Texture layer properties
	{
		map textures/mml_church/mml_church_alarm_halo.tga
		blendFunc add
	}
}

// Ghost shader
textures/mml_church/mml_church_ghost
{
	// Radiant properties
	qer_trans 0.75

	// RTCW properties
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm nolightmap
	nofog
	cull disable
	nopicmip
	nomipmaps
	polygonoffset
	tesssize 32
	deformVertexes wave 160 sin 0 8 0 .3

	// Texture layer properties
	{
		map textures/mml_church/mml_church_ghost.tga
		blendFunc add
	}
}

//////////////////////////////////////////////////////////////////////////
// Fog to black

textures/mml_church/mml_church_black
{
	// Radiant properties
	qer_editorimage textures/mml_church/mml_church_fog.tga
        qer_trans 0.3

	// RTCW properties
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm fog
	surfaceparm nolightmap
	fogparms ( 0.0 0.0 0.0 ) 128

	// Q3Map properties
	q3map_globaltexture

//	implicitblend textures/mml_church/mml_church_mist.tga
}

//////////////////////////////////////////////////////////////////////////
// Sky box
textures/mml_church/mml_church_skybox
{
	qer_editorimage textures/mml_church/mml_church_ft.tga

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	q3map_globaltexture
	q3map_lightsubdivide 512

	q3map_sun 1.0 1.0 0.9 120 220 60
	q3map_surfacelight 100

	fogvars ( 0.95 0.95 1.0 ) .00006

	skyparms textures/mml_church/mml_church 128 -
	q3map_backsplash 0 0
	q3map_bounce 0

	{
		map textures/mml_church/mml_church_clouds.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		tcMod scroll 0.005 0.002
		tcMod scale 3.0 3.0
	}
}

//////////////////////////////////////////////////////////////////////////
// Sewer water (no tesssize so volume fog works)

// Normal visible water
textures/mml_church/mml_church_water
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga
	qer_trans .75
	q3map_globaltexture
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm water
	cull disable
	deformVertexes wave 160 sin 0 8 0 .3
	{
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
		tcmod scale 0.5 0.4
		tcmod scroll .03 .02		
	}	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		rgbGen identity
		blendFunc GL_src_alpha GL_ONE
		alphagen const .5		
		tcmod scale 0.4 0.5
		tcmod scroll -.03 -.02	
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

// Invisible water
textures/mml_church/mml_church_water_invis
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga
	qer_trans 0.5

	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nodraw

	cull disable
}

// Font water
textures/mml_church/mml_church_font_water
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga
	qer_trans .75
	q3map_globaltexture
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm water
	cull disable
	{
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
		tcmod scale 0.5 0.4
		tcmod scroll .01 .01
	}	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		rgbGen identity
		blendFunc GL_src_alpha GL_ONE
		alphagen const .5		
		tcmod scale 0.4 0.5
		tcmod scroll -.01 0.0	
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

//////////////////////////////////////////////////////////////////////////
// Modified official shaders for specific effects

// Modified window to give out light
textures/mml_church/mml_church_window1_lit
{
	qer_editorimage textures/mml_church/mml_church_window1.tga
	q3map_surfaceLight 400

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window1.blend.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
}

// Modified window to give out light
textures/mml_church/mml_church_window2_lit
{
	qer_editorimage textures/mml_church/mml_church_window2.tga
	q3map_surfaceLight 400

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window2.blend.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
}

// Modified window to give out light
textures/mml_church/mml_church_window3_lit
{
	qer_editorimage textures/mml_church/mml_church_window3.tga
	q3map_surfaceLight 400

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window3.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_window3.blend.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
}

// Modified fence shader - can now be shot through
textures/mml_church/mml_church_grill
{
	// RTCW properties
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm nomarks
	surfaceparm playerclip
	surfaceparm trans
	surfaceparm clipmissile
	nomipmaps
	nopicmip
	cull disable

	// Texture layer properties
	{
		map textures/mml_church/mml_church_grill.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}

// Modified nodrawnonsolid - is now set to cull back
textures/mml_church/mml_church_nodrawnonsolid
{
	// Radiant properties
	qer_editorimage textures/common/nodrawnonsolid.tga
	qer_trans 0.3

	// RTCW properties
	surfaceparm nodraw
	surfaceparm nonsolid
	cull back
}

// Modified clipfull - is now set to cull disable
textures/mml_church/mml_church_clipfull
{
	// Radiant properties
	qer_editorimage textures/common/clipfull.tga
	qer_trans 0.3

	// RTCW properties
	surfaceparm nodraw
	surfaceparm playerclip
	cull disable
}

//////////////////////////////////////////////////////////////////////////
// Modified official shaders for vertex lighting

// Modified wood_m06
textures/mml_church/mml_church_wood_m06
{
	// RTCW properties
	surfaceparm woodsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_wood_m06.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified floor_c10
textures/mml_church/mml_church_floor_c10
{
	// RTCW properties
	surfaceparm carpetsteps

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_floor_c10.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified wood_m02
textures/mml_church/mml_church_wood_m02
{
	// RTCW properties
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_wood_m02.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified chwood_c04
textures/mml_church/mml_church_chwood_c04
{
	// RTCW properties
	surfaceparm woodsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_chwood_c04.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified carpet_c11
textures/mml_church/mml_church_carpet_c11
{
	// RTCW properties
	surfaceparm carpetsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_carpet_c11.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified wood_m05
textures/mml_church/mml_church_wood_m05
{
	// RTCW properties
	surfaceparm woodsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_wood_m05.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified wood_m06b
textures/mml_church/mml_church_wood_m06b
{
	// RTCW properties
	surfaceparm woodsteps

	// Texture layer properties
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_wood_m06b.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified cwood_mo2s1
textures/mml_church/mml_church_wood_top
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_wood_top.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified book_c03
textures/mml_church/mml_church_books
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_books.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified door_m01
textures/mml_church/mml_church_door
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_door.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
// Modified grass_dm01
textures/mml_church/mml_church_grass
{
	surfaceparm grasssteps
	surfaceparm landmine

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 20
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_grass.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified board_cl01
textures/mml_church/mml_church_board
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_board.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified metal_mo2
textures/mml_church/mml_church_metal_1
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_metal_1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified metal_c02
textures/mml_church/mml_church_metal_2
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_metal_2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Modified barrel_m01
textures/mml_church/mml_church_barrel
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_barrel.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// textures/props/box_m01
textures/mml_church/mml_church_box_1
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_box_1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//textures/props/box_m02
textures/mml_church/mml_church_box_2
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_box_2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//textures/props/box_m03
textures/mml_church/mml_church_box_3
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_box_3.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


//textures/props/box_m04a
textures/mml_church/mml_church_box_4
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_box_4.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


//textures/props/box_m05a
textures/mml_church/mml_church_box_5
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_box_5.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// textures/metal_misc/ametal_m03a
textures/mml_church/mml_church_metal_3
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_metal_3.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// textures/metal_misc/ametal_m04a
textures/mml_church/mml_church_metal_4
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_metal_4.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// textures/doors/door_c13
textures/mml_church/mml_church_door_2
{
	surfaceparm woodsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mml_church/mml_church_door_2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
