// Market Garden .shader file
// 

textures/mp_btmap/river_m01
{
	nocompress
	qer_editorimage textures/liquids/ocean_m1b.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
	nofog
	waterfogvars ( 0.1 0.1 0.1 ) 300

	{
		fog on
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity		
	}
	{ 
		fog on
		map textures/liquids/lake_m1.tga
		rgbgen identity
		tcmod scale .4 .3
		tcmod scroll .0075 -.0025
		tcmod stretch sin 1 .005 0 .06
	}
	{ 
		fog on    // added fog layer, not sure why it was disabled/missing - Wils
		map textures/mp_btmap/river_m2_darker.tga    // less obvious moss thing - Wils
		blendFunc GL_dst_color GL_one
		rgbgen identity		
		tcmod scale -.12 .2
	}
}

textures/terrain/wilsterrainfux0r
{
	qer_editorimage textures/common/terrain.tga
	surfaceparm pointlight
//	surfaceparm nolightmap
	q3map_novertexshadows
//	q3map_vertexshadows
	q3map_forcesunlight
	q3map_vertexscale 0.5	
	{
		map textures/terrain/grass_ml03cmp.tga
		rgbGen vertex
//		tcmod scale 0.125 0.125 - commented out for now; need to create a proper terrain entity
	}
}

//textures/skies/wils_skybox
//{
//	qer_editorimage textures/mp_btmap/env/sky_dn.tga	// added 19/12/01
//	qer_editorimage textures/skies/topclouds.tga
//	surfaceparm noimpact
//	surfaceparm nolightmap
//	surfaceparm sky
//	surfaceparm nodlight	// added so dlights don't affect surface
//	q3map_globaltexture
//	q3map_lightsubdivide 1024	// added 19/12/01
//	q3map_lightsubdivide 512 
//	q3map_sun red green blue intensity degrees elevation
//	q3map_sun 0.8 0.8 0.6 100 315 33	// added 19/12/01
//	q3map_sun	1.0 1.0 0.9 65 160 24
//	q3map_surfacelight 100	// added 19/12/01
//	q3map_surfacelight 60
//	this is based on skies/tram_skybox with lighter fog. Hopefully :)
//	fogvars ( .13 .13 .14 ) .001 - old values
//	fogvars ( .13 .13 .14 ) .0001
//	skyfogvars ( .23 .23 .24 ) .0001
//	skyparms textures/mp_btmap/env/sky - -	// added 19/12/01
//	skyparms full 200 -
//
//	don't need any of this atm:	
//	{
//		map textures/skies/dimclouds.tga
//		tcMod scroll 0.002 0.002
//		tcMod scale 1 1
//		depthWrite
//	}
//	{
//		map textures/skies/dimclouds.tga
//		blendfunc GL_ONE GL_ONE
//		tcMod scroll -0.001 -0.005
//		tcMod scale 10 10
//	}
//}

textures/skies/wils_skybox
{
	//qer_editorimage textures/mp_btmap/env/sky_dn.tga
	qer_editorimage textures/skies/sky_4.tga
	q3map_lightimage textures/skies/n_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	surfaceparm nodlight
	q3map_globaltexture
	//q3map_sun 0.8 0.8 0.6 100 315 33 not used
	q3map_lightsubdivide 2048
	q3map_sun 1.0 0.8 0.6 100 315 56
	//q3map_sun 1.0 0.8 0.6 130 220 50
	q3map_surfacelight 100
	//skyparms textures/mp_btmap/env/sky - -
	skyparms full 200 -
	fogvars ( .13 .13 .14 ) .0001
	skyfogvars ( .23 .23 .24 ) .0001
	q3map_backsplash -1 -1
}



models/mapobjects/mp_btmap/barb_wire
{
    surfaceparm metalsteps
    nomipmaps
    nopicmip
    cull disable
    {
        map models/mapobjects/mp_btmap/barb_wire.tga
        alphaFunc GE128
	//blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        depthWrite
        rgbGen vertex
    }
}





textures/mp_btmap/chateau_c08
{
	qer_editorimage textures/alpha/chateau_c08.tga
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm noimpact
    	surfaceparm nomarks
    	surfaceparm nonsolid
    	surfaceparm playerclip
	nomipmaps
	nopicmip
	cull disable
	{
        	map textures/alpha/chateau_c08.tga
		alphaFunc GE128
        	depthWrite
        	rgbGen vertex
	}
}

textures/mp_btmap/EEgg_poster
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/EEgg_poster.tga
		alphaFunc GE128
      		depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/seamine
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/seamine.tga
//		alphaFunc GE128
		blendfunc blend
      		depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster01
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster01.tga
		alphaFunc GE128
      		depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster02
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster02.tga
		alphaFunc GE128
      		depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster03
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster03.tga
		alphaFunc GE128
      	depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster04
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster04.tga
		alphaFunc GE128
      	depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster05
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster05.tga
		alphaFunc GE128
      	depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/brand_poster06
{
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/mp_btmap/brand_poster06.tga
		alphaFunc GE128
      	depthWrite
		rgbGen vertex
	}
}

// **********************************************
// Terrain Shaders for terrain around bridge area
// **********************************************

textures/mp_btmap/riverterrain_0
{
	surfaceparm gravelsteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		tcmod scale 0.1250000000 0.1250000000
	}
}

textures/mp_btmap/riverterrain_1
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		tcmod scale 0.1250000000 0.1250000000
	}
}

textures/mp_btmap/riverterrain_2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		tcmod scale 0.2500000000 0.2500000000
	}
}

textures/mp_btmap/riverterrain_0to1
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.1250000000 0.1250000000
	}
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/riverterrain_0to2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.1250000000 0.1250000000
	}
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/riverterrain_1to2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.1250000000 0.1250000000
	}
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

// *********************************

//
// RR2DO2
//
// Terrain Shaders for terrain around mansion
//
textures/mp_btmap/mansionterrain_0
{
	surfaceparm gravelsteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		tcmod scale 0.250000000 0.250000000
	}
}

textures/mp_btmap/mansionterrain_1
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		tcmod scale 0.250000000 0.250000000
	}
}

textures/mp_btmap/mansionterrain_2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		tcmod scale 0.500000000 0.500000000
	}
}

textures/mp_btmap/mansionterrain_3
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock1b.tga
		rgbGen vertex
		tcmod scale 0.500000000 0.500000000
	}
}

textures/mp_btmap/mansionterrain_4
{
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/town_floor/floor_d01.tga
		rgbGen vertex
		tcmod scale 0.500000000 0.500000000
	}
}

textures/mp_btmap/mansionterrain_0to1
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_0to2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_0to3
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/stone/mxrock1b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_0to4
{
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock4c.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/town_floor/floor_d01.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_1to2
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_1to3
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/stone/mxrock1b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_1to4
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.250000000 0.250000000
	}
	{
		map textures/town_floor/floor_d01.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_2to3
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
	}
	{
		map textures/stone/mxrock1b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_2to4
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
	}
	{
		map textures/town_floor/floor_d01.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/mp_btmap/mansionterrain_3to4
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock2b.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
	}
	{
		map textures/town_floor/floor_d01.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500000000 0.500000000
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/vxmp_btmap/mansionterrain
{
	surfaceparm grasssteps
	surfaceparm nolightmap
	surfaceparm landmine
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/stone/mxrock0b.tga
		rgbGen vertex
		tcmod scale 0.250000000 0.250000000
	}
}

// Hedge textures
textures/mp_btmap/hedge
{
	surfaceparm alphashadow
	surfaceparm grasssteps
	nomipmaps
	nopicmip
	cull none
	{
		map textures/mp_btmap/hedge.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}

textures/mp_btmap/hedge_end
{
	surfaceparm alphashadow
	surfaceparm grasssteps
	nomipmaps
	nopicmip
	cull none
	{
		map textures/mp_btmap/hedge_end.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}

// nature textures
textures/mp_btmap/sand
{
	qer_editorimage textures/stone/mxrock4c.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock4c.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/mp_btmap/grass
{
	qer_editorimage textures/stone/mxrock0b.tga
	surfaceparm grasssteps
	surfaceparm landmine
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock0b.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// sfx
textures/mp_btmap/blackness
{	
	surfaceparm nolightmap
	surfaceparm noimpact
	surfaceparm nomarks
	{
		map textures/mp_btmap/blackness.tga
	}
}

// models
models/mapobjects/mp_btmap/lightarea
{
	surfaceparm nomarks
	q3map_lightimage models/mapobjects/mp_btmap/lightarea.tga
	q3map_surfacelight 20000
	
	{
		map models/mapobjects/mp_btmap/lightarea.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen vertex
	}
	{
		map models/mapobjects/mp_btmap/lightarea.tga
		blendfunc GL_ONE GL_ONE
	}
}