////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///                                                                                                                          ///
///  Fichier Shader pour toutes les skyboxs par Necrom@ncer                                                                  ///
///                                                                                                                          ///
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
// color will be normalized, so it doesn't matter what range you use
// intensity falls off with angle but not distance 100 is a fairly bright sun
// degree of 0 = from the east, 90 = north, etc.  altitude of 0 = sunrise/set, 90 = noon



textures/skies/algierssky
{
	qer_editorimage textures/skies/algierssky.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	//q3map_sun .5 .37 .19  30 70
	//q3map_sun .5 .37 .19 70 170 40
	q3map_sun .5 .5 .5 110 130 55
	//q3map_surfacelight 80
	q3map_surfacelight 170

        skyparms env/algiers/algierssky - -
	
}

textures/skies/almostparadise_skybox
{
	qer_editorimage textures/skies/almostparadise.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.00 1.00 0.90 100 110 30
	q3map_surfacelight 100
	skyparms env/almostparadise/almostparadise - -
}

textures/skies/austria_skybox
{
	qer_editorimage textures/skies/austria.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
    q3map_sunExt 238 232 185 300 130 55 3 16
	q3map_skylight 300 3
    q3map_backsplash 0 0

    skyparms env/austria/austriasky - -
	
}

textures/skies/bleached_skybox
{
	qer_editorimage textures/skies/bleached.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.0 1.0 0.95 120 0 90
	q3map_surfacelight 50
	skyparms env/bleached/bleached - -
}

textures/skies/box15
{
	qer_editorimage textures/skies/box15.jpg
	q3map_backsplash 0 0
	q3map_sun .9 .72 .44 450 180 70
	q3map_surfacelight 350
	q3map_lightmapfilterradius 0 64
	q3map_skylight 300 9
	surfaceparm sky
	surfaceparm nolightmap
	surfaceparm noimpact



skyparms env/box15/box15 - -
}

textures/skies/box293
{
qer_editorimage textures/skies/box293.jpg 
q3map_sun .80 .78 .75 450 270 70   //old 70 180 37 4 128 // 450 270 70 4 64 mobb0 .81 .78 .70 140 270 70 mobb2
//q3map_lightmapfilterradius 0 16
//q3map_skylight 70 4 // 400 mobb0
//q3map_lightsubdivide 256
q3map_surfacelight 350 // 350 mobb0 100 mobb2
//q3map_backsplash 0 0
//q3map_backsplash 0 256
//q3map_globaltexture
surfaceparm sky
surfaceparm nolightmap
surfaceparm noimpact
//surfaceparm nomarks
nopicmip
nomipmaps



skyparms env/box293/box293 - -

{
		map textures/sky/clouds.tga
       	blendfunc  GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 3 3
		tcMod scroll 0.005 0.007	
	}
 
}

textures/skies/darkgloom_skybox
{
	qer_editorimage textures/skies/darkgloom.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 0.934 0.835 1.00 75 300 25
	q3map_surfacelight 50
	skyparms env/darkgloom/darkgloom - -
	{
		map textures/skies/clouds.jpg
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies/desert_skybox
{
	qer_editorimage textures/skies/desert.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 75
	surfaceparm sky
	q3map_sun 1.00 0.949 0.977 100 200 45
	skyparms env/desert/desert - -
}

textures/skies/desertsky_skybox
{
	qer_editorimage textures/skies/desertsky.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 0.934 0.835 1.00 75 230 35
	q3map_surfacelight 50
	skyparms env/desertsky/desertsky - -
//	{
//		map textures/skies/clouds.jpg
//		blendFunc filter
//		tcMod scroll 0.005 0.005
//		tcMod scale 3 3
//	}
}


textures/skies/frozen_skybox
{
	qer_editorimage textures/skies/frozen.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 100
	surfaceparm sky
	q3map_sun 227 237 254 100 35 50
	skyparms env/frozen/frozen - -
}

textures/skies/frozendusk_skybox
{
	qer_editorimage textures/skies/frozendusk.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.894 0.933 1.00 200 250 15
	skyparms env/frozendusk/frozendusk - -
}

textures/skies/graveyard_skybox
{
	qer_editorimage textures/skies/graveyard.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 35
	surfaceparm sky
	q3map_sun 0.934 0.956 1.00 75 0 50
	skyparms env/graveyard/graveyard - -
}

textures/skies/iceflow_skybox
{
	qer_editorimage textures/skies/iceflow.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.884 0.940 1.000 100 300 42
	skyparms env/iceflow/iceflow - -
}

textures/skies/majesty_skybox
{
	qer_editorimage textures/skies/majesty.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_surfacelight 50
	q3map_sun 1 0.9 1 100 90 35
	skyParms env/majesty/majesty - -
}

textures/skies/mars_skybox
{
	qer_editorimage textures/skies/mars.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 75
	surfaceparm sky
	q3map_sun 4 3 3 150 135 50
	skyparms env/mars/mars - -
}

textures/skies/miramar
{
	qer_editorimage textures/skies/miramar.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 110
        q3map_sun 1 1 1 150 290 60
	skyparms env/miramar/miramar - -
//	{
//		map textures/sky/sky_clouds.jpg
//		blendFunc filter
//		tcMod scroll 0.005 0.005
//		tcMod scale 3 3
//	}
}

textures/skies/morose_skybox
{
	qer_editorimage textures/skies/morose.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.3 0.4 0.65 60 85 80
	skyparms env/morose/morose - -
}

textures/skies/oasisday_skybox
{
	qer_editorimage textures/skies/oasisday
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_surfacelight 50
	q3map_sun 1.0 0.95 0.8 90 0 33
	skyParms env/oasisday/oasisday - -
}

textures/skies/orangecream_skybox
{
	qer_editorimage textures/skies/orangecream.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.00 0.90 0.80 110 180 35
	q3map_surfacelight 50
	skyparms env/orangecream/orangecream - -
}

textures/skies/powderpeak_skybox
{
	qer_editorimage textures/skies/powderpeak.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 0.934 0.835 1.00 90 0 25
	q3map_surfacelight 50
	skyparms env/powderpeak/powderpeak - -
}

textures/skies/rockyvalley_skybox
{
	qer_editorimage textures/skies/rockyvalley.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.00 1.00 0.965 75 90 30
	q3map_surfacelight 50
	skyparms env/rockyvalley/rockyvalley - -
	{
		map textures/skies/clouds.jpg
		blendFunc filter
		tcMod scroll 0.010 0.005
		tcMod scale 2 2
	}
}

textures/skies/shadowpeak_skybox
{
	qer_editorimage textures/skies/shadowpeak.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.00 1.00 1.00 100 270 35
	q3map_surfacelight 80
	skyparms env/shadowpeak/shadowpeak - -
}

textures/skies/siege_skybox
{
	qer_editorimage textures/skies/siege.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1.00 1.00 0.965 75 90 30
	q3map_surfacelight 50
	skyparms env/amethyst7/siege/siege - -
	{
		map textures/skies/clouds.jpg
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

textures/skies/arrakisday
{
	qer_editorimage textures/skies/arrakisday.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 100
	q3map_sun 1 1 1 140 170 50
	skyparms env/arrakisday/arrakisday - -
}


textures/skies/brightblue
{
	qer_editorimage textures/skies/brightblue.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 150
	q3map_sun 1 1 1 150 -11 77
	skyparms env/brightblue/brightblue - -
}


textures/skies/dragonfire
{
	qer_editorimage textures/skies/dragonfire.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 166
	q3map_sun 1 0.8 0.7 99 334 27
	skyparms env/dragonfire/dragonfire - -
}

textures/skies/dragonheart
{
	qer_editorimage textures/skies/dragonheart.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 0.9 0.8 66 290 35
	skyparms env/dragonheart/dragonheart - -
}

textures/skies/dragonmoon
{
	qer_editorimage textures/skies/dragonmoon.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_surfacelight 188
	q3map_lightsubdivide 512
	q3map_sun	1 1 1 88 0 90
	skyparms env/dragonmoon/dragonmoon - -

}

textures/skies/dragonmoon-clouds
{
	qer_editorimage textures/skies/dragonmoon-clouds.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_surfacelight 288
	q3map_lightsubdivide 512
	q3map_sun	1 1 1 11 0 90
	skyparms env/dragonmoon/dragonmoon - -
	{
		map textures/skies/dragonclouds.jpg
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.02
	}
}

textures/skies/dragonvale
{
	qer_editorimage textures/skies/dragonvale.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 120
	q3map_sun 1 0.9 0.7 60 290 35
	skyparms env/dragonvale/dragonvale - -
}

textures/skies/dunes
{
	qer_editorimage textures/skies/dunes.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 77
	q3map_sun 1 1 1 111 100 40
	skyparms env/dunes/dunes - -
}

textures/skies/duske
{
	qer_editorimage textures/skies/duske.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 133
	q3map_sun 1 0.8 0.6 99 0 16
	skyparms env/duske/duske - -
}

textures/skies/dust
{
	qer_editorimage textures/skies/dust.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 122 260 50
	skyparms env/dust/dust - -
}

textures/skies/eaglesdare
{
	qer_editorimage textures/skies/eaglesdare.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 88
	q3map_sun 1 1 1 111 72.3 25
	skyparms env/eaglesdare/eaglesdare - -
}

textures/skies/heather
{
	qer_editorimage textures/skies/heather.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 77
	q3map_sun 1 1 1 88 145 30
	skyparms env/heather/heather - -
}

textures/skies/highlandspring
{
	qer_editorimage textures/skies/highlandspring.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 133
	q3map_sun 1 1 1 99 65 32
	skyparms env/highlandspring/highlandspring - -
}

textures/skies/horus
{
	qer_editorimage textures/skies/horus.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 100
	q3map_sun 1 1 1 100 200 55
	skyparms env/horus/horus - -
}

textures/skies/kradegar
{
	qer_editorimage textures/skies/kradegar.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 100
	q3map_sun 1 1 1 100 10 45
	skyparms env/kradegar/kradegar - -
}

textures/skies/luna
{
	qer_editorimage textures/skies/luna.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 33
	q3map_sun 1 1 1 122 275 80
	skyparms env/luna/luna - -
}

textures/skies/med-siesta
{
	qer_editorimage textures/skies/med-siesta.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 100 45 55
	skyparms env/med-siesta/med-siesta - -
}

textures/skies/med-tramonto
{
	qer_editorimage textures/skies/med-tramonto.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 77 252 11
	skyparms env/med-tramonto/med-tramonto - -
}

textures/skies/med-troubadour
{
	qer_editorimage textures/skies/med-troubadour.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 155
	q3map_sun 1 1 1 90 115 48
	skyparms env/med-troubadour/med-troubadour - -
}

textures/skies/mensae
{
	qer_editorimage textures/skies/mensae.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 88
	q3map_sun 1 0.9 0.7 66 81 25
	skyparms env/mensae/mensae - -
}

textures/skies/ofelas
{
	qer_editorimage textures/skies/ofelas.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 88
	q3map_sun 1 1 1 11 0 90
	skyparms env/ofelas/ofelas - -
}

textures/skies/ozymandias
{
	qer_editorimage textures/skies/ozymandias.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 88
	q3map_sun 1 0.9 0.5 88 56 12
	skyparms env/ozymandias/ozymandias - -
}

textures/skies/rlyeh
{
	qer_editorimage textures/skies/rlyeh.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 90
	q3map_sun 1 1 1 66 127 62
	skyparms env/rlyeh/rlyeh - -
}

textures/skies/saltflats
{
	qer_editorimage textures/skies/saltflats.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 111 57 41
	skyparms env/saltflats/saltflats - -
}

textures/skies/scapulaflow
{
	qer_editorimage textures/skies/scapulaflow.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 120
	q3map_sun 1 1 1 100 305 40
	skyparms env/scapulaflow/scapulaflow - -
}

textures/skies/seraphim
{
	qer_editorimage textures/skies/seraphim.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 122
	q3map_sun 0.9 0.9 1 144 267 18
	skyparms env/seraphim/seraphim - -
}

textures/skies/snowmoon
{
	qer_editorimage textures/skies/snowmoon.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 144
	q3map_sun 1 1 1 44 64 22
	skyparms env/snowmoon/snowmoon - -
}

textures/skies/starfrost
{
	qer_editorimage textures/skies/starfrost.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 33
	q3map_sun 1 1 1 88 283 35
	skyparms env/starfrost/starfrost - -
}

textures/skies/verdanis-cool
{
	qer_editorimage textures/skies/verdanis-cool.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 144 267 18
	skyparms env/verdanis-cool/verdanis-cool - -
}

textures/skies/verdanis-warm
{
	qer_editorimage textures/skies/verdanis-warm.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 111
	q3map_sun 1 1 1 144 267 18
	skyparms env/verdanis-warm/verdanis-warm - -
}

textures/skies/wakeworld
{
	qer_editorimage textures/skies/wakeworld.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 80
	q3map_sun 1 1 1 70 190 45
	skyparms env/wakeworld/wakeworld - -
}

textures/skies/whitecrispness
{
	qer_editorimage textures/skies/whitecrispness.jpg
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 177
	q3map_sun 1 1 1 100 8 30
	skyparms env/whitecrispness/whitecrispness - -
}

textures/skies/snowy_skybox
{
	qer_editorimage textures/skies/snowy.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_surfacelight 50
	q3map_sun 0.9 0.95 1 75 90 25
	skyParms env/snowy/snowy - -
}

textures/skies/strat_skybox
{
	qer_editorimage textures/skies/stratosphere.jpg
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.941 0.984 1.00 150 270 45
	skyparms env/stratosphere/stratosphere - -
}

