// Shader for the custom map "loffys_tram1".
// Game: Enemy Territory.
// By Loffy (http://www.loffy.tk), October 2004.
// Sky textures and sky-shader by Sock.


textures/loffys_tram1_tex/emile_claus_loftram
{
	qer_editorimage textures/loffys_tram1_tex/emile_claus_loftram.jpg
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/gogh_loftram
{
	qer_editorimage textures/loffys_tram1_tex/gogh_loftram.jpg
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/gogh2_loftram
{
	qer_editorimage textures/loffys_tram1_tex/gogh2_loftram.jpg
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/kahlo_loftram
{
	qer_editorimage textures/loffys_tram1_tex/kahlo_loftram.jpg
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}


textures/loffys_tram1_tex/dali_loftram
{
	qer_editorimage textures/loffys_tram1_tex/dali_loftram.jpg
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}



textures/loffys_tram1_tex/loffytram_canvas
{
	qer_editorimage textures/egypt_props_sd/siwa_canvas1.tga
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	nopicmip
	nomipmaps
	deformVertexes wave 8 sin 0 1 0 0.5
	tessSize 8
	implicitMap textures/egypt_props_sd/siwa_canvas1.tga
}

textures/loffys_tram1_tex/red_blink
{
	qer_editorimage textures/sfx/construction.tga
	cull none
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
        map textures/sfx/construction.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.5 0 0.5
		tcgen environment
	}
	{
		map $whiteimage
		blendfunc filter
		rgbGen const ( 1.0 0.6 0.6 )
	}
}

// ----- START terrain shaders. Note: These shaders are based on Sock's and ydnar's ideas and work -------------

textures/loffys_tram1_tex/nodot_pri_snowbig_sec_sd_rock_w_alpha // for projection y * Normal snow and rock texture blending, no dotproduct2.
 {
 	qer_editorimage textures/loffys_tram1_tex/sd_rock_editor.jpg
 	q3map_nonplanar
 	q3map_shadeAngle 45 // Originally 120
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 ) //  256, 512 or 1024. for projection y
 	{
		map 	textures/snow_sd/snow_var01_big.tga // Primary
 		rgbGen identity
 	}
 	{
		map textures/loffys_tram1_tex/sd_rock_w_alpha.tga // Secondary
 		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
 		alphaFunc GE128
 		rgbGen identity
 		alphaGen vertex
 	}
 	{
 		map $lightmap
 		blendFunc GL_DST_COLOR GL_ZERO
 		rgbGen identity
 	}
 }



textures/loffys_tram1_tex/sd_bigsnow_vertical2_loffytram1		 // big snow, for vertical projection y
{
	q3map_nonplanar
	q3map_shadeangle 45
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 ) //  256, 512 or 1024.
	nopicmip
	nomipmaps
	qer_editorimage textures/sfx/construction.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga   // big snow
		blendFunc filter
	}
}

textures/loffys_tram1_tex/sd_bigsnow_vertical_loffytram1		 // big snow, for vertical projection x
{
	q3map_nonplanar
	q3map_shadeangle 45
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 ) //  256, 512 or 1024.
	nopicmip
	nomipmaps
	qer_editorimage textures/loffys_tram1_tex/snowbig_nodot_vertical_q3map2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga   // big snow
		blendFunc filter
	}
}

textures/loffys_tram1_tex/sd_bigsnow_loffytram1		 // big snow z
{
	q3map_nonplanar
	q3map_shadeangle 45
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 ) //  256, 512 or 1024.
	nopicmip
	nomipmaps
	qer_editorimage textures/snow_sd/snow_var01_big.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/snow_var01_big.tga   // big snow
		blendFunc filter
	}
}

textures/loffys_tram1_tex/sd_snownoisy_loftram_phong
{
	q3map_nonplanar
	q3map_shadeangle 45
	nopicmip
	nomipmaps
	qer_editorimage textures/loffys_tram1_tex/sd_snow_noisy_loftram.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/loffys_tram1_tex/sd_snow_noisy_loftram.tga
		blendFunc filter
	}
}

textures/loffys_tram1_tex/loffys_tram_minable_snow
{
	qer_editorimage textures/snow_sd/icelake2.tga
	surfaceparm landmine
	surfaceparm slick
	nopicmip
	nomipmaps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/concretec05_snow.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_gold.tga
		blendFunc GL_ONE GL_ONE
		tcGen environment
	}
}

textures/loffys_tram1_tex/nodot_pri_snowbig_sec_mxsnow // * Normal texture blending, no dotproduct2.
 {
 	qer_editorimage textures/loffys_tram1_tex/snowbig_nodot_q3map2.tga
 	q3map_nonplanar
 	q3map_shadeAngle 45 // Originally 120

 	{
		map 	textures/snow_sd/snow_var01_big.tga // Primary
		tcMod scale 0.0625 0.0625
 		rgbGen identity
 	}
 	{
		map textures/loffys_tram1_tex/sd_mxrock4b_snow_loftram.tga // Secondary
		tcMod scale 0.0625 0.0625
 		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
 		alphaFunc GE128
 		rgbGen identity
 		alphaGen vertex
 	}
 	{
 		map $lightmap
 		blendFunc GL_DST_COLOR GL_ZERO
 		rgbGen identity
 	}
 }

textures/loffys_tram1_tex/dotprod_pri_snowbig_sec_mxsnow  // Main snow tex. Used on some ground snow brushes.
{
	qer_editorimage textures/loffys_tram1_tex/snowbig_dot2_q3map2.tga
	q3map_nonplanar
	q3map_shadeangle 45 // Originally 120
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 ) //  256, 512 or 1024.
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )

	{
		map 	textures/snow_sd/snow_var01_big.tga  // Primary, used to be ter_moss1.tga
		//tcMod scale 0.125 0.125
		rgbGen identity
	}
	{
		map textures/loffys_tram1_tex/sd_mxrock4b_snow_loftram.tga  // Secondary, used to be ter_mud1.tga
		//tcMod scale 0.125 0.125
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/loffys_tram1_tex/alpha_000_loffy	// Primary texture ONLY
{
 	qer_editorimage textures/loffys_tram1_tex/alpha_000
 	q3map_alphaMod volume
 	q3map_alphaMod set 0
 	surfaceparm nodraw
 	surfaceparm nonsolid
 	surfaceparm trans
 	qer_trans 0.75
 }

textures/loffys_tram1_tex/alpha_025_loffy
 {
 	qer_editorimage textures/loffys_tram1_tex/alpha_025
 	q3map_alphaMod volume
 	q3map_alphaMod set 0.25
 	surfaceparm nodraw
 	surfaceparm nonsolid
 	surfaceparm trans
 	qer_trans 0.75
 }

textures/loffys_tram1_tex/alpha_050_loffy	// Perfect mix of both Primary + Secondary
{
 	qer_editorimage textures/loffys_tram1_tex/alpha_050
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/loffys_tram1_tex/alpha_075_loffy
 {
 	qer_editorimage textures/loffys_tram1_tex/alpha_075
 	q3map_alphaMod volume
 	q3map_alphaMod set 0.75
 	surfaceparm nodraw
 	surfaceparm nonsolid
 	surfaceparm trans
 	qer_trans 0.75
 }



textures/loffys_tram1_tex/alpha_100_loffy	 // Secondary texture ONLY
 {
 	qer_editorimage textures/loffys_tram1_tex/alpha_100
 	q3map_alphaMod volume
 	q3map_alphaMod set 1.0
 	surfaceparm nodraw
 	surfaceparm nonsolid
 	surfaceparm trans
 	qer_trans 0.75
 }


// ------------------------- END terrain shaders -------------------------

textures/loffys_tram1_tex/axis_sign
{
	qer_editorimage textures/loffys_tram1_tex/sd_axissign_loftram.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/loffys_tram1_tex/sd_axissign_loftram.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_gold.tga
		blendFunc GL_ONE GL_ONE
		tcGen environment
	}
}

textures/loffys_tram1_tex/allied_sign
{
	qer_editorimage textures/loffys_tram1_tex/sd_alliedsign_loftram.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/loffys_tram1_tex/sd_alliedsign_loftram.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map  textures/effects/envmap_gold.tga
		blendFunc GL_ONE GL_ONE
		tcGen environment
	}
}


textures/loffys_tram1_tex/spectator_limbo
{
	qer_editorimage textures/loffys_tram1_tex/sd_specsign_loftram.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	{
		map textures/loffys_tram1_tex/sd_specsign_loftram.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map  textures/effects/envmap_gold.tga
		blendFunc GL_ONE GL_ONE
		tcGen environment
	}
}

textures/loffys_tram1_tex/masters_of_doom
{
	qer_editorimage textures/loffys_tram1_tex/masters_of_doom.jpg
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

models/mapobjects/gr_trees/nadelsnowr
{
	surfaceparm alphashadow
	surfaceparm trans
	cull none
	nopicmip
	{
	map models/mapobjects/gr_trees/nadelsnowr.tga
	alphaFunc GE128
	depthWrite
	rgbGen vertex
	}
}

models/mapobjects/gr_trees/nadelsnowb
{
	surfaceparm alphashadow
	surfaceparm trans
	cull none
	nopicmip
	{
	map models/mapobjects/gr_trees/nadelsnowb.tga
	alphaFunc GE128
	depthWrite
	rgbGen vertex
	}
}

models/mapobjects/gr_trees/nadelsnowg
{
	surfaceparm alphashadow
	surfaceparm trans
	cull none
	nopicmip
	{
	map models/mapobjects/gr_trees/nadelsnowg.tga
	alphaFunc GE128
	depthWrite
	rgbGen vertex
	}
}

models/mapobjects/gr_trees/kerzeblau
{
	surfaceparm alphashadow
	surfaceparm trans
	cull none
	nopicmip
	{
	map models/mapobjects/gr_trees/kerzeblau.tga
	alphaFunc GE128
	depthWrite
	rgbGen vertex
	}
}

models/mapobjects/gr_trees/kerzerot
{
	surfaceparm alphashadow
	surfaceparm trans
	cull none
	nopicmip
	{
	map models/mapobjects/gr_trees/kerzerot.tga
	alphaFunc GE128
	depthWrite
	rgbGen vertex
	}
}

textures/loffys_tram1_tex/loffys_tram_respect1
{
	qer_editorimage textures/loffys_tram1_tex/loffys_tram_respect1.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/loffys_tram_respect2
{
	qer_editorimage textures/loffys_tram1_tex/loffys_tram_respect2.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/loffys_tram_manufactored_by
{
	qer_editorimage textures/loffys_tram1_tex/loffys_tram_manufactored_by.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/loffys_tram_door1
{
	qer_editorimage textures/loffys_tram1_tex/loffys_tram_door1.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}


textures/loffys_tram1_tex/loffys_tram_door2
{
	qer_editorimage textures/loffys_tram1_tex/loffys_tram_door2.tga
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/sd_bigrock_loffytram1		 // big rock
{
	q3map_nonplanar
	q3map_shadeangle 179
	nopicmip
	nomipmaps
	qer_editorimage textures/snow_sd/bigrock_rounded_faint.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/bigrock_rounded_faint.tga   // big rock
		blendFunc filter
	}
}

textures/loffys_tram1_tex/sd_blacksnow_loffytram1		 // black snow
{
	q3map_nonplanar
	q3map_shadeangle 179
	nopicmip
	nomipmaps
	qer_editorimage textures/snow/s_cathedrale_c24b.jpg
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow/s_cathedrale_c24b.jpg // dirty snow, coal
		blendFunc filter
	}
}

textures/loffys_tram1_tex/sd_dirtsnow_loffytram1		 // dirty snow, coal
{
	q3map_nonplanar
	q3map_shadeangle 179
	nopicmip
	nomipmaps
	qer_editorimage textures/snow_sd/s_dirt_m03i_2_big.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/snow_sd/s_dirt_m03i_2_big.tga // dirty snow, coal
		blendFunc filter
	}
}

textures/loffys_tram1_tex/banksign1
{
	qer_editorimage textures/loffys_tram1_tex/banksign1.jpg
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/loffys_tram1_tex/banksign2
{
	qer_editorimage textures/loffys_tram1_tex/banksign2.jpg
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}


textures/loffys_tram1_tex/tramrust
{
	qer_editorimage textures/loffys_tram1_tex/tramrust.jpg
	surfaceparm metalsteps
	nopicmip
	nomipmaps
	implicitMap -
}

//**********************************************************************
//
//	Frozendusk.shader for Q3Radiant
//	by Sock - 11th January 2001
//
//**********************************************************************

//textures/frozendusk/frozendusk_skybox
//{
//	qer_editorimage textures/frozendusk/frozendusk_view.jpg
//	surfaceparm noimpact
//	surfaceparm nolightmap
//	q3map_globaltexture
//	q3map_lightsubdivide 256
//	q3map_surfacelight 50
//	surfaceparm sky
//	nocompress
//    q3map_sun 1.00 0.9 0.56 100 270 25
//	q3map_skylight 60 5
	// original frozendusk: q3map_sun 0.894 0.933 1.00 200 250 15
	// q3map_sun [red] [green] [blue] [intensity] [degrees] ( 90 is north, 180 is west and 270 is south) [elevation]
//	skyparms env/frozendusk/frozendusk - -
//}

textures/loffys_tram1_tex/sd_batterysky_loffystram1
{
	nocompress
	qer_editorimage textures/skies/topclouds.tga
	q3map_lightrgb 0.8 0.9 1.0
    q3map_sun 1.00 0.9 0.56 100 270 25 // Originally: q3map_sun 1 .96 .87 140 140 8
	// q3map_sun [red] [green] [blue] [intensity] [degrees] ( 90 is north, 180 is west and 270 is south) [elevation]
	q3map_skylight 60 5 // Originally: q3map_skylight 60 3
	q3map_nofog
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

	skyparms textures/skies_sd/wurzburg_env/sky 512 -

	sunshader textures/skies_sd/batterysunfog


	{
		fog off
		map textures/skies_sd/battery_clouds.tga
		tcMod scale 2.5 2.5
		// tcMod scroll 0.0015 -0.003 turned off, for higher fps
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/battery_mask_ydnar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		// rgbGen identityLighting
		//rgbGen const ( 0.6 0.6 0.6 )
		rgbGen const ( 0.4 0.4 0.4 )
	}
}

// --------- Shader for levelshots (command map, compass) -----------
levelshots/loffys_tram1_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/loffys_tram1_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/loffys_tram1_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/loffys_tram1_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

// ------ End of shader for levelshots ---------------------------------

