//**************************************
//*******      brouillard      *********
//**************************************
textures/the_lac/fog_crypt
{
	qer_editorimage textures/sfx/fog_grey1.tga
	
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	
	fogparms ( 0.4 0.4 0.4 ) 10240
}
textures/the_lac/xwall_c07
{
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/xwall_c07.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
textures/the_lac/herbe2
{
	qer_trans 0.85
	qer_editorimage textures/the_lac/herbe2.tga
	cull disable
	sort 6
	nomipmaps
	nopicmip
	surfaceparm nomarks
//	surfaceparm alphashadow
//	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nonsolid

	implicitMask textures/the_lac/herbe2.tga
}
textures/the_lac/herbe3
{
	q3map_nonplanar
	q3map_shadeangle 90
	qer_trans 0.85
	qer_editorimage textures/the_lac/herbe3.tga
	cull disable
	sort 6
	nomipmaps
	nopicmip
	surfaceparm nomarks
//	surfaceparm alphashadow
//	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nonsolid

	implicitMask textures/the_lac/herbe3.tga
}
textures/the_lac/herbe4
{
	qer_trans 0.85
	qer_editorimage textures/the_lac/herbe4.tga
	cull disable
	sort 6
	nomipmaps
	nopicmip
	surfaceparm nomarks
//	surfaceparm alphashadow
//	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nonsolid
	implicitMap -
}
textures/the_lac/ground
{
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm landmine
	surfaceparm gravelsteps
	implicitMap -
}
//**************************************
//*******        common        *********
//**************************************
textures/the_lac/clip_carpet
{
	qer_trans 0.3
	surfaceparm clipmissile
	surfaceparm carpetsteps
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm playerclip
	surfaceparm trans
}
textures/the_lac/clip_glass
{
    qer_editorimage "textures/the_lac/clip_glass.tga"
    qer_trans 0.3
    surfaceparm nodraw
    surfaceparm nomarks
    surfaceparm trans
    surfaceparm glass
}
textures/the_lac/safe
{
	qer_editorimage textures/the_lac/qer_commonsafe.tga
	qer_trans 0.1
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm clipmissile
	surfaceparm clipshot
	surfaceparm noimpact
	surfaceparm nodamage
	//surfaceparm nosteps
	surfaceparm nodrop
	surfaceparm nodlight
	surfaceparm nomarks
	surfaceparm trans
}
textures/the_lac/safe3
{
	qer_editorimage textures/the_lac/qer_commonsafe.tga
	qer_trans 0.7
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm playerclip
	surfaceparm clipmissile
	surfaceparm noimpact
	surfaceparm nodamage
	surfaceparm nosteps
	surfaceparm nodlight
	surfaceparm nomarks
	surfaceparm trans
}
//****************************************************************
//***********************WATER SHADERS****************************
//****************************************************************

////////////////////ocean//////////////////////////////
//blue water
textures/the_lac/sp_deepWater
{
	qer_editorimage textures/the_lac/sp_deepWater.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	cull none
	nomipmaps
	nopicmip
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
//	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .02 0
	}
	{ 
		map textures/the_lac/sp_deepWater.tga
		blendFunc blend
		alphaGen vertex
		tcMod scroll .02 0
	}
}

//green water
textures/the_lac/sp_mediumWater
{
	qer_editorimage textures/the_lac/sp_mediumWater.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	cull none
	nomipmaps
	nopicmip
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
//	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .02 0
	}
}

//clear water with foam/waves
textures/the_lac/sp_shallowWater
{
	qer_editorimage textures/liquids_sd/seawall_foam.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		alphaGen oneMinusVertex
		rgbGen wave sin 0 0.7 0.5 0.09
		tcMod scale 3 1
		tcMod scroll .03 0
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		alphaGen oneMinusVertex
		tcMod scale 3 1
		rgbGen wave sin 0 0.3 0 0.09
		tcMod scroll .02 0
	}
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		alphaGen vertex
		tcMod scroll .02 0

	}
}

//clear dark blue water
textures/the_lac/siwa_water
{
	qer_editorimage textures/the_lac/siwa_water.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	cull none
	nomipmaps
	nopicmip
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/the_lac/siwa_water.tga
		blendFunc blend
		tcMod scroll .02 0
	}
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		alphaGen vertex
		tcMod scroll .02 0
	}
}

///////////////////////end ocean//////////////////
//**************************************************************

//water merging into horizon
textures/the_lac/SP_skyWaterMerge
{
	qer_editorimage textures/the_lac_editor/sp_ed_horizon.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans
	polygonoffset
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .02 0
	}
	{ 
      	map textures/the_lac/sp_deepWater.tga
		blendFunc blend
		tcMod scroll .02 0
	}
	{ 
		map $whiteimage
		rgbGen const ( 0.753 0.878 0.973 )
		blendFunc blend
		alphaGen vertex
	} 	
}

//used for the horizon merging part of the water when looking inside out. Same as deep water but has culling since SP_skyWaterMerge is transparent. VERY dumb. FIX
textures/the_lac/sp_underWaterMerge
{
	qer_editorimage textures/the_lac/sp_deepWater.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm splash
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/the_lac/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .01 0
	}
	{ 
		map textures/the_lac/sp_deepWater.tga
		blendFunc blend
		tcMod scroll .01 0
	}

}

textures/the_lac/sp_underWaterMerge1
{
	qer_editorimage textures/the_lac/sp_deepWater.tga
	deformVertexes move 0 0 2 sin 0 2 0.3 0.09
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
      	map textures/the_lac/sp_deepWater.tga
	}
	{ 
		map $whiteimage
		rgbGen const ( 0.753 0.878 0.973 )
		blendFunc blend
		alphaGen vertex
	}
}

textures/the_lac/SP_sandWaterMerge
{
	qer_editorimage textures/the_lac/sand_wave_bright.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapmergable
	{
		map textures/the_lac/sp_deepWater.tga
	}
	{ 
		map textures/the_lac/sand_wave_bright.tga
		rgbGen const ( 0.85 0.85 0.85 )
		blendFunc blend
		alphaGen vertex
	}
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 
}
						
textures/the_lac/rs_water
{
	qer_editorimage textures/the_lac/sp_deepWater.tga
      qer_trans .9
	deformVertexes wave 1817 sin 0 2.5 0 0.15
 	deformVertexes wave 517 sin 0 1.5 0 0.30
	nopicmip
	nocompress
	cull none
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 0.10 0 0.10
		tcmod scroll 0.51 0.08
	}
	{
		map textures/the_lac/sp_deepWater.tga 
		blendfunc blend
		tcMod scroll 0.41 0
		alphaGen Vertex
	}

}

//**************************************
//*******   ALTERNANCE IMAGE   *********
//**************************************
textures/the_lac/signature
{
	qer_editorimage textures/the_lac/signature.tga
	surfaceparm nomarks
	q3map_surfacelight 600
			
	{
		map textures/the_lac/signature.tga
		tcMod scroll 0 0.022
		rgbGen const ( 0.9 0.9 0.9 )
	}
}

textures/the_lac/flag_l_m01
{
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm pointlight
	cull disable
	deformVertexes wave 10 sin 0 6 0 0.2 
	implicitMask -
}

textures/the_lac/flags_m1
{
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm pointlight
	cull disable
	deformVertexes wave 10 sin 0 6 0 0.2 
	implicitMask -
}

textures/the_lac/radar_01
{
	qer_editorimage textures/the_lac/radar_01.tga
	surfaceparm metalsteps
	
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/radar_01.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/the_lac/radar_beep.jpg
		tcMod rotate -.1
		blendFunc GL_ONE GL_ONE
	}
	{
		map textures/the_lac/radar_sweep.jpg
		tcMod rotate 90
		blendFunc GL_ONE GL_ONE
	}
}
textures/the_lac/light_run_0
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0 0.7 
	}
}
textures/the_lac/light_run_1
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.1 0.7 
	}
}
textures/the_lac/light_run_2
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.2 0.7 
	}
}
textures/the_lac/light_run_3
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.3 0.7 
	}
}
textures/the_lac/light_run_4
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.4 0.7 
	}
}
textures/the_lac/light_run_5
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.5 0.7 
	}
}
textures/the_lac/light_run_6
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.6 0.7 
	}
}
textures/the_lac/light_run_7
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.7 0.7 
	}
}
textures/the_lac/light_run_8
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.8 0.7 
	}
}
textures/the_lac/light_run_9
{
	qer_editorimage textures/lights/light_m16.tga
	q3map_lightimage textures/lights/light_m16.blend.tga
	surfaceparm nomarks
	q3map_surfacelight 300
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/lights/light_m16.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/lights/light_m16.blend.tga
		blendfunc add
		rgbGen wave sin 0 1 0.9 0.7 
	}
}
textures/the_lac/screen_bleu2
{
	qer_editorimage textures/the_lac/screen_bleu2.tga
	q3map_lightimage textures/xlab_props/softblue.tga
	q3map_lightsubdivide 128
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/screen_bleu2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave sin 1 .1 0 7
	}
}
textures/the_lac/screen_bleu3
{
	qer_editorimage textures/the_lac/screen_bleu3.tga
	q3map_lightimage textures/xlab_props/softblue.tga
	q3map_lightsubdivide 128
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/screen_bleu3.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave sin 1 .1 0 7
	}
}
textures/the_lac/screen_bleu4
{
	qer_editorimage textures/the_lac/screen_bleu4.tga
	q3map_lightimage textures/xlab_props/softblue.tga
	q3map_lightsubdivide 128
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/screen_bleu4.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave sin 1 .1 0 7
	}
}
textures/the_lac/screen_bleu5
{
	qer_editorimage textures/the_lac/screen_bleu5.tga
	q3map_lightimage textures/xlab_props/softblue.tga
	q3map_lightsubdivide 128
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/screen_bleu5.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave sin 1 .1 0 7
	}
}
textures/the_lac/screen_bleu
{
	qer_editorimage textures/the_lac/screen_bleu.tga
	q3map_lightimage textures/xlab_props/softblue.tga
	q3map_lightsubdivide 128
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/the_lac/screen_bleu.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen wave sin 1 .6 0 7
	}
}
textures/the_lac/fan
{
	cull none
	nopicmip
	qer_editorimage textures/sfx/fan.tga
	surfaceparm nomarks
	surfaceparm trans
	{
		clampmap textures/sfx/fan.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		rgbGen identity
		tcMod rotate 125
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
		rgbGen identity
	}
}
textures/the_lac/exit
{
	q3map_surfacelight 200	
	cull none
	surfaceparm glass
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/the_lac/exit.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map textures/the_lac/exit.tga
		blendfunc add
		rgbGen wave sin 0 1 0.9 0.7 
	}
}

//**************************************
//*******     DECALS  IMAGE    *********
//**************************************
textures/the_lac/port_trees
{
	qer_editorimage textures/the_lac/port_trees.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm alphashadow
	nomipmaps
	nopicmip
	cull disable
	{
		map textures/the_lac/port_trees.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}

textures/the_lac/tree1_dark
{
	qer_editorimage textures/the_lac/tree1_dark.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm alphashadow
	nomipmaps
	nopicmip
	cull disable
	{
		map textures/the_lac/tree1_dark.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}

textures/the_lac/wires_4droop
{
	cull disable
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/the_lac/wires_coil
{
	cull disable
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/the_lac/wires_wave
{
	cull disable
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/the_lac/yamaha_sign
{
	qer_editorimage textures/the_lac/yamaha_sign.tga
	
	polygonOffset
	surfaceparm pointlight
	implicitBlend textures/the_lac/yamaha_sign.tga
}

textures/the_lac/xzone
{
	
	polygonOffset
	surfaceparm pointlight
	implicitBlend -
}

textures/the_lac/chain
{
	qer_trans 0.85
	qer_editorimage textures/the_lac/chainlink.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm metalsteps
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/the_lac/chainlink.tga
}

textures/the_lac/block03a_spawn
{
	qer_trans 0.85
	qer_editorimage textures/the_lac/block03a_spawn.tga
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm playerclip
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/the_lac/block03a_spawn.tga
}
textures/the_lac/block03a
{
	surfaceparm gravelsteps
	surfaceparm pointlight
	implicitMap -
}

//**************************************
//*******    Standard IMAGE    *********
//**************************************
textures/the_lac/crane_metal
{
	qer_editorimage textures/the_lac/crane_metal.jpg
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm metalsteps
	implicitmap textures/the_lac/crane_metal.jpg
}
textures/the_lac/crane_panel
{
	qer_editorimage textures/the_lac/crane_panel.tga
	surfaceparm metalsteps
	implicitmap textures/the_lac/crane_panel.jpg
}

//elevator
textures/the_lac/medicpanel_buttons
{
	q3map_nonplanar
	q3map_shadeangle 155
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/fieldoppanel_buttons
{
	q3map_nonplanar
	q3map_shadeangle 155
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/elevator_inside_buttons
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/elevator_left_door1
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/elevator_right_door1
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/elevator_metal
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/porte_garage
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/fannndevant
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/the_lac/coffreoutil
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}
textures/the_lac/coffreoutil3
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}
textures/the_lac/door_code
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}
textures/the_lac/mt_containerseite_gr
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}
textures/the_lac/mt_containerseite_ye
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}
textures/the_lac/speaker
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/stereo2
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/buchewood
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/buchetop
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/firefly_church9
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/wall_rusty_grey2fil_fitting
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm gravelsteps
	implicitMap -
}
textures/the_lac/wall_rustygreen_grey1
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm gravelsteps
	implicitMap -
}
textures/the_lac/wood@cratepile2b
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}
textures/the_lac/wood@tarptop1
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}

//************************      *******************************
//************************MODELS*******************************
//************************      *******************************

//**************************************
//*******      Parachute       *********
//**************************************
models/mapobjects/parachute/para2
{
	surfaceparm nomarks
	surfaceparm nonsolid
	cull none
	{
		map models/mapobjects/parachute/para2.tga
		rgbGen identity
	}
}

//**************************************
//*******        Camera        *********
//**************************************
textures/the_lac/portal_screen
{
	qer_editorimage textures/the_lac/stereo2.tga
	surfaceparm playerclip
	surfaceparm nolightmap
	portal
	{
		
		map textures/the_lac/stereo2.tga
		blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		depthWrite
		alphaGen portal 1024
    }
}

//**************************************
//*******   Countdown Number   *********
//**************************************
textures/the_lac/num_0
{
	qer_editorimage models/lac_md3/number/xxx0.tga
	
	{
		map models/lac_md3/number/xxx0.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_1
{
	qer_editorimage models/lac_md3/number/xxx1.tga
	
	{
		map models/lac_md3/number/xxx1.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}
textures/the_lac/num_2
{
	qer_editorimage models/lac_md3/number/xxx2.tga
	
	{
		map models/lac_md3/number/xxx2.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_3
{
	qer_editorimage models/lac_md3/number/xxx3.tga
	
	{
		map models/lac_md3/number/xxx3.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}
textures/the_lac/num_4
{
	qer_editorimage models/lac_md3/number/xxx4.tga
	
	{
		map models/lac_md3/number/xxx4.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_5
{
	qer_editorimage models/lac_md3/number/xxx5.tga
	
	{
		map models/lac_md3/number/xxx5.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}
textures/the_lac/num_6
{
	qer_editorimage models/lac_md3/number/xxx6.tga
	
	{
		map models/lac_md3/number/xxx6.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_7
{
	qer_editorimage models/lac_md3/number/xxx7.tga
	
	{
		map models/lac_md3/number/xxx7.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}
textures/the_lac/num_8
{
	qer_editorimage models/lac_md3/number/xxx8.tga
	
	{
		map models/lac_md3/number/xxx8.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_9
{
	qer_editorimage models/lac_md3/number/xxx9.tga
	
	{
		map models/lac_md3/number/xxx9.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}
textures/the_lac/num_c
{
	qer_editorimage models/lac_md3/number/xxxc.tga
	
	{
		map models/lac_md3/number/xxxc.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

textures/the_lac/num_e
{
	qer_editorimage models/lac_md3/number/xxxe.tga
	
	{
		map models/lac_md3/number/xxxe.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
	}
}

//**************************************
//******* SHIP *************************
//**************************************
textures/lac_md3/fishnet
{
	qer_trans 0.85
	qer_editorimage models/lac_md3/fishnet.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm grasssteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/lac_md3/fishnet.tga
}

textures/lac_md3/axisflag
{
	qer_editorimage models/lac_md3/axisflag.jpg
	cull none
	surfaceparm nomarks
      surfaceparm noimpact
	surfaceparm nonsolid
	implicitmap  models/lac_md3/axisflag.jpg 
}


textures/lac_md3/shipcammo
{
	qer_editorimage models/lac_md3/shipcammo.jpg
	q3map_nonplanar 
	q3map_shadeangle 135
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipcammo.jpg
}

textures/lac_md3/shipwindow
{
	qer_editorimage models/lac_md3/shipwindow.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipwindow.jpg
}

textures/lac_md3/shipdoor
{
	qer_editorimage models/lac_md3/shipdoor.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipdoor.jpg
}

textures/lac_md3/shipvent
{
	qer_editorimage models/lac_md3/shipvent.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipvent.jpg
}

textures/lac_md3/shipgunmetal
{
	qer_editorimage models/lac_md3/shipgunmetal.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipgunmetal.jpg
}

textures/lac_md3/shipgunmetal2
{
	qer_editorimage models/lac_md3/shipgunmetal2.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipgunmetal2.jpg
}

textures/lac_md3/shipgun
{
	qer_editorimage models/lac_md3/shipgun.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipgun.jpg
}

textures/lac_md3/shipmetal
{
	qer_editorimage models/lac_md3/shipmetal.jpg
	surfaceparm metalsteps
	implicitmap models/lac_md3/shipmetal.jpg
}

//**************************************
//*******       bulldozer      *********
//**************************************
textures/lac_md3/br_bulldozer
{
	qer_editorimage models/lac_md3/new/br_bulldozer/br_bulldozer.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_bulldozer/br_bulldozer.tga
}

//**************************************
//*******        missile       *********
//**************************************
textures/lac_md3/missile
{
	qer_editorimage models/lac_md3/missile.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/missile.tga
}

//**************************************
//*******        barrel        *********
//**************************************
models/lac_md3/br_woodenbarrel/br_barrelltop
{
	qer_editorimage models/lac_md3/new/br_barrell/br_barrelltop.tga
	surfaceparm woodsteps
	implicitmap models/lac_md3/new/br_barrell/br_barrelltop.tga
}

models/lac_md3/br_woodenbarrel/br_barrellside
{
	qer_editorimage models/lac_md3/new/br_barrell/br_barrellside.tga
	surfaceparm woodsteps
	implicitmap models/lac_md3/new/br_barrell/br_barrellside.tga
}

//**************************************
//*******        fence         *********
//**************************************
models/lac_md3/br_chainlink/br_fence1
{
	qer_editorimage models/lac_md3/new/br_chainlink/br_fence1.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_chainlink/br_fence1.tga
}

models/lac_md3/br_chainlink/br_fence2
{
	qer_trans 0.85
	qer_editorimage models/lac_md3/new/br_chainlink/br_fence2.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm grasssteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/lac_md3/new/br_chainlink/br_fence2.tga

}

models/lac_md3/br_chainlink/br_wire1
{
	qer_trans 0.85
	qer_editorimage models/lac_md3/new/br_chainlink/br_wire1.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm grasssteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/lac_md3/new/br_chainlink/br_wire1.tga

}

//**************************************
//*******         balet        *********
//**************************************
models/lac_md3/br_cleaning/br_cleaning
{
	qer_editorimage models/lac_md3/new/br_cleaning/br_cleaning.tga
	surfaceparm woodsteps
	implicitmap models/lac_md3/new/br_cleaning/br_cleaning.tga
}

//**************************************
//*******       neon light     *********
//**************************************
textures/lac_md3/br_flourlight
{
	qer_editorimage models/lac_md3/new/br_flourlight/br_flourlight.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_flourlight/br_flourlight.tga
}

//**************************************
//*******        tool kit      *********
//**************************************
models/lac_md3/br_toolbox/br_tools1
{
	qer_editorimage models/lac_md3/new/br_toolbox/br_tools1.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_toolbox/br_tools1.tga
}

//**************************************
//*******    generator wheel   *********
//**************************************
textures/lac_md3/br_generator
{
	qer_editorimage models/lac_md3/new/br_generator/br_generator.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_generator/br_generator.tga
}

//**************************************
//*******        propane       *********
//**************************************
textures/lac_md3/br_propane1
{
	qer_editorimage models/lac_md3/new/br_propane/br_propane2.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_propane/br_propane2.tga
}

textures/lac_md3/br_propane2
{
	qer_editorimage models/lac_md3/new/br_propane/br_propane1.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/new/br_propane/br_propane1.tga
}

//**************************************
//*******     colors mds       *********
//**************************************
textures/lac_md3/couleur/black
{
	qer_editorimage models/lac_md3/couleur/black.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/black.tga
}

textures/lac_md3/couleur/blanc
{
	qer_editorimage models/lac_md3/couleur/blanc.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/blanc.tga
}

textures/lac_md3/couleur/bleu
{
	qer_editorimage models/lac_md3/couleur/bleu.tga
	surfaceparm metalsteps
	surfaceparm pointlight
	implicitmap models/lac_md3/couleur/bleu.tga
}

textures/lac_md3/couleur/jaune
{
	qer_editorimage models/lac_md3/couleur/jaune.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/jaune.tga
}

textures/lac_md3/couleur/orangeeclairer
{
	  qer_editorimage models/lac_md3/couleur/orangeeclairer.tga
        cull disable
        q3map_surfacelight	10
	  surfaceparm glass

        {
                map models/lac_md3/couleur/orangeeclairer.tga
		rgbGen identity
        }
}

textures/lac_md3/couleur/orange
{
	qer_editorimage models/lac_md3/couleur/orange.tga
	q3map_surfacelight 200	
	cull none
	surfaceparm glass
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map models/lac_md3/couleur/orange.tga
		blendfunc filter
		rgbGen const ( 0.241176 0.241176 0.241176 )
	}
	{
		map models/lac_md3/couleur/orange.tga
		blendfunc add
		rgbGen wave sin 0 1 0.9 0.7 
	}
}

textures/lac_md3/couleur/rouge
{
	qer_editorimage models/lac_md3/couleur/rouge.tga
	surfaceparm metalsteps
	surfaceparm pointlight
	implicitmap models/lac_md3/couleur/rouge.tga
}

textures/lac_md3/couleur/framebas
{
	qer_editorimage models/lac_md3/couleur/framebas.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/framebas.tga
}

textures/lac_md3/couleur/framehaut
{
	qer_editorimage models/lac_md3/couleur/framehaut.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/framehaut.tga
}

textures/lac_md3/couleur/metal1rack
{
	qer_editorimage models/lac_md3/couleur/metal1rack.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/metal1rack.tga
}

textures/lac_md3/couleur/metal2chain
{
	qer_editorimage models/lac_md3/couleur/metal2chain.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/metal2chain.tga
}

textures/lac_md3/couleur/metal3detail
{
	qer_editorimage models/lac_md3/couleur/metal3detail.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/metal3detail.tga
}

textures/lac_md3/couleur/metallame
{
	qer_editorimage models/lac_md3/couleur/metallame.tga
	surfaceparm pointlight
	surfaceparm metalsteps
	implicitmap models/lac_md3/couleur/metallame.tga
}

textures/lac_md3/couleur/roue
{
	qer_editorimage models/lac_md3/couleur/roue.tga
	surfaceparm carpetsteps
	implicitmap models/lac_md3/couleur/roue.tga
}

textures/lac_md3/couleur/volantsiege
{
	qer_editorimage models/lac_md3/couleur/volantsiege.tga
	surfaceparm metalsteps
	surfaceparm pointlight
	implicitmap models/lac_md3/couleur/volantsiege.tga
}

//**************************************
//*******        plane         *********
//**************************************
models/lac_md3/avion/bot_left
{
	qer_editorimage models/lac_md3/avion/bot_left.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/avion/bot_left.tga
}

models/lac_md3/avion/bot_right
{
	qer_editorimage models/lac_md3/avion/bot_right.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/avion/bot_right.tga
}

models/lac_md3/avion/top_left
{
	qer_editorimage models/lac_md3/avion/top_left.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/avion/top_left.tga
}

models/lac_md3/avion/top_right
{
	qer_editorimage models/lac_md3/avion/top_right.tga
	surfaceparm metalsteps
	implicitmap models/lac_md3/avion/top_right.tga
}

models/lac_md3/avion/glass
{
	qer_trans 0.5
	qer_editorimage textures/common/s_glass.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm glass
	surfaceparm trans
	{
		map textures/common/s_glass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

//**************************************
//*******    Anti Ship Gun     *********
//**************************************
models/the_lac/pak75
{
	qer_editorimage models/mapobjects/pak75_sd/pak75.tga
	surfaceparm metalsteps
	implicitmap models/mapobjects/pak75_sd/pak75.tga
}

//**************************************
//******* Camera Surveillance  *********
//**************************************
models/mapobjects/Videocamera/videocamera
{
	qer_alphafunc gequal 0.5
	cull none
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

models/mapobjects/Videocamera/videocamerasupport
{
	qer_editorimage models/mapobjects/Videocamera/videocamerasupport.tga
	
	polygonOffset
	surfaceparm pointlight
	implicitBlend models/mapobjects/Videocamera/videocamerasupport.tga
}

//**************************************
//*******      red  trans      *********
//*******     Explosives       *********
//**************************************
models/mapobjects/dyno4/ball2_red
{
	qer_editorimage textures/common/dirtymirror.tga
	surfaceparm trans
	surfaceparm pointlight
	cull disable
	{
		map textures/the_lac/b.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.5 
		tcGen environment 
	}
	{
		map textures/the_lac/r.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.1 
		tcGen environment 
	}
	{
		map textures/the_lac/g.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.05 
		tcGen environment 
	}
}

//**************************************
//*******        roof          *********
//**************************************
textures/the_lac/wall_rusty_grey2fil_fitting3
{
      qer_editorimage textures/the_lac/wall_rusty_grey2fil_fitting3.tga
	q3map_forcemeta
	q3map_lightmapSampleOffset 8.0
	q3map_nonplanar
	q3map_clipModel
	implicitMap textures/the_lac/wall_rusty_grey2fil_fitting3.tga
	surfaceparm pointlight
	q3map_shadeangle 180
 
}

//**************************************
//*******       Copter         *********
//**************************************
models/gunship_copter/gunship_copter
{ 
   qer_editorimage models/gunship_copter/gunmap.tga 
  implicitMap models/gunship_copter/gunmap.tga 
   surfaceparm nomarks 
}

models/gunship_copter/gunship_copterblade
{ 
   qer_editorimage models/gunship_copter/gunmap.tga 
  implicitMap models/gunship_copter/gunmap.tga 
   surfaceparm nomarks 
}

models/gunship_copter/gunship_copterbladetail
{ 
   qer_editorimage models/gunship_copter/gunmap.tga 
  implicitMap models/gunship_copter/gunmap.tga 
   surfaceparm nomarks 
}

//************************       *******************************
//************************TERRAIN*******************************
//************************       *******************************
//	q3map_shadeangle 155	 135 is also good.. some ppl use lower like 80-90..

textures/the_lac/base
{
	nomipmaps
	nopicmip
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_nonplanar
	q3map_shadeangle 179	
	q3map_forcemeta

//	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	tcmod scale 0.080000001 0.080000001
//	surfaceparm pointlight

}
//	q3map_baseshader textures/the_lac/terrain_foliage_base
//	q3map_baseshader textures/the_lac/terrain_foliage_fade

textures/the_lac/terrain_foliage_base
{
	q3map_baseShader textures/the_lac/base

	q3map_foliage models/lac_md3/grass_foliage1.md3 1.25 48 0.1 2
	q3map_foliage models/lac_md3/grass_foliage2.md3 1.1 48 0.1 2
	q3map_foliage models/lac_md3/grass_foliage3.md3 1 48 0.1 2
}

textures/the_lac/terrain_foliage_fade
{
	q3map_baseShader textures/the_lac/base

	q3map_foliage models/lac_md3/grass_foliage1.md3 1.25 64 0.1 2
	q3map_foliage models/lac_md3/grass_foliage2.md3 1.1 64 0.1 2
	q3map_foliage models/lac_md3/grass_foliage3.md3 1 64 0.1 2
}

textures/the_lac/terrain_0
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/temperate_sd/sand_bubbles_bright.tga
	surfaceparm landmine
	surfaceparm grasssteps
	
	{

		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_1
{
	q3map_baseshader textures/the_lac/terrain_foliage_base
	qer_editorimage textures/temperate_sd/grass_dense1.tga
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_2
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/the_lac/sand_wave_bright2.tga
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_3
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/the_lac/magic_mountain.tga
	surfaceparm gravelsteps

	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_4
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/the_lac/sp_rock1.tga
	surfaceparm gravelsteps

	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_5
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/the_lac/ground.tga
	surfaceparm gravelsteps

	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_6
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/the_lac/sand_wave_bright.tga
	surfaceparm gravelsteps

	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_7
{
	q3map_baseshader textures/the_lac/base
	qer_editorimage textures/temperate_sd/sand_patchnoise.tga
	surfaceparm gravelsteps

	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		tcmod scale 0.080000001 0.080000001

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_0to1
{
	q3map_baseshader textures/the_lac/base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001

		
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}
	
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_0to2
{
	q3map_baseshader textures/the_lac/base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001	
	}
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}	
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_0to3
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001	
	}
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_0to4
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001

		
	}
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_0to5
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001

		
	}
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}
textures/the_lac/terrain_0to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001

		
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}
textures/the_lac/terrain_0to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/sand_bubbles_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001

		
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_1to2
{
	q3map_baseshader textures/the_lac/base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001


	}
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_1to3
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_1to4
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_1to5
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_1to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_1to7
{
	q3map_baseshader textures/the_lac/terrain_foliage_fade
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_dense1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_2to3
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}

}

textures/the_lac/terrain_2to4
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_2to5
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_2to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_2to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright2.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_3to4
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_3to5
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_3to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_3to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/magic_mountain.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_4to5
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_4to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_4to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sp_rock1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_5to6
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_5to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/ground.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain_6to7
{
	q3map_baseshader textures/the_lac/base
	surfaceparm gravelsteps
	{
		map textures/the_lac/sand_wave_bright.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
	}
	{
		map textures/temperate_sd/sand_patchnoise.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/the_lac/terrain.vertex
 {
	q3map_baseshader textures/the_lac/base
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcmod scale 0.080000001 0.080000001
	}
  }

models/lac_md3/grass_foliage1
{
	qer_editorimage models/foliage/grassfoliage1.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 512 1792 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage1.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/lac_md3/grass_foliage2
{
	qer_editorimage models/foliage/grassfoliage2.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 512 1536 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage2.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/lac_md3/grass_foliage3
{
	qer_editorimage models/foliage/grassfoliage3.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 480 1280 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage3.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}


//**************************************
//*******         SKY          *********
//**************************************
//**********************************************************************//
// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
// color will be normalized, so it doesn't matter what range you use
// intensity falls off with angle but not distance 100 is a fairly bright sun
// degree of 0 = from the east, 90 = north, etc.  altitude of 0 = sunrise/set, 90 = noon
	
textures/the_lac/station_skybox
{
		qer_editorimage env/the_lac/station/station_up.tga
	      q3map_sunExt 1 1 1 140 -35 25 3 20
	      q3map_lightmapFilterRadius 0 8		//self other
	      q3map_skyLight 100 5
      	nopicmip
          	nomipmaps
	
    
		q3map_globaltexture
		surfaceparm nodlight   
		surfaceparm noimpact 
		surfaceparm nolightmap
		surfaceparm sky       
		skyparms - 200 -  
     
		skyparms env/the_lac/station/station - -
}	

textures/the_lac/emerald_skybox
{
	      qer_editorimage env/the_lac/emerald/emerald_up.tga
       	skyParms env/the_lac/emerald/emerald 2048 -
// R G B Intensity Angle Pitch
//	      q3map_sunExt 0.99216 0.95686 0.82353 120 105 20 4 14
//	      q3map_sunExt 0.5 0.35 0.34 65 270 14	
	      q3map_sunExt 0.99216 0.95686 0.82353 100 270 14	

	      q3map_skyLight 100 3	    
	      q3map_lightmapFilterRadius 0 8
      	q3map_noFog

		surfaceparm nodlight   
		surfaceparm noimpact 
		surfaceparm nolightmap
		surfaceparm sky  
	      nopicmip
	      nomipmaps
}
