//Shaders by Sage
//*********************

/////////////////////////////////
//////////////Sky///////////////
///////////////////////////////
//
//Compile:
//

textures/kerkyra/sky
{
	qer_editorimage textures/kerkyra/sky.jpg
	
	nomipmaps
	nopicmip
	
	//q3map_sunExt 1 0.84 0.62 90 -45 45 3 32	//32 same as q3map_sun +  deviance (half shadows)+ samples

	
	q3map_sun 1 0.84 0.62 100 -45 45


	q3map_lightmapFilterRadius 0 8			//to stop "stadium lights" without longer compile

	q3map_skylight 60 6 // 3		//3=dev 6=final(brightness) + iterations ("quality")
	

	sunshader textures/kerkyra/sun
	
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

	//fogvars ( 1 0.73 0.33 ) .0001
	//skyfogvars ( 1 0.73 0.33 ) .026	//0.96 0.75 0.32	
	
	skyparms full 512 -
 	q3map_nofog

	{
		clampmap textures/kerkyra/sky.tga
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
		//depthWrite
	}

	{
		map textures/kerkyra/clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll -0.003 0.003
		tcmod scale 4 4
	}

	{
		map textures/kerkyra/clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll 0.007 0.008
		tcmod scale 2 2
	}

}

textures/kerkyra/sun
{
	//nomipmaps
	//nopicmip
	nocompress
	cull none
	q3map_nofog

	{
		map textures/kerkyra/sun.tga
		//blendFunc  GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//rgbGen identity
		blendFunc blend
		rgbGen identityLighting
	}

}

textures/kerkyra/fog
{	
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	
	fogparms ( 0.94 0.74 0.42 ) 49152
}

//Wow this is not easy :D
textures/kerkyra/sky_fakefog
{
	qer_editorimage textures/kerkyra/fakefog.tga
	qer_trans 0.98
	//cull none
	nocompress
	nopicmip
	nomipmaps
	q3map_forceMeta		//Bake the patch
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	{
		map textures/kerkyra/fakefog.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
	}
}

textures/kerkyra/sky_water
{
	qer_editorimage textures/liquids_sd/sea_bright_na.tga
	qer_trans 0.8
	nopicmip
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight

	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
		//tcmod scroll 0.003 0.01
	}

	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .8
		tcmod scroll 0.003 0.01

	}

}

models/mapobjects/kerkyra/sky_terrain
{
	//nomipmaps
	//nopicmip
	//nocompress

	{
		map models/mapobjects/kerkyra/sky_terrain.tga
		rgbGen identity
	}

//Make it hot ;)
	{
		map models/mapobjects/kerkyra/sky_fake.tga

       	//blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		tcMod scale 14 14
		rgbGen identity
	}

	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}

//	{	
//	map textures/detail_sd/sanddetail.tga
//		blendFunc GL_DST_COLOR GL_SRC_COLOR
//		//detail
//		tcMod scale 4 4
//	}


}

textures/kerkyra_walls/plant_wall_slick
{
	qer_editorimage textures/kerkyra_walls/plant_wall.tga
	surfaceparm slick
	implicitMap textures/kerkyra_walls/plant_wall.tga
}

/////////////////////////////////
//////////////Alpha/////////////
///////////////////////////////

textures/kerkyra_details/orange_wall_detail
{
    cull disable
    nomipmaps
    nopicmip
    surfaceparm nomarks
    surfaceparm alphashadow
    surfaceparm metalsteps
    surfaceparm pointlight
    surfaceparm trans
    polygonOffset
    sort decal
    {
        map textures/kerkyra_details/orange_wall_detail.tga
	  blendFunc blend
    }
}

textures/kerkyra_details/seam
{
    cull disable
    nomipmaps
    nopicmip
    surfaceparm nomarks
    surfaceparm alphashadow
    surfaceparm metalsteps
    surfaceparm pointlight
    surfaceparm trans
    polygonOffset
    sort decal
    {
        map textures/kerkyra_details/seam.tga
	  blendFunc blend
    }
}

textures/kerkyra_details/pit_cover
{
    cull disable
    nomipmaps
    nopicmip
    surfaceparm nomarks
    surfaceparm alphashadow
    surfaceparm metalsteps
    surfaceparm pointlight
    surfaceparm trans
    polygonOffset
    sort decal
    {
        map textures/kerkyra_details/pit_cover.tga
	  blendFunc blend
    }
}

textures/kerkyra_details/mines
{
	nomipmaps
	nopicmip
	surfaceparm metalsteps
	implicitMap -
}

textures/kerkyra/hay
{
	surfaceparm nomarks
	surfaceparm grasssteps
	implicitMap textures/props/hay.tga
}

textures/kerkyra/water
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
	cull none
	//deformVertexes wave 1317 sin 0 2.5 0 0.15
 	//deformVertexes wave 317 sin 0 1.5 0 0.30
	
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .65
		//tcmod scroll 0.0003 0.001
		tcMod turb 0 -0.03 0 -0.13

	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 -0.03 0 -0.13
		tcmod scroll -0.0009 -0.004
	}

	
}


textures/kerkyra/water_wave
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
	cull none
	deformVertexes wave 717 sin 0 2.4 0 0.14
 	deformVertexes wave 317 sin 0 1.4 0 0.3
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .78
		//tcmod scroll 0.0003 0.001
		tcMod turb 0 -0.03 0 -0.13

	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 -0.03 0 -0.13
		tcmod scroll -0.0009 -0.004
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.15 0.1 0.1 0.15
		alphaGen vertex
		tcMod turb 0 0.03 0.3 0.13
		tcmod scroll 0.0009 0.007
	}
	
}

textures/kerkyra/water_flow
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
	cull none
	//deformVertexes wave 1317 sin 0 2.5 0 0.15
 	//deformVertexes wave 317 sin 0 1.5 0 0.30
	
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .6
		tcmod scroll 0.03 0.0001
	}

	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.23 0.1 0 0.15
		alphaGen vertex
		tcmod scroll 0.002 0.0001
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.18 0.1 0.1 0.10
		alphaGen vertex
		tcmod scroll 0.009 0.0001
	}
	
}


///////////////////phong shading!//////////////////

textures/kerkyra_floors/sd_inside
{
	qer_editorimage textures/desert_sd/floor_inside_1.tga
	q3map_nonplanar
	q3map_shadeangle 60
	implicitMap textures/desert_sd/floor_inside_1.tga
}


textures/kerkyra_walls/concrete_wall
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/kerkyra_walls/peach1
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/kerkyra_walls/brown_rock_wall
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/kerkyra_walls/brown_rock_wall_dark
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/kerkyra_walls/wall_wood
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm woodsteps
	implicitMap -
}

/////////////////////////////////
//////////////Reflection////////
///////////////////////////////


textures/kerkyra_floors/floor_bathroom
{
	{
		map textures/kerkyra_floors/floor_bathroom.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_radar.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
	//	alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/kerkyra_windows/windows_big
{
	{
		map textures/kerkyra_windows/windows_big.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


textures/kerkyra_windows/windows_curtain
{
	{
		map textures/kerkyra_windows/windows_curtain.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


textures/kerkyra_windows/windows_curtain_2
{
	{
		map textures/kerkyra_windows/windows_curtain_2.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


textures/kerkyra_windows/windows_high
{
	{
		map textures/kerkyra_windows/windows_high.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


textures/kerkyra_windows/windows_side
{
	{
		map textures/kerkyra_windows/windows_side.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}


textures/kerkyra_windows/windows_small
{
	{
		map textures/kerkyra_windows/windows_small.tga
		blendFunc GL_ONE GL_ZERO
		rgbGen identity
	}
	{
		map textures/effects/envmap_ice2.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		tcMod Scale 1.2 1.2
//		alphagen const 0.5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/kerkyra/hedge_alpha
{
	qer_alphaFunc greater 0.5
	q3map_nonplanar
	q3map_shadeangle 90
	cull disable
	nomipmaps
	nopicmip
	//surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow
	surfaceparm trans
	implicitMask -
}