// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/jff_playground_b1/ter_dirtmud
{
        qer_editorimage textures/terrain_example/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/terrain_example/ter_dirt1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/terrain_example/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/jff_playground_b1/oase_grass
{
        qer_editorimage textures/terrain_example/ter_mossmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/temperate_sd/grass_dense1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/jff_playground_b1/grass_dense1_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/jff_playground_b1/rockwall
{
        qer_editorimage textures/terrain_example/ter_rockmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/desert_sd/rock_edged_smooth.tga	// Primary
		rgbGen identity
	}
	{
		map textures/jff_playground_b1/grass_dense1_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// Hong Phonged textures
// ======================================================================
textures/jff_playground_b1/ter_rock2
{
	q3map_nonplanar
	q3map_shadeangle 120
        qer_editorimage textures/terrain_example/ter_rock2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/terrain_example/ter_rock2.tga
		blendFunc filter
	}
}

// ======================================================================
// Alpha blending without dotProduct2 and ivector
// ======================================================================
textures/jff_playground_b1/bld_grass2rock	// Normal texture blending
{
        qer_editorimage textures/terrain_example/bld_rock2moss1.tga
	
	q3map_nonplanar
	q3map_shadeAngle 120
	
	{
		map textures/desert_sd/rock_edged_smooth.tga	// Primary
		rgbGen identity
	}
	{
		map textures/jff_playground_b1/grass_dense1_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/jff_playground_b1/dcl_moss1		// Decal blending
{
        qer_editorimage textures/terrain_example/ter_moss1.tga
	q3map_nonplanar 
	q3map_shadeangle 120 
	surfaceparm trans 
	surfaceparm nonsolid 
	surfaceparm nomarks
	polygonoffset
	{
		map textures/terrain_example/ter_moss1.tga
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/jff_playground_b1/alpha_000	// Primary texture ONLY
{
	qer_editorimage textures/terrain_example/alpha_000.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/jff_playground_b1/alpha_025
{
	qer_editorimage textures/terrain_example/alpha_025.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/jff_playground_b1/alpha_050	// Perfect mix of both Primary + Secondary
{
	qer_editorimage textures/terrain_example/alpha_050.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/jff_playground_b1/alpha_075
{	
	qer_editorimage textures/terrain_example/alpha_075.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/jff_playground_b1/alpha_085
{	
	qer_editorimage textures/terrain_example/alpha_085.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/jff_playground_b1/alpha_100	// Secondary texture ONLY
{
	qer_editorimage textures/terrain_example/alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}
