////////////
///////////NATURE
////////////

///// Big thanks to Sage for helping me out with these //////

//Base shader

textures/breakout2/base_shader //applied to every shader on the terrain
{
	q3map_nonPlanar 				//allow shadows to be cast correctly
	q3map_shadeAngle 120 			//smooths out the terrain (phong shading), might not work correctly tho

	//q3map_lightmapSampleOffset 3.0 	//offset, use it if you need it
	q3map_lightmapAxis z
	// q3map_lightmapMergable
	
	//q3map_lightmapSampleSize 16
	//q3map_lightmapSize 512 512 

	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )	  //will strecth the textures to be 512x512
	q3map_alphaMod dotproduct2 ( 0 0 2 ) 		 //blending mode
	q3map_tcMod rotate 33				//Will rotate the textures by 33 degrees (to make it look less tiled)
}

textures/breakout2/base_shader_verti //applied to every vertical shader
{
	q3map_nonPlanar 				//allow shadows to be cast correctly
	q3map_shadeAngle 120			//smooths out the terrain (phong shading), might not work correctly tho

	// q3map_lightmapSampleOffset 3.0 	
	q3map_lightmapAxis z	
	// q3map_lightmapMergable 			//use this instead of q3map_nonplanar
	
	//q3map_lightmapSampleSize 16
	//q3map_lightmapSize 512 512 
}

//***-***

//Single, non blending shaders:

textures/breakout2/road
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/road.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/gravel.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/grass01_NONFOLIAGE
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/grass.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/grass01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/grass01_FOLIAGE
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/grass_fol.tga
	q3map_foliage models/rayban_foliage/w_grass_foliage1.md3  1 48 0.04 2
	q3map_foliage models/rayban_foliage/w_grass_foliage2.md3  1.1 48 0.1 2
	q3map_foliage models/rayban_foliage/w_grass_foliage3.md3  1 48 0.03 2
	surfaceparm grasssteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/grass01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/mud01
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/mud.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/mud01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/rock01
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/rock.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/rock01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/dirt01
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/dirt.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/dirt01.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//***-***

//Dual, blending shaders:

textures/breakout2/road_to_mud
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/road_to_mud.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/gravel.tga
		rgbGen identity
	}
	{
		map textures/breakout2/nature/mud01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/mud_to_grass
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/mud_to_grass.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/mud01.tga
		rgbGen identity
	}
	{
		map textures/breakout2/nature/grass01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/grass_to_dirt
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/grass_to_dirt.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/breakout2/nature/dirt01.tga
		rgbGen identity
	}
	{
		map textures/breakout2/nature/grass01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/rock_to_mud
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/rock_to_mud.tga
	surfaceparm gravelsteps
	
	{
		map textures/breakout2/nature/rock01.tga
		rgbGen identity
	}
	{
		map textures/breakout2/nature/mud01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/breakout2/grass_to_rock
{
	q3map_baseshader textures/breakout2/base_shader
	qer_editorimage textures/breakout2/editor/grass_to_rock.tga
	surfaceparm grasssteps
	
	{
		map textures/breakout2/nature/rock01.tga
		rgbGen identity
	}
	{
		map textures/breakout2/nature/grass01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/nature/rock_to_moss_verti		// Normal texture blending
{
        qer_editorimage textures/breakout2/editor/moss_to_rock_verti.tga	
	q3map_baseshader textures/breakout2/base_shader_verti
	
	{
		map textures/breakout2/nature/rock01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/breakout2/nature/grass01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/breakout2/nature/rock01
{
	q3map_shadeAngle 110
	implicitMap -
}

textures/breakout2/nature/dirt01
{
	q3map_shadeAngle 90
	implicitMap -
}

textures/breakout2/nature/gold
{
	qer_editorimage textures/breakout2/nature/gold.tga
	polygonOffset
	surfaceparm glass
	{
		map textures/breakout2/fx/env_02.tga
		tcGen environment
	}
	{
		map textures/breakout2/nature/gold.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

////////NATURE VEGETATION
/////////////////////////

textures/breakout2/nature/wines
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm nonsolid
	polygonOffset
	cull none   
	implicitMask -
}

textures/breakout2/nature/flowers01
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm noclip
	polygonOffset
	cull none
	q3map_noTJunc
	q3map_noclip
	polygonOffset
	implicitMask -
}

////////NATURE VEGETATION 2
///////////////////////// FROM THE MAP PRAETORIA_ONE BY DIEGO

textures/breakout2/nature/foliage_treeline_03_cntr
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_lightmapsamplesize 32 // Sets lightmap sample size to 2x normal to save mem
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/foliage_treeline_03_left
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_lightmapsamplesize 32 // Sets lightmap sample size to 2x normal to save mem
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/foliage_treeline_03_rite
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_lightmapsamplesize 32 // Sets lightmap sample size to 2x normal to save mem
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/foliage_hedgerow_cntr
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/foliage_hedgerow_left
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/foliage_hedgerow_rite
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/nature/ivy
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm playerclip
	cull none
	q3map_noTJunc
	q3map_noclip
	polygonOffset
	implicitMask -
}


//////////////////////////
//////Breakout 2 Sky/////
////////////////////////

textures/breakout2/breakout2_sky
{
	qer_editorimage textures/breakout2/breakout2_sky/breakout2_sky_up.jpg
	
	skyParms textures/breakout2/breakout2_sky/breakout2_sky 1024 -

	q3map_sunExt 0.90 0.83 0.71 175 -100 25	// R G B Intensity Angle Pitch


	q3map_skylight 100 4                    //amount iterations
	q3map_noFog

	surfaceparm sky                         //flags compiler that this is sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight

	nopicmip
	nomipmaps

	{
		map textures/breakout2/nature/clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll 0.005 0.005
		tcmod scale 3 3
	}

}

//////////////////////////
/////Breakout 2 Misc/////
////////////////////////

textures/breakout2/misc/heart
{
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm woodsteps
	surfaceparm playerclip
	polygonOffset
	cull none
	q3map_noTJunc
	q3map_noclip
	implicitMask -
}

textures/breakout2/misc/blackness
{
	implicitMask -
}

textures/breakout2/misc/roof_1
{
	implicitMask -
}

textures/breakout2/misc/board
{
	implicitMask -
	surfaceparm woodsteps
}

textures/breakout2/misc/wire_material_noclip
{
	qer_editorimage textures/assault/atool_m02.jpg
	surfaceparm nonsolid
	surfaceparm trans
	implicitMap textures/assault/atool_m02.jpg
	
}

//////////////////////////
///Breakout 2 Windows////
////////////////////////

textures/breakout2/windows/window_1_refl
{
	qer_editorimage textures/breakout2/windows/window_1.tga
	surfaceparm glass
	cull disable
	polygonOffset
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
	}
	{
		map textures/breakout2/windows/window_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/breakout2/windows/window_1_trans
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/breakout2/windows/window_1.tga
	
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/breakout2/windows/window_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/breakout2/windows/window_2_refl
{
	qer_editorimage textures/breakout2/windows/window_2.tga
	surfaceparm glass
	cull none
	polygonOffset
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
	}
	{
		map textures/breakout2/windows/window_2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/breakout2/windows/window_2_trans
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/breakout2/windows/window_2.tga
	
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/breakout2/windows/window_2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/breakout2/windows/window_3_refl
{
	qer_editorimage textures/breakout2/windows/window_3.tga
	surfaceparm glass
	cull none
	polygonOffset
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
	}
	{
		map textures/breakout2/windows/window_3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/breakout2/windows/window_3_trans
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/breakout2/windows/window_3.tga
	
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/breakout2/windows/window_3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/breakout2/windows/window_4_trans
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/breakout2/windows/window_4.tga
	
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/breakout2/windows/window_4.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}


//////////////////////////
///Breakout 2 Doors//////
////////////////////////

textures/breakout2/doors/door01_refl
{
	qer_editorimage textures/breakout2/doors/door01.tga
	surfaceparm wood
	cull disable
	polygonOffset
	{
		map textures/breakout2/fx/env_01.tga
		tcGen environment
	}
	{
		map textures/breakout2/doors/door01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map $lightmap
		rgbGen Identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

//////////////////////////
///Breakout 2 Water//////
////////////////////////

textures/breakout2/nature/water
{
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	cull disable
	deformVertexes wave 128 sin 1 2 2 1 
	{
		map textures/liquids_sd/sea_bright_na.tga
		blendfunc gl_one gl_dst_color
		tcMod scroll 0.3 0
	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendfunc gl_dst_color gl_one_minus_dst_alpha
		tcMod scroll 0.3 -0.05
	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendfunc gl_one_minus_dst_color gl_src_alpha
		tcMod scroll 0.3 0.05
	}
}

textures/breakout_2/ocean_base
{
	qer_editorimage textures/liquids_sd/seawall_ocean.tga
	qer_trans 0.75
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
}

textures/breakout2/water_0
{
	q3map_baseshader textures/breakout2/ocean_base
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.35
 	deformVertexes wave 317 sin 0 1.5 0 0.50 
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
		
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.8
		tcmod scroll 0.25 0.3
		tcmod scale 0.25 0.25
	}
}

textures/breakout2/water_1
{
	q3map_baseshader textures/breakout2/ocean_base
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.35
 	deformVertexes wave 317 sin 0 1.5 0 0.50 
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .8
		tcmod scroll 0.25 0.3
		tcmod scale 0.25 0.25
	}

	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.3 0.2 0 0.4
		alphaGen vertex
		tcMod turb 0 0.05 0 0.35
		tcmod scroll -0.5 0.4
		tcmod scale 0.25 0.25
	}
}

textures/breakout2/water_0to1
{
	
	q3map_baseshader textures/breakout2/ocean_base
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.35
 	deformVertexes wave 317 sin 0 1.5 0 0.50 	
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .8
		tcmod scroll 0.25 0.3
		tcmod scale 0.25 0.25
	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.3 0.2 0 0.4
		alphaGen vertex
		tcMod turb 0 0.15 0.5 0.35
		tcmod scroll -0.5 0.4
		tcmod scale 0.25 0.25
	}
}

// waterfall sprays

textures/breakout2/nature/waterfall_spray1
{
	qer_editorimage textures/breakout2/nature/spray.tga
	q3map_globaltexture
	deformvertexes autosprite
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nodlight
	surfaceparm trans
	cull disable
	{
		clampmap textures/breakout2/nature/spray.tga
		alphagen wave sin 1 0.4 0 0.8
		tcmod stretch sin 1 0.1 0 1
		tcmod rotate 400
		blendfunc gl_src_alpha gl_one
	}
}

textures/breakout2/nature/waterfall_spray2
{
	qer_editorimage textures/breakout2/nature/spray.tga
	q3map_globaltexture
	deformvertexes autosprite
	surfaceparm pointlight
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nodlight
	surfaceparm trans
	cull disable
	{
		clampmap textures/breakout2/nature/spray.tga
		alphagen wave sin 1 0.4 0.1 0.8
		tcmod stretch sin 1 0.1 0.2 1
		tcmod rotate -400
		blendfunc gl_src_alpha gl_one
	}
}

////////////////////////
// VOLUMETRIC CLOUDS //
//////////////////////

textures/breakout2/nature/vol_clouds
{
	qer_editorimage textures/effects/envmap_radar.tga
	surfaceparm nonsolid
	surfaceparm nosteps
	cull disable
	deformVertexes bulge 6 6 0.5
	{
		map textures/effects/envmap_radar.tga
		blendfunc add
		tcMod scroll 0.02 0.02
	}
	{
		map textures/effects/wdfx_w.tga
		blendfunc add
		tcMod scroll 0.05 0.05
	}
	{
		map textures/effects/envmap_slate.tga
		blendfunc add
		tcMod scroll 0.07 0.07
	}
}

//////////////////////////
///Breakout 2 Walls//////
////////////////////////

textures/breakout2/walls/wall01
{
	implicitMask -
}

textures/breakout2/walls/wall02
{
	implicitMask -
}

textures/breakout2/walls/wall03
{
	implicitMask -
}

textures/breakout2/walls/wall04
{
	implicitMask -
}

textures/breakout2/walls/wall05
{
	implicitMask -
}

textures/breakout2/walls/wall06
{
	implicitMask -
}

textures/breakout2/walls/was_here
{
	implicitMask -
}

//////////////////////////////////
/////// LIGHT
//////////////////////////////////

textures/breakout2/light_disabled
{
	qer_editorimage textures/lights/light_c01.tga
	q3map_lightimage textures/lightimage/light_c01_color.tga
	q3map_surfacelight 500
	
	polygonOffset
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm nomarks
	{
		map textures/lights/light_c01.tga
		rgbGen vertex
	}
	{
		map textures/lights/light_c01.blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

textures/breakout2/misc/redlight
{
	qer_editorimage textures/breakout2/misc/redlight.tga
	q3map_lightimage textures/breakout2/misc/redlight.blend.tga
	q3map_surfacelight 10000
	surfaceparm nomarks
	polygonOffset
	{
		map textures/breakout2/misc/redlight.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/breakout2/misc/redlight.blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sawtooth .6 .1 0 7
	}
}

textures/breakout2/misc/redlight2
{
	qer_editorimage textures/breakout2/misc/redlight2.tga
	q3map_lightimage textures/breakout2/misc/redlight2.blend.tga
	q3map_surfacelight 10000
	surfaceparm nomarks
	polygonOffset
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/breakout2/misc/redlight2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/breakout2/misc/redlight2.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .3 .1 0 0.5
	}
}
