//======================================================================
// Fueldump.shader
// Last edit: 26/04/03 Sock
//

// SKY

textures/fueldump-z2/skybox/miramar
{
	qer_editorimage textures/fueldump-z2/skybox/miramar_up.jpg
//	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
//	q3map_lightsubdivide 256
	q3map_surfacelight 120
	q3map_sun 1 .95 .9 150 305 40
	skyparms textures/fueldump-z2/skybox/miramar - -
	{
		map textures/fueldump-z2/skybox/sky_clouds.jpg
		blendFunc filter
		tcMod scroll 0.001 0.001
		tcMod scale 3 3
	}
}

levelshots/fueldump-z2_cc_automap
{
  	nopicmip
	nocompress
	nomipmaps
  	{
  	  	clampmap levelshots/fueldump-z2_cc.tga
		depthFunc equal
		rgbGen identity
  	}
}

levelshots/fueldump-z2_cc_trans
{
  	nopicmip
	nocompress
	nomipmaps

	{

  	  	clampmap levelshots/fueldump-z2_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
  	}
}



//The Churchhill tank model and the textures for oasis model fixed by {SSF}Sage
//We use the fixed churchhill snow model and we remapshader it in the script
//so we get an oasis tank... here's some shaders for texture fixed
//mg42turret_oasis is a new texture recolored from mg42turret


models/mapobjects/tanks_sd/mg42turret_oasis
{
	{
		map models/mapobjects/tanks_sd/mg42turret_oasis.tga
		rgbGen lightingDiffuse
	}
}

models/mapobjects/tanks_sd/churchill_flat_oasis_fix
{
	{
		map models/mapobjects/tanks_sd/churchill_flat_oasis_fix.tga
		rgbGen lightingDiffuse
	}
}

//===========================================================================
// Floor and wall textures for the cave system + hong phong goodness
//===========================================================================
textures/fueldump/cave_dark
{
	q3map_nonplanar
	q3map_shadeangle 60
	qer_editorimage textures/stone/mxrock3_a.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock3_a.tga
		blendFunc filter
	}
}

textures/fueldump/cave_floor
{
	surfaceparm gravelsteps
	q3map_nonplanar
	q3map_shadeangle 60
	qer_editorimage textures/stone/mxrock1aa.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock1aa.tga
		blendFunc filter
	}
}

//======================================================================
// Base for metashaders
//======================================================================
textures/fueldump-z2/terrain_base
{
	q3map_lightmapMergable
	q3map_lightmapaxis z
	q3map_lightmapsize 512 512
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_tcMod rotate 37
	q3map_tcMod scale 2 2
	surfaceparm landmine
	surfaceparm grasssteps
}

//======================================================================
// Metashader for both sides of the map
// _0: Slighty dirty snow
// _1: Mud/dirt snow
// _2: Clean white snow
// _3: Snow crispy rock
//======================================================================
textures/fueldump-z2/terrain1_0
{
        qer_editorimage textures/fueldump-z2/master_grass_dirt3.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/master_grass_dirt3.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_1
{
        qer_editorimage textures/fueldump-z2/rock_graynoise.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/rock_graynoise.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_2
{
        qer_editorimage textures/fueldump-z2/grass_path1.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/grass_path1.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_3
{
        qer_editorimage textures/fueldump-z2/rock_ugly_brown.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/rock_ugly_brown.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_0to1
{
        qer_editorimage textures/fueldump-z2/master_grass_dirt3.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/master_grass_dirt3.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/rock_graynoise.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_0to2
{
        qer_editorimage textures/fueldump-z2/master_grass_dirt3.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/master_grass_dirt3.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_0to3
{
        qer_editorimage textures/fueldump-z2/master_grass_dirt3.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/master_grass_dirt3.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_1to2
{
        qer_editorimage textures/fueldump-z2/rock_graynoise.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/rock_graynoise.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_1to3
{
        qer_editorimage textures/fueldump-z2/rock_graynoise.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/rock_graynoise.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/fueldump-z2/terrain1_2to3
{
        qer_editorimage textures/fueldump-z2/grass_path1.tga
	q3map_baseshader textures/fueldump-z2/terrain_base
	{
		map textures/fueldump-z2/grass_path1.tga
		rgbgen identity
	}
	{
		map textures/fueldump-z2/rock_ugly_brown.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

//==========================================================================
// Terrain/tunnel blend textures
//==========================================================================
textures/snow_sd/snow_road01
{
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm snowsteps
	{
		map textures/snow_sd/snow_road01.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 1 1
		detail
	}
}

textures/snow_sd/snow_path01
{
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm snowsteps
	{
		map textures/snow_sd/snow_path01.tga
		rgbgen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 1 1
		detail
	}
}

//==========================================================================
// Misc stuff for the central building in the axis base
//==========================================================================
// Comms tower
textures/fueldump/atruss_m06a
{
	qer_alphafunc gequal 0.5
	qer_editorimage textures/assault/atruss_m06a.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm roofsteps
	surfaceparm trans
	implicitMask textures/assault/atruss_m06a.tga
}

textures/awf/awf_w_m11
{
	qer_editorimage textures/awf/awf_w_m11.tga
	q3map_lightimage textures/awf/awf_w_m11_g.tga
	q3map_surfacelight 200
	surfaceparm nomarks
	implicitMask textures/awf/awf_w_m11.tga
}

textures/awf/awf_w_m11_nlm
{
	qer_editorimage textures/awf/awf_w_m11_nlm.tga
	surfaceparm nomarks
	implicitMask textures/awf/awf_w_m11.tga
}

// This is more or less similiar to clipmissile
textures/alpha/fence_c11fd
{
	qer_trans 0.85
	qer_editorimage textures/alpha/fence_c11.tga
	cull disable
	nomipmaps
	nopicmip

	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans

	implicitMask textures/alpha/fence_c11.tga
}

//==========================================================================
// Various terrain decals textures
//==========================================================================

// ydnar: nuked unnecessary alphaGen vertex part & added surfaceparm trans & pointlight
textures/fueldump/cave_floorblend
{
	qer_editorimage textures/snow/s_dirt_m03i_alphadir.tga
	q3map_nonplanar
	q3map_shadeangle 60
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm gravelsteps
	surfaceparm pointlight
	polygonOffset

	{
		map textures/snow/s_dirt_m03i_alpha.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}


textures/fueldump/alphatree
{
	qer_editorimage textures/snow/s_dirt_m03i_alphatree.tga
	q3map_nonplanar 
	q3map_shadeangle 120 
	surfaceparm trans 
	surfaceparm nonsolid 
	surfaceparm pointlight
	surfaceparm nomarks
	polygonOffset
	{
		map textures/snow/s_dirt_m03i_alphatree.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

//==========================================================================
// Various metal surfaceparm textures
//==========================================================================
textures/fueldump/door_m01asml
{
	qer_editorimage textures/fueldump_sd/door_m01asml.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/fueldump_sd/door_m01asml.tga
		blendFunc filter
	}
}

textures/fueldump/door_m01asml_axis
{
	qer_editorimage textures/fueldump_sd/door_m01asml_axis.tga
	surfaceparm metalsteps
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/fueldump_sd/door_m01asml_axis.tga
		blendFunc filter
	}
}

//==========================================================================
// Ice Lake
//==========================================================================
textures/fueldump/icelake_top
{
	qer_trans 0.80
	qer_editorimage textures/snow_sd/icelake3.tga
	sort seethrough
	surfaceparm slick
	surfaceparm trans
	surfaceparm glass
	
	tesssize 256

	{
		map textures/effects/envmap_ice2.tga
		tcgen environment
		blendfunc blend
	}
	{
		map textures/snow_sd/icelake3.tga
		blendfunc blend
	}
	{
		map $lightmap
		blendfunc filter
		rgbGen identity
		depthWrite
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 4 4
		detail
	}
}

textures/fueldump/icelake_bottom
{
	qer_trans 0.80
	qer_editorimage textures/snow_sd/icelake3.tga
	sort seethrough
	surfaceparm trans
	cull disable
	
	{
		map textures/snow_sd/icelake3.tga
		blendfunc filter
	}
}

textures/fueldump/riverbed
{
	qer_editorimage textures/stone/mxdebri0_riverbed.tga

	{
		map textures/stone/mxdebri0_riverbed.tga
		rgbGen vertex
	}	
}

textures/fueldump-z2/clear_water
{
	qer_editorimage textures/fueldump-z2/qer_clear_water.jpg
	qer_trans .5
	q3map_globaltexture
	cull disable
	surfaceparm nonsolid
	surfaceparm water
	{
		map textures/fueldump-z2/clear_water1.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 1.5 0 1.5 1 1 2
		tcmod scroll -.05 .001
	}
	{
		map textures/fueldump-z2/da_pool.jpg
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .5 .5
		tcmod transform 0 1.5 1 1.5 2 1
		tcmod scroll .025 -.001
	}
	{
		map textures/fueldump-z2/clear_water1.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .5
		tcmod scroll .001 .025
	}
	{
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity
	}
}

// Ktrees shader
// Kic

models/mapobjects/ktrees/01bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/04bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/05bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/06bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/07bark
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/barkg
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/oak01_trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/oak1_trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/trunck3
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/trunk01
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/ttrunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/Umbrella_Trunk
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/wood06
{
	q3map_clipModel
	surfaceparm woodsteps
	surfaceparm nomarks
	implicitMap -
}

models/mapobjects/ktrees/07branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/06branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/12branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/01branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/02branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/04branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/11branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/10branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/oak1_leaf
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/09branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/plant_01
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/oak_leaf
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/13branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/08branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/llv
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf01
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf02
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf021
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/tree
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leaf01u
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/cross09
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/ttree
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/branch_t
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/topkor
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/101branch
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

models/mapobjects/ktrees/leafs
{
	qer_alphaFunc gequal 0.5
	nopicmip
	nomipmaps
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}

