//**********************************************************************//
//
//	terrain_example.shader for Q3 by Sock
//	Website : http://www.planetquake.com/simland/
//
//**********************************************************************//


// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================


textures/oc_escort/ter_grassdirt
{
        qer_editorimage textures/oc_escort/ter_grassdirt.tga
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_greengrass01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/oc_escort/ter_grassgrass
{
        qer_editorimage textures/oc_escort/ter_grassgrass.tga
	
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_greengrass01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_greengrass01.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/oc_escort/ter_roaddirt
{
        qer_editorimage textures/oc_escort/ter_roaddirt.tga
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_road01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/oc_escort/ter_sanddirt
{
        qer_editorimage textures/oc_escort/ter_sanddirt.tga
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_sand_gravels_bright.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}




textures/oc_escort/ter_grasssand
{
        qer_editorimage textures/oc_escort/ter_grasssand.tga
	
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_greengrass01.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_sand_gravels_bright.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/oc_escort/ter_dirtdirt
{
        qer_editorimage textures/oc_escort/ter_dirtdirt.tga
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_dirt.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/oc_escort/ter_dirtsand
{
        qer_editorimage textures/oc_escort/ter_dirtsand.tga
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeangle 150
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.85 )
	
	{
		map textures/oc_escort/oc_dirt.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_sand_gravels_bright.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// Hong Phonged textures
// ======================================================================
textures/escort/ter_rock2
{
	q3map_nonplanar
	q3map_shadeangle 150
        qer_editorimage textures/oc_escort/oc_ter_rock2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/escort/oc_ter_rock2.tga
		blendFunc filter
	}
}

// ======================================================================
// Alpha blending without dotProduct2 and ivector
// ======================================================================
textures/oc_escort/ter_dirtrock		// Normal texture blending
{
        qer_editorimage textures/oc_escort/ter_dirtrock.tga
	
	q3map_nonplanar
	q3map_shadeangle 150
	
	{
		map textures/oc_escort/oc_ter_rock2.tga	// Primary
		rgbGen identity
	}
	{
		map textures/oc_escort/oc_dirt.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/escort/dcl_moss1		// Decal blending
{
        qer_editorimage textures/escort/oc_greengrass01.tga
	q3map_nonplanar 
	q3map_shadeangle 150 
	surfaceparm trans 
	surfaceparm nonsolid 
	surfaceparm nomarks
	polygonoffset
	{
		map textures/escort/oc_greengrass01.tga
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/oc_escort/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/oc_escort/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/oc_escort/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/oc_escort/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/oc_escort/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/oc_escort/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}
