// =========================================================================
// ======================= terrain =========================================
// =========================================================================

textures/trains/ter_snowfloor4
{
	qer_editorimage textures/trains/ter_snowfloor4.tga
	surfaceparm grasssteps
	surfaceparm landmine	
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/trains/ter_mud1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/trains/ter_moss1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/trains/ter_mud1
{
      qer_editorimage textures/trains/ter_rock_dirt.tga
	surfaceparm gravelsteps
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/trains/ter_rock3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/trains/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}



// ===========================================================
// ======================= cable for lift ====================
// ===========================================================

textures/trains/cable_down
{
	qer_editorimage textures/props/cable_m01.jpg
	surfaceparm metalsteps
	{
		map textures/props/cable_m01.jpg
		rgbGen vertex
		tcMod scroll 0 -0.5
	}
}

textures/trains/cable_up
{
	qer_editorimage textures/props/cable_m01.tga
	surfaceparm metalsteps
	{
		map textures/props/cable_m01.tga
		rgbGen vertex
		tcMod scroll 0 0.5
	}
}

// ========================================================
// ======================= fan ============================
// ========================================================

textures/trains/fan_fast
{
	qer_editorimage textures/sfx/fan.tga
	cull none
	nopicmip
	surfaceparm nomarks
	surfaceparm trans
	{
		clampmap textures/sfx/fan.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		rgbGen identity
		tcMod rotate 512
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
		rgbGen identity
	}
}

// banner textures and shaders all from frostbite
textures/trains/banner
{
	surfaceparm nomarks // added
	qer_editorimage textures/trains/banner.tga
	q3map_bounceScale 0.2

	surfaceparm alphashadow
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/trains/banner.tga
		alphafunc ge128		
		rgbGen vertex
	}
	{
		map $lightmap
		blendfunc gl_zero gl_one
		rgbgen identity
		depthfunc equal
	}

}

textures/trains/banner_small
{
	surfaceparm nomarks // added
	qer_editorimage textures/trains/banner_small.tga
	q3map_bounceScale 0.5

	surfaceparm alphashadow
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/trains/banner_small.tga
		alphafunc ge128		
		rgbGen vertex
	}
	{
		map $lightmap
		blendfunc gl_zero gl_one
		rgbgen identity
		depthfunc equal
	}

}



// limbo 

gfx/limbo/cm_my_generator
{
	nopicmip
	nocompress
	nomipmaps
	{
		map gfx/limbo/cm_my_generator.tga
		depthfunc equal
		blendfunc blend
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/limbo/cm_entrance
{
	nopicmip
	nocompress
	nomipmaps
	{
		map gfx/limbo/cm_entrance.tga
		depthfunc equal
		blendfunc blend
		rgbGen vertex
		alphaGen vertex
	}
}