// ======================================================================
// etl_frostbite_v3 shader
// 2017 Cedric 'keMoN' E.
// http://www.moddb.com/mods/etlegacy
// distribution, in part or in whole, in any medium, permitted
// ======================================================================

/////////////////
// COMMAND MAP //
/////////////////

levelshots/etl_frostbite_v3_cc_automap
{
	nopicmip
	nocompress
	nomipmaps	 
  	{
		clampmap levelshots/etl_frostbite_v3_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/etl_frostbite_v3_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/etl_frostbite_v3_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

// END COMMAND MAP //

textures/sfx/xflame2_1750_nolick
{
	qer_editorimage textures/sfx/flame1.tga
	q3map_surfacelight 3000
	cull none
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
	}
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}
	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6
	}
}

models/castlemap/megaphone
{ 
	qer_editorimage models/castlemap/mega1.tga
	q3map_forceMeta 
	q3map_nonplanar 
	q3map_shadeAngle 180
	q3map_lightmapSampleOffset 8.0
	implicitMap models/castlemap/mega1.tga
}

textures/etl_frostbite/_snow
{
	qer_editorimage textures/etl_frostbite/_snow.tga
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
//	q3map_globalTexture
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	surfaceparm snowsteps
	surfaceparm landmine
	{
		// Primary 1
		map textures/snow_sd/s_grass_ml03b_big.tga
		rgbGen identity
	}
	{
		// Primary 2
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen Vertex
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_snow_mud
{
	qer_editorimage textures/etl_frostbite/_snow_mud.tga
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
//	q3map_globalTexture
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	surfaceparm snowsteps
	surfaceparm landmine
	{
		// Primary 1
		map textures/snow_sd/snow_muddy.tga
		rgbGen identity
	}
	{
		// Primary 2
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen Vertex
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_cliffZ
{
	qer_editorimage textures/etl_frostbite/_cliffZ.tga
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
//	q3map_globalTexture
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	surfaceparm snowsteps
	surfaceparm landmine
	{
		// Primary 1
		map textures/stone/mxrock3g.tga
		rgbGen identity
	}
	{
		// Primary 2
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen Vertex
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_cliffX
{
	qer_editorimage textures/etl_frostbite/_cliffX.tga
	q3map_tcGen ivector ( 0 256 0 ) ( 0 0 256 )
//	q3map_globalTexture
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	{		
		// Primary 1
		map textures/stone/mxrock3g.tga
		rgbGen identity
	}
	{
		// Primary 2
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen Vertex
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_cliffY
{
	qer_editorimage textures/etl_frostbite/_cliffY.tga
	q3map_tcGen ivector ( 0 0 256 ) ( 256 0 0 )
//	q3map_globalTexture
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	{		
		// Primary 1
		map textures/stone/mxrock3g.tga
		rgbGen identity
	}
	{
		// Primary 2
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen Vertex
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_rockZ
{
	qer_editorimage textures/etl_frostbite/_rockZ.tga
	q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 )
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
//	q3map_globalTexture
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	// surfaceparm landmine
	{
		// Primary 1
		map textures/temperate_sd/rock_ugly_brown.tga
		rgbGen identity
	}
	// {
		// Primary 2
		// map textures/temperate_sd/rocky_sand.tga
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		// alphaGen Vertex
		// rgbGen identity
	// }
	{
		// Secondary
		map textures/temperate_sd/rocky_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_rockX
{
	qer_editorimage textures/etl_frostbite/_rockX.tga
	q3map_tcGen ivector ( 0 128 0 ) ( 0 0 128 )
//	q3map_globalTexture
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	{
		// Primary 1
		map textures/temperate_sd/rock_ugly_brown.tga
		rgbGen identity
	}
	// {
		// Primary 2
		// map textures/temperate_sd/rocky_sand.tga
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		// alphaGen Vertex
		// rgbGen identity
	// }
	{
		// Secondary
		map textures/temperate_sd/rocky_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_rockY
{
	qer_editorimage textures/etl_frostbite/_rockY.tga
	q3map_tcGen ivector ( 0 0 128 ) ( 128 0 0 )
//	q3map_globalTexture
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapMergable
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.6 )
	{
		// Primary 1
		map textures/temperate_sd/rock_ugly_brown.tga
		rgbGen identity
	}
	// {
		// Primary 2
		// map textures/temperate_sd/rocky_sand.tga
		// blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		// alphaGen Vertex
		// rgbGen identity
	// }
	{
		// Secondary
		map textures/temperate_sd/rocky_sand.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/etl_frostbite/_sky
{
	qer_editorimage textures/skies/sky_8.tga
	//q3map_skylight 65 3
//	q3map_skylight 20 5
//	q3map_sun 0.3 0.3 0.45 60 35 45
//	q3map_sunExt 143 174 174 15 35 45 1 16
	q3map_sunExt 143 174 174 100 35 45 1 16
	nocompress
//	skyparms - 200 -
	sunshader textures/skies_sd/full_moon2
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	skyparms textures/skies_sd/wurzburg_env/sky 512 -
	{	
		fog off
		map textures/skies_sd/goldrush_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}
	{	
		fog off
		map textures/skies/nightsky1.jpg
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}
	{
		fog off
		clampmap textures/skies_sd/goldrush_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		// rgbGen identityLighting
		//rgbGen const ( 0.6 0.6 0.6 ) 
		rgbGen const ( 0.4 0.4 0.4 ) 
	}
}

textures/etl_frostbite/xmetal_c03_noclip
{
	qer_editorimage textures/xlab_wall/xmetal_c03.tga
	surfaceparm nonsolid
	implicitMap textures/xlab_wall/xmetal_c03
}

textures/decals/maps
{
	qer_editorimage textures/decals/maps.tga
	surfaceparm alphashadow
	surfaceparm nolightmap
	nopicmip
	nomipmaps
	polygonOffset
	{
		map textures/decals/maps.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

textures/decals/maps_rocket
{
	qer_editorimage textures/decals/maps.tga
	surfaceparm alphashadow
	surfaceparm nolightmap
	nopicmip
	nomipmaps
	polygonOffset
	{
		map textures/decals/maps.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

textures/decals/luff
{
	polygonOffset
	entityMergable
	{
		map textures/decals/luff.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/decals/one
{
	polygonOffset
	entityMergable
	{
		map textures/decals/one.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/decals/two
{
	polygonOffset
	entityMergable
	{
		map textures/decals/two.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

// DOA custom models - FireFly

models/doa/search_light/s_light_main
{ 	
	qer_editorimage models/doa/search_light/s_light_main.tga
	implicitMap models/doa/search_light/s_light_main.tga
}

models/doa/search_light/s_light_lamp
{ 	
	qer_editorimage models/doa/search_light/s_light_lamp.tga
	q3map_surfacelight 250
	{
		map models/doa/search_light/s_light_lamp.tga
		blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map models/doa/search_light/s_light_lamp_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

textures/snow/alpha_ice2
{
	qer_editorimage textures/snow/alpha_ice2s.tga		
	surfaceparm alphashadow
	cull none
	{
		map textures/snow/alpha_ice2s.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/decals/drain
{
	polygonOffset
	entityMergable


	{
		map textures/decals/drain.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

//dt_aa shader
//last edited by Detoeni 27.12.2004

models/mapobjects/dt_aa/light_grill
{
	qer_editorimage models/mapobjects/dt_aa/light_grill.tga
	qer_alphafunc greater 0.5
	nomipmaps
	nopicmip
	surfaceparm nomarks
	implicitMask models/mapobjects/dt_aa/light_grill.tga
}
models/mapobjects/dt_aa/bulkhead
{
	qer_editorimage models/mapobjects/dt_aa/bulkhead.tga
	surfaceparm nomarks
	implicitMap models/mapobjects/dt_aa/bulkhead.tga
}
models/mapobjects/dt_aa/light_nl
{
	qer_editorimage models/mapobjects/dt_aa/light_nl.tga
	surfaceparm nomarks
	implicitMap models/mapobjects/dt_aa/light_nl.tga
}
models/mapobjects/dt_aa/swing_light_nl
{
	qer_editorimage models/mapobjects/dt_aa/swing_light_nl.tga
	surfaceparm nomarks
	implicitMap models/mapobjects/dt_aa/swing_light_nl.tga
}

models/mapobjects/dt_aa/light_l
{
	q3map_editorimage models/mapobjects/dt_aa/light_l.tga
	q3map_lightimage models/mapobjects/dt_aa/light_l_blend.tga
	q3map_backSplash 2 23
	q3map_surfacelight  80000
	surfaceparm nomarks
	{
		map models/mapobjects/dt_aa/light_l.tga
		rgbGen vertex
	}
	{
		map models/mapobjects/dt_aa/light_l_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}
models/mapobjects/dt_aa/swing_light
{
	q3map_editorimage models/mapobjects/dt_aa/light_l.tga
	q3map_lightimage models/mapobjects/dt_aa/light_l_blend.tga
	q3map_backSplash 2 12
	q3map_surfacelight  20000
	surfaceparm nomarks
	{
		map models/mapobjects/dt_aa/light_l.tga
		rgbGen vertex
	}
	{
		map models/mapobjects/dt_aa/light_l_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen identity
	}
}

//end of dt_aa shader

models/mapobjects/trees_sd/leaves_snow
{
	nopicmip
	qer_alphafunc gequal 0.5
	cull disable
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	deformVertexes wave 10 sin 0 2 0 0.2
	implicitMask -
}