// ET Depot Shadering
//
//

///////////////////////////////////////////////////////////////////////////////////////
// PART 1
//
// Modell Satelitte
models/mapobjects/satellite/cables
{
    cull disable
    surfaceparm alphashadow
        {
                map models/mapobjects/satellite/cables.tga
                alphaFunc GE128
		depthWrite
		rgbGen vertex
        }
}



/////////////////////////////////////////////////////////////////////////////////////////////
// PART 2
//	
// Folder: ET Depot 
//		Texturen ohne normalmaps etc..

//Lichtstrahlen
textures/et_depot/beam
{
	qer_editorimage textures/et_depot/beam.tga
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/et_depot/beam.tga
		blendFunc add
		tcmod scroll -0.03 -0.05
//		q3map_tcMod scale 0.0625 0.0625
	}
}



// Light
textures/et_depot/light_m16
{
	qer_editorimage textures/et_depot/light_m16.tga
	q3map_surfacelight 20000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/et_depot/light_m16.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/et_depot/light_m16.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}


// Light
textures/et_depot/light_m16_20k
{
	qer_editorimage textures/et_depot/light_m16.tga
	q3map_surfacelight 20000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/et_depot/light_m16.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/et_depot/light_m16.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}


//spiegel
textures/et_depot/mirror
{
	qer_editorimage textures/et_depot/mirror.tga
	surfaceparm nolightmap
	portal
  
	{
		map textures/et_depot/mirror.tga
		blendfunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		depthWrite
	}
}


//fog
textures/et_depot/fog_crypt
{
	qer_editorimage textures/et_depot/fog.tga
        qer_trans 0.3
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	q3map_globaltexture
	q3map_surfacelight 1
	fogparms ( .15 .15 .17 ) 768
//	fogparms ( .2 .2 .2 ) 384

		

	{
		map textures/et_depot/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}

	{
		map textures/et_depot/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}



// Blood Decals
//
textures/et_depot/blood1
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/blood1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/et_depot/blood2
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/blood2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/et_depot/blood3
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/blood3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/et_depot/blood4
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/blood4.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

textures/et_depot/blood5
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/blood5.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}


// Map rocket Decal Wand
textures/et_depot/maps_rocket_depot
{
	polygonOffset
	entityMergable
	{
		map textures/et_depot/maps-rocket.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}



//Che Decal
textures/et_depot/che
{
         qer_editorimage textures/et_depot/che.tga
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/che.tga
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}

//Mnze
//PART 1 
textures/et_depot/fid_decal_muenze1
{
         qer_editorimage textures/et_depot/fid_decal_dm1.tga 
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/fid_decal_dm1.tga 
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}
//PART 2
textures/et_depot/fid_decal_muenze2
{
         qer_editorimage textures/et_depot/fid_decal_dm2.tga 
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/fid_decal_dm2.tga 
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}


// decal_orden
textures/et_depot/orden_decal
{
         qer_editorimage textures/et_depot/fid_decal_orden.tga
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/fid_decal_orden.tga
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}


//rtcw logo decal
textures/et_depot/rtcwlogo_decal
{
         surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/rtcwlogo_decal.tga
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}   


//Kletterpflanzen
textures/et_depot/ivy_c01
{
    surfaceparm woodsteps
    surfaceparm nomarks
    nomipmaps
    nopicmip
    cull disable
//  surfaceparm alphashadow
    {
        map textures/et_depot/ivy_c01.tga
       //alphaFunc GE128
	blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        depthWrite
        rgbGen vertex

    }
}


//Spinnweben  
textures/et_depot/cweb_m01drk
{
    qer_trans 0.8
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm nonsolid
    cull disable
    deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/et_depot/cweb_m01drk.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }
}


//Spinnweben
textures/et_depot/cweb_m01a
{
    //removelightmap info
    //surfaceparm nolightmap
    qer_trans 0.8
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm nonsolid
    cull disable
    deformVertexes wave 10 sin 0 2 0 0.2
    {
        map textures/et_depot/cweb_m01a.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }
}



// Rohr aus Wand
textures/et_depot/drain_trans
{
         qer_editorimage textures/et_depot/drain.tga.tga
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/et_depot/drain.tga
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}  




//Flaggen
textures/et_depot/flags_temp
{
	surfaceparm alphashadow
	// qer_trans 0.50
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_temp.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flag_c03dmtad
{
	surfaceparm alphashadow
	qer_trans 0.9

	cull twosided
	{
		map textures/et_depot/flag_c03dmtad.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}
textures/et_depot/flags_temptad
{
	surfaceparm alphashadow
	 qer_trans 0.90
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_temptad.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flags_m1
{
	surfaceparm alphashadow
	// qer_trans 0.50
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_m1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flags_m1_snow

{
//	surfaceparm nolightmap // added as test
//	surfaceparm trans // added as test
	surfaceparm alphashadow
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_m1_snow.tga
		alphafunc ge128		
		rgbGen vertex
	}
	{
		map $lightmap
		blendfunc gl_zero gl_one
		rgbgen identity
		depthfunc equal
	}

}

textures/et_depot/flags_m1_snowtad

{
	surfaceparm alphashadow
	 qer_trans 0.90
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_m1_snowtad.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flags_m1_fac

{
	surfaceparm alphashadow
	 qer_trans 0.90
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flags_m1_fac.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flag_l_m01

{
	qer_editorimage textures/et_depot/flag_l_m01.tga
	// qer_trans 0.50
//	deformVertexes wave 194 sin 0 2 0 .1
//	deformVertexes wave 30 sin 0 1 0 .3
//	deformVertexes wave 194 sin 0 1 0 .4
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/et_depot/flag_l_m01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flag_l_m01nomove

{
	qer_editorimage textures/et_depot/flag_l_m01.tga

	// qer_trans 0.50
	cull twosided
	{
		map textures/et_depot/flag_l_m01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}

textures/et_depot/flag_l_m01_tad

{
	qer_editorimage textures/et_depot/flag_l_m01_tad.tga

	// qer_trans 0.50
	cull twosided
	{
		map textures/et_depot/flag_l_m01_tad.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}

}





/////////////////////////////////////////////////////////////////////////////
// PART 3
//
//
//Folder shaderlab_1337 
//
//

// shader and textures (c) 2004 randy 'ydnar' reddig
// http://shaderlab.com

// -----------------------------------------------------------
// sky
// must be compiled with -skyfix in BSP phase using Q3Map2
// to fix ATI/correct texture clamping issue
// -----------------------------------------------------------

textures/shaderlab_1337/sky
{
	qer_editorimage textures/shaderlab_1337/sky_clouds.tga
	
	q3map_lightImage textures/shaderlab_1337/sky_clouds.tga
	
	// light values tuned for -gamma 2 -compensate 4
	q3map_sunExt 1 1 1 400 -30 45 2 12
	q3map_skyLight 75 3
	
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	
	skyparms textures/shaderlab_1337/env/sky 1337 -
	
	nopicmip
	
	{
		map textures/shaderlab_1337/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map textures/shaderlab_1337/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}



// -----------------------------------------------------------
// concrete that fades to tan (using alphaMod volume brushes)
// -----------------------------------------------------------

textures/shaderlab_1337/conc_1
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/shaderlab_1337/conc_1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/shaderlab_1337/env/sky_dn.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen oneMinusVertex
	}
}



// -----------------------------------------------------------
// water shit (from shaderlab_sorting_fun)
// -----------------------------------------------------------

textures/shaderlab_1337/water_caulk
{
	qer_trans 0.5
	
	surfaceparm nodraw
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
}


textures/shaderlab_1337/water
{
	q3map_tessSize 2048
	q3map_tcGen ivector ( 1337 0 0 ) ( 0 1337 0 )
	
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	surfaceparm pointlight
	
	cull none
	sort additive
	
	deformVertexes wave 100 sin 3 2 .1 0.1
	
	{
		map textures/shaderlab_1337/water.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen identity
		alphaGen vertex
		tcMod scroll 0.01 0.025
	}
	{
		map textures/shaderlab_1337/water.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen identity
		alphaGen vertex
		tcMod scale 1.5 1.5
		tcMod scroll -0.0075 -0.03
		rgbGen identity
	}
}




////////////////////////////////////////////////////////////////////////////////////////
// PART 4
//
// Folder et_depot
//
// http://fidel.vido.info
//
//  bumpmaps
//  normalmaps
//  phong



textures/et_depot/metal051_bump
{
   qer_editorimage textures/et_depot/metal051.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal051_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal051.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 


textures/et_depot/metal008_bump
{
   qer_editorimage textures/et_depot/metal008.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal008_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal008.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/brickred_01_bump
{
   qer_editorimage textures/et_depot/brickred_01.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/brickred_01_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/brickred_01.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/wood020_bump
{
   qer_editorimage textures/et_depot/wood020.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood020_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood020.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_box4_bump
{
   qer_editorimage textures/et_depot/dr_box4.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_box4_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_box4.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 


textures/et_depot/dr_box2_bump
{
   qer_editorimage textures/et_depot/dr_box2.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_box2_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_box2.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 


textures/et_depot/dr_box1_bump
{
   qer_editorimage textures/et_depot/dr_box1.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_box1_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_box1.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 


textures/et_depot/dirt_m03g_bump
{
   qer_editorimage textures/et_depot/dirt_m03g.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dirt_m03g_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dirt_m03g.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 


textures/et_depot/dr_poster1_bump
{
   qer_editorimage textures/et_depot/dr_poster1.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster1_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster1.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/dr_poster2_bump
{
   qer_editorimage textures/et_depot/dr_poster2.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster2_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster2.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster3_bump
{
   qer_editorimage textures/et_depot/dr_poster3.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster3_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster3.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster4_bump
{
   qer_editorimage textures/et_depot/dr_poster4.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster4_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster4.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster5_bump
{
   qer_editorimage textures/et_depot/dr_poster5.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster5_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster5.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 
 
textures/et_depot/dr_poster6_bump
{
   qer_editorimage textures/et_depot/dr_poster6.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster6_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster6.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster7_bump
{
   qer_editorimage textures/et_depot/dr_poster7.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster7_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster7.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster8_bump
{
   qer_editorimage textures/et_depot/dr_poster8.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster8_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster8.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_poster9_bump
{
   qer_editorimage textures/et_depot/dr_poster9.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_poster9_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_poster9.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_soldbuch_bump
{
   qer_editorimage textures/et_depot/dr_soldbuch.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_soldbuch_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_soldbuch.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/dr_telecode_bump
{
   qer_editorimage textures/et_depot/dr_telecode.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_telecode_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_telecode.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m12_bump
{
   qer_editorimage textures/et_depot/wood_m12.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m12_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m12.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 

textures/et_depot/wood_c01_bump
{
   qer_editorimage textures/et_depot/wood_c01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_c01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_c01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m03_bump
{
   qer_editorimage textures/et_depot/ametal_m03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m02_bump
{
   qer_editorimage textures/et_depot/ametal_m02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/concrete_c05_bump
{
   qer_editorimage textures/et_depot/concrete_c05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_c05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_c05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m08_bump
{
   qer_editorimage textures/et_depot/ametal_m08.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m08_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m08.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/metal_m01_bump
{
   qer_editorimage textures/et_depot/metal_m01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal_m01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal_m01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/miltary_m06_bump
{
   qer_editorimage textures/et_depot/miltary_m06.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/miltary_m06_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/miltary_m06.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m07a_bump
{
   qer_editorimage textures/et_depot/ametal_m07a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m07a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m07a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/concrete_c02_bump
{
   qer_editorimage textures/et_depot/concrete_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m01_usat_bump
{
   qer_editorimage textures/et_depot/wood_m01_usat.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m01_usat_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m01_usat.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/metal_m04dg_bump
{
   qer_editorimage textures/et_depot/metal_m04dg.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal_m04dg_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal_m04dg.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/mroof_m01a_bump
{
   qer_editorimage textures/et_depot/mroof_m01a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/mroof_m01a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/mroof_m01a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/xmetal_c03_bump
{
   qer_editorimage textures/et_depot/xmetal_c03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xmetal_c03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xmetal_c03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c03dm_bump
{
   qer_editorimage textures/et_depot/xpanel_c03dm.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c03dm_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c03dm.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c04_bump
{
   qer_editorimage textures/et_depot/xpanel_c04.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c04_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c04.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c04a_bump
{
   qer_editorimage textures/et_depot/xpanel_c04a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c04a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c04a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c02dm_bump
{
   qer_editorimage textures/et_depot/xpanel_c02dm.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c02dm_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c02dm.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c04dm_bump
{
   qer_editorimage textures/et_depot/xpanel_c04dm.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c04dm_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c04dm.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}



textures/et_depot/xpanel_c05_bump
{
   qer_editorimage textures/et_depot/xpanel_c05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c05_light_half_bump
{
   qer_editorimage textures/et_depot/xpanel_c05_light_half.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c05_light_half_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c05_light_half.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c07_bump
{
   qer_editorimage textures/et_depot/xpanel_c07.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c07_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c07.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/xpanel_c08a_bump
{
   qer_editorimage textures/et_depot/xpanel_c08a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c08a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c08a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c10_light_bump
{
   qer_editorimage textures/et_depot/xpanel_c10_light.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c10_light_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c10_light.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_c11_bump
{
   qer_editorimage textures/et_depot/xpanel_c11.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c11_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c11.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/xpanel_c08_bump
{
   qer_editorimage textures/et_depot/xpanel_c08.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_c08_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_c08.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xpanel_switch_bump
{
   qer_editorimage textures/et_depot/xpanel_switch.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xpanel_switch_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xpanel_switch.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/xradio_c02_bump
{
   qer_editorimage textures/et_depot/xradio_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xradio_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xradio_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m04a_bump
{
   qer_editorimage textures/et_depot/ametal_m04a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m04a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m04a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/concrete_c07bcmp_sand_bump
{
   qer_editorimage textures/et_depot/concrete_c07bcmp_sand.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_c07bcmp_sand_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_c07bcmp_sand.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m13_usat_bump
{
   qer_editorimage textures/et_depot/wood_m13_usat.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m13_usat_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m13_usat.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/diamond_c_01b_bump
{
   qer_editorimage textures/et_depot/diamond_c_01b.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/diamond_c_01b_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/diamond_c_01b.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/xconcrete_c54_c_bump
{
   qer_editorimage textures/et_depot/xconcrete_c54_c.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/xconcrete_c54_c_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/xconcrete_c54_c.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wall03_mid_bump
{
   qer_editorimage textures/et_depot/wall03_mid.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wall03_mid_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wall03_mid.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/ametal_m01_bump
{
   qer_editorimage textures/et_depot/ametal_m01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/ametal_m01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/ametal_m01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_c13_bump
{
   qer_editorimage textures/et_depot/wood_c13.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_c13_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_c13.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m02a_bump
{
   qer_editorimage textures/et_depot/wood_m02a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m02a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m02a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/cwood_mo6_bump
{
   qer_editorimage textures/et_depot/cwood_mo6.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/cwood_mo6_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/cwood_mo6.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/desk_c04_bump
{
   qer_editorimage textures/et_depot/desk_c04.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/desk_c04_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/desk_c04.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/concrete_c05_bump
{
   qer_editorimage textures/et_depot/concrete_c05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_c05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_c05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/concrete_c02_bump
{
   qer_editorimage textures/et_depot/concrete_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/concrete022_bump
{
   qer_editorimage textures/et_depot/concrete022.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete022_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete022.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/controlpanel_c02_bump
{
   qer_editorimage textures/et_depot/controlpanel_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/controlpanel_c03_bump
{
   qer_editorimage textures/et_depot/controlpanel_c03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/controlpanel_c05_bump
{
   qer_editorimage textures/et_depot/controlpanel_c05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/controlpanel_c06_bump
{
   qer_editorimage textures/et_depot/controlpanel_c06.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c06_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c06.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/controlpanel_c_04_bump
{
   qer_editorimage textures/et_depot/controlpanel_c_04.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c_04_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c_04.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/logo-drk_bump
{
   qer_editorimage textures/et_depot/logo-drk.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/logo-drk_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/logo-drk.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/metal022_bump
{
   qer_editorimage textures/et_depot/metal022.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal022_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal022.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/metal023_bump
{
   qer_editorimage textures/et_depot/metal023.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal023_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal023.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/metal033_bump
{
   qer_editorimage textures/et_depot/metal033.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal033_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal033.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/panel_c02_bump
{
   qer_editorimage textures/et_depot/panel_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/panel_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/panel_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/sand_disturb_bright_bump
{
   qer_editorimage textures/et_depot/sand_disturb_bright.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/sand_disturb_bright_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/sand_disturb_bright.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m06a_bump
{
   qer_editorimage textures/et_depot/wood_m06a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m06a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m06a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/controlpanel_c02_bump
{
   qer_editorimage textures/et_depot/controlpanel_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/controlpanel_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/controlpanel_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}



textures/et_depot/concrete_m05c_bump
{
   qer_editorimage textures/et_depot/concrete_m05c.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/concrete_m05c_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/concrete_m05c.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/wall04_mid_bump
{
   qer_editorimage textures/et_depot/wall04_mid.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wall04_mid_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wall04_mid.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/door_m01swf_bump
{
   qer_editorimage textures/et_depot/door_m01swf.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/door_m01swf_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/door_m01swf.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m18_bump
{
   qer_editorimage textures/et_depot/wood_m18.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m18_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m18.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_m13_bump
{
   qer_editorimage textures/et_depot/wood_m13.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_m13_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_m13.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}



textures/et_depot/box_c01_bump
{
   qer_editorimage textures/et_depot/box_c01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_c01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_c01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_c02_bump
{
   qer_editorimage textures/et_depot/box_c02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_c02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_c02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_c03_bump
{
   qer_editorimage textures/et_depot/box_c03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_c03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_c03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m01_bump
{
   qer_editorimage textures/et_depot/box_m01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m02_bump
{
   qer_editorimage textures/et_depot/box_m02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m03_bump
{
   qer_editorimage textures/et_depot/box_m03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m04_bump
{
   qer_editorimage textures/et_depot/box_m04.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m04_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m04.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m04a_bump
{
   qer_editorimage textures/et_depot/box_m04a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m04a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m04a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m04_sd_bump
{
   qer_editorimage textures/et_depot/box_m04_sd.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m04_sd_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m04_sd.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m05_bump
{
   qer_editorimage textures/et_depot/box_m05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_m05a_bump
{
   qer_editorimage textures/et_depot/box_m05a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_m05a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_m05a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_t_m02_bump
{
   qer_editorimage textures/et_depot/box_t_m02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_t_m02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_t_m02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/box_t_m02a_bump
{
   qer_editorimage textures/et_depot/box_t_m02a.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/box_t_m02a_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/box_t_m02a.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/cable_m01_bump
{
   qer_editorimage textures/et_depot/cable_m01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/cable_m01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/cable_m01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train1_bump
{
   qer_editorimage textures/et_depot/train1.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train1_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train1.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m01_bump
{
   qer_editorimage textures/et_depot/train_m01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m02_bump
{
   qer_editorimage textures/et_depot/train_m02.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m02_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m02.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m03_bump
{
   qer_editorimage textures/et_depot/train_m03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m04_bump
{
   qer_editorimage textures/et_depot/train_m04.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m04_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m04.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m05_bump
{
   qer_editorimage textures/et_depot/train_m05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/train_m06_bump
{
   qer_editorimage textures/et_depot/train_m06.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/train_m06_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/train_m06.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/diamond_m03_bump
{
   qer_editorimage textures/et_depot/diamond_m03.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/diamond_m03_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/diamond_m03.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/duct_a2_bump
{
   qer_editorimage textures/et_depot/duct_a2.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/duct_a2_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/duct_a2.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/brick_l_01_bump
{
   qer_editorimage textures/et_depot/brick_l_01.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/brick_l_01_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/brick_l_01.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/metal_m05_bump
{
   qer_editorimage textures/et_depot/metal_m05.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/metal_m05_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/metal_m05.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/wood_c08_bump
{
   qer_editorimage textures/et_depot/wood_c08.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wood_c08_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wood_c08.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}



textures/et_depot/wall02_mid_bump
{
   qer_editorimage textures/et_depot/wall02_mid.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/wall02_mid_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/wall02_mid.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}

textures/et_depot/dr_window_bump
{
   qer_editorimage textures/et_depot/dr_window.tga

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/dr_window_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/dr_window.tga
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_newspaper_bump
{
   qer_editorimage textures/et_depot/fid_newspaper.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_newspaper_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_newspaper.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_map_potsdam_bump
{
   qer_editorimage textures/et_depot/fid_map_potsdam.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_map_potsdam_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_map_potsdam.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_0001_bump
{
   qer_editorimage textures/et_depot/fid_picture_0001.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_0001_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_0001.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_flug_bump
{
   qer_editorimage textures/et_depot/fid_picture_flug.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_flug_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_flug.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_panzergemalde_bump
{
   qer_editorimage textures/et_depot/fid_picture_panzergemalde.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_panzergemalde_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_panzergemalde.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_propaganda_bump
{
   qer_editorimage textures/et_depot/fid_picture_propaganda.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_propaganda_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_propaganda.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_rommel_bump
{
   qer_editorimage textures/et_depot/fid_picture_rommel.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_rommel_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_rommel.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_sieg_bump
{
   qer_editorimage textures/et_depot/fid_picture_sieg.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_sieg_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_sieg.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}


textures/et_depot/fid_picture_sw_bump
{
   qer_editorimage textures/et_depot/fid_picture_sw.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 89
   // PHONG ENDE

   q3map_normalimage textures/et_depot/fid_picture_sw_bump.jpg
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/et_depot/fid_picture_sw.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
}



//	PART 5
//	Decal Entity Thing
textures/et_depot/decal_thing
{
	qer_editorimage textures/et_depot/che.tga
	qer_trans 0.75
	q3map_nonplanar
	q3map_shadeAngle 179
	q3map_noTJunc
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	polygonOffset

	{
		map textures/et_depot/che.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen identity
	}
}


// 	PART 6
//	Mapweiter Nebel

textures/et_depot/fog
{
	qer_editorimage textures/sfx/fog_grey1.tga
	
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	
	fogparms ( 0.09411 0.09803 0.12549 ) 2416
}


 


