/////////////////////////////////////////////////////////////////////////////////////
//	et-dam shaders based on shaders by Splashdamage and Simon O'Callaghan      //
/////////////////////////////////////////////////////////////////////////////////////

// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/et_dam/ter_dirtmud
{
        qer_editorimage textures/et_dam/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 40
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/et_dam/ter_dirt1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/et_dam/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/et_dam/ter_mossmud
{
        qer_editorimage textures/terrain_example/ter_mossmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 40
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/et_dam/ter_moss1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/et_dam/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/et_dam/ter_rockmud
{
        qer_editorimage textures/terrain_example/ter_rockmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 40
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/et_dam/ter_rock3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/et_dam/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/et_dam/ter_rockgrass
{
        qer_editorimage textures/terrain_example/rockgrass.tga
	
	q3map_nonplanar
	q3map_shadeangle 140
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/et_dam/ter_rock3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/et_dam/ter_moss1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// Hong Phonged moss

textures/et_dam/phong_moss1
{
	q3map_nonplanar
	q3map_shadeangle 140
        qer_editorimage textures/terrain_example/ter_moss1.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/et_dam/ter_moss1.tga
		blendFunc filter
	}
}

// alpha fade shaders

textures/terrain_example/alpha_000	
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_050	
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/terrain_example/alpha_100
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/decals/three
{
	polygonOffset
	entityMergable
	{
		map textures/decals/three.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

levelshots/et_dam_b1_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/et_dam_b1_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/et_dam_b1_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/et_dam_b1_cc.tga
		blendFunc blend
		rgbGen identity
		alphaGen vertex
	}
}

textures/et_dam/water_dam
{
	qer_editorimage textures/et_dam/ocean_m1.tga
	qer_trans .5
	q3map_globaltexture
	cull disable
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	waterfogvars ( 0.1 0.35 0.1 ) 512
	{
		map textures/et_dam/ocean_m1.tga
		rgbgen identity
		tcmod scale .8 .7
		tcmod scroll .00 -.01
	}
	{
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbgen identity
	}
}

textures/et_dam/sky_dam_wils
{
	qer_editorimage textures/skies/nightsky1.jpg

	nocompress

	q3map_backsplash -1 -1
	q3map_globaltexture

	q3map_lightsubdivide 2048 
//	q3map_sun	0.274632 0.274632 0.39 30 315 45
	q3map_sun	0.274632 0.274632 0.39 30 315 45
	q3map_surfacelight 10

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	surfaceparm nodlight

//	fogvars ( .02 0.02 0.03 ) .0001
	fogvars ( .02 0.02 0.03 ) .0002
	skyfogvars ( .23 .23 .3 ) .01

	skyparms full 200 -
}

textures/et_dam/sky_dam_wils_skybox
{
	qer_editorimage textures/skies/nightsky1.jpg

	nocompress

	q3map_backsplash -1 -1
	q3map_globaltexture

	q3map_lightsubdivide 2048 
//	q3map_sun	0.274632 0.274632 0.39 30 315 45
	q3map_sun	0.274632 0.274632 0.39 30 315 45
	q3map_surfacelight 10

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	surfaceparm nodlight

//	fogvars ( .15 .15 .2 ) .0001
//	skyfogvars ( .23 .23 .3 ) .01

	skyparms full 200 -

	{
		map textures/skies/nightsky1.tga
		tcMod scale 16.0 16.0
		depthWrite
	}
	{
		map textures/et_dam/vil_clouds1.tga
		blendfunc blend
		tcMod scroll 0.001 0.00
		tcMod scale 2 1
	}
}

textures/et_dam/tree_m02dm
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/et_dam/drain
{
	
	polygonOffset
	surfaceparm pointlight
	implicitBlend -
}