// Shader file for the ET-map "Eagles 2 ways beta 1", a remake of Drakir's classic map "Eagles"
// (a second route up to the castle, for the Allied Forces, is added).
// Drakir's original was made in April, 2004. This remake is done in February, 2006, by Loffy.

textures/e2ways_tex/map_made_by_drakir
{
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}

// Loffy's cat, Randi
textures/e2ways_tex/e2ways_randi
{
	cull none
	nopicmip
	{
 		map textures/e2ways_tex/e2ways_randi.tga
 		alphaFunc GE128
 		depthWrite
 		rgbGen vertex
 	}
}

textures/e2ways_tex/flaglm01neutral
{
	surfaceparm woodsteps
	nopicmip
	nomipmaps
	implicitMap -
}

textures/e2ways_tex/e2ways__sky1
{
	skyparms textures/shaderlab_terrain/env/sky 1024 -
	q3map_lightImage textures/shaderlab_terrain/sky_clouds.tga
	q3map_sunExt 1.00 0.92 0.46 140 -35 25 3 16
	q3map_lightmapFilterRadius 0 8		//self other
	q3map_skyLight 100 3
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	nopicmip
	nomipmaps
	qer_editorimage textures/e2ways_tex/e2ways__sky1.tga
	{
		map textures/shaderlab_terrain/sky_clouds.tga
		tcMod scale 3 3
		rgbGen identityLighting
	}
	{
		map textures/shaderlab_terrain/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/e2ways_tex/e2ways__sky2
{
	skyparms textures/shaderlab_terrain/env/sky 1024 -
	q3map_lightImage textures/shaderlab_terrain/sky_clouds.tga
	q3map_sunExt 1.00 0.92 0.46 140 -35 25 3 16
	q3map_lightmapFilterRadius 0 8		//self other
	q3map_skyLight 100 3
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	nopicmip
	nomipmaps
	qer_editorimage textures/e2ways_tex/e2ways__sky2.tga
	{
		map textures/shaderlab_terrain/sky_clouds.tga
		tcMod scale 3 3
		rgbGen identityLighting
	}
	{
		map textures/shaderlab_terrain/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}


levelshots/eagles_2ways_b1_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/eagles_2ways_b1_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/eagles_2ways_b1_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/eagles_2ways_b1_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

textures/e2ways_tex/alpha_00
{
    qer_editorimage textures/e2ways_tex/alpha_00.tga
	qer_trans 0.5
	q3map_alphaMod volume
	q3map_alphaMod scale 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

// *** Outdoor snow shader **********

textures/e2ways_tex/snowtodirt_z
{
    qer_editorimage textures/e2ways_tex/z_projection.tga
	surfaceparm landmine
	surfaceparm snowsteps
	q3map_lightmapaxis z // Project lightmap on z axis (up/down)
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 1024 0 ) // ( X Y Z ). Zero value in both groups = projection axis (here: z).
    {
		map textures/snow_sd/coal_snow.tga //  Dark, dirty snow. This texture does not have an alpha channel.
	}
	{
		map textures/e2ways_tex/hg_sdsnowvar01.tga // Bright snow. This texture has an alpha channel.
		blendFunc blend
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/e2ways_tex/snowtodirt_x // x-axis projection (sideways projection, east-west).
{
    qer_editorimage textures/e2ways_tex/x_projection.tga
	surfaceparm landmine
	surfaceparm snowsteps
	q3map_lightmapaxis z // Project lightmap on z axis (up/down)
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 ) // x-axis projection.
    {
		map textures/snow_sd/coal_snow.tga //  Dark, dirty snow. This texture does not have an alpha channel.
	}
	{
		map textures/e2ways_tex/hg_sdsnowvar01.tga // Bright snow. This texture has an alpha channel.
		blendFunc blend
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/e2ways_tex/snowtodirt_y // y-axis projection (sideways projection, south-north).
{
    qer_editorimage textures/e2ways_tex/y_projection.tga
	surfaceparm landmine
	surfaceparm snowsteps
	q3map_lightmapaxis z // Project lightmap on z axis (up/down)
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 ) // y-axis projection.
    {
		map textures/snow_sd/coal_snow.tga //  Dark, dirty snow. This texture does not have an alpha channel.
	}
	{
		map textures/e2ways_tex/hg_sdsnowvar01.tga // Bright snow. This texture has an alpha channel.
		blendFunc blend
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/eagles/dr_wheels1
{
   surfaceparm metalsteps
   {
      	map textures/eagles/dr_wheels1.tga
      	rgbGen identity
   }
}

textures/eagles/dr_wheels2
{
   surfaceparm metalsteps
   {
      	map textures/eagles/dr_wheels2.tga
      	rgbGen identity
		tcMod rotate -110
   }
}

textures/eagles/dr_wheels3
{
   qer_editorimage textures/snow_sd/ametal_m03_snow.tga
   surfaceparm metalsteps
   {
      	map textures/snow_sd/ametal_m03_snow.tga
      	rgbGen identity
   }
}

textures/eagles/dr_wheels4
{
   qer_editorimage textures/snow_sd/ametal_m03_snow.tga
   surfaceparm metalsteps
   {
      	map textures/snow_sd/ametal_m03_snow.tga
      	rgbGen identity
		// tcMod scroll 20
   }
}

textures/eagles/eagles_ice
{
	qer_trans 0.85
	qer_editorimage textures/snow/alpha_ice2s.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/snow/alpha_ice2s.tga
}

textures/eagles/black_snow
{
   	qer_editorimage textures/snow_sd/coal_snow.tga
   	surfaceparm snowsteps
	surfaceparm landmine
   	{
      		map textures/snow_sd/coal_snow.tga
      		rgbGen identity
   	}
}
